---
title: "module lang::flybytes::tests::DefaultParameters"
id: DefaultParameters
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/DefaultParameters
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::tests::DefaultParameters;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
```


## function defParamClass {#lang-flybytes-tests-DefaultParameters-defParamClass}

```rascal
Class defParamClass()
```

# Tests
## test testDefParamSet {#lang-flybytes-tests-DefaultParameters-testDefParamSet}

```rascal

test bool testDefParamSet() { 
  m = loadClass(defParamClass());
  // if you pass a string, you get the string back
  return m.invokeStatic(methodDesc(string(), "testMethod", [string()]), [prim(string(), "bye!")]).toValue(#str) == "bye!";
}
```

## test testDefParamUnSet {#lang-flybytes-tests-DefaultParameters-testDefParamUnSet}

```rascal

test bool testDefParamUnSet() { 
  m = loadClass(defParamClass());
  // if you pass 'null' you get the default initializer expression for the parameter
  return m.invokeStatic(methodDesc(string(), "testMethod", [string()]), [Mirror::null()]).toValue(#str) == "hello!";
}
```

