---
title: "module lang::flybytes::tests::InterfaceTests"
id: InterfaceTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/InterfaceTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::tests::InterfaceTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
```


## function interfA {#lang-flybytes-tests-InterfaceTests-interfA}

```rascal
Class interfA()
```

## function interfB {#lang-flybytes-tests-InterfaceTests-interfB}

```rascal
Class interfB()
```

## function implInvokeInterface {#lang-flybytes-tests-InterfaceTests-implInvokeInterface}

```rascal
Class implInvokeInterface()
```

## function implInvokeVirtual {#lang-flybytes-tests-InterfaceTests-implInvokeVirtual}

```rascal
Class implInvokeVirtual()
```

## function interfDefault {#lang-flybytes-tests-InterfaceTests-interfDefault}

```rascal
Class interfDefault()
```

## function implInvokeDefault {#lang-flybytes-tests-InterfaceTests-implInvokeDefault}

```rascal
Class implInvokeDefault()
```

# Tests
## test implementAbstractMethodInvokeVirtual {#lang-flybytes-tests-InterfaceTests-implementAbstractMethodInvokeVirtual}

```rascal
test bool implementAbstractMethodInvokeVirtual() {
  // load the classes together
  cs = loadClasses([interfA(), interfB(), implInvokeVirtual()], prefix=just(|project://flybytes/generated/|));
  
  // get a mirror instance of the class that implements the two interfaces
  c = cs["Impl_A"];
  i = c.newInstance(constructorDesc([]),[]);
  
  // call test method which uses two implemented interface methods
  return i.invoke(methodDesc(\void(), "testMethod", []), []).toValue(#bool);
}
```

## test implementAbstractMethodInvokeInterface {#lang-flybytes-tests-InterfaceTests-implementAbstractMethodInvokeInterface}

```rascal
test bool implementAbstractMethodInvokeInterface() {
  // load the classes together
  cs = loadClasses([interfA(), interfB(), implInvokeInterface()], prefix=just(|project://flybytes/generated/|));
  
  // get a mirror instance of the class that implements the two interfaces
  c = cs["Impl_A"];
  i = c.newInstance(constructorDesc([]),[]);
  
  // call test method which uses two implemented interface methods
  return i.invoke(methodDesc(\void(), "testMethod", []), []).toValue(#bool);
}
```

## test testInterfaceDefaultMethod {#lang-flybytes-tests-InterfaceTests-testInterfaceDefaultMethod}

```rascal
test bool testInterfaceDefaultMethod() {
  // load the classes together, default methods require version 1.8
  cs = loadClasses([interfDefault(), implInvokeDefault()], prefix=just(|project://flybytes/generated/|), version=v1_8());
  
  // get a mirror instance of the class that implements the two interfaces
  c = cs["Impl_B"];
  i = c.newInstance(constructorDesc([]),[]);
  
  // call test method which uses two implemented interface methods
  return i.invoke(methodDesc(\void(), "testMethod", []), []).toValue(#bool);
}
```

