---
title: "module lang::flybytes::tests::MirrorTests"
id: MirrorTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/MirrorTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::tests::MirrorTests;
```

#### Dependencies
```rascal
import lang::flybytes::Mirror;
import lang::flybytes::api::JavaLang;
import lang::flybytes::Syntax;
```


# Tests
## test intId {#lang-flybytes-tests-MirrorTests-intId}

```rascal
test bool intId(int v) = v % maxIntValue(integer()) == integer(integer(v % maxIntValue(integer())));
```

## test longId {#lang-flybytes-tests-MirrorTests-longId}

```rascal
test bool longId(int v) = v % maxIntValue(long()) == long(long(v % maxIntValue(long())));
```

## test byteId {#lang-flybytes-tests-MirrorTests-byteId}

```rascal
test bool byteId(int v) = v % maxIntValue(byte()) == byte(byte(v % maxIntValue(byte())));
```

## test shortId {#lang-flybytes-tests-MirrorTests-shortId}

```rascal
test bool shortId(int v) = v % maxIntValue(short()) == short(short(v % maxIntValue(short())));
```

## test stringId {#lang-flybytes-tests-MirrorTests-stringId}

```rascal
test bool stringId(str x) = x == string(string(x));
```

## test doubleId {#lang-flybytes-tests-MirrorTests-doubleId}

```rascal
test bool doubleId() {
   for (d <- [1.0,1.5..10.0]) {
     if (double(double(d)) != d) {
       return false;
     }
   }
   return true;
}
```

## test floatId {#lang-flybytes-tests-MirrorTests-floatId}

```rascal
test bool floatId() {
   for (f <- [1.0,1.5..10.0]) {
     if (float(float(f)) != f) {
       return false;
     }
   }
   return true;
}
```

## test arrayMirror {#lang-flybytes-tests-MirrorTests-arrayMirror}

```rascal
test bool arrayMirror(list[int] v) {
  a = array(integer(), [integer(e mod 1000) | e <- v]);
 
  int i = a.length() - 1;
  while (i >= 0) {
    if (a.load(i).toValue(#int) mod 1000 != v[i] mod 1000) {
      return false;
    }
    i -= 1;
  } 
  
  return true;
}
```

## test floatStatic {#lang-flybytes-tests-MirrorTests-floatStatic}

```rascal
test bool floatStatic()
  = classMirror("java.lang.Float").getStatic("MAX_VALUE").toValue(#real) == 3.4028235E38;
```

## test doubleStatic {#lang-flybytes-tests-MirrorTests-doubleStatic}

```rascal
test bool doubleStatic()
  = classMirror("java.lang.Double").getStatic("MAX_VALUE").toValue(#real) == 1.7976931348623157E308;
```

## test longStatic {#lang-flybytes-tests-MirrorTests-longStatic}

```rascal
test bool longStatic()
  = classMirror("java.lang.Long").getStatic("MAX_VALUE").toValue(#int) == 9223372036854775807;
```

## test intStatic {#lang-flybytes-tests-MirrorTests-intStatic}

```rascal
test bool intStatic()
  = classMirror("java.lang.Integer").getStatic("MAX_VALUE").toValue(#int) == 2147483647;
```

## test newInstance {#lang-flybytes-tests-MirrorTests-newInstance}

```rascal
test bool newInstance()
  = classMirror("java.lang.Integer").newInstance(constructorDesc([string()]), [string("12")]).toValue(#int) == 12;
```

## test invokeStatic {#lang-flybytes-tests-MirrorTests-invokeStatic}

```rascal
test bool invokeStatic()
  = classMirror("java.lang.Integer").invokeStatic(methodDesc(integer(), "parseInt", [string()]), [string("100")]).toValue(#int) == 100;
```

## test getField {#lang-flybytes-tests-MirrorTests-getField}

```rascal
test bool getField() 
  = classMirror("java.awt.Point").newInstance(constructorDesc([]),[]).getField("x").toValue(#int) == 0;
```

## test invokeMethod {#lang-flybytes-tests-MirrorTests-invokeMethod}

```rascal
test bool invokeMethod() {
  // create a Point instance at (0,0)
  p = classMirror("java.awt.Point").newInstance(constructorDesc([]),[]);
  
  // method with side effect! move to (1,2)
  p.invoke(methodDesc(\void(),"move", [integer(),integer()]), [integer(1), integer(2)]);
  
  // observe side effect
  return p.getField("x").toValue(#int) == 1
      && p.getField("y").toValue(#int) == 2;
}
```

## test staticClassName {#lang-flybytes-tests-MirrorTests-staticClassName}

```rascal
test bool staticClassName() = classMirror("java.awt.Point").class == "java.awt.Point";
```

## test objectClassName {#lang-flybytes-tests-MirrorTests-objectClassName}

```rascal
test bool objectClassName() = classMirror("java.awt.Point").newInstance(constructorDesc([]),[]).classMirror.class == "java.awt.Point";
```

## test arrayLoadInteger {#lang-flybytes-tests-MirrorTests-arrayLoadInteger}

```rascal
test bool arrayLoadInteger()
  = array(integer(), [integer(1331)]).load(0).toValue(#int) == 1331;
```

## test arrayLoadLong {#lang-flybytes-tests-MirrorTests-arrayLoadLong}

```rascal
test bool arrayLoadLong()
  = array(long(), [long(maxIntValue(long()))]).load(0).toValue(#int) == maxIntValue(long());
```

## test arrayLoadObjectNull {#lang-flybytes-tests-MirrorTests-arrayLoadObjectNull}

```rascal
test bool arrayLoadObjectNull()
  = array(object(), 10).load(0) == Mirror::null();
```

## test arrayLoadStringNull {#lang-flybytes-tests-MirrorTests-arrayLoadStringNull}

```rascal
test bool arrayLoadStringNull()
  = array(string(), 10).load(0) == Mirror::null();
```

## test arrayLoadStringSingleton {#lang-flybytes-tests-MirrorTests-arrayLoadStringSingleton}

```rascal
test bool arrayLoadStringSingleton()
  = string(array(string(), [string("x")]).load(0)) == "x";
```

## test arrayLoadStringTwo {#lang-flybytes-tests-MirrorTests-arrayLoadStringTwo}

```rascal
test bool arrayLoadStringTwo()
  = string(array(string(), [string("x"), string("y")]).load(1)) == "y";
```

## test arrayLengthFilled {#lang-flybytes-tests-MirrorTests-arrayLengthFilled}

```rascal
test bool arrayLengthFilled(int l)
  = array(integer(), [integer(e) | e <- [0..l mod 100]]).length() == l mod 100;
```

## test arrayLengthStringFilled {#lang-flybytes-tests-MirrorTests-arrayLengthStringFilled}

```rascal
test bool arrayLengthStringFilled(int l)
  = array(string(), [string("<e>") | e <- [0..l mod 100]]).length() == l mod 100;
```

## test arrayLengthDefault {#lang-flybytes-tests-MirrorTests-arrayLengthDefault}

```rascal
test bool arrayLengthDefault()
  = array(integer(), 100).length() == 100;
```

## test annoMirror {#lang-flybytes-tests-MirrorTests-annoMirror}

```rascal
test bool annoMirror() 
  = classMirror("java.lang.Deprecated").getAnnotation(object("java.lang.annotation.Retention")) != null();
```

