---
title: "module lang::flybytes::tests::VariableTests"
id: VariableTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/VariableTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.10</div>

#### Usage

```rascal
import lang::flybytes::tests::VariableTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
import lang::flybytes::api::Object;
import lang::flybytes::api::JavaLang;
import Node;
import util::Math;
```


## function primVarTestClass {#lang-flybytes-tests-VariableTests-primVarTestClass}

```rascal
Class primVarTestClass(Type t, value v)
```

## function testVarClass {#lang-flybytes-tests-VariableTests-testVarClass}

```rascal
bool testVarClass(Class c)
```

## function fit {#lang-flybytes-tests-VariableTests-fit}

```rascal
real fit(float(), real r)

real fit(double(), real r)
```

## function objVarTestClass {#lang-flybytes-tests-VariableTests-objVarTestClass}

```rascal
Class objVarTestClass(Type t, Exp v)
```

# Tests
## test intVariables {#lang-flybytes-tests-VariableTests-intVariables}

```rascal
test bool intVariables(int i)
  = all(t <- intTypes, I := i % maxIntValue(t), testVarClass(primVarTestClass(t, I)));
```

## test floatVariables {#lang-flybytes-tests-VariableTests-floatVariables}

```rascal
test bool floatVariables(real i)
  = all(t <- floatTypes, I := fit(t, i), testVarClass(primVarTestClass(t, I)));
```

## test boolVariableTrue {#lang-flybytes-tests-VariableTests-boolVariableTrue}

```rascal
test bool boolVariableTrue() = testVarClass(primVarTestClass(boolean(), true));
```

## test boolVariableFalse {#lang-flybytes-tests-VariableTests-boolVariableFalse}

```rascal
test bool boolVariableFalse() = testVarClass(primVarTestClass(boolean(), false));
```

## test stringVariable {#lang-flybytes-tests-VariableTests-stringVariable}

```rascal
test bool stringVariable() = testVarClass(objVarTestClass(string(), sconst("Hello")));
```

