@license{Copyright (c) 2016-2019, Centrum Wiskunde & Informatica (CWI) 
All rights reserved. 
 
Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 
 
1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
  
2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
}
@contributor{Rodin Aarsen}
@contributor{Jurgen Vinju}
module lang::flybytes::internal::ASTgen

import lang::flybytes::Syntax;
import Type; 
import List;
import IO;

str license = "/** 
              ' * Copyright (c) 2019, Centrum Wiskunde & Informatica (CWI)
              ' * All rights reserved.
              ' *
              ' * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
              ' *
              ' * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
              ' *
              ' * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
              ' *
              ' * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
              ' */";

public void generate()  {
  code = generate("AST", [#Class, #Field, #Method, #Annotation, #BootstrapCall, #CallSiteInfo, #Case, #Exp, #Formal, #Handler, #Instruction, #Modifier, #RetentionPolicy, #Signature, #Stat, #SwitchOption, #Type]);
  
  writeFile(|project://flybytes/src/lang/flybytes/internal/AST.java|, code);
}

public str generate(str apiName, list[type[value]] types) {
  allTypes = types;
 
  return   "<license>
           '
           '// This code was generated by lang::flybytes::internal::ASTgen
           'package lang.flybytes.internal;
           '
           'import io.usethesource.vallang.type.Type;
           'import io.usethesource.vallang.type.TypeFactory;
           'import io.usethesource.vallang.type.TypeStore;
           'import io.usethesource.vallang.*;
           '
           'public class <apiName> {
           '  private static TypeStore typestore = new TypeStore();
           '  private static TypeFactory tf = TypeFactory.getInstance();
           '  private IValueFactory vf;
           '
           '  public <apiName> (IValueFactory vf) {
           '    this.vf = vf;
           '  }
           '
           '  <for(type[value] t <- allTypes, adt(str name, _) := t.symbol) {>private static final Type _<name> = tf.abstractDataType(typestore, \"<name>\");
           '  <}> 
           '  <for(type[value] t <- allTypes) {>
           '  <declareType(t.symbol, t.definitions[t.symbol])>
           '  <}>
           '  <for(type[value] t <- allTypes, t.symbol in t.definitions, choice(_,cs) := t.definitions[t.symbol]) {> 
           '  <declareMakers(t.symbol,cs)> <}>
           '  
           '}";

}

str declareType(adt(str name, list[Symbol] _), Production choice) 
 =   "<for(Production c <- choice.alternatives ) {>
     '<declareConstructor(c, name)><}>";
  
  
str declareConstructor(Production::cons(label(str cname, Symbol _), list[Symbol] args, list[Symbol] _/*kwTypes*/, set[Attr] _), str typeName) 
  = "private static final Type _<typeName>_<cname>_<size(args)> 
    '  = tf.constructor(typestore,_<typeName>,\"<cname>\"<typeNameTuples2FactoryCallArgs(args)>);";
  
str type2FactoryCall(Symbol t){
    switch(t){
      case Symbol::\value() : return "tf.valueType()";
      case Symbol::\void() : return "tf.voidType()";
      case Symbol::\int() :  return "tf.integerType()"; 
      case Symbol::\rat() : return "tf.rationalType()";
      case Symbol::\num() : return "tf.numberType()";
      case Symbol::\real() : return "tf.realType()";
      case Symbol::\bool() : return "tf.boolType()";
      case Symbol::\str() :  return "tf.stringType()"; 
      case Symbol::\loc() : return "tf.sourceLocationType()";
      case Symbol::\datetime() : return "tf.dateTimeType()";
      case Symbol::\node() : return "tf.nodeType()";
      case Symbol::\cons(Symbol::\adt(str name,_),_,_) : return  (name);
      case Symbol::\set(ti) :  return "tf.setType(<type2FactoryCall(ti)>)";  
      case Symbol::\list(ti) :  return "tf.listType(<type2FactoryCall(ti)>)";
      case Symbol::\map(label(l1,ti),label(l2, ti2)) : return "tf.mapType(<type2FactoryCall(ti)>,\"<l1>\", <type2FactoryCall(ti2)>, \"<l2>\")";
      case Symbol::\map(ti,ti2) : return "tf.mapType(<type2FactoryCall(ti)>,<type2FactoryCall(ti2)>)";
      case Symbol::\tuple(tis) : return "tf.tupleType(<typeList2FactoryVarArgs(tis)>)";
      case Symbol::\adt(str name, _) : return "_<name>";
      default: 
        throw "Do not now how to construct <t>";  
    }
}
  
  str typeList2FactoryVarArgs(list[Symbol] tss){
    if (tss == []) { return "";}
    else { return toExtraArgs([ type2FactoryCall(t) | t <- tss]); }
  }
  
  str typeList2FactoryVarArgsFirstPos(list[Symbol] tss){
    return intercalate(",",[ type2FactoryCall(t) | t <- tss]);
  }
  
  str toExtraArgs(list[str] strs) =
    ("" | "<it>,<s>" | s <- strs);
  
  
  str typeNameTuples2FactoryCallArgs(list[Symbol] args) {
    return toExtraArgs([type2FactoryCall(t),"\"" + n + "\"" | label(n,t) <- args]);
  } 
  
  //str declareGetters(Symbol t, set[Production] cs){
  //  if(adt(str name, ps) := t){
  //    return   "<for(c <- cs) {><declareConstructorGetters(c,name)><}>";
  //  } 
  //  // throw "Cannot declare getters for type <t>";
  //  return ""; 
  //}
  
  str declareMakers(adt(str _, list[Symbol] _), set[Production] cs) 
     = "<for (c <- cs) {>
       '<declareMaker(c)>
       '<}>";
  
  str declareMaker(Production::cons(label(str cname, Symbol typ:adt(str typeName, list[Symbol] _)), list[Symbol] args, list[Symbol] _, set[Attr] _)) 
     = "public <typeToJavaType(typ)> <typeName>_<cname>(<declareConsArgs(args)[2..]>) {
       '  <for (label(str l, Symbol t) <- args) { str argName = argToSimpleJavaArg(l, t); str argType = type2FactoryCall(t);>  
       '  if (!<argName>.getType().isSubtypeOf(<argType>)) {
       '    throw new IllegalArgumentException(\"Expected \" + <argType> + \" but got \" + <argName>.getType() + \" for <argName>:\" + <argName>);
       '  }
       '  <}>
       '  return vf.constructor(_<typeName>_<cname>_<size(args)> <callConsArgs(args)>);
       '}";
  
  str declareConsArgs(list[Symbol] args) = "<for (label(str l, Symbol t) <- args) {>, <typeToSimpleJavaType(t)> $<l><}>";
     
  str callConsArgs( list[Symbol] args) = "<for (label(str l, Symbol t) <- args) {>, <argToSimpleJavaArg(l, t)><}>";
  
  str argToSimpleJavaArg(str l, Symbol t) {
    switch(t){
      case \int() : return "vf.integer($<l>)";
      case \real() : return "vf.real($<l>)";
      case \bool() : return "vf.bool($<l>)";
      case \str() :  return "vf.string($<l>)";
      default : return "$<l>";
    }
  }
  
  str typeToSimpleJavaType(Symbol t){
    switch(t){
      case \int() : return "int";
      case \real() : return "double";
      case \num() : return "double";
      case \bool() : return "boolean";
      case \str() :  return "String";
      case \label(_, x) : return typeToSimpleJavaType(x);
      default : return typeToJavaType(t);
    }
  }
  
  str javaResult(Symbol t, str access){
    switch(t){
      case \int() : return "((IInteger)<access>).intValue()";
      case \real() : return "((IReal)<access>).doubleValue()";
      case \num() : return "<access> instanceof IInteger ? (double)((IInteger)<access>).intValue() : ((IReal)<access>).doubleValue()";
      case \bool() : return "((IBool)<access>).getValue()";
      case \str() :  return "((IString)<access>).getValue()";
      case \label(_,x) : return javaResult(x, access);
      default : return "(<typeToJavaType(t)>)<access>";
    }
  }
  
  str typeToJavaType(Symbol t){
    switch(t){
      case \adt(_,_) : return "IConstructor";
      case \cons(_,_,_) : return "IConstructor";
      case \int() : return "IInteger";
      case \real() : return "IReal";
      case \num() : return "INumber";
      case \bool() : return "IBool";
      case \list(_) : return "IList";
      case \map(_,_) : return "IMap";
      case \set(_) : return "ISet";
      case \loc() : return "ISourceLocation";
      case \str() :  return "IString";
      case \datetime() : return "IDateTime";
      case \tuple(_) : return  "ITuple";     
      case \func(_, _, _): return "ICallableValue";
      case \alias(_,_,a) : return typeToJavaType(a);
      default : return "IValue";
    }
  }
    
