---
title: "module lang::flybytes::Mirror"
id: Mirror
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/Mirror
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

Provides a native interface to Java objects via class and object reflection.
#### Usage

```rascal
import lang::flybytes::Mirror;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
```

#### Description


Using this Mirror representation you can test generated class files by loading the class
and executing static methods on the classes, getting static fields, allocating new instances,
calling methods on these instances, etc. There is also support for native arrays.


## data Mirror {#lang-flybytes-Mirror-Mirror}

```rascal
data Mirror  
     = class(str class, 
        Mirror (Signature method, list[Mirror] args) invokeStatic,
        Mirror (str name) getStatic,
        Mirror (Signature constructor, list[Mirror] args) newInstance,
        Mirror (Type \type) getAnnotation)
     | object(Mirror classMirror, 
        Mirror (Signature method, list[Mirror] args) invoke,
        Mirror (str name) getField,
        &T  (type[&T] expect) toValue)
     | array(int () length,
        Mirror (int index) load)
     | \null()
     ;
```

## function val {#lang-flybytes-Mirror-val}

reflects a Rascal value as a JVM object Mirror

```rascal
Mirror val(value v)
```

## function classMirror {#lang-flybytes-Mirror-classMirror}

reflects a JVM class object as Mirror class

```rascal
Mirror classMirror(str name,list[loc] classpath = [|system:///|])
```

## function array {#lang-flybytes-Mirror-array}

creates a mirrored array

```rascal
Mirror array(Type \type, list[Mirror] elems)
```

## function array {#lang-flybytes-Mirror-array}

creates a mirrored array

```rascal
Mirror array(Type \type, int length)
```

## function toString {#lang-flybytes-Mirror-toString}

```rascal
str toString(Mirror m:object(_, _, _, _))

str toString(class(str name, _, _, _, _))

str toString(null())

str toString(Mirror m:array(_, _))
```

## function integer {#lang-flybytes-Mirror-integer}

```rascal
Mirror integer(int v)
```

## function long {#lang-flybytes-Mirror-long}

```rascal
Mirror long(int v)
```

## function byte {#lang-flybytes-Mirror-byte}

```rascal
Mirror byte(int v)
```

## function short {#lang-flybytes-Mirror-short}

```rascal
Mirror short(int v)
```

## function character {#lang-flybytes-Mirror-character}

```rascal
Mirror character(int v)
```

## function string {#lang-flybytes-Mirror-string}

```rascal
Mirror string(str v)
```

## function double {#lang-flybytes-Mirror-double}

```rascal
Mirror double(real v)
```

## function float {#lang-flybytes-Mirror-float}

```rascal
Mirror float(real v)
```

## function boolean {#lang-flybytes-Mirror-boolean}

```rascal
Mirror boolean(bool v)
```

## function prim {#lang-flybytes-Mirror-prim}

```rascal
Mirror prim(integer(), int t)

Mirror prim(short(), int t)

Mirror prim(byte(), int t)

Mirror prim(long(), int t)

Mirror prim(double(), real t)

Mirror prim(float(), real t)

Mirror prim(string(), str t)

Mirror prim(character(), int t)

Mirror prim(boolean(), bool t)
```

## function integer {#lang-flybytes-Mirror-integer}

```rascal
int integer(Mirror i)
```

## function long {#lang-flybytes-Mirror-long}

```rascal
int long(Mirror l)
```

## function byte {#lang-flybytes-Mirror-byte}

```rascal
int byte(Mirror b)
```

## function short {#lang-flybytes-Mirror-short}

```rascal
int short(Mirror s)
```

## function string {#lang-flybytes-Mirror-string}

```rascal
str string(Mirror s)
```

## function double {#lang-flybytes-Mirror-double}

```rascal
real double(Mirror d)
```

## function float {#lang-flybytes-Mirror-float}

```rascal
real float(Mirror f)
```

## function character {#lang-flybytes-Mirror-character}

```rascal
int character(Mirror f)
```

## function boolean {#lang-flybytes-Mirror-boolean}

```rascal
bool boolean(Mirror f)
```

