---
title: "module lang::flybytes::demo::func::Syntax"
id: Syntax
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/demo/func/Syntax
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::demo::func::Syntax;
```



## syntax Ident {#lang-flybytes-demo-func-Syntax-Ident}

```rascal
lexical Ident =  [a-zA-Z][a-zA-Z0-9]* !>> [a-zA-Z0-9];
```

## syntax Natural {#lang-flybytes-demo-func-Syntax-Natural}

```rascal
lexical Natural = [0-9]+ !>> [0-9];
```

## syntax LAYOUT {#lang-flybytes-demo-func-Syntax-LAYOUT}

```rascal
lexical LAYOUT = [\t-\n\r\ ];
```

## syntax LAYOUTLIST {#lang-flybytes-demo-func-Syntax-LAYOUTLIST}

```rascal
layout LAYOUTLIST = LAYOUT*  !>> [\t-\n\r\ ] ;
```

## syntax Prog {#lang-flybytes-demo-func-Syntax-Prog}

```rascal
start syntax Prog = prog: Func* ;
```

## syntax Func {#lang-flybytes-demo-func-Syntax-Func}

```rascal
syntax Func = func: Ident name "(" {Ident ","}* ")" "=" FExp;
```

## syntax FExp {#lang-flybytes-demo-func-Syntax-FExp}

```rascal
syntax FExp = let: "let" {Binding ","}* "in" FExp "end"
            | cond: "if" FExp "then" FExp "else" FExp "end"
            | bracket "(" FExp ")"
            | var: Ident
            | nat: Natural 
            | call: Ident "(" {FExp ","}* ")"
            > non-assoc (
               left mul: FExp "*" FExp 
             | non-assoc div: FExp "/" FExp
            ) 
            > left (
               left add: FExp "+" FExp 
             | left sub: FExp "-" FExp
            )
            >
            non-assoc (
               non-assoc gt: FExp "\>" FExp
             | non-assoc lt:  FExp "\<" FExp
             | non-assoc geq:  FExp "\>=" FExp
             | non-assoc leq:  FExp "\<=" FExp
            )
            >
            right assign: Ident ":=" FExp
            >
            right seq: FExp ";" FExp;
```

## syntax Binding {#lang-flybytes-demo-func-Syntax-Binding}

```rascal
syntax Binding = binding: Ident "=" FExp;
```

