---
title: "module lang::flybytes::demo::pico::Compiler"
id: Compiler
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/demo/pico/Compiler
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::demo::pico::Compiler;
```

#### Dependencies
```rascal
import lang::flybytes::demo::pico::Syntax;
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
import lang::flybytes::api::System;
import lang::flybytes::api::Object;
import lang::flybytes::api::String;
import lang::flybytes::api::JavaLang;
import lang::flybytes::macros::ControlFlow;
import IO;
import String;
import ParseTree;
```


## function parse {#lang-flybytes-demo-pico-Compiler-parse}

```rascal
Program parse(loc program) = parse(#start[Program], program).top;
```

## function testFactorial {#lang-flybytes-demo-pico-Compiler-testFactorial}

```rascal
void testFactorial() {
  Program tree = parse(|project://flybytes/src/lang/flybytes/demo/pico/fac.pico|);
  println(tree);
  compileProgram(tree, "Factorial", |project://flybytes/generated|);
}
```

## function testITE {#lang-flybytes-demo-pico-Compiler-testITE}

```rascal
void testITE() {
  Program tree = parse(|project://flybytes/src/lang/flybytes/demo/pico/ite.pico|);
  println(tree);
  compileProgram(tree, "ITE", |project://flybytes/generated|);
}
```

## function compileProgram {#lang-flybytes-demo-pico-Compiler-compileProgram}

```rascal
void compileProgram(Program p, str name, loc folder) {
  cl = compileProgram(p, name);
  compileClass(compileProgram(p, name), folder + "<name>.class", debugMode=true);
}


Class compileProgram(Program p, str name)
  = class(object(name),
      methods=[
        main("$$args", [
          *decls(p.decls), 
          *commandline(p.decls), 
          *stats(p.body),
          *output(p.decls),
          \return()
        ])[src=p@\loc]
      ]
  )[src=p@\loc];
```

## function decls {#lang-flybytes-demo-pico-Compiler-decls}

```rascal
list[Stat] decls(Declarations p)
  = [decl(\type(t), "<i>")[src=i@\loc] | (IdType) `<Id i> : <Type t>` <- p.decls];
```

## function \type {#lang-flybytes-demo-pico-Compiler-\type}

```rascal
Type \type((Type) `natural`) = integer();

Type \type((Type) `string`)  = lang::flybytes::Syntax::string();
```

## function stats {#lang-flybytes-demo-pico-Compiler-stats}

```rascal
list[Stat] stats({Statement  ";"}* stats) = [stat(s)[src=s@\loc] | s <- stats];
```

## function stat {#lang-flybytes-demo-pico-Compiler-stat}

```rascal
Stat stat(s:(Statement) `<Id var> := <Expression val>`)
   = store("<var>", expr(val));

Stat stat(s:(Statement) 
                 `if <Expression cond> then 
                 '  <{Statement ";"}* thenPart> 
                 'else 
                 '  <{Statement ";"}* elsePart> 
                 'fi`)                
   = \if(ne(expr(cond), iconst(0)), stats(thenPart), stats(elsePart)) when /Id _ := thenPart;

Stat stat(s:(Statement) 
                 `while <Expression cond> do 
                 '  <{Statement ";"}* body> 
                 'od`)
   = \while(expr(cond), stats(body));
```

## function expr {#lang-flybytes-demo-pico-Compiler-expr}

```rascal
Exp expr(e:(Expression) `<Id name>`)                        = load("<name>", src=e@\loc);

Exp expr(e:(Expression) `<String s>`)                       = const(lang::flybytes::Syntax::string(), "<s>"[1..-1], src=e@\loc);

Exp expr(e:(Expression) `<Natural natcon>`)                 = const(integer(), toInt("<natcon>"), src=e@\loc);

Exp expr(e:(Expression) `(<Expression e>)`)                 = expr(e);

Exp expr(e:(Expression) `<Expression l> || <Expression r>`) = String_concat(expr(l), expr(r))[src=e@\loc];

Exp expr(e:(Expression) `<Expression l> + <Expression r>`)  = add(expr(l), expr(r), src=e@\loc);

Exp expr(e:(Expression) `<Expression l> - <Expression r>`)  = sub(expr(l), expr(r), src=e@\loc);
```

## function output {#lang-flybytes-demo-pico-Compiler-output}

```rascal
list[Stat] output(Declarations p)
  = [stdout(String_concat(const(lang::flybytes::Syntax::string(), "<i>\t: "), toString(i, t)))[src=i@\loc] 
    | (IdType) `<Id i> : <Type t>` <- p.decls]
    ;
```

## function toString {#lang-flybytes-demo-pico-Compiler-toString}

```rascal
Exp toString(Id i, (Type) `natural`) 
  = invokeStatic(object("java.lang.Integer"), methodDesc(lang::flybytes::Syntax::string(), "toString", [integer()]), [load("<i>")])[src=i@\loc];

Exp toString(Id i, (Type) `string`)
  = load("<i>", src=i@\loc);
```

## function commandline {#lang-flybytes-demo-pico-Compiler-commandline}

```rascal
list[Stat] commandline(Declarations p) 
  = [for_array("$$args", "i", [
       // if (args[i].equals(varName))
        \if (equals(sconst("<i>"), aload(load("$$args"), load("i"))), [
          // varName = fromString(args[i+1])
          store("<i>", fromString(t, aload(load("$$args"), add(load("i"), iconst(1)))))
        ])[src=i@\loc]
      ])
    | (IdType) `<Id i> : <Type t>` <- p.decls];
```

## function fromString {#lang-flybytes-demo-pico-Compiler-fromString}

```rascal
Exp fromString((Type) `natural`, Exp e) = Integer_parseInt(e, 10);

Exp fromString((Type) `string`, Exp e)  = e;
```

