---
title: "module lang::flybytes::tests::ArithmeticTests"
id: ArithmeticTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/ArithmeticTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::ArithmeticTests;
```

#### Dependencies
```rascal
import lang::flybytes::Compiler;
import lang::flybytes::Mirror;
import lang::flybytes::api::JavaLang;
import Node;
import IO;
import util::Math;
```


## alias BinOp {#lang-flybytes-tests-ArithmeticTests-BinOp}

```rascal
Exp (Exp, Exp)
```

## alias UnOp {#lang-flybytes-tests-ArithmeticTests-UnOp}

```rascal
Exp (Exp)
```

## function binOpClass {#lang-flybytes-tests-ArithmeticTests-binOpClass}

```rascal
Class binOpClass(Type t, BinOp op)
```

## function unOpClass {#lang-flybytes-tests-ArithmeticTests-unOpClass}

```rascal
Class unOpClass(Type t, UnOp op)
```

## function testBinOp {#lang-flybytes-tests-ArithmeticTests-testBinOp}

```rascal
bool testBinOp(Class c, Type t, num lhs, num rhs, num answer)
```

## function testUnOp {#lang-flybytes-tests-ArithmeticTests-testUnOp}

```rascal
bool testUnOp(Class c, Type t, num arg, num answer)
```

## function testBinOpRange {#lang-flybytes-tests-ArithmeticTests-testBinOpRange}

```rascal
bool testBinOpRange(Class c, Type t, num lhs, num rhs, real answer)
```

## function testUnOpRange {#lang-flybytes-tests-ArithmeticTests-testUnOpRange}

```rascal
bool testUnOpRange(Class c, Type t, num arg, real answer)
```

## function fit {#lang-flybytes-tests-ArithmeticTests-fit}

```rascal
real fit(float(), real r)

real fit(double(), real r)
```

## function round {#lang-flybytes-tests-ArithmeticTests-round}

```rascal
real round(float(),  real f)

real round(double(), real f)

default int round(Type _, int f)
```

## function realVal {#lang-flybytes-tests-ArithmeticTests-realVal}

```rascal
real realVal(float(), Mirror r)

real realVal(double(), Mirror r)
```

## function intVal {#lang-flybytes-tests-ArithmeticTests-intVal}

```rascal
int  intVal(Type _, Mirror r)
```

# Tests
## test testNeg1 {#lang-flybytes-tests-ArithmeticTests-testNeg1}

```rascal
test bool testNeg1(int i)
  = all(t <- exactArithmeticTypes,
        I := i % maxIntValue(t), testUnOp(unOpClass(t, neg), t, I, -1 * I));
```

## test testAdd2 {#lang-flybytes-tests-ArithmeticTests-testAdd2}

```rascal
test bool testAdd2(int i, int j) 
  = all (t <- exactArithmeticTypes,
         I := (i % maxIntValue(t)) / 2,
         J := (j % maxIntValue(t)) / 2, 
         testBinOp(binOpClass(t, add), t, I, J, I + J));
```

## test testMul2 {#lang-flybytes-tests-ArithmeticTests-testMul2}

```rascal
test bool testMul2(int i, int j) 
  = all (t <- exactArithmeticTypes,
         I := (i % 10),
         J := (j % 10), 
         testBinOp(binOpClass(t, mul), t, I, J, I * J));
```

## test testSub2 {#lang-flybytes-tests-ArithmeticTests-testSub2}

```rascal
test bool testSub2(int i, int j) 
  = all (t <- exactArithmeticTypes,
         I := (i % maxIntValue(t)) / 2,
         J := ((j % maxIntValue(t)) / 2),
         testBinOp(binOpClass(t, sub), t, I, J, I - J));
```

## test testDivInt {#lang-flybytes-tests-ArithmeticTests-testDivInt}

```rascal
test bool testDivInt(int i, int j) 
  = all (t <- exactArithmeticTypes,
         I := (i % maxIntValue(t)),
         J := abs(((j % maxIntValue(t)) / 2)) + 1, // never 0, 
         testBinOp(binOpClass(t, div), t, I, J, I / J));
```

## test testRem {#lang-flybytes-tests-ArithmeticTests-testRem}

```rascal
test bool testRem(int i, int j) 
  = all (t <- exactArithmeticTypes,
         I := (i % maxIntValue(t)),
         J := abs(((j % maxIntValue(t)) / 2)) + 1, // never 0, 
         testBinOp(binOpClass(t, rem), t, I, J, I % J));
```

## test testAdd {#lang-flybytes-tests-ArithmeticTests-testAdd}

```rascal
test bool testAdd(real i, real j) 
  = all (t <- floatingPointTypes,
         I := fit(t, 1. / (i + .1)), // stick with numbers in +/-[0,1] we can manage
         J := fit(t, 1. / (j + .1)), // stick with numbers in +/-[0,1] we can manage
         testBinOpRange(binOpClass(t, add), t, I, J, fit(t, I + J)));
```

## test testMul {#lang-flybytes-tests-ArithmeticTests-testMul}

```rascal
test bool testMul(real i, real j) 
  = all (t <- floatingPointTypes,
         I := fit(t, 1. / (i + .1)), // stick with numbers in +/-[0,1] we can manage
         J := fit(t, 1. / (j + .1)), // stick with numbers in +/-[0,1] we can manage
         testBinOpRange(binOpClass(t, mul), t, I, J, fit(t, I * J)));
```

## test testSub {#lang-flybytes-tests-ArithmeticTests-testSub}

```rascal
test bool testSub(real i, real j) 
  = all (t <- floatingPointTypes,
         I := fit(t, 1. / (i + .1)), // stick with numbers in +/-[0,1] we can manage
         J := fit(t, 1. / (j + .1)), // stick with numbers in +/-[0,1] we can manage
         testBinOpRange(binOpClass(t, sub), t, I, J, fit(t, I - J)));
```

## test testDivReal {#lang-flybytes-tests-ArithmeticTests-testDivReal}

```rascal
test bool testDivReal(real i, real j) 
  = all (t <- floatingPointTypes,
         I := fit(t, 1. / (i + .1)), // stick with numbers in [0,1] we can manage,
         J := abs(fit(t, (1. / (j + .1)) + 1.)), // // stick with numbers in [1,2] we can manage 
         testBinOpRange(binOpClass(t, div), t, I, J, fit(t, I / J)));
```

## test testNeg {#lang-flybytes-tests-ArithmeticTests-testNeg}

```rascal
test bool testNeg(real i)
  = all(t <- floatingPointTypes,
        I := fit(t, 1. / (i + .1)), // stick with numbers in [0,1] we can manage, 
        testUnOpRange(unOpClass(t, neg), t, I, -1 * I));
```

