---
title: "module lang::flybytes::tests::ArrayTests"
id: ArrayTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/ArrayTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::ArrayTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
import Node;
import List;
```


## function primArrayTestClass {#lang-flybytes-tests-ArrayTests-primArrayTestClass}

```rascal
Class primArrayTestClass(Type t, int len)
```

## function defVal {#lang-flybytes-tests-ArrayTests-defVal}

```rascal
Exp defVal(integer())

Exp defVal(long())

Exp defVal(byte())

Exp defVal(character())

Exp defVal(short())

Exp defVal(object(str _))

Exp defVal(array(Type _))

Exp defVal(string())

Exp defVal(boolean())
```

## function testArrayClass {#lang-flybytes-tests-ArrayTests-testArrayClass}

```rascal
bool testArrayClass(Class c)
```

## function valArrayTestClass {#lang-flybytes-tests-ArrayTests-valArrayTestClass}

```rascal
Class valArrayTestClass(Type t, int len, Exp val)
```

## function initArrayTestClass {#lang-flybytes-tests-ArrayTests-initArrayTestClass}

```rascal
Class initArrayTestClass(Type t, list[Exp] values, Exp val)
```

# Tests
## test primitiveArrays10 {#lang-flybytes-tests-ArrayTests-primitiveArrays10}

```rascal
test bool primitiveArrays10() 
  = all( t <- primTypes, testArrayClass(primArrayTestClass(t, 10)));
```

## test primitiveArrays0 {#lang-flybytes-tests-ArrayTests-primitiveArrays0}

```rascal
test bool primitiveArrays0() 
  = all( t <- primTypes, testArrayClass(primArrayTestClass(t, 0)));
```

## test primitiveArrays1 {#lang-flybytes-tests-ArrayTests-primitiveArrays1}

```rascal
test bool primitiveArrays1() 
  = all( t <- primTypes, testArrayClass(primArrayTestClass(t, 1)));
```

## test boolArrayTrue1 {#lang-flybytes-tests-ArrayTests-boolArrayTrue1}

```rascal
test bool boolArrayTrue1() 
  = testArrayClass(valArrayTestClass(boolean(), 1, \true()));
```

## test boolArrayFalse1 {#lang-flybytes-tests-ArrayTests-boolArrayFalse1}

```rascal
test bool boolArrayFalse1() 
  = testArrayClass(valArrayTestClass(boolean(), 1, \false()));
```

## test boolArrayFalse10 {#lang-flybytes-tests-ArrayTests-boolArrayFalse10}

```rascal
test bool boolArrayFalse10() 
  = testArrayClass(valArrayTestClass(boolean(), 10, \false()));
```

## test boolInitArrayTrue {#lang-flybytes-tests-ArrayTests-boolInitArrayTrue}

```rascal
test bool boolInitArrayTrue() 
  = testArrayClass(initArrayTestClass(integer(), [iconst(10), iconst(20), iconst(30)], \true()));
```

