---
title: "module lang::flybytes::tests::BranchingTests"
id: BranchingTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/BranchingTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::BranchingTests;
```

#### Dependencies
```rascal
import lang::flybytes::Compiler;
import lang::flybytes::Mirror;
import lang::flybytes::api::JavaLang;
import Node;
import util::Math;
```


## function ifClass {#lang-flybytes-tests-BranchingTests-ifClass}

```rascal
Class ifClass(Exp cond)
```

## function testIf {#lang-flybytes-tests-BranchingTests-testIf}

```rascal
bool testIf(Class c, bool answer)
```

## alias BinOp {#lang-flybytes-tests-BranchingTests-BinOp}

```rascal
Exp (Exp, Exp)
```

## function ifCmpClass {#lang-flybytes-tests-BranchingTests-ifCmpClass}

```rascal
Class ifCmpClass(Type t, BinOp op)
```

## function testIf {#lang-flybytes-tests-BranchingTests-testIf}

```rascal
bool testIf(Class c, Type t, str mn, Mirror lhs, Mirror rhs, bool answer)
```

# Tests
## test testIfTrue {#lang-flybytes-tests-BranchingTests-testIfTrue}

```rascal
test bool testIfTrue() = testIf(ifClass(\true()), true);
```

## test testIfFalse {#lang-flybytes-tests-BranchingTests-testIfFalse}

```rascal
test bool testIfFalse() = testIf(ifClass(\false()), false);
```

## test testIfMethodTrue {#lang-flybytes-tests-BranchingTests-testIfMethodTrue}

```rascal
test bool testIfMethodTrue() = testIf(ifClass(invokeStatic(methodDesc(boolean(),"methodTrue",[]),[])), true);
```

## test testIfMethodFalse {#lang-flybytes-tests-BranchingTests-testIfMethodFalse}

```rascal
test bool testIfMethodFalse() = testIf(ifClass(invokeStatic(methodDesc(boolean(),"methodFalse",[]),[])), false);
```

## test testIfEqTrue {#lang-flybytes-tests-BranchingTests-testIfEqTrue}

```rascal
test bool testIfEqTrue() = testIf(ifClass(eq(iconst(1),iconst(1))), true);
```

## test testIfEqFalse {#lang-flybytes-tests-BranchingTests-testIfEqFalse}

```rascal
test bool testIfEqFalse() = testIf(ifClass(eq(iconst(2),iconst(1))), false);
```

## test testIfEqBoolTrue {#lang-flybytes-tests-BranchingTests-testIfEqBoolTrue}

```rascal
test bool testIfEqBoolTrue() = testIf(ifClass(eq(\true(), \true())), true);
```

## test testIfEqBoolFalse {#lang-flybytes-tests-BranchingTests-testIfEqBoolFalse}

```rascal
test bool testIfEqBoolFalse() = testIf(ifClass(eq(\true(), \false())), false);
```

## test testEqTrue {#lang-flybytes-tests-BranchingTests-testEqTrue}

```rascal
test bool testEqTrue(int i) 
  = all (t <- intTypes, 
         I := prim(t, abs(i) % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, eq), t, cl, I, I, true));
```

## test testEqFalse {#lang-flybytes-tests-BranchingTests-testEqFalse}

```rascal
test bool testEqFalse(int i) 
  = all (t <- intTypes, 
         I := abs(i) % maxIntValue(t), cl <- condTypes,
         testIf(ifCmpClass(t, eq), t, cl, prim(t, I), prim(t, I - 1), false));
```

## test testNEqTrue {#lang-flybytes-tests-BranchingTests-testNEqTrue}

```rascal
test bool testNEqTrue(int i) 
  = all (t <- intTypes, 
         I := abs(i) % maxIntValue(t), cl <- condTypes,
         testIf(ifCmpClass(t, ne), t, cl, prim(t, I), prim(t, I - 1), true));
```

## test testNEqFalse {#lang-flybytes-tests-BranchingTests-testNEqFalse}

```rascal
test bool testNEqFalse(int i) 
  = all (t <- intTypes, 
         I := prim(t, abs(i) % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, ne), t, cl, I, I, false));
```

## test testLt {#lang-flybytes-tests-BranchingTests-testLt}

```rascal
test bool testLt(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, lt), t, cl, prim(t, I), prim(t, J), I < J));
```

## test testGt {#lang-flybytes-tests-BranchingTests-testGt}

```rascal
test bool testGt(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, gt), t, cl, prim(t, I), prim(t, J), I > J));
```

## test testGe {#lang-flybytes-tests-BranchingTests-testGe}

```rascal
test bool testGe(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, ge), t, cl, prim(t, I), prim(t, J), I >= J));
```

## test testLe {#lang-flybytes-tests-BranchingTests-testLe}

```rascal
test bool testLe(int i, int j) 
  = all (t <- intTypes, 
         I := (i % maxIntValue(t)),
         J := (j % maxIntValue(t)), cl <- condTypes,
         testIf(ifCmpClass(t, le), t, cl, prim(t, I), prim(t, J), I <= J));
```

