---
title: "module lang::flybytes::tests::CatchTests"
id: CatchTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/CatchTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::CatchTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
import lang::flybytes::Mirror;
```


## function catchClass {#lang-flybytes-tests-CatchTests-catchClass}

```rascal
Class catchClass()
```

## function multipleCatchClass {#lang-flybytes-tests-CatchTests-multipleCatchClass}

```rascal
Class multipleCatchClass()
```

## function finallyClass {#lang-flybytes-tests-CatchTests-finallyClass}

```rascal
Class finallyClass()
```

## function finallyContinueClass {#lang-flybytes-tests-CatchTests-finallyContinueClass}

```rascal
Class finallyContinueClass()
```

## function finallyBreakClass {#lang-flybytes-tests-CatchTests-finallyBreakClass}

```rascal
Class finallyBreakClass()
```

# Tests
## test testCatch {#lang-flybytes-tests-CatchTests-testCatch}

```rascal
test bool testCatch() = loadClass(catchClass(), file=just(|project://flybytes/generated/CatchTest.class|))
  .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

## test multipleTestCatch {#lang-flybytes-tests-CatchTests-multipleTestCatch}

```rascal
test bool multipleTestCatch() {
  m = loadClass(multipleCatchClass(), file=just(|project://flybytes/generated/MultipleCatchTest.class|));
  return m.invokeStatic(methodDesc(boolean(), "testMethod", [boolean()]), [boolean(true)]).toValue(#int) == 1
      && m.invokeStatic(methodDesc(boolean(), "testMethod", [boolean()]), [boolean(false)]).toValue(#int) == 2;
}
```

## test finallyTest {#lang-flybytes-tests-CatchTests-finallyTest}

```rascal
test bool finallyTest() {
  m = loadClass(finallyClass(), file=just(|project://flybytes/generated/FinallyTest.class|));
  return m.invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#int) == 3 /*should be 3 when return supported finally */;
}
```

## test finallyContinueTest {#lang-flybytes-tests-CatchTests-finallyContinueTest}

```rascal
test bool finallyContinueTest() {
  m = loadClass(finallyContinueClass(), debugMode=false, file=just(|project://flybytes/generated/FinallyContinueTest.class|));
  return m.invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#int) == 10 /*should be 3 when return supported finally */;
}
```

## test finallyBreakTest {#lang-flybytes-tests-CatchTests-finallyBreakTest}

```rascal
test bool finallyBreakTest() {
  m = loadClass(finallyBreakClass(), debugMode=false, file=just(|project://flybytes/generated/FinallyBreakTest.class|));
  return m.invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#int) == 1;
}
```

