---
title: "module lang::flybytes::tests::ClassTests"
id: ClassTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/ClassTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::ClassTests;
```

#### Dependencies
```rascal
import lang::flybytes::Compiler;
import lang::flybytes::Mirror;
import lang::flybytes::api::JavaLang;
import lang::flybytes::api::System;
```


## function testClass {#lang-flybytes-tests-ClassTests-testClass}

```rascal
Class testClass()
```

## function compiledTestClass {#lang-flybytes-tests-ClassTests-compiledTestClass}

```rascal
Mirror compiledTestClass()
```

## function extendClass {#lang-flybytes-tests-ClassTests-extendClass}

```rascal
Class extendClass()
```

## function main {#lang-flybytes-tests-ClassTests-main}

```rascal
void main()
```

# Tests
## test newInstanceGetUnitializedInteger {#lang-flybytes-tests-ClassTests-newInstanceGetUnitializedInteger}

```rascal
test bool newInstanceGetUnitializedInteger() {
  c = compiledTestClass();
  i = c.newInstance(constructorDesc([]),[]);
  return i.getField("field").toValue(#int) == 0;
}
```

## test newInstanceCallGetter {#lang-flybytes-tests-ClassTests-newInstanceCallGetter}

```rascal
test bool newInstanceCallGetter() {
  c = compiledTestClass();
  i = c.newInstance(constructorDesc([]),[]);
  return i.invoke(methodDesc(integer(), "getField", []), []).toValue(#int) == 0;
}
```

## test newInstanceCallSetter {#lang-flybytes-tests-ClassTests-newInstanceCallSetter}

```rascal
test bool newInstanceCallSetter() {
  c = compiledTestClass();
  i = c.newInstance(constructorDesc([]),[]);
  
  int tester = 32;
  
  // call method with the side-effect
  i.invoke(methodDesc(\void(), "setField", [integer()]), [integer(tester)]);
  
  // test if it worked by retrieving the field
  return i.getField("field").toValue(#int) == tester;
}
```

## test staticMethod {#lang-flybytes-tests-ClassTests-staticMethod}

```rascal
test bool staticMethod() {
  c = compiledTestClass();
  int tester = 666;
  c.invokeStatic(methodDesc(\void(), "putStatic", [integer()]), [integer(tester)]);
  r = c.getStatic("staticField").toValue(#int);
  c.invokeStatic(methodDesc(\void(), "putStatic", [integer()]), [integer(42)]); // set it back
  return r == tester;
}
```

## test staticFieldInitializer {#lang-flybytes-tests-ClassTests-staticFieldInitializer}

```rascal
test bool staticFieldInitializer() 
  = compiledTestClass().getStatic("staticField").toValue(#int) == 42;
```

## test extendTest {#lang-flybytes-tests-ClassTests-extendTest}

```rascal
test bool extendTest() {
  // load the classes together
  cs = loadClasses([extendClass(), testClass()], prefix=just(|project://flybytes/generated/|));
  
  // get a mirror instance of the subclass
  c = cs["ExtendedClass"];
  i = c.newInstance(constructorDesc([]),[]);
  
  // call super method with a side-effect
  return i.invoke(methodDesc(\void(), "testMethod", []), []).toValue(#bool);
}
```

