---
title: "module lang::flybytes::tests::OtherExpressionTests"
id: OtherExpressionTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/OtherExpressionTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::OtherExpressionTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
```


## function incExpClass {#lang-flybytes-tests-OtherExpressionTests-incExpClass}

```rascal
Class incExpClass()
```

## function incStatClass {#lang-flybytes-tests-OtherExpressionTests-incStatClass}

```rascal
Class incStatClass()
```

## function newExpClass {#lang-flybytes-tests-OtherExpressionTests-newExpClass}

```rascal
Class newExpClass()
```

## function coerceTestClass {#lang-flybytes-tests-OtherExpressionTests-coerceTestClass}

```rascal
Class coerceTestClass(Type from, Type to, Exp \in, Exp out)
```

# Tests
## test testInc {#lang-flybytes-tests-OtherExpressionTests-testInc}

```rascal
test bool testInc() = loadClass(incExpClass())
  .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

## test testIncStat {#lang-flybytes-tests-OtherExpressionTests-testIncStat}

```rascal
test bool testIncStat() = loadClass(incStatClass())
  .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

## test testNew {#lang-flybytes-tests-OtherExpressionTests-testNew}

```rascal
test bool testNew() = loadClass(newExpClass())
   .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

## test testCoerceIntDouble {#lang-flybytes-tests-OtherExpressionTests-testCoerceIntDouble}

```rascal
test bool testCoerceIntDouble()
  = loadClass(coerceTestClass(\integer(), \double(), iconst(1), dconst(1.0)))
  .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

## test testCoerceDoubleInt {#lang-flybytes-tests-OtherExpressionTests-testCoerceDoubleInt}

```rascal
test bool testCoerceDoubleInt()
  = loadClass(coerceTestClass(\double(), \integer(), dconst(0.0), iconst(0)))
  .invokeStatic(methodDesc(boolean(), "testMethod", []), []).toValue(#bool);
```

