---
title: "module lang::flybytes::tests::SwitchTests"
id: SwitchTests
slug: /Packages/org.rascalmpl.flybytes/API/lang/flybytes/tests/SwitchTests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.flybytes-0.2.9</div>

#### Usage

```rascal
import lang::flybytes::tests::SwitchTests;
```

#### Dependencies
```rascal
import lang::flybytes::Syntax;
import lang::flybytes::Compiler;
import Node;
```


## function switchClass {#lang-flybytes-tests-SwitchTests-switchClass}

```rascal
Class switchClass(SwitchOption option)
```

## function testSwitchClass {#lang-flybytes-tests-SwitchTests-testSwitchClass}

```rascal
bool testSwitchClass(Class c, int input, int result)
```

## function switchDefaultClass {#lang-flybytes-tests-SwitchTests-switchDefaultClass}

```rascal
Class switchDefaultClass(SwitchOption option)
```

## function switchCompactClass {#lang-flybytes-tests-SwitchTests-switchCompactClass}

```rascal
Class switchCompactClass(SwitchOption option)
```

# Tests
## test simpleSwitch1table {#lang-flybytes-tests-SwitchTests-simpleSwitch1table}

```rascal
test bool simpleSwitch1table() = testSwitchClass(switchClass(table()), 42, 42);
```

## test simpleSwitch2table {#lang-flybytes-tests-SwitchTests-simpleSwitch2table}

```rascal
test bool simpleSwitch2table() = testSwitchClass(switchClass(table()), 12, 12);
```

## test simpleSwitch3table {#lang-flybytes-tests-SwitchTests-simpleSwitch3table}

```rascal
test bool simpleSwitch3table() = testSwitchClass(switchClass(table()), 18, 0);
```

## test simpleSwitch1lookup {#lang-flybytes-tests-SwitchTests-simpleSwitch1lookup}

```rascal
test bool simpleSwitch1lookup() = testSwitchClass(switchClass(lookup()), 42, 42);
```

## test simpleSwitch2lookup {#lang-flybytes-tests-SwitchTests-simpleSwitch2lookup}

```rascal
test bool simpleSwitch2lookup() = testSwitchClass(switchClass(lookup()), 12, 12);
```

## test simpleSwitch3lookup {#lang-flybytes-tests-SwitchTests-simpleSwitch3lookup}

```rascal
test bool simpleSwitch3lookup() = testSwitchClass(switchClass(lookup()), 18, 0);
```

## test simpleSwitch1auto {#lang-flybytes-tests-SwitchTests-simpleSwitch1auto}

```rascal
test bool simpleSwitch1auto() = testSwitchClass(switchClass(auto()), 42, 42);
```

## test simpleSwitch2auto {#lang-flybytes-tests-SwitchTests-simpleSwitch2auto}

```rascal
test bool simpleSwitch2auto() = testSwitchClass(switchClass(auto()), 12, 12);
```

## test simpleSwitch3auto {#lang-flybytes-tests-SwitchTests-simpleSwitch3auto}

```rascal
test bool simpleSwitch3auto() = testSwitchClass(switchClass(auto()), 18, 0);
```

## test simpleDefaultSwitch1Table {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch1Table}

```rascal
test bool simpleDefaultSwitch1Table() = testSwitchClass(switchDefaultClass(table()), 42, 42);
```

## test simpleDefaultSwitch2Table {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch2Table}

```rascal
test bool simpleDefaultSwitch2Table() = testSwitchClass(switchDefaultClass(table()), 12, 12);
```

## test simpleDefaultSwitch3Table {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch3Table}

```rascal
test bool simpleDefaultSwitch3Table() = testSwitchClass(switchDefaultClass(table()), 0, -1);
```

## test simpleDefaultSwitch1Lookup {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch1Lookup}

```rascal
test bool simpleDefaultSwitch1Lookup() = testSwitchClass(switchDefaultClass(lookup()), 42, 42);
```

## test simpleDefaultSwitch2Lookup {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch2Lookup}

```rascal
test bool simpleDefaultSwitch2Lookup() = testSwitchClass(switchDefaultClass(lookup()), 12, 12);
```

## test simpleDefaultSwitch3Lookup {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch3Lookup}

```rascal
test bool simpleDefaultSwitch3Lookup() = testSwitchClass(switchDefaultClass(lookup()), 0, -1);
```

## test simpleDefaultSwitch1Auto {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch1Auto}

```rascal
test bool simpleDefaultSwitch1Auto() = testSwitchClass(switchDefaultClass(auto()), 42, 42);
```

## test simpleDefaultSwitch2Auto {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch2Auto}

```rascal
test bool simpleDefaultSwitch2Auto() = testSwitchClass(switchDefaultClass(auto()), 12, 12);
```

## test simpleDefaultSwitch3Auto {#lang-flybytes-tests-SwitchTests-simpleDefaultSwitch3Auto}

```rascal
test bool simpleDefaultSwitch3Auto() = testSwitchClass(switchDefaultClass(auto()), 0, -1);
```

## test compactDefaultSwitch1Table {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch1Table}

```rascal
test bool compactDefaultSwitch1Table() = testSwitchClass(switchCompactClass(table()), 0, 0);
```

## test compactDefaultSwitch2Table {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch2Table}

```rascal
test bool compactDefaultSwitch2Table() = testSwitchClass(switchCompactClass(table()), 1, 1);
```

## test compactDefaultSwitch3Table {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch3Table}

```rascal
test bool compactDefaultSwitch3Table() = testSwitchClass(switchCompactClass(table()), 2, 2);
```

## test compactDefaultSwitch4Table {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch4Table}

```rascal
test bool compactDefaultSwitch4Table() = testSwitchClass(switchCompactClass(table()), 6, 5);
```

## test compactDefaultSwitch1Lookup {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch1Lookup}

```rascal
test bool compactDefaultSwitch1Lookup() = testSwitchClass(switchCompactClass(lookup()),  0, 0);
```

## test compactDefaultSwitch2Lookup {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch2Lookup}

```rascal
test bool compactDefaultSwitch2Lookup() = testSwitchClass(switchCompactClass(lookup()),  1, 1);
```

## test compactDefaultSwitch3Lookup {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch3Lookup}

```rascal
test bool compactDefaultSwitch3Lookup() = testSwitchClass(switchCompactClass(lookup()),  2, 2);
```

## test compactDefaultSwitch4Lookup {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch4Lookup}

```rascal
test bool compactDefaultSwitch4Lookup() = testSwitchClass(switchCompactClass(lookup()),  6, 5);
```

## test compactDefaultSwitch1Auto {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch1Auto}

```rascal
test bool compactDefaultSwitch1Auto() = testSwitchClass(switchCompactClass(auto()), 0, 0);
```

## test compactDefaultSwitch2Auto {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch2Auto}

```rascal
test bool compactDefaultSwitch2Auto() = testSwitchClass(switchCompactClass(auto()), 1, 1);
```

## test compactDefaultSwitch3Auto {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch3Auto}

```rascal
test bool compactDefaultSwitch3Auto() = testSwitchClass(switchCompactClass(auto()), 2, 2);
```

## test compactDefaultSwitch4Auto {#lang-flybytes-tests-SwitchTests-compactDefaultSwitch4Auto}

```rascal
test bool compactDefaultSwitch4Auto() = testSwitchClass(switchCompactClass(auto()), 6, 5);
```

