/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lang.java.m3.internal.LimitedTypeStore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.rascalmpl.values.ValueFactoryFactory;

public class BindingsResolver {
    private LimitedTypeStore store;
    private final IValueFactory values = ValueFactoryFactory.getValueFactory();
    private final TypeFactory tf = TypeFactory.getInstance();
    private final boolean collectBindings;
    private final Map<String, Integer> anonymousClassCounter = new HashMap<String, Integer>();
    private final Map<String, String> resolvedAnonymousClasses = new HashMap<String, String>();
    private final Map<ISourceLocation, Integer> initializerCounter = new HashMap<ISourceLocation, Integer>();
    private final Map<Initializer, ISourceLocation> initializerLookUp = new HashMap<Initializer, ISourceLocation>();
    private Type typeSymbol;
    private final Map<String, ISourceLocation> locationCache;
    private final boolean debug = false;
    private Set<ITypeBinding> wildCardBoundsVisited = new HashSet<ITypeBinding>();
    static int stackdepth = 0;

    BindingsResolver(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache, boolean collectBindings) {
        this.collectBindings = collectBindings;
        this.store = typeStore;
        this.locationCache = cache;
    }

    public ISourceLocation resolveBinding(ASTNode node, boolean tryHard) {
        if (this.collectBindings) {
            if (node instanceof TypeDeclaration) {
                return this.resolveBinding(((TypeDeclaration)node).resolveBinding());
            }
            if (node instanceof ModuleDeclaration) {
                return this.resolveBinding((IBinding)((ModuleDeclaration)node).resolveBinding());
            }
            if (node instanceof EnumDeclaration) {
                return this.resolveBinding(((EnumDeclaration)node).resolveBinding());
            }
            if (node instanceof AnnotationTypeDeclaration) {
                return this.resolveBinding(((AnnotationTypeDeclaration)node).resolveBinding());
            }
            if (node instanceof AnnotationTypeMemberDeclaration) {
                return this.resolveBinding(((AnnotationTypeMemberDeclaration)node).resolveBinding());
            }
            if (node instanceof AnonymousClassDeclaration) {
                return this.resolveBinding(((AnonymousClassDeclaration)node).resolveBinding());
            }
            if (node instanceof EnumConstantDeclaration) {
                return this.resolveBinding(((EnumConstantDeclaration)node).resolveVariable());
            }
            if (node instanceof ClassInstanceCreation) {
                return this.resolveBinding(((ClassInstanceCreation)node).resolveConstructorBinding());
            }
            if (node instanceof FieldAccess) {
                return this.resolveFieldAccess((FieldAccess)node);
            }
            if (node instanceof MethodInvocation) {
                return this.resolveBinding(((MethodInvocation)node).resolveMethodBinding());
            }
            if (node instanceof QualifiedName) {
                return this.resolveQualifiedName((QualifiedName)node);
            }
            if (node instanceof SimpleName) {
                return this.resolveSimpleName(node, tryHard);
            }
            if (node instanceof SuperFieldAccess) {
                return this.resolveBinding(((SuperFieldAccess)node).resolveFieldBinding());
            }
            if (node instanceof SuperMethodInvocation) {
                return this.resolveBinding(((SuperMethodInvocation)node).resolveMethodBinding());
            }
            if (node instanceof MemberRef) {
                return this.resolveBinding(((MemberRef)node).resolveBinding());
            }
            if (node instanceof MethodDeclaration) {
                return this.resolveBinding(((MethodDeclaration)node).resolveBinding());
            }
            if (node instanceof MethodRef) {
                return this.resolveBinding(((MethodRef)node).resolveBinding());
            }
            if (node instanceof PackageDeclaration) {
                return this.resolveBinding(((PackageDeclaration)node).resolveBinding());
            }
            if (node instanceof org.eclipse.jdt.core.dom.Type) {
                return this.resolveBinding(((org.eclipse.jdt.core.dom.Type)node).resolveBinding());
            }
            if (node instanceof TypeParameter) {
                return this.resolveBinding(((TypeParameter)node).resolveBinding());
            }
            if (node instanceof VariableDeclaration) {
                return this.resolveVariable(node);
            }
            if (node instanceof ConstructorInvocation) {
                return this.resolveBinding(((ConstructorInvocation)node).resolveConstructorBinding());
            }
            if (node instanceof SuperConstructorInvocation) {
                return this.resolveBinding(((SuperConstructorInvocation)node).resolveConstructorBinding());
            }
            if (node instanceof TypeDeclarationStatement) {
                return this.resolveBinding(((TypeDeclarationStatement)node).resolveBinding());
            }
            if (node instanceof Initializer) {
                return this.resolveInitializer((Initializer)node);
            }
        }
        return this.makeBinding("unknown", null, null);
    }

    private ISourceLocation resolveVariable(ASTNode node) {
        VariableDeclaration n = (VariableDeclaration)node;
        IVariableBinding bin = n.resolveBinding();
        ISourceLocation result = this.resolveBinding(n.resolveBinding());
        if (result.getScheme() == "unresolved") {
            result = this.resolveBinding(n.getParent(), (IBinding)bin, n.getName());
        }
        return result;
    }

    private ISourceLocation resolveSimpleName(ASTNode node, boolean tryHard) {
        SimpleName n = (SimpleName)node;
        IBinding resolveBinding = n.resolveBinding();
        ISourceLocation result = this.resolveBinding(resolveBinding);
        if (result.getScheme().equals("unresolved") && n.getIdentifier().equals("java") && node.getParent() instanceof QualifiedName) {
            result = this.makeBinding("java+package", "", "java");
        } else if (result.getScheme().equals("unresolved") && tryHard) {
            result = this.resolveBinding(n.getParent(), resolveBinding, n);
        }
        return result;
    }

    private ISourceLocation resolveFieldAccess(FieldAccess node) {
        ITypeBinding tb = node.getExpression().resolveTypeBinding();
        if (tb != null && tb.isArray() && "length".equals(node.getName().getIdentifier())) {
            ISourceLocation arrayType = this.resolveBinding(tb);
            return this.makeBinding("java+arrayLength", arrayType.getAuthority(), arrayType.getPath());
        }
        return this.resolveBinding(node.resolveFieldBinding());
    }

    private ISourceLocation resolveBinding(ASTNode parentNode, IBinding resolvedBinding, SimpleName nodeName) {
        ISourceLocation parentBinding = this.resolveBinding(parentNode, false);
        while (parentBinding.getScheme().equals("unknown") || parentBinding.getScheme().equals("unresolved")) {
            if (parentNode == null) {
                return this.makeBinding("unresolved", null, null);
            }
            parentNode = parentNode.getParent();
            parentBinding = this.resolveBinding(parentNode, false);
        }
        if (resolvedBinding == null) {
            return this.makeBinding("unresolved", null, null);
        }
        String key = resolvedBinding.getKey();
        if (!(parentNode instanceof Initializer) && this.locationCache.containsKey(key)) {
            return this.locationCache.get(key);
        }
        Object qualifiedName = parentBinding.getPath();
        String[] bindingKeys = key.split("#");
        if (bindingKeys.length > 2) {
            for (int i = 1; i < bindingKeys.length - 1; ++i) {
                if (!((String)qualifiedName).endsWith("/")) {
                    qualifiedName = (String)qualifiedName + "/";
                }
                qualifiedName = (String)qualifiedName + "scope(" + bindingKeys[i] + ")/";
            }
        }
        ISourceLocation childBinding = this.makeBinding("java+variable", null, ((String)qualifiedName).concat(nodeName.getIdentifier()));
        this.locationCache.put(key, childBinding);
        return childBinding;
    }

    private ISourceLocation resolveQualifiedName(QualifiedName node) {
        ITypeBinding tb = node.getQualifier().resolveTypeBinding();
        if (tb != null && tb.isArray() && "length".equals(node.getName().getIdentifier())) {
            ISourceLocation arrayType = this.resolveBinding(tb);
            return this.makeBinding("java+arrayLength", arrayType.getAuthority(), arrayType.getPath());
        }
        return this.resolveBinding((ASTNode)node.getName(), false);
    }

    private ISourceLocation resolveInitializer(Initializer node) {
        if (this.initializerLookUp.containsKey(node)) {
            return this.initializerLookUp.get(node);
        }
        int initCounter = 1;
        ISourceLocation parent = this.resolveBinding(node.getParent(), true);
        if (this.initializerCounter.containsKey(parent)) {
            initCounter = this.initializerCounter.get(parent) + 1;
        }
        this.initializerCounter.put(parent, initCounter);
        Object key = "";
        for (String storedKey : this.locationCache.keySet()) {
            if (!this.locationCache.get(storedKey).equals(parent)) continue;
            key = storedKey;
            break;
        }
        key = (String)key + "$initializer" + initCounter;
        ISourceLocation result = this.makeBinding("java+initializer", null, parent.getPath() + "$initializer" + initCounter);
        this.locationCache.put((String)key, result);
        this.initializerLookUp.put(node, result);
        return result;
    }

    public ISourceLocation resolveBinding(IBinding binding) {
        if (binding == null) {
            return this.makeBinding("unresolved", null, null);
        }
        if (binding instanceof ITypeBinding) {
            return this.resolveBinding((ITypeBinding)binding);
        }
        if (binding instanceof IMethodBinding) {
            return this.resolveBinding((IMethodBinding)binding);
        }
        if (binding instanceof IPackageBinding) {
            return this.resolveBinding((IPackageBinding)binding);
        }
        if (binding instanceof IVariableBinding) {
            return this.resolveBinding((IVariableBinding)binding);
        }
        if (binding instanceof IModuleBinding) {
            return this.makeBinding("java+module", "", ((IModuleBinding)binding).getName());
        }
        return this.makeBinding("unknown", null, null);
    }

    public IConstructor resolveType(IBinding binding, boolean isDeclaration) {
        IConstructor result = this.unresolvedSym();
        if (binding != null) {
            ISourceLocation uri = this.resolveBinding(binding);
            if (binding instanceof ITypeBinding) {
                return this.computeTypeSymbol(uri, (ITypeBinding)binding, isDeclaration);
            }
            if (binding instanceof IMethodBinding) {
                return this.computeMethodTypeSymbol(uri, (IMethodBinding)binding, isDeclaration);
            }
            if (binding instanceof IVariableBinding) {
                return this.resolveType((IBinding)((IVariableBinding)binding).getType(), isDeclaration);
            }
            if (binding instanceof IModuleBinding) {
                return this.computeTypeSymbol(uri);
            }
        }
        return result;
    }

    private IConstructor computeMethodTypeSymbol(ISourceLocation decl, IMethodBinding binding, boolean isDeclaration) {
        IList parameters = this.computeTypes(isDeclaration ? binding.getParameterTypes() : binding.getTypeArguments(), false);
        if (binding.isConstructor()) {
            return this.constructorSymbol(decl, parameters);
        }
        IList typeParameters = this.computeTypes(isDeclaration ? binding.getTypeParameters() : binding.getTypeArguments(), isDeclaration);
        IConstructor retSymbol = this.resolveType((IBinding)binding.getReturnType(), false);
        return this.methodSymbol(decl, typeParameters, retSymbol, parameters);
    }

    private IList computeTypes(ITypeBinding[] bindings, boolean isDeclaration) {
        IListWriter parameters = this.values.listWriter();
        for (ITypeBinding parameterType : bindings) {
            IConstructor arg = this.resolveType((IBinding)parameterType, isDeclaration);
            parameters.append(new IValue[]{arg});
        }
        return (IList)parameters.done();
    }

    private Type getTypeSymbol() {
        if (this.typeSymbol == null) {
            this.typeSymbol = this.store.lookupAbstractDataType("TypeSymbol");
        }
        return this.typeSymbol;
    }

    private IConstructor methodSymbol(ISourceLocation decl, IList typeParameters, IConstructor retSymbol, IList parameters) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "method", this.tf.tupleType(new Type[]{decl.getType(), typeParameters.getType(), retSymbol.getType(), parameters.getType()}));
        return this.values.constructor(cons, new IValue[]{decl, typeParameters, retSymbol, parameters});
    }

    private IConstructor constructorSymbol(ISourceLocation decl, IList parameters) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "constructor", this.tf.tupleType(new Type[]{decl.getType(), parameters.getType()}));
        return this.values.constructor(cons, new IValue[]{decl, parameters});
    }

    private IConstructor parameterNode(ISourceLocation decl, ITypeBinding[] bound, boolean isDeclaration, boolean isUpperbound) {
        IConstructor boundSym = this.unboundedSym();
        if (isDeclaration) {
            if (bound.length > 0) {
                boundSym = this.boundSymbol(bound, isDeclaration, isUpperbound);
            }
            Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "typeParameter", this.tf.tupleType(new Type[]{decl.getType(), boundSym.getType()}));
            return this.values.constructor(cons, new IValue[]{decl, boundSym});
        }
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "typeArgument", this.tf.tupleType(new Type[]{decl.getType()}));
        return this.values.constructor(cons, new IValue[]{decl});
    }

    private IConstructor unboundedSym() {
        Type boundType = this.store.lookupAbstractDataType("Bound");
        Type cons = this.store.lookupConstructor(boundType, "unbounded", this.tf.voidType());
        return this.values.constructor(cons);
    }

    private IConstructor unresolvedSym() {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "unresolved", this.tf.voidType());
        return this.values.constructor(cons);
    }

    private IConstructor computeTypeSymbol(ISourceLocation decl) {
        return this.moduleSymbol(decl);
    }

    private IConstructor computeTypeSymbol(ISourceLocation decl, ITypeBinding binding, boolean isDeclaration) {
        if (binding.isPrimitive()) {
            return this.primitiveSymbol(binding.getName());
        }
        if (binding.isArray()) {
            return this.arraySymbol(this.resolveType((IBinding)binding.getComponentType(), isDeclaration), binding.getDimensions());
        }
        if (binding.isNullType()) {
            return this.nullSymbol();
        }
        if (binding.isEnum()) {
            return this.enumSymbol(decl);
        }
        if (binding.isTypeVariable()) {
            return this.parameterNode(decl, binding.getTypeBounds(), isDeclaration, true);
        }
        if (binding.isWildcardType()) {
            ITypeBinding bound = binding.getBound();
            if (bound == null) {
                return this.wildcardSymbol(this.unboundedSym());
            }
            return this.wildcardSymbol(this.boundSymbol(new ITypeBinding[]{bound}, isDeclaration, binding.isUpperbound()));
        }
        if (binding.isClass()) {
            return this.classSymbol(decl, this.computeTypes(isDeclaration ? binding.getTypeParameters() : binding.getTypeArguments(), isDeclaration));
        }
        if (binding.isCapture()) {
            ITypeBinding[] typeBounds = binding.getTypeBounds();
            ITypeBinding wildcard = binding.getWildcard();
            if (typeBounds.length == 0) {
                return this.captureSymbol(this.unboundedSym(), this.resolveType((IBinding)wildcard, isDeclaration));
            }
            for (ITypeBinding b : typeBounds) {
                if (this.wildCardBoundsVisited.contains(b)) {
                    return this.captureSymbol(this.unboundedSym(), this.resolveType((IBinding)wildcard, isDeclaration));
                }
                this.wildCardBoundsVisited.add(b);
            }
            IConstructor res = this.captureSymbol(this.boundSymbol(typeBounds, isDeclaration, true), this.resolveType((IBinding)wildcard, isDeclaration));
            for (ITypeBinding b : typeBounds) {
                this.wildCardBoundsVisited.remove(b);
            }
            return res;
        }
        if (binding.isInterface()) {
            return this.interfaceSymbol(decl, this.computeTypes(isDeclaration ? binding.getTypeParameters() : binding.getTypeArguments(), isDeclaration));
        }
        return null;
    }

    private IConstructor captureSymbol(IConstructor bound, IConstructor wildcard) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "capture", this.tf.tupleType(new Type[]{bound.getType(), wildcard.getType()}));
        return this.values.constructor(cons, new IValue[]{bound, wildcard});
    }

    private IConstructor wildcardSymbol(IConstructor boundSymbol) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "wildcard", this.tf.tupleType(new Type[]{boundSymbol.getType()}));
        return this.values.constructor(cons, new IValue[]{boundSymbol});
    }

    private IConstructor boundSymbol(ITypeBinding[] bound, boolean isDeclaration, boolean isUpperbound) {
        IList boundSym = this.computeTypes(bound, false);
        if (++stackdepth > 5) {
            System.err.println("100!");
        }
        --stackdepth;
        Type boundType = this.store.lookupAbstractDataType("Bound");
        if (!isUpperbound) {
            Type sup = this.store.lookupConstructor(boundType, "super", this.tf.tupleType(new Type[]{boundSym.getType()}));
            return this.values.constructor(sup, new IValue[]{boundSym});
        }
        Type ext = this.store.lookupConstructor(boundType, "extends", this.tf.tupleType(new Type[]{boundSym.getType()}));
        return this.values.constructor(ext, new IValue[]{boundSym});
    }

    private IConstructor enumSymbol(ISourceLocation decl) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "enum", this.tf.tupleType(new Type[]{decl.getType()}));
        return this.values.constructor(cons, new IValue[]{decl});
    }

    private IConstructor interfaceSymbol(ISourceLocation decl, IList typeParameters) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "interface", this.tf.tupleType(new Type[]{decl.getType(), typeParameters.getType()}));
        return this.values.constructor(cons, new IValue[]{decl, typeParameters});
    }

    private IConstructor classSymbol(ISourceLocation decl, IList typeParameters) {
        if (decl.getPath().equals("/java/lang/Object")) {
            Type obj = this.store.lookupConstructor(this.getTypeSymbol(), "object", this.tf.voidType());
            return this.values.constructor(obj);
        }
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "class", this.tf.tupleType(new Type[]{decl.getType(), typeParameters.getType()}));
        return this.values.constructor(cons, new IValue[]{decl, typeParameters});
    }

    private IConstructor nullSymbol() {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "null", this.tf.voidType());
        return this.values.constructor(cons);
    }

    private IConstructor primitiveSymbol(String name) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), name, this.tf.voidType());
        return this.values.constructor(cons);
    }

    private IConstructor moduleSymbol(ISourceLocation name) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "module", this.tf.sourceLocationType());
        return this.values.constructor(cons, new IValue[]{name});
    }

    private IConstructor arraySymbol(IConstructor elem, int dimensions) {
        Type cons = this.store.lookupConstructor(this.getTypeSymbol(), "array", this.tf.tupleType(new Type[]{elem.getType(), this.tf.integerType()}));
        return this.values.constructor(cons, new IValue[]{elem, this.values.integer(dimensions)});
    }

    private ISourceLocation resolveBinding(IMethodBinding binding) {
        if (binding == null) {
            return this.makeBinding("unresolved", null, null);
        }
        if (this.locationCache.containsKey(binding.getKey())) {
            return this.locationCache.get(binding.getKey());
        }
        String signature = this.resolveBinding(binding.getDeclaringClass()).getPath();
        if (!signature.isEmpty()) {
            signature = signature.concat("/");
        }
        String params = "";
        for (ITypeBinding parameterType : binding.getMethodDeclaration().getParameterTypes()) {
            if (!params.isEmpty()) {
                params = params.concat(",");
            }
            params = parameterType.isTypeVariable() ? params.concat(parameterType.getName()) : params.concat(this.getPath(this.resolveBinding(parameterType)).replaceAll("/", "."));
        }
        signature = signature.concat(binding.getMethodDeclaration().getName() + "(" + params + ")");
        String scheme = "unknown";
        scheme = binding.isConstructor() ? "java+constructor" : "java+method";
        ISourceLocation result = this.makeBinding(scheme, null, signature);
        this.locationCache.put(binding.getKey(), result);
        return result;
    }

    private ISourceLocation resolveBinding(IPackageBinding binding) {
        if (binding == null) {
            return this.makeBinding("unresolved", null, null);
        }
        if (this.locationCache.containsKey(binding.getKey())) {
            return this.locationCache.get(binding.getKey());
        }
        ISourceLocation result = this.makeBinding("java+package", null, binding.getName().replaceAll("\\.", "/"));
        this.locationCache.put(binding.getKey(), result);
        return result;
    }

    private ISourceLocation resolveBinding(ITypeBinding binding) {
        try {
            if (binding == null) {
                return this.makeBinding("unresolved", null, null);
            }
            if (this.locationCache.containsKey(binding.getKey())) {
                return this.locationCache.get(binding.getKey());
            }
            String scheme = binding.isInterface() ? "java+interface" : "java+class";
            Object qualifiedName = binding.getTypeDeclaration().getQualifiedName();
            if (((String)qualifiedName).isEmpty()) {
                if (binding.getDeclaringMethod() != null) {
                    qualifiedName = this.resolveBinding(binding.getDeclaringMethod()).getPath();
                } else if (binding.getDeclaringClass() != null) {
                    qualifiedName = this.resolveBinding(binding.getDeclaringClass()).getPath();
                }
            }
            if (binding.isEnum()) {
                scheme = "java+enum";
            }
            if (binding.isArray()) {
                scheme = "java+array";
            }
            if (binding.isTypeVariable()) {
                scheme = "java+typeVariable";
                if (binding.getDeclaringMethod() != null) {
                    qualifiedName = this.resolveBinding(binding.getDeclaringMethod()).getPath() + "/" + (String)qualifiedName;
                } else if (binding.getDeclaringClass() != null) {
                    qualifiedName = this.resolveBinding(binding.getDeclaringClass()).getPath() + "/" + (String)qualifiedName;
                }
            }
            if (binding.isPrimitive()) {
                scheme = "java+primitiveType";
            }
            if (binding.isWildcardType()) {
                return this.makeBinding("java+wildcardType", null, null);
            }
            if (binding.isLocal()) {
                qualifiedName = ((String)qualifiedName).concat("/").concat(binding.getName());
            }
            if (binding.isAnonymous()) {
                String key = binding.getKey();
                if (this.resolvedAnonymousClasses.containsKey(key)) {
                    qualifiedName = this.resolvedAnonymousClasses.get(key);
                } else {
                    int anonCounter = 1;
                    anonCounter = this.anonymousClassCounter.containsKey(qualifiedName) ? this.anonymousClassCounter.get(qualifiedName) + 1 : 1;
                    this.anonymousClassCounter.put((String)qualifiedName, anonCounter);
                    qualifiedName = (String)qualifiedName + "$anonymous" + anonCounter;
                    this.resolvedAnonymousClasses.put(key, (String)qualifiedName);
                }
                scheme = "java+anonymousClass";
            }
            ISourceLocation result = this.makeBinding(scheme, null, ((String)qualifiedName).replaceAll("\\.", "/"));
            this.locationCache.put(binding.getKey(), result);
            return result;
        }
        catch (AbortCompilation e) {
            return this.makeBinding("unknown", null, null);
        }
    }

    private ISourceLocation resolveBinding(IVariableBinding binding) {
        if (binding == null) {
            return this.makeBinding("unresolved", null, null);
        }
        Object qualifiedName = "";
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass != null) {
            qualifiedName = this.getPath(this.resolveBinding(declaringClass));
        } else {
            IMethodBinding declaringMethod = binding.getDeclaringMethod();
            if (declaringMethod != null) {
                qualifiedName = this.getPath(this.resolveBinding(declaringMethod));
            }
        }
        if (((String)qualifiedName).isEmpty()) {
            return this.makeBinding("unresolved", null, null);
        }
        qualifiedName = ((String)qualifiedName).concat("/");
        if (this.locationCache.containsKey(binding.getKey())) {
            return this.locationCache.get(binding.getKey());
        }
        String bindingKey = binding.getKey();
        String[] bindingKeys = bindingKey.split("#");
        if (bindingKeys.length > 2) {
            for (int i = 1; i < bindingKeys.length - 1; ++i) {
                if (!((String)qualifiedName).endsWith("/")) {
                    qualifiedName = (String)qualifiedName + "/";
                }
                qualifiedName = (String)qualifiedName + "scope(" + bindingKeys[i] + ")/";
            }
        }
        String scheme = "java+variable";
        if (binding.isEnumConstant()) {
            scheme = "java+enumConstant";
        } else if (binding.isParameter()) {
            scheme = "java+parameter";
        } else if (binding.isField()) {
            scheme = "java+field";
        }
        ISourceLocation result = this.makeBinding(scheme, null, ((String)qualifiedName).concat(binding.getName()));
        this.locationCache.put(binding.getKey(), result);
        return result;
    }

    protected ISourceLocation makeBinding(String scheme, String authority, String path) {
        try {
            return this.values.sourceLocation(scheme, authority, path);
        }
        catch (UnsupportedOperationException | URISyntaxException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    private String getPath(ISourceLocation iSourceLocation) {
        String path = iSourceLocation.getPath();
        return path.substring(1, path.length());
    }
}

