/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.BiConsumer;
import lang.java.m3.internal.ASTConverter;
import lang.java.m3.internal.JarConverter;
import lang.java.m3.internal.LimitedTypeStore;
import lang.java.m3.internal.SourceConverter;
import lang.java.m3.internal.TypeStoreWrapper;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.parser.gtd.io.InputConverter;
import org.rascalmpl.unicode.UnicodeDetector;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.IRascalValueFactory;

public class EclipseJavaCompiler {
    protected final IValueFactory VF;
    protected final LimitedTypeStore definitions;
    private final IRascalMonitor monitor;

    public EclipseJavaCompiler(IValueFactory vf, TypeStore definitions, IRascalMonitor monitor) {
        this.VF = vf;
        this.definitions = new TypeStoreWrapper(definitions);
        this.monitor = monitor;
    }

    protected LimitedTypeStore getM3Store() {
        return this.definitions;
    }

    public IValue createM3FromJarClass(ISourceLocation jarLoc, IList classPath) {
        this.checkClassPath(classPath);
        return this.createM3FromJarClass(jarLoc, classPath, this.getM3Store());
    }

    private void checkClassPath(IList classPath) {
        classPath.stream().map(elem -> (ISourceLocation)elem).forEach(l -> {
            if (!URIResolverRegistry.getInstance().exists(l)) {
                throw RuntimeExceptionFactory.io((String)("Path element does not exist: " + String.valueOf(l)));
            }
        });
    }

    public IValue createM3FromSingleClass(ISourceLocation classLoc, IString className, IList classpath) {
        this.checkClassPath(classpath);
        JarConverter converter = new JarConverter(this.getM3Store(), new HashMap<String, ISourceLocation>());
        converter.convertJarFile(classLoc, className.getValue(), classpath);
        return converter.getModel(false);
    }

    protected IValue createM3FromJarClass(ISourceLocation jarLoc, IList classPath, LimitedTypeStore store) {
        this.checkClassPath(classPath);
        JarConverter converter = new JarConverter(store, new HashMap<String, ISourceLocation>());
        converter.convertJar(jarLoc, classPath);
        return converter.getModel(false);
    }

    public IValue createM3FromJarFile(ISourceLocation jarLoc, IList classPath) {
        this.checkClassPath(classPath);
        return this.createM3FromJarFile(jarLoc, classPath, this.getM3Store());
    }

    protected IValue createM3FromJarFile(ISourceLocation jarLoc, IList classPath, LimitedTypeStore store) {
        JarConverter converter = new JarConverter(store, new HashMap<String, ISourceLocation>());
        converter.convertJar(jarLoc, classPath);
        return converter.getModel(false);
    }

    public IValue createM3sFromFiles(ISet files, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion) {
        this.checkClassPath(classPath);
        this.checkClassPath(sourcePath);
        return this.createM3sFromFiles(files, errorRecovery, sourcePath, classPath, javaVersion, this.getM3Store(), () -> this.checkInterrupted(this.monitor));
    }

    protected IValue createM3sFromFiles(ISet files, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, LimitedTypeStore store, Runnable interruptChecker) {
        this.checkClassPath(classPath);
        this.checkClassPath(sourcePath);
        try {
            HashMap cache = new HashMap();
            ISetWriter result = this.VF.setWriter();
            this.buildCompilationUnits(files, true, errorRecovery.getValue(), sourcePath, classPath, javaVersion, (loc, cu) -> {
                interruptChecker.run();
                result.insert(new IValue[]{this.convertToM3(store, cache, (ISourceLocation)loc, javaVersion, (CompilationUnit)cu)});
            });
            return result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    private void checkInterrupted(IRascalMonitor eval) {
    }

    public IValue createM3sAndAstsFromFiles(ISet files, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion) {
        return this.createM3sAndAstsFromFiles(files, errorRecovery, sourcePath, classPath, javaVersion, this.getM3Store(), () -> this.checkInterrupted(this.monitor));
    }

    protected IValue createM3sAndAstsFromFiles(ISet files, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, LimitedTypeStore store, Runnable interruptChecker) {
        this.checkClassPath(sourcePath);
        this.checkClassPath(classPath);
        try {
            HashMap cache = new HashMap();
            ISetWriter m3s = this.VF.setWriter();
            ISetWriter asts = this.VF.setWriter();
            this.buildCompilationUnits(files, true, errorRecovery.getValue(), sourcePath, classPath, javaVersion, (loc, cu) -> {
                interruptChecker.run();
                m3s.insert(new IValue[]{this.convertToM3(store, cache, (ISourceLocation)loc, javaVersion, (CompilationUnit)cu)});
                asts.insert(new IValue[]{this.convertToAST(this.VF.bool(true), cache, (ISourceLocation)loc, javaVersion, (CompilationUnit)cu, store)});
            });
            return this.VF.tuple(new IValue[]{m3s.done(), asts.done()});
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    public IValue createM3FromString(ISourceLocation loc, IString contents, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion) {
        this.checkClassPath(sourcePath);
        this.checkClassPath(classPath);
        return this.createM3FromString(loc, contents, errorRecovery, sourcePath, classPath, javaVersion, this.getM3Store());
    }

    protected IValue createM3FromString(ISourceLocation loc, IString contents, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, LimitedTypeStore store) {
        this.checkClassPath(sourcePath);
        this.checkClassPath(classPath);
        try {
            CompilationUnit cu = this.getCompilationUnit(loc.getPath(), contents.getValue().toCharArray(), true, errorRecovery.getValue(), javaVersion, this.translatePaths(sourcePath), this.translatePaths(classPath));
            return this.convertToM3(store, new HashMap<String, ISourceLocation>(), loc, javaVersion, cu);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    public IValue createAstsFromFiles(ISet files, IBool collectBindings, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion) {
        return this.createAstsFromFiles(files, collectBindings, errorRecovery, sourcePath, classPath, javaVersion, this.getM3Store(), () -> this.checkInterrupted(this.monitor));
    }

    protected IValue createAstsFromFiles(ISet files, IBool collectBindings, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, LimitedTypeStore store, Runnable interruptChecker) {
        this.checkClassPath(sourcePath);
        this.checkClassPath(classPath);
        try {
            HashMap cache = new HashMap();
            ISetWriter result = this.VF.setWriter();
            this.buildCompilationUnits(files, collectBindings.getValue(), errorRecovery.getValue(), sourcePath, classPath, javaVersion, (loc, cu) -> {
                interruptChecker.run();
                result.insert(new IValue[]{this.convertToAST(collectBindings, cache, (ISourceLocation)loc, javaVersion, (CompilationUnit)cu, store)});
            });
            return result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    public IValue createAstFromString(ISourceLocation loc, IString contents, IBool collectBindings, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion) {
        return this.createAstFromString(loc, contents, collectBindings, errorRecovery, sourcePath, classPath, javaVersion, this.getM3Store());
    }

    protected IValue createAstFromString(ISourceLocation loc, IString contents, IBool collectBindings, IBool errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, LimitedTypeStore store) {
        try {
            CompilationUnit cu = this.getCompilationUnit(loc.getPath(), contents.getValue().toCharArray(), collectBindings.getValue(), errorRecovery.getValue(), javaVersion, this.translatePaths(sourcePath), this.translatePaths(classPath));
            return this.convertToAST(collectBindings, new HashMap<String, ISourceLocation>(), loc, javaVersion, cu, store);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.VF.string(e.getMessage()), null, null);
        }
    }

    protected IValue convertToM3(LimitedTypeStore store, Map<String, ISourceLocation> cache, ISourceLocation loc, IConstructor javaVersion, CompilationUnit cu) {
        SourceConverter converter = new SourceConverter(store, cache);
        converter.convert(cu, (ASTNode)cu, loc);
        for (Object cm : cu.getCommentList()) {
            Comment comment = (Comment)cm;
            if (comment.getParent() != null) continue;
            converter.convert(cu, (ASTNode)comment, loc);
        }
        return converter.getModel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildCompilationUnits(ISet files, boolean resolveBindings, boolean errorRecovery, IList sourcePath, IList classPath, IConstructor javaVersion, final BiConsumer<ISourceLocation, CompilationUnit> buildNotifier) throws IOException {
        boolean fastPath = true;
        for (IValue f : files) {
            fastPath &= this.safeResolve((ISourceLocation)f).getScheme().equals("file");
        }
        if (fastPath) {
            final HashMap<String, ISourceLocation> reversePathLookup = new HashMap<String, ISourceLocation>();
            String[] absolutePaths = new String[files.size()];
            String[] encodings = new String[absolutePaths.length];
            int i = 0;
            try {
                this.monitor.jobStart("Resolving source files", files.size());
                for (IValue p : files) {
                    this.monitor.jobStep("Resolving source files", p.toString(), 1);
                    ISourceLocation loc = (ISourceLocation)p;
                    if (!URIResolverRegistry.getInstance().isFile(loc)) {
                        throw RuntimeExceptionFactory.io((IString)this.VF.string(String.valueOf(loc) + " is not a file"), null, null);
                    }
                    if (!URIResolverRegistry.getInstance().exists(loc)) {
                        throw RuntimeExceptionFactory.io((IString)this.VF.string(String.valueOf(loc) + " doesn't exist"), null, null);
                    }
                    absolutePaths[i] = new File(this.safeResolve(loc).getPath()).getAbsolutePath();
                    reversePathLookup.put(absolutePaths[i], loc);
                    encodings[i] = this.guessEncoding(loc);
                    ++i;
                }
            }
            finally {
                this.monitor.jobEnd("Resolving source files", true);
            }
            ASTParser parser = this.constructASTParser(resolveBindings, errorRecovery, javaVersion, this.translatePaths(sourcePath), this.translatePaths(classPath));
            try {
                this.monitor.jobStart("Mapping syntax trees", files.size());
                parser.createASTs(absolutePaths, encodings, new String[0], new FileASTRequestor(){

                    public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                        EclipseJavaCompiler.this.monitor.jobStep("Mapping syntax trees", sourceFilePath, 1);
                        buildNotifier.accept((ISourceLocation)reversePathLookup.get(sourceFilePath), ast);
                    }
                }, null);
            }
            finally {
                this.monitor.jobEnd("Mapping syntax trees", true);
            }
        }
        this.monitor.jobStart("Mapping syntax trees", files.size());
        try {
            for (IValue file : files) {
                this.monitor.jobStep("Mapping syntax trees", file.toString(), 1);
                ISourceLocation loc = (ISourceLocation)file;
                CompilationUnit cu = this.getCompilationUnit(loc.getPath(), this.getFileContents(loc), resolveBindings, errorRecovery, javaVersion, this.translatePaths(sourcePath), this.translatePaths(classPath));
                buildNotifier.accept(loc, cu);
            }
        }
        finally {
            this.monitor.jobEnd("Mapping syntax trees", true);
        }
    }

    protected String[] translatePaths(IList paths) {
        String[] result = new String[paths.length()];
        int i = 0;
        for (IValue p : paths) {
            ISourceLocation loc = this.safeResolve((ISourceLocation)p);
            if (!loc.getScheme().equals("file")) {
                this.monitor.warning("skipped unresolvable path (must be file:/// scheme) ", loc);
            }
            result[i++] = new File(loc.getPath()).getAbsolutePath();
        }
        return result;
    }

    private ISourceLocation safeResolve(ISourceLocation loc) {
        try {
            ISourceLocation result = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (result != null) {
                return result;
            }
            return loc;
        }
        catch (IOException e) {
            return loc;
        }
    }

    protected String guessEncoding(ISourceLocation loc) {
        String string;
        block9: {
            Charset result = URIResolverRegistry.getInstance().getCharset(loc);
            if (result != null) {
                return result.name();
            }
            InputStream file = URIResolverRegistry.getInstance().getInputStream(loc);
            try {
                string = UnicodeDetector.estimateCharset((InputStream)file).name();
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable x) {
                    return null;
                }
            }
            file.close();
        }
        return string;
    }

    protected CompilationUnit getCompilationUnit(String unitName, char[] contents, boolean resolveBindings, boolean errorRecovery, IConstructor javaVersion, String[] sourcePath, String[] classPath) throws IOException {
        ASTParser parser = this.constructASTParser(resolveBindings, errorRecovery, javaVersion, sourcePath, classPath);
        parser.setUnitName(unitName);
        parser.setSource(contents);
        return (CompilationUnit)parser.createAST(null);
    }

    protected IValue convertToAST(IBool collectBindings, Map<String, ISourceLocation> cache, ISourceLocation loc, IConstructor javaVersion, CompilationUnit cu, LimitedTypeStore store) {
        ASTConverter converter = new ASTConverter(store, cache, collectBindings.getValue());
        converter.convert(cu, (ASTNode)cu, loc);
        converter.insertCompilationUnitMessages(true, null);
        return converter.getValue();
    }

    protected ASTParser constructASTParser(boolean resolveBindings, boolean errorRecovery, IConstructor javaVersion, String[] sourcePath, String[] classPath) {
        ASTParser parser = ASTParser.newParser((int)13);
        parser.setResolveBindings(resolveBindings);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(errorRecovery);
        IBool previewParameter = (IBool)javaVersion.asWithKeywordParameters().getParameter("preview");
        if (previewParameter == null) {
            previewParameter = IRascalValueFactory.getInstance().bool(true);
        }
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.jdt.core.compiler.source", ((IString)javaVersion.asWithKeywordParameters().getParameter("version")).getValue());
        options.put("org.eclipse.jdt.core.compiler.compliance", ((IString)javaVersion.asWithKeywordParameters().getParameter("version")).getValue());
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", previewParameter.getValue() ? "enabled" : "disabled");
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        parser.setEnvironment(classPath, sourcePath, null, true);
        return parser;
    }

    protected char[] getFileContents(ISourceLocation loc) throws IOException {
        try (Reader textStream = URIResolverRegistry.getInstance().getCharacterReader(loc);){
            char[] cArray = InputConverter.toChar((Reader)textStream);
            return cArray;
        }
    }
}

