/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import lang.java.m3.internal.ASMNodeResolver;
import lang.java.m3.internal.LimitedTypeStore;
import lang.java.m3.internal.M3Constants;
import lang.java.m3.internal.M3Converter;
import lang.java.m3.internal.M3LocationUtil;
import lang.java.m3.internal.NodeResolver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleExportNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.ModuleOpenNode;
import org.objectweb.asm.tree.ModuleProvideNode;
import org.objectweb.asm.tree.ModuleRequireNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;

public class JarConverter
extends M3Converter {
    private ISourceLocation compUnitPhysical;
    private NodeResolver resolver;
    private Map<Integer, IConstructor> modifiersOpcodes;
    private URIResolverRegistry registry = URIResolverRegistry.getInstance();

    public JarConverter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache) {
        super(typeStore, cache);
        this.initializeModifiers();
    }

    private void initializeModifiers() {
        this.modifiersOpcodes = new HashMap<Integer, IConstructor>();
        this.modifiersOpcodes.put(1024, this.constructModifierNode("abstract", new IValue[0]));
        this.modifiersOpcodes.put(16, this.constructModifierNode("final", new IValue[0]));
        this.modifiersOpcodes.put(256, this.constructModifierNode("native", new IValue[0]));
        this.modifiersOpcodes.put(2, this.constructModifierNode("private", new IValue[0]));
        this.modifiersOpcodes.put(4, this.constructModifierNode("protected", new IValue[0]));
        this.modifiersOpcodes.put(1, this.constructModifierNode("public", new IValue[0]));
        this.modifiersOpcodes.put(8, this.constructModifierNode("static", new IValue[0]));
        this.modifiersOpcodes.put(2048, this.constructModifierNode("strictfp", new IValue[0]));
        this.modifiersOpcodes.put(32, this.constructModifierNode("synchronized", new IValue[0]));
        this.modifiersOpcodes.put(128, this.constructModifierNode("transient", new IValue[0]));
        this.modifiersOpcodes.put(64, this.constructModifierNode("volatile", new IValue[0]));
        this.modifiersOpcodes.put(32, this.constructModifierNode("transitive", new IValue[0]));
    }

    public void convertJar(ISourceLocation jar, IList classPath) {
        this.loc = jar;
        this.resolver = new ASMNodeResolver(this.loc, classPath, this.typeStore);
        this.createM3();
    }

    public void convertJarFile(ISourceLocation classFile, String className, IList classpath) {
        this.loc = classFile;
        this.createSingleClassM3(className, classpath);
    }

    private void createM3() {
        try (JarInputStream jarStream = new JarInputStream(this.registry.getInputStream(this.loc));){
            JarEntry entry = jarStream.getNextJarEntry();
            while (entry != null) {
                this.compUnitPhysical = URIUtil.getChildLocation((ISourceLocation)JarURIResolver.jarify((ISourceLocation)this.loc), (String)entry.getName());
                if (entry.getName().endsWith(".class")) {
                    String compUnit = this.getCompilationUnitRelativePath();
                    ClassReader classReader = this.resolver.buildClassReader(jarStream);
                    this.setCompilationUnitRelations(compUnit);
                    this.setPackagesRelations(compUnit);
                    this.setClassRelations(classReader, compUnit);
                }
                entry = jarStream.getNextJarEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while managing Jar stream.", e);
        }
    }

    private void createSingleClassM3(String className, IList classpath) {
        if (this.resolver == null) {
            this.resolver = new ASMNodeResolver(this.loc, classpath, this.typeStore);
        }
        String compUnit = className.replaceAll("\\.", "/");
        ClassReader classReader = this.resolver.buildClassReader(className);
        this.compUnitPhysical = URIUtil.getChildLocation((ISourceLocation)JarURIResolver.jarify((ISourceLocation)this.loc), (String)(compUnit + ".class"));
        this.setCompilationUnitRelations(compUnit);
        this.setPackagesRelations(compUnit);
        this.setClassRelations(classReader, compUnit);
    }

    private String getCompilationUnitRelativePath() {
        int beginningIndex = this.loc.getPath().length();
        String absolutePath = this.compUnitPhysical.getPath().substring(beginningIndex).replace(".class", "");
        return absolutePath.substring(absolutePath.indexOf("/"));
    }

    private void setCompilationUnitRelations(String compUnitRelative) {
        ISourceLocation packageLogical = this.createParentPackageLogicalLoc(compUnitRelative);
        ISourceLocation compUnitLogical = M3LocationUtil.makeLocation("java+compilationUnit", "", compUnitRelative);
        this.addToContainment(packageLogical, compUnitLogical);
        this.addToDeclarations(compUnitLogical, this.compUnitPhysical);
    }

    private void setPackagesRelations(String compUnitRelative) {
        ISourceLocation packageLogical = this.createParentPackageLogicalLoc(compUnitRelative);
        String packagePath = packageLogical.getPath();
        int packages = packagePath.length() - packagePath.replace("/", "").length() - 1;
        for (int i = 0; i < packages; ++i) {
            IString name = M3LocationUtil.getLocationName(packageLogical);
            String parentPkgPath = packagePath.substring(0, packagePath.lastIndexOf("/"));
            ISourceLocation packagePhysical = M3LocationUtil.extendPath(this.loc, packagePath);
            ISourceLocation parentPkgLogical = M3LocationUtil.makeLocation("java+package", "", parentPkgPath);
            ISourceLocation parentPkgPhysical = M3LocationUtil.extendPath(this.loc, parentPkgPath);
            this.addToContainment(parentPkgLogical, packageLogical);
            this.addToDeclarations(packageLogical, packagePhysical);
            this.addToNames(packageLogical, name);
            if (i == packages - 1) {
                IString parentName = M3LocationUtil.getLocationName(parentPkgLogical);
                this.addToDeclarations(parentPkgLogical, parentPkgPhysical);
                this.addToNames(parentPkgLogical, parentName);
            }
            packageLogical = parentPkgLogical;
            packagePath = parentPkgPath;
        }
    }

    private ISourceLocation createParentPackageLogicalLoc(String relativePath) {
        String path = relativePath.substring(0, relativePath.lastIndexOf("/"));
        return M3LocationUtil.makeLocation("java+package", "", path);
    }

    private ISourceLocation resolveInternalTypeName(String name) {
        ClassReader classReader = this.resolver.buildClassReader(name);
        if (classReader != null) {
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 2);
            return this.resolver.resolveBinding(classNode, null);
        }
        return this.bindingsResolver.makeBinding("java+classOrInterface", name, name);
    }

    private void setClassRelations(ClassReader classReader, String compUnitRelative) {
        if (classReader != null) {
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 2);
            if (classNode.module != null) {
                this.addModuleRelations(classNode.module);
                return;
            }
            IString className = M3LocationUtil.getLocationName(classNode.name);
            ISourceLocation compUnitLogical = M3LocationUtil.makeLocation("java+compilationUnit", "", compUnitRelative);
            ISourceLocation classLogical = this.resolver.resolveBinding(classNode, null);
            ISourceLocation classPhysical = M3LocationUtil.makeLocation(this.compUnitPhysical, classReader.header, classReader.b.length);
            IConstructor cons = this.resolver.resolveType(classNode, null);
            List<AnnotationNode> annotations = this.composeAnnotations(classNode.visibleAnnotations, classNode.invisibleAnnotations);
            this.addToContainment(compUnitLogical, classLogical);
            this.addToDeclarations(classLogical, classPhysical);
            this.addToNames(classLogical, className);
            this.addToExtends(classLogical, classNode);
            this.addToImplements(classLogical, classNode);
            this.addToModifiers(classLogical, classNode.access, true);
            this.addToAnnotations(classLogical, annotations);
            this.addToTypes(classLogical, cons);
            this.setInnerClassRelations(classNode, classLogical);
            this.setFieldRelations(classNode, classLogical);
            this.setMethodRelations(classNode, classLogical);
            this.setLanguages(this.resolver.resolveLanguageVersion(classNode));
        }
    }

    private void addModuleRelations(ModuleNode module) {
        ISourceLocation service;
        ISourceLocation modLoc = this.resolveBinding(module);
        this.addToDeclarations(modLoc, this.compUnitPhysical);
        if (module.exports != null) {
            for (ModuleExportNode export : module.exports) {
                ISourceLocation pkgLoc = this.resolveBinding(export.packaze);
                if (export.modules.isEmpty()) {
                    this.insert(this.moduleExportsPackage, (IValue)modLoc, (IValue)pkgLoc, (IValue)URIUtil.rootLocation((String)"java+module"));
                    continue;
                }
                for (String to : export.modules) {
                    this.insert(this.moduleExportsPackage, (IValue)modLoc, (IValue)pkgLoc, (IValue)M3LocationUtil.makeLocation("java+module", "", to));
                }
            }
        }
        if (module.provides != null) {
            for (ModuleProvideNode provides : module.provides) {
                service = this.resolveInternalTypeName(provides.service);
                for (String to : provides.providers) {
                    this.insert(this.moduleProvidesService, (IValue)modLoc, (IValue)service, (IValue)this.resolveInternalTypeName(to));
                }
            }
        }
        if (module.uses != null) {
            for (String uses : module.uses) {
                service = this.resolveInternalTypeName(uses);
                this.insert(this.moduleProvidesService, (IValue)modLoc, (IValue)service);
            }
        }
        if (module.requires != null) {
            for (ModuleRequireNode requires : module.requires) {
                ISourceLocation required = M3LocationUtil.makeLocation("java+module", "", requires.module);
                this.insert(this.moduleRequiresModule, (IValue)modLoc, (IValue)required);
            }
        }
        if (module.opens != null) {
            for (ModuleOpenNode opens : module.opens) {
                ISourceLocation pkg = this.resolveBinding(opens.packaze);
                if (opens.modules.isEmpty()) {
                    this.insert(this.moduleOpensPackage, (IValue)pkg, (IValue)URIUtil.rootLocation((String)"java+module"));
                    continue;
                }
                for (String to : opens.modules) {
                    this.insert(this.moduleOpensPackage, (IValue)modLoc, (IValue)pkg, (IValue)this.resolveInternalTypeName(to));
                }
            }
        }
    }

    private void setInnerClassRelations(ClassNode classNode, ISourceLocation classLogical) {
        List innerClasses = classNode.innerClasses;
        if (innerClasses != null) {
            for (int i = 0; i < innerClasses.size(); ++i) {
                InnerClassNode innerClass = (InnerClassNode)innerClasses.get(i);
                String classPath = classLogical.getPath();
                if (!innerClass.name.equals(classNode.name) || !classPath.contains("$")) continue;
                String outerClassPath = classPath.substring(0, classPath.lastIndexOf("$"));
                ISourceLocation outerClassLogical = M3LocationUtil.changePath(classLogical, outerClassPath);
                if (classNode.outerMethod != null && !classNode.outerMethod.isEmpty()) {
                    ISourceLocation methodLogical = this.resolver.resolveMethodBinding(classNode.outerMethod, classNode.outerMethodDesc, outerClassLogical);
                    this.addToContainment(methodLogical, classLogical);
                } else {
                    this.addToContainment(outerClassLogical, classLogical);
                }
                this.addToModifiers(classLogical, innerClass.access, true);
            }
        }
    }

    private void setFieldRelations(ClassNode classNode, ISourceLocation classLogical) {
        List fields = classNode.fields;
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                FieldNode fieldNode = (FieldNode)fields.get(i);
                if ((fieldNode.access & 0x1000) != 0) continue;
                IString fieldName = values.string(fieldNode.name);
                ISourceLocation fieldLogical = this.resolver.resolveBinding(fieldNode, classLogical);
                ISourceLocation fieldPhysical = this.compUnitPhysical;
                IConstructor cons = this.resolver.resolveType(fieldNode, classLogical);
                List<AnnotationNode> annotations = this.composeAnnotations(fieldNode.visibleAnnotations, fieldNode.invisibleAnnotations);
                this.addToContainment(classLogical, fieldLogical);
                this.addToDeclarations(fieldLogical, fieldPhysical);
                this.addToNames(fieldLogical, fieldName);
                this.addToModifiers(fieldLogical, fieldNode.access, new boolean[0]);
                this.addToAnnotations(fieldLogical, annotations);
                this.addToTypeDependency(fieldLogical, Type.getType((String)fieldNode.desc));
                this.addToTypes(fieldLogical, cons);
            }
        }
    }

    private void setLanguages(IConstructor version) {
        this.addToLanguages(version);
    }

    private void setMethodRelations(ClassNode classNode, ISourceLocation classLogical) {
        List methods = classNode.methods;
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                MethodNode methodNode = (MethodNode)methods.get(i);
                Type methodType = Type.getType((String)methodNode.desc).getReturnType();
                ISourceLocation methodLogical = this.resolver.resolveBinding(methodNode, classLogical);
                ISourceLocation methodPhysical = this.compUnitPhysical;
                IString methodName = this.getMethodName(methodLogical);
                IConstructor cons = this.resolver.resolveType(methodNode, classLogical);
                List<AnnotationNode> annotations = this.composeAnnotations(methodNode.visibleAnnotations, methodNode.invisibleAnnotations);
                this.addToContainment(classLogical, methodLogical);
                this.addToDeclarations(methodLogical, methodPhysical);
                this.addToNames(methodLogical, methodName);
                this.addToModifiers(methodLogical, methodNode.access, new boolean[0]);
                this.addToAnnotations(methodLogical, annotations);
                this.addToTypeDependency(methodLogical, methodType);
                this.addToMethodOverrides(classNode, methodNode, methodLogical);
                this.addToTypes(methodLogical, cons);
                this.setExceptionRelations(methodNode, methodLogical);
                this.setParameterRelations(methodNode, methodLogical);
                this.setInstructionRelations(methodNode, methodLogical);
            }
        }
    }

    private void setMethodOverridesRelation(String superClass, MethodNode methodNode, ISourceLocation methodLogical) {
        ClassReader classReader = this.resolver.buildClassReader(superClass);
        if (classReader != null) {
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 2);
            List superMethods = classNode.methods;
            if (superMethods != null) {
                for (MethodNode superMethodNode : superMethods) {
                    ISourceLocation methodSuperLogical;
                    ISourceLocation superClassLogical;
                    if ((superMethodNode.access & 8) != 0 || (superMethodNode.access & 0x10) != 0) continue;
                    if (superMethodNode.name.equals(methodNode.name) && superMethodNode.desc.equals(methodNode.desc)) {
                        superClassLogical = this.resolver.resolveBinding(classNode, null);
                        methodSuperLogical = this.resolver.resolveBinding(superMethodNode, superClassLogical);
                        this.insert(this.methodOverrides, (IValue)methodLogical, (IValue)methodSuperLogical);
                        this.addToMethodOverrides(classNode, methodNode, methodLogical);
                        continue;
                    }
                    if (!superMethodNode.name.equals(methodNode.name) || !Type.getArgumentTypes((String)superMethodNode.desc).equals(Type.getArgumentTypes((String)methodNode.desc))) continue;
                    superClassLogical = this.resolver.resolveBinding(classNode, null);
                    methodSuperLogical = this.resolver.resolveBinding(superMethodNode, superClassLogical);
                    this.insert(this.methodOverrides, (IValue)methodLogical, (IValue)methodSuperLogical);
                    this.addToMethodOverrides(classNode, methodNode, methodLogical);
                }
            }
        }
    }

    private void setExceptionRelations(MethodNode methodNode, ISourceLocation methodLogical) {
        List exceptions = methodNode.exceptions;
        for (String exception : exceptions) {
            ISourceLocation exceptionLogical = M3LocationUtil.makeLocation("java+class", "", exception);
            this.addToTypeDependency(methodLogical, exceptionLogical);
        }
    }

    private void setParameterRelations(MethodNode methodNode, ISourceLocation methodLogical) {
        Type[] parameters = Type.getType((String)methodNode.desc).getArgumentTypes();
        for (int i = 0; i < parameters.length; ++i) {
            IString parameterName = values.string("param" + i);
            String path = methodLogical.getPath() + "/" + parameterName.getValue();
            IConstructor cons = this.resolver.resolveType(parameters[i], null);
            ISourceLocation parameterLogical = M3LocationUtil.makeLocation("java+parameter", "", path);
            ISourceLocation parameterPhysical = this.compUnitPhysical;
            this.addToContainment(methodLogical, parameterLogical);
            this.addToDeclarations(parameterLogical, parameterPhysical);
            this.addToNames(parameterLogical, parameterName);
            this.addToTypeDependency(parameterLogical, parameters[i]);
            this.addToTypes(parameterLogical, cons);
        }
    }

    private void setInstructionRelations(MethodNode methodNode, ISourceLocation methodLogical) {
        InsnList instructions = methodNode.instructions;
        if (instructions != null) {
            for (AbstractInsnNode node : instructions) {
                if (node instanceof MethodInsnNode) {
                    this.setInstructionRelations(methodNode, methodLogical, (MethodInsnNode)node);
                    continue;
                }
                if (node instanceof FieldInsnNode) {
                    this.setInstructionRelations(methodNode, methodLogical, (FieldInsnNode)node);
                    continue;
                }
                if (!(node instanceof TypeInsnNode)) continue;
                this.setInstructionRelations(methodNode, methodLogical, (TypeInsnNode)node);
            }
        }
    }

    private void setInstructionRelations(MethodNode methodNode, ISourceLocation methodLogical, MethodInsnNode instructionNode) {
        ISourceLocation methodInvocationLogical = this.resolver.resolveBinding(instructionNode, methodLogical);
        this.addToMethodInvocation(methodLogical, methodInvocationLogical);
        this.addToTypeDependency(methodLogical, Type.getObjectType((String)instructionNode.owner));
    }

    private void setInstructionRelations(MethodNode methodName, ISourceLocation methodLogical, FieldInsnNode instructionNode) {
        ISourceLocation fieldLogical = this.resolver.resolveBinding(instructionNode, methodLogical);
        this.addToFieldAccess(methodLogical, fieldLogical);
        this.addToTypeDependency(methodLogical, Type.getObjectType((String)instructionNode.owner));
    }

    private void setInstructionRelations(MethodNode methodNode, ISourceLocation methodLogical, TypeInsnNode instructionNode) {
        this.addToTypeDependency(methodLogical, Type.getObjectType((String)instructionNode.desc));
    }

    private void addToAnnotations(ISourceLocation parent, List<AnnotationNode> annotationNodes) {
        for (AnnotationNode node : annotationNodes) {
            ISourceLocation child = this.resolver.resolveBinding(node, null);
            this.insert(this.annotations, (IValue)parent, (IValue)child);
        }
    }

    private void addToContainment(ISourceLocation parent, ISourceLocation child) {
        this.insert(this.containment, (IValue)parent, (IValue)child);
    }

    private void addToDeclarations(ISourceLocation logical, ISourceLocation physical) {
        this.insert(this.declarations, (IValue)logical, (IValue)physical);
    }

    private void addToExtends(ISourceLocation subclassLogical, ClassNode subclassNode) {
        if (subclassNode.superName != null && !subclassNode.superName.equalsIgnoreCase(M3Constants.OBJECT_CLASS_PATH) && !subclassNode.superName.equalsIgnoreCase(M3Constants.ENUM_CLASS_PATH)) {
            ISourceLocation extendsLogical = M3LocationUtil.makeLocation(subclassLogical.getScheme(), "", subclassNode.superName);
            this.insert(this.extendsRelations, (IValue)subclassLogical, (IValue)extendsLogical);
        }
    }

    private void addToFieldAccess(ISourceLocation methodLogical, ISourceLocation fieldLogical) {
        this.insert(this.fieldAccess, (IValue)methodLogical, (IValue)fieldLogical);
    }

    private void addToImplements(ISourceLocation classLogical, ClassNode classNode) {
        List interfaces = classNode.interfaces;
        if (interfaces != null) {
            ISetWriter writer = this.resolver.resolveClassScheme(classNode) == "java+interface" ? this.extendsRelations : this.implementsRelations;
            for (String path : interfaces) {
                ISourceLocation implementsLogical = M3LocationUtil.makeLocation("java+interface", "", path);
                this.insert(writer, (IValue)classLogical, (IValue)implementsLogical);
            }
        }
    }

    private void addToMethodInvocation(ISourceLocation methodLogical, ISourceLocation methodInvocationLogical) {
        this.insert(this.methodInvocation, (IValue)methodLogical, (IValue)methodInvocationLogical);
    }

    private void addToMethodOverrides(ClassNode classNode, MethodNode methodNode, ISourceLocation methodLogical) {
        List interfaces;
        if (classNode.superName != null && !classNode.superName.isEmpty()) {
            this.setMethodOverridesRelation(classNode.superName, methodNode, methodLogical);
        }
        if ((interfaces = classNode.interfaces) != null) {
            for (String interfac : interfaces) {
                this.setMethodOverridesRelation(interfac, methodNode, methodLogical);
            }
        }
    }

    private void addToModifiers(ISourceLocation logical, int access, boolean ... isClass) {
        for (int i = 0; i < 15; ++i) {
            int shift = 1 << i;
            IConstructor modifier = this.modifiersOpcodes.get(shift);
            if ((access & shift) == 0 || modifier == null || isClass.length >= 1 && shift == 32) continue;
            this.insert(this.modifiers, (IValue)logical, modifier);
        }
    }

    private void addToNames(ISourceLocation logical, IString name) {
        this.insert(this.names, name, (IValue)logical);
    }

    private void addToTypeDependency(ISourceLocation logical, Type type) {
        if (!type.equals((Object)Type.VOID_TYPE)) {
            ISourceLocation typeLogical = this.resolver.resolveBinding(type, null);
            this.addToTypeDependency(logical, typeLogical);
        }
    }

    private void addToTypeDependency(ISourceLocation logical, ISourceLocation typeLogical) {
        this.insert(this.typeDependency, (IValue)logical, (IValue)typeLogical);
    }

    private void addToTypes(ISourceLocation logical, IConstructor cons) {
        this.insert(this.types, (IValue)logical, cons);
    }

    private void addToLanguages(IConstructor lang) {
        this.insert(this.languages, (IValue)lang);
    }

    private List<AnnotationNode> composeAnnotations(List<AnnotationNode> ann1, List<AnnotationNode> ann2) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (ann1 != null) {
            annotations.addAll(ann1);
        }
        if (ann2 != null) {
            annotations.addAll(ann2);
        }
        return annotations;
    }

    private IString getMethodName(ISourceLocation methodLogical) {
        String signature = M3LocationUtil.getLocationName(methodLogical).getValue();
        IString name = signature.contains("(") ? values.string(signature.substring(0, signature.indexOf("("))) : values.string(signature);
        return name;
    }
}

