/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;
import java.util.Stack;
import lang.java.m3.internal.JavaToRascalConverter;
import lang.java.m3.internal.LimitedTypeStore;

public abstract class M3Converter
extends JavaToRascalConverter {
    private static final String DATATYPE_M3_NODE = "M3";
    private final Type DATATYPE_M3_NODE_TYPE;
    private final Type DATATYPE_M3_LANGUAGE_TYPE;
    protected final Stack<ISourceLocation> scopeManager = new Stack();
    protected ISetWriter uses;
    protected ISetWriter declarations;
    protected ISetWriter containment;
    protected ISetWriter extendsRelations;
    protected ISetWriter implementsRelations;
    protected ISetWriter fieldAccess;
    protected ISetWriter methodInvocation;
    protected ISetWriter typeDependency;
    protected ISetWriter documentation;
    protected ISetWriter modifiers;
    protected ISetWriter names;
    protected ISetWriter methodOverrides;
    protected ISetWriter types;
    protected ISetWriter annotations;
    protected ISetWriter moduleOpensPackage;
    protected ISetWriter moduleProvidesService;
    protected ISetWriter moduleRequiresModule;
    protected ISetWriter moduleUsesService;
    protected ISetWriter moduleExportsPackage;
    protected final Type CONSTRUCTOR_M3;
    protected final Type JAVA_LANGUAGE_M3;
    protected ISetWriter languages;
    protected ISourceLocation currentModule = null;

    M3Converter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache, IConstructor javaVersion) {
        this(typeStore, cache);
        this.languages.insert(new IValue[]{javaVersion});
    }

    M3Converter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache) {
        super(typeStore, cache, true);
        this.DATATYPE_M3_NODE_TYPE = this.typeStore.lookupAbstractDataType(DATATYPE_M3_NODE);
        this.DATATYPE_M3_LANGUAGE_TYPE = this.typeStore.lookupAbstractDataType("Language");
        TypeFactory tf = TypeFactory.getInstance();
        this.CONSTRUCTOR_M3 = this.typeStore.lookupConstructor(this.DATATYPE_M3_NODE_TYPE, "m3", tf.tupleType(new Type[]{tf.sourceLocationType()}));
        this.JAVA_LANGUAGE_M3 = this.typeStore.lookupConstructor(this.DATATYPE_M3_LANGUAGE_TYPE, "java", tf.tupleEmpty());
        this.uses = values.setWriter();
        this.declarations = values.setWriter();
        this.containment = values.setWriter();
        this.extendsRelations = values.setWriter();
        this.implementsRelations = values.setWriter();
        this.fieldAccess = values.setWriter();
        this.methodInvocation = values.setWriter();
        this.modifiers = values.setWriter();
        this.typeDependency = values.setWriter();
        this.documentation = values.setWriter();
        this.names = values.setWriter();
        this.methodOverrides = values.setWriter();
        this.annotations = values.setWriter();
        this.types = values.setWriter();
        this.languages = values.setWriter();
        this.moduleOpensPackage = values.setWriter();
        this.moduleProvidesService = values.setWriter();
        this.moduleRequiresModule = values.setWriter();
        this.moduleUsesService = values.setWriter();
        this.moduleExportsPackage = values.setWriter();
    }

    public IValue getModel(boolean insertErrors) {
        this.ownValue = values.constructor(this.CONSTRUCTOR_M3, new IValue[]{this.loc});
        this.setKeywordParameter("languages", (IValue)this.languages.done());
        this.setKeywordParameter("declarations", (IValue)this.declarations.done());
        this.setKeywordParameter("uses", (IValue)this.uses.done());
        this.setKeywordParameter("containment", (IValue)this.containment.done());
        this.setKeywordParameter("extends", (IValue)this.extendsRelations.done());
        this.setKeywordParameter("implements", (IValue)this.implementsRelations.done());
        this.setKeywordParameter("methodInvocation", (IValue)this.methodInvocation.done());
        this.setKeywordParameter("modifiers", (IValue)this.modifiers.done());
        this.setKeywordParameter("typeDependency", (IValue)this.typeDependency.done());
        this.setKeywordParameter("documentation", (IValue)this.documentation.done());
        this.setKeywordParameter("fieldAccess", (IValue)this.fieldAccess.done());
        this.setKeywordParameter("names", (IValue)this.names.done());
        this.setKeywordParameter("methodOverrides", (IValue)this.methodOverrides.done());
        this.setKeywordParameter("types", (IValue)this.types.done());
        this.setKeywordParameter("annotations", (IValue)this.annotations.done());
        this.setKeywordParameter("moduleOpensPackage", (IValue)this.moduleOpensPackage.done());
        this.setKeywordParameter("moduleProvidesService", (IValue)this.moduleProvidesService.done());
        this.setKeywordParameter("moduleRequiresModule", (IValue)this.moduleRequiresModule.done());
        this.setKeywordParameter("moduleUsesInterface", (IValue)this.moduleUsesService.done());
        this.setKeywordParameter("moduleExportsPackage", (IValue)this.moduleExportsPackage.done());
        this.insertCompilationUnitMessages(insertErrors, (IList)this.messages.done());
        return this.ownValue;
    }

    public ISourceLocation getParent() {
        return this.scopeManager.peek();
    }

    public void insert(ISetWriter relW, IValue lhs, IValue rhs) {
        if (this.isValid((ISourceLocation)lhs) && this.isValid((ISourceLocation)rhs)) {
            relW.insert(new IValue[]{values.tuple(new IValue[]{lhs, rhs})});
        }
    }

    public void insert(ISetWriter relW, IValue lhs, IValue middle, IValue rhs) {
        if (this.isValid((ISourceLocation)lhs) && this.isValid((ISourceLocation)middle) && this.isValid((ISourceLocation)rhs)) {
            relW.insert(new IValue[]{values.tuple(new IValue[]{lhs, middle, rhs})});
        }
    }

    public void insert(ISetWriter relW, IValue lhs, IList rhs) {
        for (IValue oneRHS : rhs) {
            if (!lhs.getType().isString() && (!this.isValid((ISourceLocation)lhs) || !this.isValid((ISourceLocation)oneRHS))) continue;
            this.insert(relW, lhs, oneRHS);
        }
    }

    public void insert(ISetWriter relW, IString lhs, IValue rhs) {
        if (this.isValid((ISourceLocation)rhs)) {
            relW.insert(new IValue[]{values.tuple(new IValue[]{lhs, rhs})});
        }
    }

    public void insert(ISetWriter relW, IValue lhs, IConstructor rhs) {
        if (this.isValid((ISourceLocation)lhs) && rhs != null) {
            relW.insert(new IValue[]{values.tuple(new IValue[]{lhs, rhs})});
        }
    }

    public void insert(ISetWriter setW, IValue elem) {
        setW.insert(new IValue[]{elem});
    }

    protected boolean isValid(ISourceLocation binding) {
        return binding != null && !binding.getScheme().equals("unknown") && !binding.getScheme().equals("unresolved");
    }
}

