---
title: "module lang::java::\\syntax::Java15"
id: Java15
slug: /Packages/org.rascalmpl.java-air/API/lang/java/syntax/Java15
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC73</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.java-air-1.0.0-RC4</div>

Java 5
#### Usage

```rascal
import lang::java::\syntax::Java15;
```

#### Dependencies
```rascal
import ParseTree;
extend lang::sdf2::filters::DirectThenCountPreferAvoid;
```

#### Description


The grammar was based on the SDF2 definition in the  Java-frontend project for Stratego/XT 
See https://github.com/metaborg/java-front

#### Pitfalls


* The grammar has been changed to use Rascal's disambiguation constructs rather than SDF2's constructs,
but this has not been well tested.


## syntax CompilationUnit {#lang-java-\syntax-Java15-CompilationUnit}

```rascal
start syntax CompilationUnit =
   compilationUnit: PackageDec? ImportDec* TypeDec*
  ;
```

## syntax PackageDec {#lang-java-\syntax-Java15-PackageDec}

```rascal
syntax PackageDec =
   packageDec: Anno* "package"  PackageName ";" 
  ;
```

## syntax PackageName {#lang-java-\syntax-Java15-PackageName}

```rascal
syntax PackageName =
   packageName: {Id "."}+ 
  ;
```

## syntax ImportDec {#lang-java-\syntax-Java15-ImportDec}

```rascal
syntax ImportDec 
  = typeImportDec: "import"  TypeName ";" 
  | typeImportOnDemandDec: "import"  PackageName "." "*" ";" 
  | staticImportOnDemandDec: "import"  "static"  TypeName "." "*" ";" 
  | staticImportDec: "import"  "static"  TypeName "." Id ";" 
  ;
```

## syntax TypeDec {#lang-java-\syntax-Java15-TypeDec}

```rascal
syntax TypeDec =
  InterfaceDec 
  | ClassDec 
  |  semicolon: ";" 
  ;
```

## syntax InterfaceDec {#lang-java-\syntax-Java15-InterfaceDec}

```rascal
syntax InterfaceDec 
  = AnnoDecHead "{" AnnoElemDec* "}"
  | InterfaceDecHead "{" InterfaceMemberDec* "}" 
  ;
```

## syntax AnnoDecHead {#lang-java-\syntax-Java15-AnnoDecHead}

```rascal
syntax AnnoDecHead 
  = annoDecHead: (InterfaceMod | Anno)* "@" "interface"  Id 
  ;
```

## syntax AnnoElemDec {#lang-java-\syntax-Java15-AnnoElemDec}

```rascal
syntax AnnoElemDec
  = semicolon: ";" 
  | ClassDec 
  | ConstantDec 
  | InterfaceDec 
  | annoMethodDec: (Anno | AbstractMethodMod)* Type Id "(" ")" DefaultVal? ";" 
  ;
```

## syntax InterfaceDecHead {#lang-java-\syntax-Java15-InterfaceDecHead}

```rascal
syntax InterfaceDecHead =
   interfaceDecHead: (InterfaceMod | Anno)* "interface"  Id TypeParams? ExtendsInterfaces? 
  ;
```

## syntax LocalVarDec {#lang-java-\syntax-Java15-LocalVarDec}

```rascal
syntax LocalVarDec =
  @prefer localVarDec: (Anno | VarMod)* Type {VarDec ","}+ 
  ;
```

## syntax TypeParams {#lang-java-\syntax-Java15-TypeParams}

```rascal
syntax TypeParams =
   typeParams: "\<" {TypeParam ","}+ "\>" 
  ;
```

## syntax Literal {#lang-java-\syntax-Java15-Literal}

```rascal
syntax Literal =
  FloatLiteral 
  | CharLiteral 
  | BoolLiteral 
  | ClassLiteral 
  | StringLiteral 
  | NullLiteral 
  | IntLiteral 
  ;
```

## syntax ClassDec {#lang-java-\syntax-Java15-ClassDec}

```rascal
syntax ClassDec =
  EnumDec 
  |  classDec: ClassDecHead ClassBody 
  ;
```

## syntax ClassDecHead {#lang-java-\syntax-Java15-ClassDecHead}

```rascal
syntax ClassDecHead =
   classDecHead: (ClassMod | Anno)* "class"  Id TypeParams? Super? Interfaces? 
  ;
```

## syntax SignedInteger {#lang-java-\syntax-Java15-SignedInteger}

```rascal
lexical SignedInteger =
  [+ \-]? [0-9]+ 
  ;
```

## syntax ClassMod {#lang-java-\syntax-Java15-ClassMod}

```rascal
syntax ClassMod =
  "static" 
  | "public" 
  | "abstract" 
  | "protected" 
  | "final"
  | "strictfp" 
  | "private" 
  ;
```

## syntax LEX_StringLiteral {#lang-java-\syntax-Java15-LEX_StringLiteral}

```rascal
lexical LEX_StringLiteral =
   string: "\"" StringPart* "\"" 
  ;
```

## syntax SwitchGroup {#lang-java-\syntax-Java15-SwitchGroup}

```rascal
syntax SwitchGroup =
   switchGroup: SwitchLabel+ BlockStm+ 
  ;
```

## syntax ClassBodyDec {#lang-java-\syntax-Java15-ClassBodyDec}

```rascal
syntax ClassBodyDec =
  InstanceInit 
  | ClassMemberDec 
  | StaticInit 
  | ConstrDec 
  ;
```

## syntax FloatType {#lang-java-\syntax-Java15-FloatType}

```rascal
syntax FloatType =
   float: "float"  
  |  double: "double"  
  ;
```

## syntax HexaSignificand {#lang-java-\syntax-Java15-HexaSignificand}

```rascal
lexical HexaSignificand =
  [0] [X x] [0-9 A-F a-f]* "." [0-9 A-F a-f]* 
  | [0] [X x] [0-9 A-F a-f]+ 
  ;
```

## syntax OctaNumeral {#lang-java-\syntax-Java15-OctaNumeral}

```rascal
lexical OctaNumeral =
  [0] [0-7]+ 
  ;
```

## syntax HexaNumeral {#lang-java-\syntax-Java15-HexaNumeral}

```rascal
lexical HexaNumeral =
  [0] [X x] [0-9 A-F a-f]+ 
  ;
```

## syntax ClassMemberDec {#lang-java-\syntax-Java15-ClassMemberDec}

```rascal
syntax ClassMemberDec =
   semicolon: ";" 
  | ClassDec 
  | MethodDec 
  | FieldDec 
  | InterfaceDec 
  ;
```

## syntax LEX_CharLiteral {#lang-java-\syntax-Java15-LEX_CharLiteral}

```rascal
lexical LEX_CharLiteral =
   char: "\'" CharContent "\'" 
  ;
```

## syntax ConstantDec {#lang-java-\syntax-Java15-ConstantDec}

```rascal
syntax ConstantDec =
   constantDec: (ConstantMod | Anno)* Type {VarDec ","}+ ";" 
  ;
```

## syntax ConstantMod {#lang-java-\syntax-Java15-ConstantMod}

```rascal
syntax ConstantMod =
  "static" 
  | "public" 
  | "final"
  ;
```

## syntax SwitchBlock {#lang-java-\syntax-Java15-SwitchBlock}

```rascal
syntax SwitchBlock =
   switchBlock: "{" SwitchGroup* SwitchLabel* "}" 
  ;
```

## syntax CondMid {#lang-java-\syntax-Java15-CondMid}

```rascal
syntax CondMid =
  bracket "?" Expr ":" 
  ;
```

## syntax WildcardBound {#lang-java-\syntax-Java15-WildcardBound}

```rascal
syntax WildcardBound =
   wildcardLowerBound: "super"  RefType 
  |  wildcardUpperBound: "extends"  RefType 
  ;
```

## syntax EscChar {#lang-java-\syntax-Java15-EscChar}

```rascal
lexical EscChar =
  "\\" 
  ;
```

## syntax EnumDecHead {#lang-java-\syntax-Java15-EnumDecHead}

```rascal
syntax EnumDecHead =
   enumDecHead: (Anno | ClassMod)* "enum"  Id Interfaces? 
  ;
```

## syntax PackageOrTypeName {#lang-java-\syntax-Java15-PackageOrTypeName}

```rascal
syntax PackageOrTypeName =
   packageOrTypeName: PackageOrTypeName "." Id 
  |  packageOrTypeName: Id 
  ;
```

## syntax OctaEscape {#lang-java-\syntax-Java15-OctaEscape}

```rascal
lexical OctaEscape 
  = "\\" [0-3] [0-7]+ !>> [0-7] 
  | "\\" [0-7] !>> [0-7] 
  | "\\" [4-7] [0-7] 
  ;
```

## syntax IntType {#lang-java-\syntax-Java15-IntType}

```rascal
syntax IntType =
   long: "long"  
  |  short: "short"  
  |  char: "char"  
  |  \int: "int"  
  |  byte: "byte"  
  ;
```

## syntax VarInit {#lang-java-\syntax-Java15-VarInit}

```rascal
syntax VarInit =
  Expr 
  | ArrayInit 
  ;
```

## syntax EnumBodyDecs {#lang-java-\syntax-Java15-EnumBodyDecs}

```rascal
syntax EnumBodyDecs =
   enumBodyDecs: ";" ClassBodyDec* 
  ;
```

## syntax ClassType {#lang-java-\syntax-Java15-ClassType}

```rascal
syntax ClassType =
   classType: TypeDecSpec TypeArgs? 
  ;
```

## syntax ExtendsInterfaces {#lang-java-\syntax-Java15-ExtendsInterfaces}

```rascal
syntax ExtendsInterfaces =
   extendsInterfaces: "extends"  {InterfaceType ","}+ 
  ;
```

## syntax EscEscChar {#lang-java-\syntax-Java15-EscEscChar}

```rascal
lexical EscEscChar =
  "\\\\" 
  ;
```

## syntax FormalParam {#lang-java-\syntax-Java15-FormalParam}

```rascal
syntax FormalParam =
   param: (Anno | VarMod)* Type VarDecId 
  |  varArityParam: (Anno | VarMod)* Type "..." VarDecId 
  ;
```

## syntax StaticInit {#lang-java-\syntax-Java15-StaticInit}

```rascal
syntax StaticInit =
   staticInit: "static"  Block 
  ;
```

## syntax EnumConstArgs {#lang-java-\syntax-Java15-EnumConstArgs}

```rascal
syntax EnumConstArgs =
  bracket "(" {Expr ","}* ")" 
  ;
```

## syntax LocalVarDecStm {#lang-java-\syntax-Java15-LocalVarDecStm}

```rascal
syntax LocalVarDecStm =
  @prefer localVarDecStm: LocalVarDec ";" 
  ;
```

## syntax HexaSignificandKeywords {#lang-java-\syntax-Java15-HexaSignificandKeywords}

```rascal
keyword HexaSignificandKeywords = "0x." | "0X.";
```

## syntax StringChars {#lang-java-\syntax-Java15-StringChars}

```rascal
lexical StringChars =
  FooStringChars 
  ;
```

## syntax EnumConst {#lang-java-\syntax-Java15-EnumConst}

```rascal
syntax EnumConst =
   enumConst: Anno* Id EnumConstArgs? ClassBody? 
  ;
```

## syntax LAYOUT {#lang-java-\syntax-Java15-LAYOUT}

```rascal
lexical LAYOUT =
  [\t-\n \a0C-\a0D \ ] 
  | Comment 
  ;
```

## syntax NumType {#lang-java-\syntax-Java15-NumType}

```rascal
syntax NumType =
  FloatType 
  | IntType 
  ;
```

## syntax MethodDecHead {#lang-java-\syntax-Java15-MethodDecHead}

```rascal
syntax MethodDecHead =
   methodDecHead: (Anno | MethodMod)* TypeParams? ResultType Id "(" {FormalParam ","}* ")" Throws? 
  |  deprMethodDecHead: (MethodMod | Anno)* TypeParams? ResultType Id "(" {FormalParam ","}* ")" Dim+ Throws? 
  ;
```

## syntax Anno {#lang-java-\syntax-Java15-Anno}

```rascal
syntax Anno =
   \anno: "@" TypeName "(" {ElemValPair ","}* ")" 
  |  markerAnno: "@" TypeName 
  |  singleElemAnno: "@" TypeName "(" ElemVal ")" 
  ;
```

## syntax CharContent {#lang-java-\syntax-Java15-CharContent}

```rascal
lexical CharContent =
  EscapeSeq 
  | UnicodeEscape 
  |  single: SingleChar 
  ;
```

## syntax FieldDec {#lang-java-\syntax-Java15-FieldDec}

```rascal
syntax FieldDec =
   fieldDec: (FieldMod | Anno)* Type {VarDec ","}+ ";" 
  ;
```

## syntax FieldMod {#lang-java-\syntax-Java15-FieldMod}

```rascal
syntax FieldMod =
  "public" 
  | "static" 
  | "transient" 
  | "protected" 
  | "volatile" 
  | "final"
  | "private" 
  ;
```

## syntax Comment {#lang-java-\syntax-Java15-Comment}

```rascal
lexical Comment =
  "/**/" 
  | "//" EOLCommentChars !>> ![\n \a0D] LineTerminator 
  | "/*" !>> [*] CommentPart* "*/" 
  | "/**" !>> [/] CommentPart* "*/" 
  ;
```

## syntax ArraySubscript {#lang-java-\syntax-Java15-ArraySubscript}

```rascal
syntax ArraySubscript =
  bracket "[" Expr "]" 
  ;
```

## syntax ConstrBody {#lang-java-\syntax-Java15-ConstrBody}

```rascal
syntax ConstrBody =
   constrBody: "{" ConstrInv? BlockStm* "}" 
  ;
```

## syntax FieldAccess {#lang-java-\syntax-Java15-FieldAccess}

```rascal
syntax FieldAccess =
   superField: "super"  "." Id 
  |  qSuperField: TypeName "." "super"  "." Id 
  ;
```

## syntax OctaLiteral {#lang-java-\syntax-Java15-OctaLiteral}

```rascal
lexical OctaLiteral =
  OctaNumeral !>> [0-7] [L l]? 
  ;
```

## syntax ConstrInv {#lang-java-\syntax-Java15-ConstrInv}

```rascal
syntax ConstrInv =
   altConstrInv: TypeArgs? "this"  "(" {Expr ","}* ")" ";" 
  |  superConstrInv: TypeArgs? "super"  "(" {Expr ","}* ")" ";" 
  |  qSuperConstrInv: Expr "." TypeArgs? "super"  "(" {Expr ","}* ")" ";" 
  ;
```

## syntax HexaFloatNumeral {#lang-java-\syntax-Java15-HexaFloatNumeral}

```rascal
lexical HexaFloatNumeral =
  HexaSignificand \ HexaSignificandKeywords !>> [0-9 A-F a-f] BinaryExponent 
  ;
```

## syntax IntLiteral {#lang-java-\syntax-Java15-IntLiteral}

```rascal
syntax IntLiteral =
   hexa: HexaLiteral !>> [L l.] 
  |  octa: OctaLiteral !>> [L l] 
  |  deci: DeciLiteral !>> [L l] 
  ;
```

## syntax HexaLiteral {#lang-java-\syntax-Java15-HexaLiteral}

```rascal
lexical HexaLiteral =
  HexaNumeral !>> [0-9 A-F a-f] [L l]? 
  ;
```

## syntax InterfaceMemberDec {#lang-java-\syntax-Java15-InterfaceMemberDec}

```rascal
syntax InterfaceMemberDec =
  ClassDec 
  |  semicolon: ";" 
  | InterfaceDec 
  | AbstractMethodDec 
  | ConstantDec 
  ;
```

## syntax ElemValPair {#lang-java-\syntax-Java15-ElemValPair}

```rascal
syntax ElemValPair =
   elemValPair: Id "=" ElemVal 
  ;
```

## syntax CatchClause {#lang-java-\syntax-Java15-CatchClause}

```rascal
syntax CatchClause =
   \catch: "catch"  "(" FormalParam ")" Block 
  ;
```

## syntax ArrayInit {#lang-java-\syntax-Java15-ArrayInit}

```rascal
syntax ArrayInit =
   arrayInit: "{" {VarInit ","}* "," "}" 
  |  arrayInit: "{" {VarInit ","}* "}" 
  ;
```

## syntax VarDecId {#lang-java-\syntax-Java15-VarDecId}

```rascal
syntax VarDecId =
   arrayVarDecId: Id Dim+ 
  | Id 
  ;
```

## syntax Modifier {#lang-java-\syntax-Java15-Modifier}

```rascal
syntax Modifier =
  "final"
  | "strictfp" 
  | "private" 
  | "synchronized" 
  | "volatile" 
  | "protected" 
  | "transient" 
  | "abstract" 
  | "native" 
  | "static" 
  | "public" 
  ;
```

## syntax ElemVal {#lang-java-\syntax-Java15-ElemVal}

```rascal
syntax ElemVal =
  Anno 
  |  elemValArrayInit: "{" {ElemVal ","}* "}" 
  |  elemValArrayInit: "{" {ElemVal ","}* "," "}" 
  | Expr!assign
  ;
```

## syntax InterfaceType {#lang-java-\syntax-Java15-InterfaceType}

```rascal
syntax InterfaceType =
   interfaceType: TypeDecSpec TypeArgs? 
  ;
```

## syntax ConstrMod {#lang-java-\syntax-Java15-ConstrMod}

```rascal
syntax ConstrMod =
  "public" 
  | "protected" 
  | "private" 
  ;
```

## syntax ID {#lang-java-\syntax-Java15-ID}

```rascal
lexical ID =
	// Yes, this would be more correct, but REALLY slow at the moment
	//JavaLetter JavaLetterDigits* 
	//
	// therefore we go the ascii route:
  [$ A-Z _ a-z] [$ 0-9 A-Z _ a-z]* 
  ;
```

## syntax ConstrDec {#lang-java-\syntax-Java15-ConstrDec}

```rascal
syntax ConstrDec =
   constrDec: ConstrHead ConstrBody 
  ;
```

## syntax DeciFloatDigits {#lang-java-\syntax-Java15-DeciFloatDigits}

```rascal
lexical DeciFloatDigits =
  [0-9]+ 
  | [0-9]* "." [0-9]* 
  ;
```

## syntax ArrayAccess {#lang-java-\syntax-Java15-ArrayAccess}

```rascal
syntax ArrayAccess =
   arrayAccess: Expr!postDecr!postIncr!preDecr!preIncr!not!complement!plus!plusDec!minus!remain!div!mul!rightShift!uRightShift!leftShift!instanceOf!gt!ltEq!lt!gtEq!eq!notEq!and!excOr!or!lazyAnd!lazyOr!cond!assign!assignLeftShift!assignOr!assignAnd!assignRightShift!assignMul!assignRemain!assignPlus!assignExcOr!assignDiv!assignURightShift!assignMinus!castRef!castPrim ArraySubscript 
  ;
```

## syntax ArrayBaseType {#lang-java-\syntax-Java15-ArrayBaseType}

```rascal
syntax ArrayBaseType =
  PrimType 
  | TypeName 
  |  unboundWld: TypeName "\<" "?" "\>" 
  ;
```

## syntax TypeName {#lang-java-\syntax-Java15-TypeName}

```rascal
syntax TypeName =
   typeName: PackageOrTypeName "." Id 
  |  typeName: Id 
  ;
```

## syntax FloatLiteral {#lang-java-\syntax-Java15-FloatLiteral}

```rascal
syntax FloatLiteral =
   float: HexaFloatLiteral !>> [D F d f] 
  |  float: DeciFloatLiteral !>> [D F d f] 
  ;
```

## syntax DeciFloatLiteral {#lang-java-\syntax-Java15-DeciFloatLiteral}

```rascal
lexical DeciFloatLiteral 
    = [0-9] !<< [0-9]+ DeciFloatExponentPart [D F d f]?
    | [0-9] !<< [0-9]+ [D F d f]
    | [0-9] !<< [0-9]+ "." [0-9]* !>> [0-9] DeciFloatExponentPart? [D F d f]?
    | [0-9] !<< "." [0-9]+ !>> [0-9] DeciFloatExponentPart? [D F d f]?
  ;
```

## syntax DeciLiteral {#lang-java-\syntax-Java15-DeciLiteral}

```rascal
lexical DeciLiteral =
  DeciNumeral !>> [. 0-9 D F d f] [L l]? 
  ;
```

## syntax DeciNumeral {#lang-java-\syntax-Java15-DeciNumeral}

```rascal
lexical DeciNumeral 
  = [1-9] [0-9]* 
  | "0" 
  ;
```

## syntax SwitchLabel {#lang-java-\syntax-Java15-SwitchLabel}

```rascal
syntax SwitchLabel =
   \default: "default"  ":" 
  |  \case: "case"  Expr ":" 
  ;
```

## syntax ConstrHead {#lang-java-\syntax-Java15-ConstrHead}

```rascal
syntax ConstrHead =
   constrDecHead: (ConstrMod | Anno)* TypeParams? Id "(" {FormalParam ","}* ")" Throws? 
  ;
```

## syntax Stm {#lang-java-\syntax-Java15-Stm}

```rascal
syntax Stm =
   \continue: "continue"  Id? ";" 
  |  forEach: "for"  "(" FormalParam ":" Expr ")" Stm 
  |  \try: "try" Block CatchClause* "finally"  Block 
  |  \throw: "throw"  Expr ";" 
  | Block 
  |  assertStm: "assert"  Expr ":" Expr ";" 
  |  \for: "for" "(" {Expr ","}* ";" Expr? ";" {Expr ","}* ")" Stm 
  |  \try: "try"  Block CatchClause+ 
  |  labeled: Id ":" Stm 
  |  \for: "for"  "(" LocalVarDec ";" Expr? ";" {Expr ","}* ")" Stm 
  |  \switch: "switch"  "(" Expr ")" SwitchBlock 
  |  \if: "if" "(" Expr ")" Stm "else"  Stm 
  |  doWhile: "do"  Stm "while"  "(" Expr ")" ";" 
  |  synchronized: "synchronized"  "(" Expr ")" Block 
  | @prefer \if: "if"  "(" Expr ")" Stm 
  |  empty: ";" 
  |  \while: "while"  "(" Expr ")" Stm 
  |  assertStm: "assert"  Expr ";" 
  |  \return: "return"  Expr? ";" 
  |  \break: "break" Id? ";" 
  |  exprStm: Expr ";" 
  ;
```

## syntax NullLiteral {#lang-java-\syntax-Java15-NullLiteral}

```rascal
syntax NullLiteral =
   null: "null" 
  ;
```

## syntax ExceptionType {#lang-java-\syntax-Java15-ExceptionType}

```rascal
syntax ExceptionType =
  ClassType 
  ;
```

## syntax EscapeSeq {#lang-java-\syntax-Java15-EscapeSeq}

```rascal
lexical EscapeSeq =
  NamedEscape 
  | OctaEscape 
  ;
```

## syntax LAYOUTLIST {#lang-java-\syntax-Java15-LAYOUTLIST}

```rascal
layout LAYOUTLIST  =
  LAYOUT* !>> [\t-\n \a0C-\a0D \ ] !>> "/*" !>> "//"
  ;
```

## syntax ResultType {#lang-java-\syntax-Java15-ResultType}

```rascal
syntax ResultType =
   \void: "void"  
  | Type 
  ;
```

## syntax Expr {#lang-java-\syntax-Java15-Expr}

```rascal
syntax Expr =
  FieldAccess  
  |  newInstance: "new"  TypeArgs? ClassOrInterfaceType "(" {Expr ","}* ")" ClassBody? 
  |  invoke: MethodSpec "(" {Expr ","}* ")" 
  | bracket "(" Expr ")" 
  |  lit: Literal 
  |  qThis: TypeName "." "this"  
  | ArrayCreationExpr 
  |  this: "this"  
  | ArrayAccess  
  ;
```

## syntax NamedEscape {#lang-java-\syntax-Java15-NamedEscape}

```rascal
lexical NamedEscape =
   namedEscape: "\\" [\" \' \\ b f n r t] 
  ;
```

## syntax ArrayType {#lang-java-\syntax-Java15-ArrayType}

```rascal
syntax ArrayType =
   arrayType: Type "[" "]" 
  ;
```

## syntax ClassBody {#lang-java-\syntax-Java15-ClassBody}

```rascal
syntax ClassBody =
   classBody: "{" ClassBodyDec* "}" 
  ;
```

## syntax BinaryExponent {#lang-java-\syntax-Java15-BinaryExponent}

```rascal
lexical BinaryExponent =
  [P p] SignedInteger !>> [0-9] 
  ;
```

## syntax BlockCommentChars {#lang-java-\syntax-Java15-BlockCommentChars}

```rascal
lexical BlockCommentChars =
  ![* \\]+ 
  ;
```

## syntax TypeDecSpec {#lang-java-\syntax-Java15-TypeDecSpec}

```rascal
syntax TypeDecSpec =
   member: TypeDecSpec TypeArgs "." Id 
  | TypeName 
  ;
```

## syntax PrimType {#lang-java-\syntax-Java15-PrimType}

```rascal
syntax PrimType =
   boolean: "boolean"  
  | NumType 
  ;
```

## syntax EnumDec {#lang-java-\syntax-Java15-EnumDec}

```rascal
syntax EnumDec =
   enumDec: EnumDecHead EnumBody 
  ;
```

## syntax Keyword {#lang-java-\syntax-Java15-Keyword}

```rascal
keyword Keyword =
  "continue" 
  | "package" 
  | "short" 
  | "boolean" 
  | "for" 
  | "extends" 
  | "do" 
  | "strictfp" 
  | "if" 
  | "enum" 
  | "synchronized" 
  | "else" 
  | "interface" 
  | "return" 
  | "private" 
  | "volatile" 
  | "default" 
  | "throws" 
  | "static" 
  | "long" 
  | "throw" 
  | "this" 
  | "catch" 
  | "super" 
  | "const" 
  | "switch" 
  | "int" 
  | "implements" 
  | "native" 
  | "abstract" 
  | "break" 
  | "goto" 
  | "final" 
  | "class" 
  | "byte" 
  | "instanceof" 
  | "void" 
  | "finally" 
  | "try" 
  | "new" 
  | "float" 
  | "public" 
  | "transient" 
  | "char" 
  | "assert" 
  | "case" 
  | "while" 
  | "double" 
  | "protected" 
  | "import" 
  ;
```

## syntax FooStringChars {#lang-java-\syntax-Java15-FooStringChars}

```rascal
lexical FooStringChars =
  ([\a00] | ![\n \a0D \" \\])+ 
  ;
```

## syntax ActualTypeArg {#lang-java-\syntax-Java15-ActualTypeArg}

```rascal
syntax ActualTypeArg =
   wildcard: "?" WildcardBound? 
  | Type 
  ;
```

## syntax StringPart {#lang-java-\syntax-Java15-StringPart}

```rascal
lexical StringPart =
  UnicodeEscape 
  | EscapeSeq 
  |  chars: StringChars !>> ![\n \a0D \" \\]  !>> [\a00]
  ;
```

## syntax MethodName {#lang-java-\syntax-Java15-MethodName}

```rascal
syntax MethodName =
   methodName: AmbName "." Id 
  |  methodName: Id 
  ;
```

## syntax EOLCommentChars {#lang-java-\syntax-Java15-EOLCommentChars}

```rascal
lexical EOLCommentChars =
  ![\n \a0D]* 
  ;
```

## syntax InterfaceMod {#lang-java-\syntax-Java15-InterfaceMod}

```rascal
syntax InterfaceMod =
  "protected" 
  | "public" 
  | "static" 
  | "abstract" 
  | "private" 
  | "strictfp" 
  ;
```

## syntax SingleChar {#lang-java-\syntax-Java15-SingleChar}

```rascal
lexical SingleChar =
  ![\n \a0D \' \\] 
  ;
```

## syntax ClassLiteral {#lang-java-\syntax-Java15-ClassLiteral}

```rascal
syntax ClassLiteral =
   voidClass: "void"  "." "class"  
  |  class: Type "." "class"  
  ;
```

## syntax StringLiteral {#lang-java-\syntax-Java15-StringLiteral}

```rascal
syntax StringLiteral =
  LEX_StringLiteral 
  ;
```

## syntax AbstractMethodDec {#lang-java-\syntax-Java15-AbstractMethodDec}

```rascal
syntax AbstractMethodDec =
   abstractMethodDec: (Anno | AbstractMethodMod)* TypeParams? ResultType Id "(" {FormalParam ","}* ")" Throws? ";" 
  |  deprAbstractMethodDec: (Anno | AbstractMethodMod)* TypeParams? ResultType Id "(" {FormalParam ","}* ")" Dim+ Throws? ";" 
  ;
```

## syntax AbstractMethodMod {#lang-java-\syntax-Java15-AbstractMethodMod}

```rascal
syntax AbstractMethodMod =
  "abstract" 
  | "public" 
  ;
```

## syntax CommentPart {#lang-java-\syntax-Java15-CommentPart}

```rascal
lexical CommentPart =
  UnicodeEscape 
  | BlockCommentChars !>> ![* \\] 
  | EscChar !>> [\\ u] 
  | Asterisk !>> [/] 
  | EscEscChar 
  ;
```

## syntax Id {#lang-java-\syntax-Java15-Id}

```rascal
syntax Id =
   id: [$ A-Z _ a-z] !<< ID \ IDKeywords !>> [$ 0-9 A-Z _ a-z] 
  ;
```

## syntax TypeBound {#lang-java-\syntax-Java15-TypeBound}

```rascal
syntax TypeBound =
   typeBound: "extends"  {ClassOrInterfaceType "&"}+ 
  ;
```

## syntax BoolLiteral {#lang-java-\syntax-Java15-BoolLiteral}

```rascal
syntax BoolLiteral
  = \false: "false" 
  | \true: "true" 
  ;
```

## syntax MethodBody {#lang-java-\syntax-Java15-MethodBody}

```rascal
syntax MethodBody =
   noMethodBody: ";" 
  | Block 
  ;
```

## syntax ExprName {#lang-java-\syntax-Java15-ExprName}

```rascal
syntax ExprName =
   exprName: AmbName "." Id 
  |  exprName: Id 
  ;
```

## syntax DefaultVal {#lang-java-\syntax-Java15-DefaultVal}

```rascal
syntax DefaultVal =
   defaultVal: "default"  ElemVal  
  ;
```

## syntax MethodDec {#lang-java-\syntax-Java15-MethodDec}

```rascal
syntax MethodDec =
   methodDec: MethodDecHead MethodBody 
  ;
```

## syntax AmbName {#lang-java-\syntax-Java15-AmbName}

```rascal
syntax AmbName =
   ambName: Id 
  |  ambName: AmbName "." Id 
  ;
```

## syntax MethodMod {#lang-java-\syntax-Java15-MethodMod}

```rascal
syntax MethodMod =
  "static" 
  | "protected" 
  | "synchronized" 
  | "strictfp" 
  | "private" 
  | "final"
  | "public" 
  | "native" 
  | "abstract" 
  ;
```

## syntax RefType {#lang-java-\syntax-Java15-RefType}

```rascal
syntax RefType =
  ArrayType 
  | ClassOrInterfaceType 
  ;
```

## syntax ArrayCreationExpr {#lang-java-\syntax-Java15-ArrayCreationExpr}

```rascal
syntax ArrayCreationExpr =
   newArray: "new"  ArrayBaseType DimExpr+ Dim* !>> "["
  |  newArray: "new" ArrayBaseType Dim+ !>> "[" ArrayInit 
  ;
```

## syntax LHS {#lang-java-\syntax-Java15-LHS}

```rascal
syntax LHS =
  ExprName 
  | bracket "(" LHS ")"
  | ArrayAccess  
  | FieldAccess  
  ;
```

## syntax TypeArgs {#lang-java-\syntax-Java15-TypeArgs}

```rascal
syntax TypeArgs =
   typeArgs: "\<" {ActualTypeArg ","}+ "\>" 
  ;
```

## syntax TypeParam {#lang-java-\syntax-Java15-TypeParam}

```rascal
syntax TypeParam =
   typeParam: TypeVarId TypeBound? 
  ;
```

## syntax DeciFloatExponentPart {#lang-java-\syntax-Java15-DeciFloatExponentPart}

```rascal
lexical DeciFloatExponentPart =
  [E e] SignedInteger !>> [0-9] 
  ;
```

## syntax MethodSpec {#lang-java-\syntax-Java15-MethodSpec}

```rascal
syntax MethodSpec =
   methodName: MethodName 
  |  superMethod: "super"  "." TypeArgs? Id 
  |  genericMethod: AmbName "." TypeArgs Id 
  |  qSuperMethod: TypeName "." "super"  "." TypeArgs? Id 
  ;
```

## syntax Type {#lang-java-\syntax-Java15-Type}

```rascal
syntax Type =
  PrimType 
  | RefType 
  ;
```

## syntax Super {#lang-java-\syntax-Java15-Super}

```rascal
syntax Super =
   superDec: "extends"  ClassType 
  ;
```

## syntax CharLiteral {#lang-java-\syntax-Java15-CharLiteral}

```rascal
syntax CharLiteral =
  LEX_CharLiteral 
  ;
```

## syntax EndOfFile {#lang-java-\syntax-Java15-EndOfFile}

```rascal
lexical EndOfFile =
  
  ;
```

## syntax InstanceInit {#lang-java-\syntax-Java15-InstanceInit}

```rascal
syntax InstanceInit =
   instanceInit: Block 
  ;
```

## syntax IDKeywords {#lang-java-\syntax-Java15-IDKeywords}

```rascal
keyword IDKeywords =
  "null" 
  | Keyword 
  | "true" 
  | "false" 
  ;
```

## syntax EnumBody {#lang-java-\syntax-Java15-EnumBody}

```rascal
syntax EnumBody =
   enumBody: "{" {EnumConst ","}* EnumBodyDecs? "}" 
  |  enumBody: "{" {EnumConst ","}* "," EnumBodyDecs? "}" 
  ;
```

## syntax CarriageReturn {#lang-java-\syntax-Java15-CarriageReturn}

```rascal
lexical CarriageReturn =
  [\a0D] 
  ;
```

## syntax Throws {#lang-java-\syntax-Java15-Throws}

```rascal
syntax Throws =
   throwsDec: "throws"  {ExceptionType ","}+ 
  ;
```

## syntax Block {#lang-java-\syntax-Java15-Block}

```rascal
syntax Block =
   block: "{" BlockStm* "}" 
  ;
```

## syntax TypeVar {#lang-java-\syntax-Java15-TypeVar}

```rascal
syntax TypeVar =
   typeVar: TypeVarId 
  ;
```

## syntax Dim {#lang-java-\syntax-Java15-Dim}

```rascal
syntax Dim =
   dim: "[" "]" 
  ;
```

## syntax TypeVarId {#lang-java-\syntax-Java15-TypeVarId}

```rascal
syntax TypeVarId =
  Id 
  ;
```

## syntax UnicodeEscape {#lang-java-\syntax-Java15-UnicodeEscape}

```rascal
lexical UnicodeEscape =
   unicodeEscape: "\\" [u]+ [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] 
  ;
```

## syntax LineTerminator {#lang-java-\syntax-Java15-LineTerminator}

```rascal
lexical LineTerminator =
  [\n] 
  | EndOfFile !>> ![] 
  | [\a0D] [\n] 
  | CarriageReturn !>> [\n] 
  ;
```

## syntax HexaFloatLiteral {#lang-java-\syntax-Java15-HexaFloatLiteral}

```rascal
lexical HexaFloatLiteral =
  HexaFloatNumeral [D F d f]? 
  ;
```

## syntax BlockStm {#lang-java-\syntax-Java15-BlockStm}

```rascal
syntax BlockStm =
  Stm 
  |  classDecStm: ClassDec 
  | LocalVarDecStm 
  ;
```

## syntax DimExpr {#lang-java-\syntax-Java15-DimExpr}

```rascal
syntax DimExpr =
   dim: "[" Expr "]" 
  ;
```

## syntax Interfaces {#lang-java-\syntax-Java15-Interfaces}

```rascal
syntax Interfaces =
   implementsDec: "implements"  {InterfaceType ","}+ 
  ;
```

## syntax Asterisk {#lang-java-\syntax-Java15-Asterisk}

```rascal
lexical Asterisk =
  "*" 
  ;
```

## syntax VarDec {#lang-java-\syntax-Java15-VarDec}

```rascal
syntax VarDec =
   varDec: VarDecId "=" VarInit 
  |  varDec: VarDecId 
  ;
```

## syntax VarMod {#lang-java-\syntax-Java15-VarMod}

```rascal
syntax VarMod =
  "final"
  ;
```

## syntax ClassOrInterfaceType {#lang-java-\syntax-Java15-ClassOrInterfaceType}

```rascal
syntax ClassOrInterfaceType =
   classOrInterfaceType: TypeDecSpec TypeArgs? 
  ;
```

## function expectedAmb {#lang-java-\syntax-Java15-expectedAmb}

```rascal
bool expectedAmb({(Expr)`(<RefType t>) <Expr e>`, appl(_,[(Expr)`(<ExprName n>)`,*_])})

bool expectedAmb({appl(_,[*_,(Expr)`(<RefType t>) <Expr e>`]), appl(_,[appl(_,[*_,(Expr)`(<ExprName n>)`]),*_])})

default bool expectedAmb(set[Tree] t)
```

