---
title: "module lang::java::\\syntax::Java18"
id: Java18
slug: /Packages/org.rascalmpl.java-air/API/lang/java/syntax/Java18
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC73</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.java-air-1.0.0-RC4</div>

Java 8 grammar
#### Usage

```rascal
import lang::java::\syntax::Java18;
```



This Java grammar is based on the following references:

* https://docs.oracle.com/javase/specs/jls/se8/html/jls-19.html
* https://github.com/antlr/grammars-v4/blob/master/java8/Java8.g4
* Rascal Java15 grammar

#### Benefits


* the grammar is well-annotated with the source information

#### Pitfalls


* the grammar contains too many non-terminals for the expression sub-language (priorities and associativities
are still encoded with non-terminals)
* same for the Statements; too many non-terminals for handy use with concrete-syntax patterns
* the grammar is not well tested


## syntax CompilationUnit {#lang-java-\syntax-Java18-CompilationUnit}

```rascal
start syntax CompilationUnit = PackageDeclaration? Imports TypeDeclaration*;
```

## syntax Literal {#lang-java-\syntax-Java18-Literal}

```rascal
syntax Literal = IntegerLiteral
  			   | FloatingPointLiteral
  			   | BooleanLiteral
  			   | CharacterLiteral
  			   | StringLiteral
  			   | NullLiteral
  			   ;
```

## syntax Imports {#lang-java-\syntax-Java18-Imports}

```rascal
syntax Imports = ImportDeclaration*;
```

## syntax Type {#lang-java-\syntax-Java18-Type}

```rascal
syntax Type = PrimitiveType
             | ReferenceType
             ;
```

## syntax PrimitiveType {#lang-java-\syntax-Java18-PrimitiveType}

```rascal
syntax PrimitiveType = Annotation* NumericType
                      | Annotation* "boolean" 
                      ;
```

## syntax NumericType {#lang-java-\syntax-Java18-NumericType}

```rascal
syntax NumericType = IntegralType
                    | FloatingPointType
                    ;
```

## syntax IntegralType {#lang-java-\syntax-Java18-IntegralType}

```rascal
syntax IntegralType = "byte" 
                    | "short" 
                    | "int" 
                    | "long" 
                    | "char"
                    ;
```

## syntax FloatingPointType {#lang-java-\syntax-Java18-FloatingPointType}

```rascal
syntax FloatingPointType = "float" | "double" ;
```

## syntax ReferenceType {#lang-java-\syntax-Java18-ReferenceType}

```rascal
syntax ReferenceType = ClassOrInterfaceType 
                     | arrayType: ArrayType
                     ;
```

## syntax ClassOrInterfaceType {#lang-java-\syntax-Java18-ClassOrInterfaceType}

```rascal
syntax ClassOrInterfaceType = ClassType 
                     ;
```

## syntax ClassType {#lang-java-\syntax-Java18-ClassType}

```rascal
syntax ClassType = Annotation* Identifier TypeArguments? 
                 | ClassOrInterfaceType "." Annotation* Identifier TypeArguments?
                 ;
```

## syntax InterfaceType {#lang-java-\syntax-Java18-InterfaceType}

```rascal
syntax InterfaceType = ClassType;
```

## syntax TypeVariable {#lang-java-\syntax-Java18-TypeVariable}

```rascal
syntax TypeVariable = Annotation* Identifier;
```

## syntax ArrayType {#lang-java-\syntax-Java18-ArrayType}

```rascal
syntax ArrayType = PrimitiveType Dims 
                 | ClassOrInterfaceType Dims 
                 ;
```

## syntax Dims {#lang-java-\syntax-Java18-Dims}

```rascal
syntax Dims = Annotation* "[" "]" (Annotation* "[" "]")*;
```

## syntax TypeParameter {#lang-java-\syntax-Java18-TypeParameter}

```rascal
syntax TypeParameter = typeParameter: TypeParameterModifier* Identifier TypeBound? ;
```

## syntax TypeParameterModifier {#lang-java-\syntax-Java18-TypeParameterModifier}

```rascal
syntax TypeParameterModifier = Annotation;
```

## syntax TypeBound {#lang-java-\syntax-Java18-TypeBound}

```rascal
syntax TypeBound = "extends" { ClassOrInterfaceType "&" }+
                 ;
```

## syntax AdditionalBound {#lang-java-\syntax-Java18-AdditionalBound}

```rascal
syntax AdditionalBound = "&" InterfaceType ;
```

## syntax TypeArguments {#lang-java-\syntax-Java18-TypeArguments}

```rascal
syntax TypeArguments = "\<"  {TypeArgument ","}* "\>" ;
```

## syntax TypeArgument {#lang-java-\syntax-Java18-TypeArgument}

```rascal
syntax TypeArgument = ReferenceType 
                    | Wildcard
                    ;
```

## syntax Wildcard {#lang-java-\syntax-Java18-Wildcard}

```rascal
syntax Wildcard = Annotation* "?" WildcardBounds? ;
```

## syntax WildcardBounds {#lang-java-\syntax-Java18-WildcardBounds}

```rascal
syntax WildcardBounds = "extends" ReferenceType
	                  |	"super" ReferenceType
	                  ;
```

## syntax TypeName {#lang-java-\syntax-Java18-TypeName}

```rascal
syntax TypeName = Identifier
                | PackageOrTypeName "." Identifier
                ;
```

## syntax PackageOrTypeName {#lang-java-\syntax-Java18-PackageOrTypeName}

```rascal
syntax PackageOrTypeName = Identifier 
                         | PackageOrTypeName "." Identifier
                         ;
```

## syntax ExpressionName {#lang-java-\syntax-Java18-ExpressionName}

```rascal
syntax ExpressionName = Identifier 
                      | AmbiguousName "." Identifier                        
                      ;
```

## syntax MethodName {#lang-java-\syntax-Java18-MethodName}

```rascal
syntax MethodName = Identifier;
```

## syntax PackageName {#lang-java-\syntax-Java18-PackageName}

```rascal
syntax PackageName = Identifier 
                   | PackageName "." Identifier
                   ;
```

## syntax AmbiguousName {#lang-java-\syntax-Java18-AmbiguousName}

```rascal
syntax AmbiguousName = Identifier 
                     | AmbiguousName "." Identifier
                     ;
```

## syntax PackageDeclaration {#lang-java-\syntax-Java18-PackageDeclaration}

```rascal
syntax PackageDeclaration = PackageModifier* "package" {Identifier "."}+ ";" ;
```

## syntax PackageModifier {#lang-java-\syntax-Java18-PackageModifier}

```rascal
syntax PackageModifier = Annotation ;
```

## syntax ImportDeclaration {#lang-java-\syntax-Java18-ImportDeclaration}

```rascal
syntax ImportDeclaration = importDeclaration: SingleTypeImportDeclaration       // import Class; 
                         | TypeImportOnDemandDeclaration     // import br.unb.rascal.*;
                         | SingleStaticImportDeclaration     // import static br.unb.rascal.Foo.m;
                         | StaticImportOnDemandDeclaration   // import static br.unb.rascal.Foo.*;
                         ;
```

## syntax SingleTypeImportDeclaration {#lang-java-\syntax-Java18-SingleTypeImportDeclaration}

```rascal
syntax SingleTypeImportDeclaration = "import" TypeName ";"+ ;
```

## syntax TypeImportOnDemandDeclaration {#lang-java-\syntax-Java18-TypeImportOnDemandDeclaration}

```rascal
syntax TypeImportOnDemandDeclaration = "import" PackageOrTypeName "." "*" ";"+ ;
```

## syntax SingleStaticImportDeclaration {#lang-java-\syntax-Java18-SingleStaticImportDeclaration}

```rascal
syntax SingleStaticImportDeclaration = "import" "static" TypeName "." Identifier ";"+;
```

## syntax StaticImportOnDemandDeclaration {#lang-java-\syntax-Java18-StaticImportOnDemandDeclaration}

```rascal
syntax StaticImportOnDemandDeclaration = "import" "static" TypeName "." "*" ";"+ ;
```

## syntax TypeDeclaration {#lang-java-\syntax-Java18-TypeDeclaration}

```rascal
syntax TypeDeclaration = ClassDeclaration ";"*
                       | InterfaceDeclaration ";"* 
                       ;
```

## syntax ClassDeclaration {#lang-java-\syntax-Java18-ClassDeclaration}

```rascal
syntax ClassDeclaration = NormalClassDeclaration
                        | EnumDeclaration 
                        ;
```

## syntax NormalClassDeclaration {#lang-java-\syntax-Java18-NormalClassDeclaration}

```rascal
syntax NormalClassDeclaration = normalClassDeclaration: ClassModifier* "class" Identifier TypeParameters? Superclass? Superinterfaces? ClassBody ;
```

## syntax ClassModifier {#lang-java-\syntax-Java18-ClassModifier}

```rascal
syntax ClassModifier = Annotation 
                     | "public" 
                     | "protected" 
                     | "private" 
                     | "abstract" 
                     | "static" 
                     | "final" 
                     | "strictfp"
                     ;
```

## syntax TypeParameters {#lang-java-\syntax-Java18-TypeParameters}

```rascal
syntax TypeParameters = typeParameters : "\<" {TypeParameter ","}+ "\>" ;
```

## syntax Superclass {#lang-java-\syntax-Java18-Superclass}

```rascal
syntax Superclass = "extends" ClassType ;
```

## syntax Superinterfaces {#lang-java-\syntax-Java18-Superinterfaces}

```rascal
syntax Superinterfaces = "implements" {InterfaceType ","}+ ;
```

## syntax ClassBody {#lang-java-\syntax-Java18-ClassBody}

```rascal
syntax ClassBody = classBody : "{" ClassBodyDeclaration* decls "}" ";"? ;
```

## syntax ClassBodyDeclaration {#lang-java-\syntax-Java18-ClassBodyDeclaration}

```rascal
syntax ClassBodyDeclaration = ClassMemberDeclaration 
                            | InstanceInitializer 
                            | StaticInitializer 
                            | ConstructorDeclaration 
                            ;
```

## syntax ClassMemberDeclaration {#lang-java-\syntax-Java18-ClassMemberDeclaration}

```rascal
syntax ClassMemberDeclaration = FieldDeclaration 
                              | MethodDeclaration 
                              | ClassDeclaration 
                              | InterfaceDeclaration 
                              //| ";"
                              ;
```

## syntax FieldDeclaration {#lang-java-\syntax-Java18-FieldDeclaration}

```rascal
syntax FieldDeclaration = fieldDeclaration: FieldModifier* UnannType VariableDeclaratorList ";"+ ;
```

## syntax FieldModifier {#lang-java-\syntax-Java18-FieldModifier}

```rascal
syntax FieldModifier = Annotation 
                     | "public" 
                     | "protected" 
                     | "private" 
                     | "static" 
                     | "final" 
                     | "transient" 
                     | "volatile"
                     ;
```

## syntax VariableDeclaratorList {#lang-java-\syntax-Java18-VariableDeclaratorList}

```rascal
syntax VariableDeclaratorList = variableDeclaratorList: {VariableDeclarator ","}+ ;
```

## syntax VariableDeclarator {#lang-java-\syntax-Java18-VariableDeclarator}

```rascal
syntax VariableDeclarator = variableDeclarator: VariableDeclaratorId ("=" VariableInitializer)? ;
```

## syntax VariableDeclaratorId {#lang-java-\syntax-Java18-VariableDeclaratorId}

```rascal
syntax VariableDeclaratorId = Identifier Dims? ;
```

## syntax VariableInitializer {#lang-java-\syntax-Java18-VariableInitializer}

```rascal
syntax VariableInitializer = Expression 
                           | ArrayInitializer
                           ;
```

## syntax UnannType {#lang-java-\syntax-Java18-UnannType}

```rascal
syntax UnannType = UnannPrimitiveType 
                 | UnannReferenceType
                 ;
```

## syntax UnannPrimitiveType {#lang-java-\syntax-Java18-UnannPrimitiveType}

```rascal
syntax UnannPrimitiveType = NumericType 
                          | "boolean" 
                          ;
```

## syntax UnannReferenceType {#lang-java-\syntax-Java18-UnannReferenceType}

```rascal
syntax UnannReferenceType = UnannClassOrInterfaceType 
                          | UnannArrayType
                          ;
```

## syntax UnannClassOrInterfaceType {#lang-java-\syntax-Java18-UnannClassOrInterfaceType}

```rascal
syntax UnannClassOrInterfaceType = UnannClassType 
                                 ;
```

## syntax UnannClassType {#lang-java-\syntax-Java18-UnannClassType}

```rascal
syntax UnannClassType = Identifier TypeArguments? 
                      | UnannClassOrInterfaceType "." Annotation* Identifier TypeArguments?;
```

## syntax UnannInterfaceType {#lang-java-\syntax-Java18-UnannInterfaceType}

```rascal
syntax UnannInterfaceType = UnannClassType ;
```

## syntax UnannTypeVariable {#lang-java-\syntax-Java18-UnannTypeVariable}

```rascal
syntax UnannTypeVariable = Identifier ;
```

## syntax UnannArrayType {#lang-java-\syntax-Java18-UnannArrayType}

```rascal
syntax UnannArrayType = UnannPrimitiveType Dims 
               | UnannClassOrInterfaceType Dims 
               ;
```

## syntax MethodDeclaration {#lang-java-\syntax-Java18-MethodDeclaration}

```rascal
syntax MethodDeclaration = methodDeclaration: MethodModifier* MethodHeader MethodBody ;
```

## syntax MethodModifier {#lang-java-\syntax-Java18-MethodModifier}

```rascal
syntax MethodModifier = Annotation 
                      | "public" 
                      | "protected" 
                      | "private"
                      | "abstract" 
                      | "static" 
                      | "final" 
                      | "synchronized" 
                      | "native" 
                      | "strictfp"
                      ;
```

## syntax MethodHeader {#lang-java-\syntax-Java18-MethodHeader}

```rascal
syntax MethodHeader = methodHeader: Result MethodDeclarator Throws?
                    |  TypeParameters Annotation* Result MethodDeclarator Throws?
                    ;
```

## syntax Result {#lang-java-\syntax-Java18-Result}

```rascal
syntax Result = UnannType 
              | "void" 
              ;
```

## syntax MethodDeclarator {#lang-java-\syntax-Java18-MethodDeclarator}

```rascal
syntax MethodDeclarator = Identifier "(" ")" Dims?
                        | Identifier "(" LastFormalParameter ")" Dims?
                        | Identifier "(" {FormalParameter ","}+ ("," LastFormalParameter)?")" Dims?
                        ;
```

## syntax FormalParameterList {#lang-java-\syntax-Java18-FormalParameterList}

```rascal
syntax FormalParameterList = FormalParameters ;
```

## syntax FormalParameters {#lang-java-\syntax-Java18-FormalParameters}

```rascal
syntax FormalParameters = formalParameter : FormalParameter ("," FormalParameters)?
                        | lastFormalParameter: LastFormalParameter
                        ;
```

## syntax FormalParameter {#lang-java-\syntax-Java18-FormalParameter}

```rascal
syntax FormalParameter = VariableModifier* mds UnannType atype VariableDeclaratorId vdid;
```

## syntax LastFormalParameter {#lang-java-\syntax-Java18-LastFormalParameter}

```rascal
syntax LastFormalParameter = VariableModifier* UnannType Annotation* "..." VariableDeclaratorId 
                           ;
```

## syntax ReceiverParameter {#lang-java-\syntax-Java18-ReceiverParameter}

```rascal
syntax ReceiverParameter = Annotation* UnannType (Identifier ".")? "this" ;
```

## syntax VariableModifier {#lang-java-\syntax-Java18-VariableModifier}

```rascal
syntax VariableModifier = Annotation 
                        | "final" 
                        ;
```

## syntax Throws {#lang-java-\syntax-Java18-Throws}

```rascal
syntax Throws = "throws" { ExceptionType "," }+;
```

## syntax ExceptionType {#lang-java-\syntax-Java18-ExceptionType}

```rascal
syntax ExceptionType = ClassType 
                     ;
```

## syntax MethodBody {#lang-java-\syntax-Java18-MethodBody}

```rascal
syntax MethodBody = Block ";"*
                  | ";"
                  ;
```

## syntax InstanceInitializer {#lang-java-\syntax-Java18-InstanceInitializer}

```rascal
syntax InstanceInitializer = Block ;
```

## syntax StaticInitializer {#lang-java-\syntax-Java18-StaticInitializer}

```rascal
syntax StaticInitializer = "static" Block ";"* ;
```

## syntax ConstructorDeclaration {#lang-java-\syntax-Java18-ConstructorDeclaration}

```rascal
syntax ConstructorDeclaration = ConstructorModifier* ConstructorDeclarator Throws? ConstructorBody ;
```

## syntax ConstructorModifier {#lang-java-\syntax-Java18-ConstructorModifier}

```rascal
syntax ConstructorModifier = Annotation 
                           | "public" 
                           | "protected" 
                           | "private" 
                           | "strictfp"
                           ;
```

## syntax ConstructorDeclarator {#lang-java-\syntax-Java18-ConstructorDeclarator}

```rascal
syntax ConstructorDeclarator = TypeParameters? SimpleTypeName "(" FormalParameterList? ")" ;
```

## syntax SimpleTypeName {#lang-java-\syntax-Java18-SimpleTypeName}

```rascal
syntax SimpleTypeName = Identifier ;
```

## syntax ConstructorBody {#lang-java-\syntax-Java18-ConstructorBody}

```rascal
syntax ConstructorBody = "{" ExplicitConstructorInvocation? BlockStatements? "}" ";"* ;
```

## syntax ExplicitConstructorInvocation {#lang-java-\syntax-Java18-ExplicitConstructorInvocation}

```rascal
syntax ExplicitConstructorInvocation = TypeArguments? "this" "(" ArgumentList? ")" ";"  
                                     | TypeArguments? "super" "(" ArgumentList? ")" ";" 
                                     | ExpressionName "." TypeArguments "super" "(" ArgumentList? ")" ";" 
                                     | Primary "." TypeArguments? "super" "(" ArgumentList? ")" ";"
                                     ;
```

## syntax EnumDeclaration {#lang-java-\syntax-Java18-EnumDeclaration}

```rascal
syntax EnumDeclaration = enumDeclaration : ClassModifier* "enum" Identifier Superinterfaces? EnumBody ;
```

## syntax EnumBody {#lang-java-\syntax-Java18-EnumBody}

```rascal
syntax EnumBody = "{" EnumConstantList? ","? EnumBodyDeclarations? "}" ";"?;
```

## syntax EnumConstantList {#lang-java-\syntax-Java18-EnumConstantList}

```rascal
syntax EnumConstantList = { EnumConstant "," }+ ;
```

## syntax EnumConstant {#lang-java-\syntax-Java18-EnumConstant}

```rascal
syntax EnumConstant = EnumConstantModifier* Identifier ("(" ArgumentList? ")")? ClassBody ? ;
```

## syntax EnumConstantModifier {#lang-java-\syntax-Java18-EnumConstantModifier}

```rascal
syntax EnumConstantModifier = Annotation ;
```

## syntax EnumBodyDeclarations {#lang-java-\syntax-Java18-EnumBodyDeclarations}

```rascal
syntax EnumBodyDeclarations =  ";" ClassBodyDeclaration* ;
```

## syntax InterfaceDeclaration {#lang-java-\syntax-Java18-InterfaceDeclaration}

```rascal
syntax InterfaceDeclaration = NormalInterfaceDeclaration 
                            | AnnotationTypeDeclaration
                            ;
```

## syntax NormalInterfaceDeclaration {#lang-java-\syntax-Java18-NormalInterfaceDeclaration}

```rascal
syntax NormalInterfaceDeclaration = normalInterfaceDeclaration : InterfaceModifier* "interface" Identifier TypeParameters? ExtendsInterfaces? InterfaceBody ;
```

## syntax InterfaceModifier {#lang-java-\syntax-Java18-InterfaceModifier}

```rascal
syntax InterfaceModifier = Annotation 
                         | "public" 
                         | "protected" 
                         | "private" 
                         | "abstract" 
                         | "static" 
                         | "strictfp"
                         ;
```

## syntax ExtendsInterfaces {#lang-java-\syntax-Java18-ExtendsInterfaces}

```rascal
syntax ExtendsInterfaces = "extends" {InterfaceType ","}+ ;
```

## syntax InterfaceBody {#lang-java-\syntax-Java18-InterfaceBody}

```rascal
syntax InterfaceBody = "{" InterfaceMemberDeclaration* "}" ";"* ;
```

## syntax InterfaceMemberDeclaration {#lang-java-\syntax-Java18-InterfaceMemberDeclaration}

```rascal
syntax InterfaceMemberDeclaration = ConstantDeclaration 
                                  | InterfaceMethodDeclaration 
                                  | ClassDeclaration 
                                  | InterfaceDeclaration 
                                  ;
```

## syntax ConstantDeclaration {#lang-java-\syntax-Java18-ConstantDeclaration}

```rascal
syntax ConstantDeclaration = ConstantModifier* UnannType VariableDeclaratorList ";" ;
```

## syntax ConstantModifier {#lang-java-\syntax-Java18-ConstantModifier}

```rascal
syntax ConstantModifier = Annotation 
                        | "public" 
                        | "static" 
                        | "final"
                        ;
```

## syntax InterfaceMethodDeclaration {#lang-java-\syntax-Java18-InterfaceMethodDeclaration}

```rascal
syntax InterfaceMethodDeclaration = InterfaceMethodModifier* MethodHeader MethodBody ";"?;
```

## syntax InterfaceMethodModifier {#lang-java-\syntax-Java18-InterfaceMethodModifier}

```rascal
syntax InterfaceMethodModifier = Annotation 
                               | "public" 
                               | "abstract" 
                               | "default" 
                               | "static" 
                               | "strictfp"
                               ;
```

## syntax AnnotationTypeDeclaration {#lang-java-\syntax-Java18-AnnotationTypeDeclaration}

```rascal
syntax AnnotationTypeDeclaration = InterfaceModifier* "@" "interface" Identifier AnnotationTypeBody ;
```

## syntax AnnotationTypeBody {#lang-java-\syntax-Java18-AnnotationTypeBody}

```rascal
syntax AnnotationTypeBody = "{" AnnotationTypeMemberDeclaration* "}" ;
```

## syntax AnnotationTypeMemberDeclaration {#lang-java-\syntax-Java18-AnnotationTypeMemberDeclaration}

```rascal
syntax AnnotationTypeMemberDeclaration = AnnotationTypeElementDeclaration 
                                       | ConstantDeclaration 
                                       | ClassDeclaration 
                                       | InterfaceDeclaration 
                                       | InterfaceMethodDeclaration
                                    //   | ";"
                                       ;
```

## syntax AnnotationTypeElementDeclaration {#lang-java-\syntax-Java18-AnnotationTypeElementDeclaration}

```rascal
syntax AnnotationTypeElementDeclaration = AnnotationTypeElementModifier* UnannType Identifier "(" ")" Dims? DefaultValue? ;
```

## syntax AnnotationTypeElementModifier {#lang-java-\syntax-Java18-AnnotationTypeElementModifier}

```rascal
syntax AnnotationTypeElementModifier = Annotation 
                                     | "public" 
                                     | "abstract"
                                     ;
```

## syntax DefaultValue {#lang-java-\syntax-Java18-DefaultValue}

```rascal
syntax DefaultValue = "default" ElementValue ";"*;
```

## syntax Annotation {#lang-java-\syntax-Java18-Annotation}

```rascal
syntax Annotation = NormalAnnotation 
                  | MarkerAnnotation 
                  | SingleElementAnnotation
                  ;
```

## syntax NormalAnnotation {#lang-java-\syntax-Java18-NormalAnnotation}

```rascal
syntax NormalAnnotation = "@" TypeName "(" ElementValuePairList? ")" ;
```

## syntax ElementValuePairList {#lang-java-\syntax-Java18-ElementValuePairList}

```rascal
syntax ElementValuePairList = {ElementValuePair ","}+ ;
```

## syntax ElementValuePair {#lang-java-\syntax-Java18-ElementValuePair}

```rascal
syntax ElementValuePair = Identifier "=" ElementValue ;
```

## syntax ElementValue {#lang-java-\syntax-Java18-ElementValue}

```rascal
syntax ElementValue = ConditionalExpression 
                    | ElementValueArrayInitializer 
                    | Annotation
                    ;
```

## syntax ElementValueArrayInitializer {#lang-java-\syntax-Java18-ElementValueArrayInitializer}

```rascal
syntax ElementValueArrayInitializer = "{" ElementValueList? ","? "}" ;
```

## syntax ElementValueList {#lang-java-\syntax-Java18-ElementValueList}

```rascal
syntax ElementValueList = { ElementValue "," }*;
```

## syntax MarkerAnnotation {#lang-java-\syntax-Java18-MarkerAnnotation}

```rascal
syntax MarkerAnnotation = "@" TypeName ;
```

## syntax SingleElementAnnotation {#lang-java-\syntax-Java18-SingleElementAnnotation}

```rascal
syntax SingleElementAnnotation = "@" TypeName "(" ElementValue ")" ;
```

## syntax ArrayInitializer {#lang-java-\syntax-Java18-ArrayInitializer}

```rascal
syntax ArrayInitializer = "{" VariableInitializerList? ","? "}" ;
```

## syntax VariableInitializerList {#lang-java-\syntax-Java18-VariableInitializerList}

```rascal
syntax VariableInitializerList = { VariableInitializer "," }+ ;
```

## syntax Block {#lang-java-\syntax-Java18-Block}

```rascal
syntax Block = "{" BlockStatements? "}" ;
```

## syntax BlockStatements {#lang-java-\syntax-Java18-BlockStatements}

```rascal
syntax BlockStatements = BlockStatement BlockStatement* ;
```

## syntax BlockStatement {#lang-java-\syntax-Java18-BlockStatement}

```rascal
syntax BlockStatement = LocalVariableDeclarationStatement 
                      | ClassDeclaration 
                      | Statement
                      ;
```

## syntax LocalVariableDeclarationStatement {#lang-java-\syntax-Java18-LocalVariableDeclarationStatement}

```rascal
syntax LocalVariableDeclarationStatement = LocalVariableDeclaration ";"+ ;
```

## syntax LocalVariableDeclaration {#lang-java-\syntax-Java18-LocalVariableDeclaration}

```rascal
syntax LocalVariableDeclaration = VariableModifier* UnannType VariableDeclaratorList ;
```

## syntax Statement {#lang-java-\syntax-Java18-Statement}

```rascal
syntax Statement = StatementWithoutTrailingSubstatement 
                 | LabeledStatement 
                 | IfThenStatement 
                 | IfThenElseStatement 
                 | WhileStatement 
                 | ForStatement
                 ;
```

## syntax StatementNoShortIf {#lang-java-\syntax-Java18-StatementNoShortIf}

```rascal
syntax StatementNoShortIf = StatementWithoutTrailingSubstatement 
                          | LabeledStatementNoShortIf 
                          | IfThenElseStatementNoShortIf 
                          | WhileStatementNoShortIf 
                          | ForStatementNoShortIf
                          ;
```

## syntax StatementWithoutTrailingSubstatement {#lang-java-\syntax-Java18-StatementWithoutTrailingSubstatement}

```rascal
syntax StatementWithoutTrailingSubstatement = Block 
                                            | EmptyStatement 
                                            | ExpressionStatement 
                                            | AssertStatement 
                                            | SwitchStatement 
                                            | DoStatement 
                                            | BreakStatement 
                                            | ContinueStatement 
                                            | ReturnStatement 
                                            | SynchronizedStatement 
                                            | ThrowStatement 
                                            | TryStatement
                                            ;
```

## syntax EmptyStatement {#lang-java-\syntax-Java18-EmptyStatement}

```rascal
syntax EmptyStatement = ";" ;
```

## syntax LabeledStatement {#lang-java-\syntax-Java18-LabeledStatement}

```rascal
syntax LabeledStatement = Identifier ":" Statement ;
```

## syntax LabeledStatementNoShortIf {#lang-java-\syntax-Java18-LabeledStatementNoShortIf}

```rascal
syntax LabeledStatementNoShortIf = Identifier ":"  StatementNoShortIf ;
```

## syntax ExpressionStatement {#lang-java-\syntax-Java18-ExpressionStatement}

```rascal
syntax ExpressionStatement = StatementExpression ";" ;
```

## syntax StatementExpression {#lang-java-\syntax-Java18-StatementExpression}

```rascal
syntax StatementExpression = Assignment 
                           | PreIncrementExpression 
                           | PreDecrementExpression 
                           | PostIncrementExpression 
                           | PostDecrementExpression 
                           | MethodInvocation 
                           | ClassInstanceCreationExpression
                           ;
```

## syntax IfThenStatement {#lang-java-\syntax-Java18-IfThenStatement}

```rascal
syntax IfThenStatement = "if" "(" Expression ")" Statement ;
```

## syntax IfThenElseStatement {#lang-java-\syntax-Java18-IfThenElseStatement}

```rascal
syntax IfThenElseStatement = "if" "(" Expression ")" StatementNoShortIf "else" Statement ;
```

## syntax IfThenElseStatementNoShortIf {#lang-java-\syntax-Java18-IfThenElseStatementNoShortIf}

```rascal
syntax IfThenElseStatementNoShortIf = "if" "(" Expression ")" StatementNoShortIf "else" StatementNoShortIf ;
```

## syntax AssertStatement {#lang-java-\syntax-Java18-AssertStatement}

```rascal
syntax AssertStatement = "assert" Expression ";"   
                       | "assert" Expression ":" Expression ";" 
                       ;
```

## syntax SwitchStatement {#lang-java-\syntax-Java18-SwitchStatement}

```rascal
syntax SwitchStatement = "switch" "(" Expression ")" SwitchBlock ;
```

## syntax SwitchBlock {#lang-java-\syntax-Java18-SwitchBlock}

```rascal
syntax SwitchBlock = "{" SwitchBlockStatementGroups SwitchLabel* "}" ;
```

## syntax SwitchBlockStatementGroups {#lang-java-\syntax-Java18-SwitchBlockStatementGroups}

```rascal
syntax SwitchBlockStatementGroups = SwitchBlockStatementGroup* ;
```

## syntax SwitchBlockStatementGroup {#lang-java-\syntax-Java18-SwitchBlockStatementGroup}

```rascal
syntax SwitchBlockStatementGroup = SwitchLabels BlockStatements ;
```

## syntax SwitchLabels {#lang-java-\syntax-Java18-SwitchLabels}

```rascal
syntax SwitchLabels = SwitchLabel+ ;
```

## syntax SwitchLabel {#lang-java-\syntax-Java18-SwitchLabel}

```rascal
syntax SwitchLabel = "case" ConstantExpression ":" 
                   | "default" ":" 
                   ;
```

## syntax EnumConstantName {#lang-java-\syntax-Java18-EnumConstantName}

```rascal
syntax EnumConstantName = Identifier ;
```

## syntax WhileStatement {#lang-java-\syntax-Java18-WhileStatement}

```rascal
syntax WhileStatement = whileStatement: "while" "(" Expression ")" Statement ;
```

## syntax WhileStatementNoShortIf {#lang-java-\syntax-Java18-WhileStatementNoShortIf}

```rascal
syntax WhileStatementNoShortIf = "while" "(" Expression ")" StatementNoShortIf ;
```

## syntax DoStatement {#lang-java-\syntax-Java18-DoStatement}

```rascal
syntax DoStatement = "do" Statement "while" "(" Expression ")" ;
```

## syntax ForStatement {#lang-java-\syntax-Java18-ForStatement}

```rascal
syntax ForStatement = BasicForStatement  
                    | EnhancedForStatement
                    ;
```

## syntax ForStatementNoShortIf {#lang-java-\syntax-Java18-ForStatementNoShortIf}

```rascal
syntax ForStatementNoShortIf = BasicForStatementNoShortIf 
                             | EnhancedForStatementNoShortIf
                             ;
```

## syntax BasicForStatement {#lang-java-\syntax-Java18-BasicForStatement}

```rascal
syntax BasicForStatement = "for" "(" ForInit? ";" Expression? ";" ForUpdate? ")" Statement ;
```

## syntax BasicForStatementNoShortIf {#lang-java-\syntax-Java18-BasicForStatementNoShortIf}

```rascal
syntax BasicForStatementNoShortIf = "for" "(" ForInit? ";" Expression? ";" ForUpdate? ")" StatementNoShortIf ;
```

## syntax ForInit {#lang-java-\syntax-Java18-ForInit}

```rascal
syntax ForInit = StatementExpressionList 
               | LocalVariableDeclaration
               ;
```

## syntax ForUpdate {#lang-java-\syntax-Java18-ForUpdate}

```rascal
syntax  ForUpdate = StatementExpressionList ;
```

## syntax StatementExpressionList {#lang-java-\syntax-Java18-StatementExpressionList}

```rascal
syntax StatementExpressionList = {StatementExpression ","} + ;
```

## syntax EnhancedForStatement {#lang-java-\syntax-Java18-EnhancedForStatement}

```rascal
syntax EnhancedForStatement = enhancedForStatement: "for" "(" VariableModifier* UnannType VariableDeclaratorId ":" Expression ")" Statement ;
```

## syntax EnhancedForStatementNoShortIf {#lang-java-\syntax-Java18-EnhancedForStatementNoShortIf}

```rascal
syntax EnhancedForStatementNoShortIf = "for" "(" VariableModifier* UnannType VariableDeclaratorId ":" Expression ")" StatementNoShortIf ;
```

## syntax BreakStatement {#lang-java-\syntax-Java18-BreakStatement}

```rascal
syntax BreakStatement = "break" Identifier? ";" ;
```

## syntax ContinueStatement {#lang-java-\syntax-Java18-ContinueStatement}

```rascal
syntax ContinueStatement = "continue" Identifier? ";" ;
```

## syntax ReturnStatement {#lang-java-\syntax-Java18-ReturnStatement}

```rascal
syntax ReturnStatement = "return" Expression? ";" ;
```

## syntax ThrowStatement {#lang-java-\syntax-Java18-ThrowStatement}

```rascal
syntax ThrowStatement = "throw" Expression ";" ;
```

## syntax SynchronizedStatement {#lang-java-\syntax-Java18-SynchronizedStatement}

```rascal
syntax SynchronizedStatement = "synchronized" "(" Expression ")" Block ;
```

## syntax TryStatement {#lang-java-\syntax-Java18-TryStatement}

```rascal
syntax TryStatement = "try" Block Catches 
                    | "try" Block Catches? Finally 
                    | TryWithResourcesStatement
                    ;
```

## syntax Catches {#lang-java-\syntax-Java18-Catches}

```rascal
syntax Catches = CatchClause+ ;
```

## syntax CatchClause {#lang-java-\syntax-Java18-CatchClause}

```rascal
syntax CatchClause = "catch" "(" CatchFormalParameter ")" Block ;
```

## syntax CatchFormalParameter {#lang-java-\syntax-Java18-CatchFormalParameter}

```rascal
syntax CatchFormalParameter = VariableModifier* CatchType VariableDeclaratorId ;
```

## syntax CatchType {#lang-java-\syntax-Java18-CatchType}

```rascal
syntax CatchType = UnannClassType ("|" ClassType)* ;
```

## syntax Finally {#lang-java-\syntax-Java18-Finally}

```rascal
syntax Finally = "finally" Block ;
```

## syntax TryWithResourcesStatement {#lang-java-\syntax-Java18-TryWithResourcesStatement}

```rascal
syntax TryWithResourcesStatement = "try" ResourceSpecification Block Catches? Finally? ;
```

## syntax ResourceSpecification {#lang-java-\syntax-Java18-ResourceSpecification}

```rascal
syntax ResourceSpecification = "(" ResourceList ";"? ")" ;
```

## syntax ResourceList {#lang-java-\syntax-Java18-ResourceList}

```rascal
syntax ResourceList = { Resource ";" }*;
```

## syntax Resource {#lang-java-\syntax-Java18-Resource}

```rascal
syntax Resource = VariableModifier* UnannType VariableDeclaratorId "=" Expression ;
```

## syntax Primary {#lang-java-\syntax-Java18-Primary}

```rascal
syntax Primary = PrimaryNoNewArray 
                | ArrayCreationExpression
                ;
```

## syntax PrimaryNoNewArray {#lang-java-\syntax-Java18-PrimaryNoNewArray}

```rascal
syntax PrimaryNoNewArray = Literal 
                          | ClassLiteral 
                          | "this" 
                          | TypeName "." "this" 
                          | "(" Expression ")" 
                          | ClassInstanceCreationExpression 
                          | FieldAccess 
                          | ArrayAccess 
                          | MethodInvocation 
                          | MethodReference               
                          ;
```

## syntax ClassLiteral {#lang-java-\syntax-Java18-ClassLiteral}

```rascal
syntax ClassLiteral = TypeName ("[" "]")* "." "class" 
                    | NumericType ("[" "]")* "." "class" 
                    | "boolean" ("[" "]")* "." "class" 
                    | "void" "." "class"              
                    ;
```

## syntax ClassInstanceCreationExpression {#lang-java-\syntax-Java18-ClassInstanceCreationExpression}

```rascal
syntax ClassInstanceCreationExpression = UnqualifiedClassInstanceCreationExpression 
                                       | ExpressionName "." UnqualifiedClassInstanceCreationExpression 
                                       | Primary "." UnqualifiedClassInstanceCreationExpression
                                       ;
```

## syntax UnqualifiedClassInstanceCreationExpression {#lang-java-\syntax-Java18-UnqualifiedClassInstanceCreationExpression}

```rascal
syntax UnqualifiedClassInstanceCreationExpression = "new" TypeArguments? ClassOrInterfaceTypeToInstantiate "(" ArgumentList? ")" 
                                                  | AIC ;
```

## syntax AIC {#lang-java-\syntax-Java18-AIC}

```rascal
syntax AIC = "new" TypeArguments? ClassOrInterfaceTypeToInstantiate "(" ArgumentList? ")" ClassBody ;
```

## syntax ClassOrInterfaceTypeToInstantiate {#lang-java-\syntax-Java18-ClassOrInterfaceTypeToInstantiate}

```rascal
syntax ClassOrInterfaceTypeToInstantiate = {AnnotatedType "."}* TypeArgumentsOrDiamond? ;
```

## syntax AnnotatedType {#lang-java-\syntax-Java18-AnnotatedType}

```rascal
syntax AnnotatedType = Annotation* Identifier ;
```

## syntax TypeArgumentsOrDiamond {#lang-java-\syntax-Java18-TypeArgumentsOrDiamond}

```rascal
syntax TypeArgumentsOrDiamond = TypeArguments  
                              ;
```

## syntax FieldAccess {#lang-java-\syntax-Java18-FieldAccess}

```rascal
syntax FieldAccess = Primary "." Identifier 
                   | "super" "." Identifier 
                   | TypeName "." "super" "." Identifier
                   ;
```

## syntax ArrayAccess {#lang-java-\syntax-Java18-ArrayAccess}

```rascal
syntax ArrayAccess = ExpressionName "[" Expression "]" 
                   | PrimaryNoNewArray "[" Expression "]" 
                   ;
```

## syntax MethodInvocation {#lang-java-\syntax-Java18-MethodInvocation}

```rascal
syntax MethodInvocation = MethodName "(" ArgumentList? ")"  
                        | ExpressionName "." TypeArguments? Identifier "(" ArgumentList? ")" 
                        | Primary "." TypeArguments? Identifier "(" ArgumentList? ")"  
                        | "super" "." TypeArguments? Identifier "(" ArgumentList? ")"  
                        | TypeName "." "super" "." TypeArguments? Identifier "(" ArgumentList? ")" 
                        ;
```

## syntax ArgumentList {#lang-java-\syntax-Java18-ArgumentList}

```rascal
syntax ArgumentList = { Expression "," }+ ;
```

## syntax MethodReference {#lang-java-\syntax-Java18-MethodReference}

```rascal
syntax MethodReference = ExpressionName "::" TypeArguments? Identifier 
                       | Primary "::" TypeArguments? Identifier 
                       | "super" "::" TypeArguments? Identifier 
                       | TypeName "." "super" "::" TypeArguments? Identifier 
                       | ClassType "::" TypeArguments? "new" 
                       | ArrayType "::" "new"
                       ;
```

## syntax ArrayCreationExpression {#lang-java-\syntax-Java18-ArrayCreationExpression}

```rascal
syntax ArrayCreationExpression = "new" PrimitiveType DimExprs Dims? 
                               | "new" ClassOrInterfaceType DimExprs Dims? 
                               | "new" PrimitiveType Dims ArrayInitializer 
                               | "new" ClassOrInterfaceType Dims ArrayInitializer
                               ;
```

## syntax DimExprs {#lang-java-\syntax-Java18-DimExprs}

```rascal
syntax DimExprs = DimExpr+ ;
```

## syntax DimExpr {#lang-java-\syntax-Java18-DimExpr}

```rascal
syntax DimExpr = Annotation* "[" Expression "]" ;
```

## syntax Expression {#lang-java-\syntax-Java18-Expression}

```rascal
syntax Expression = LambdaExpression 
                  | AssignmentExpression
                  ;
```

## syntax LambdaExpression {#lang-java-\syntax-Java18-LambdaExpression}

```rascal
syntax LambdaExpression = LambdaParameters "-\>" LambdaBody ;
```

## syntax LambdaParameters {#lang-java-\syntax-Java18-LambdaParameters}

```rascal
syntax LambdaParameters = Identifier 
                        | "(" FormalParameterList? ")"
                        | "(" InferredFormalParameterList ")" 
                        ;
```

## syntax InferredFormalParameterList {#lang-java-\syntax-Java18-InferredFormalParameterList}

```rascal
syntax InferredFormalParameterList = { Identifier "," }+;
```

## syntax LambdaBody {#lang-java-\syntax-Java18-LambdaBody}

```rascal
syntax LambdaBody = Expression 
                  | Block                               
                  ;
```

## syntax AssignmentExpression {#lang-java-\syntax-Java18-AssignmentExpression}

```rascal
syntax AssignmentExpression = ConditionalExpression 
                            | Assignment
                            ;
```

## syntax Assignment {#lang-java-\syntax-Java18-Assignment}

```rascal
syntax Assignment = LeftHandSide AssignmentOperator Expression ;
```

## syntax LeftHandSide {#lang-java-\syntax-Java18-LeftHandSide}

```rascal
syntax LeftHandSide = ExpressionName 
                    | FieldAccess 
                    | ArrayAccess
                    ;
```

## syntax AssignmentOperator {#lang-java-\syntax-Java18-AssignmentOperator}

```rascal
syntax AssignmentOperator = "=" 
                          | "*="  
                          | "/="  
                          | "%="  
                          | "+="  
                          | "-="  
                          | "\<\<="  
                          | "\>\>="  
                          | "\>\>\>="  
                          | "&="
                          | "^="  
                          | "|=" 
                          ;
```

## syntax ConditionalExpression {#lang-java-\syntax-Java18-ConditionalExpression}

```rascal
syntax ConditionalExpression = ConditionalOrExpression 
                             | ConditionalOrExpression "?" Expression ":" ConditionalExpression 
                             | ConditionalOrExpression "?" Expression ":" LambdaExpression
                             ;
```

## syntax ConditionalOrExpression {#lang-java-\syntax-Java18-ConditionalOrExpression}

```rascal
syntax ConditionalOrExpression = ConditionalAndExpression 
                               | ConditionalOrExpression "||" ConditionalAndExpression                              
                               ;
```

## syntax ConditionalAndExpression {#lang-java-\syntax-Java18-ConditionalAndExpression}

```rascal
syntax ConditionalAndExpression = InclusiveOrExpression 
                                | ConditionalAndExpression "&&" InclusiveOrExpression
                                ;
```

## syntax InclusiveOrExpression {#lang-java-\syntax-Java18-InclusiveOrExpression}

```rascal
syntax InclusiveOrExpression = ExclusiveOrExpression 
                             | InclusiveOrExpression "|" ExclusiveOrExpression
                             ;
```

## syntax ExclusiveOrExpression {#lang-java-\syntax-Java18-ExclusiveOrExpression}

```rascal
syntax ExclusiveOrExpression = AndExpression 
                      | ExclusiveOrExpression "^" AndExpression
                      ;
```

## syntax AndExpression {#lang-java-\syntax-Java18-AndExpression}

```rascal
syntax AndExpression = EqualityExpression 
                     | AndExpression "&" EqualityExpression
                     ;
```

## syntax EqualityExpression {#lang-java-\syntax-Java18-EqualityExpression}

```rascal
syntax EqualityExpression = RelationalExpression 
                          | EqualityExpression "==" RelationalExpression 
                          | EqualityExpression "!=" RelationalExpression
                          ;
```

## syntax RelationalExpression {#lang-java-\syntax-Java18-RelationalExpression}

```rascal
syntax RelationalExpression = ShiftExpression 
                            | RelationalExpression "\<" ShiftExpression 
                            | RelationalExpression "\>" ShiftExpression 
                            | RelationalExpression "\<=" ShiftExpression 
                            | RelationalExpression "\>=" ShiftExpression 
                            | RelationalExpression "instanceof" ReferenceType
                            ;
```

## syntax ShiftExpression {#lang-java-\syntax-Java18-ShiftExpression}

```rascal
syntax ShiftExpression = AdditiveExpression 
                       | ShiftExpression "\<\<" AdditiveExpression 
                       | ShiftExpression "\>\>" AdditiveExpression 
                       | ShiftExpression "\>\>\>" AdditiveExpression
                       ;
```

## syntax AdditiveExpression {#lang-java-\syntax-Java18-AdditiveExpression}

```rascal
syntax AdditiveExpression = MultiplicativeExpression 
                          | AdditiveExpression "+" !>> "+" MultiplicativeExpression 
                          | AdditiveExpression "-" !>> "-" MultiplicativeExpression
                          ;
```

## syntax MultiplicativeExpression {#lang-java-\syntax-Java18-MultiplicativeExpression}

```rascal
syntax MultiplicativeExpression = UnaryExpression 
                                | MultiplicativeExpression "*" UnaryExpression 
                                | MultiplicativeExpression "/" UnaryExpression 
                                | MultiplicativeExpression "%" UnaryExpression
                                ;
```

## syntax UnaryExpression {#lang-java-\syntax-Java18-UnaryExpression}

```rascal
syntax UnaryExpression = PreIncrementExpression 
                       | PreDecrementExpression 
                       > "+" !>> "+" UnaryExpression 
                       | "-" !>> "-" UnaryExpression 
                       | UnaryExpressionNotPlusMinus
                       ;
```

## syntax PreIncrementExpression {#lang-java-\syntax-Java18-PreIncrementExpression}

```rascal
syntax PreIncrementExpression = "++" UnaryExpression ;
```

## syntax PreDecrementExpression {#lang-java-\syntax-Java18-PreDecrementExpression}

```rascal
syntax PreDecrementExpression = "--" UnaryExpression ;
```

## syntax UnaryExpressionNotPlusMinus {#lang-java-\syntax-Java18-UnaryExpressionNotPlusMinus}

```rascal
syntax UnaryExpressionNotPlusMinus = PostfixExpression 
                                   | "~" UnaryExpression 
                                   | "!" UnaryExpression 
                                   | CastExpression                                
                                   ;
```

## syntax PostfixExpression {#lang-java-\syntax-Java18-PostfixExpression}

```rascal
syntax PostfixExpression = Primary 
                         | ExpressionName 
                         | PostIncrementExpression 
                         | PostDecrementExpression                                   
                         ;
```

## syntax PostIncrementExpression {#lang-java-\syntax-Java18-PostIncrementExpression}

```rascal
syntax PostIncrementExpression = PostfixExpression "++" ;
```

## syntax PostDecrementExpression {#lang-java-\syntax-Java18-PostDecrementExpression}

```rascal
syntax PostDecrementExpression = PostfixExpression "--" ;
```

## syntax CastExpression {#lang-java-\syntax-Java18-CastExpression}

```rascal
syntax CastExpression = "(" PrimitiveType ")" UnaryExpression 
                      | "(" ReferenceType AdditionalBound* ")" UnaryExpressionNotPlusMinus 
                      | "(" ReferenceType AdditionalBound* ")" LambdaExpression
                      ;
```

## syntax ConstantExpression {#lang-java-\syntax-Java18-ConstantExpression}

```rascal
syntax ConstantExpression = Expression ;
```

## syntax SignedInteger {#lang-java-\syntax-Java18-SignedInteger}

```rascal
lexical SignedInteger =
  [+ \-]? [0-9]+ 
  ;
```

## syntax LEX_StringLiteral {#lang-java-\syntax-Java18-LEX_StringLiteral}

```rascal
lexical LEX_StringLiteral =
   string: "\"" StringPart* "\"" 
  ;
```

## syntax HexaSignificand {#lang-java-\syntax-Java18-HexaSignificand}

```rascal
lexical HexaSignificand =
  [0] [X x] [0-9 A-F a-f]* "." [0-9 A-F a-f]* 
  | [0] [X x] [0-9 A-F a-f]+ 
  ;
```

## syntax OctaNumeral {#lang-java-\syntax-Java18-OctaNumeral}

```rascal
lexical OctaNumeral =
  [0] [0-7]+ 
  ;
```

## syntax HexaNumeral {#lang-java-\syntax-Java18-HexaNumeral}

```rascal
lexical HexaNumeral =
  [0] [X x] [0-9 A-F a-f]+ 
  ;
```

## syntax LEX_CharLiteral {#lang-java-\syntax-Java18-LEX_CharLiteral}

```rascal
lexical LEX_CharLiteral =
   char: "\'" CharContent "\'" 
  ;
```

## syntax EscChar {#lang-java-\syntax-Java18-EscChar}

```rascal
lexical EscChar =
  "\\" 
  ;
```

## syntax OctaEscape {#lang-java-\syntax-Java18-OctaEscape}

```rascal
lexical OctaEscape 
  = "\\" [0-3] [0-7]+ !>> [0-7] 
  | "\\" [0-7] !>> [0-7] 
  | "\\" [4-7] [0-7] 
  ;
```

## syntax EscEscChar {#lang-java-\syntax-Java18-EscEscChar}

```rascal
lexical EscEscChar =
  "\\\\" 
  ;
```

## syntax DeciNumeral {#lang-java-\syntax-Java18-DeciNumeral}

```rascal
lexical DeciNumeral =
  "0"
  | [1-9]
  | [1-9] [0-9 _]* [0-9];
```

## syntax HexaSignificandKeywords {#lang-java-\syntax-Java18-HexaSignificandKeywords}

```rascal
keyword HexaSignificandKeywords 
  = "0X."
  | "0x."
  ;
```

## syntax BinaryNumeral {#lang-java-\syntax-Java18-BinaryNumeral}

```rascal
lexical BinaryNumeral =
  "0" [b B] [0-1] [0-1 _]* !>> [0-1]
  ;
```

## syntax StringChars {#lang-java-\syntax-Java18-StringChars}

```rascal
lexical StringChars =
  FooStringChars 
  ;
```

## syntax LAYOUT {#lang-java-\syntax-Java18-LAYOUT}

```rascal
lexical LAYOUT =
  [\t-\n \a0C-\a0D \ ] 
  | Comment 
  ;
```

## syntax CharContent {#lang-java-\syntax-Java18-CharContent}

```rascal
lexical CharContent =
  EscapeSeq 
  | UnicodeEscape 
  |  single: SingleChar 
  ;
```

## syntax Comment {#lang-java-\syntax-Java18-Comment}

```rascal
lexical Comment =
  "/**/" 
  | "//" EOLCommentChars !>> ![\n \a0D] LineTerminator 
  | "/*" !>> [*] CommentPart* "*/" 
  | "/**" !>> [/] CommentPart* "*/" 
  ;
```

## syntax FloatingPointLiteral {#lang-java-\syntax-Java18-FloatingPointLiteral}

```rascal
syntax FloatingPointLiteral =
   float: HexaFloatLiteral !>> [D F d f] 
  |  float: DeciFloatLiteral !>> [D F d f] 
  ;
```

## syntax OctaLiteral {#lang-java-\syntax-Java18-OctaLiteral}

```rascal
lexical OctaLiteral =
  OctaNumeral !>> [0-7] [L l]? 
  ;
```

## syntax HexaFloatNumeral {#lang-java-\syntax-Java18-HexaFloatNumeral}

```rascal
lexical HexaFloatNumeral =
  HexaSignificand \ HexaSignificandKeywords !>> [0-9 A-F a-f] BinaryExponent 
  ;
```

## syntax IntegerLiteral {#lang-java-\syntax-Java18-IntegerLiteral}

```rascal
syntax IntegerLiteral =
   hexa: HexaLiteral !>> [L l.] 
  |  octa: OctaLiteral !>> [L l] 
  |  deci: DeciLiteral !>> [L l] 
  |  binary: BinaryIntegerLiteral !>> [L l]
  ;
```

## syntax HexaLiteral {#lang-java-\syntax-Java18-HexaLiteral}

```rascal
lexical HexaLiteral =
  HexaNumeral !>> [0-9 A-F a-f] [L l]? 
  ;
```

## syntax DeciFloatLiteral {#lang-java-\syntax-Java18-DeciFloatLiteral}

```rascal
lexical DeciFloatLiteral =
  DeciFloatNumeral [D F d f]? 
  ;
```

## syntax BinaryIntegerLiteral {#lang-java-\syntax-Java18-BinaryIntegerLiteral}

```rascal
lexical BinaryIntegerLiteral =
  BinaryNumeral [L l]?
  ;
```

## syntax ID {#lang-java-\syntax-Java18-ID}

```rascal
lexical ID =
	// Yes, this would be more correct, but REALLY slow at the moment
	//JavaLetter JavaLetterDigits* 
	//
	// therefore we go the ascii route:
  [$ A-Z _ a-z] [$ 0-9 A-Z _ a-z]* 
  ;
```

## syntax DeciFloatDigits {#lang-java-\syntax-Java18-DeciFloatDigits}

```rascal
lexical DeciFloatDigits =
  [0-9]+ 
  | [0-9]* "." [0-9]* 
  ;
```

## syntax DeciLiteral {#lang-java-\syntax-Java18-DeciLiteral}

```rascal
lexical DeciLiteral =
  DeciNumeral !>> [. 0-9 D F d f] [L l]? 
  ;
```

## syntax EscapeSeq {#lang-java-\syntax-Java18-EscapeSeq}

```rascal
lexical EscapeSeq =
  NamedEscape 
  | OctaEscape 
  ;
```

## syntax LAYOUTLIST {#lang-java-\syntax-Java18-LAYOUTLIST}

```rascal
layout LAYOUTLIST  =
  LAYOUT* !>> [\t-\n \a0C-\a0D \ ] !>> "/*" !>> "//"
  ;
```

## syntax NamedEscape {#lang-java-\syntax-Java18-NamedEscape}

```rascal
lexical NamedEscape =
   namedEscape: "\\" [\" \' \\ b f n r t] 
  ;
```

## syntax BinaryExponent {#lang-java-\syntax-Java18-BinaryExponent}

```rascal
lexical BinaryExponent =
  [P p] SignedInteger !>> [0-9] 
  ;
```

## syntax BlockCommentChars {#lang-java-\syntax-Java18-BlockCommentChars}

```rascal
lexical BlockCommentChars =
  ![* \\]+ 
  ;
```

## syntax Keyword {#lang-java-\syntax-Java18-Keyword}

```rascal
keyword Keyword =
  "continue" 
  | "package" 
  | "short" 
  | "boolean" 
  | "for" 
  | "extends" 
  | "do" 
  | "strictfp" 
  | "if" 
  | "enum" 
  | "synchronized" 
  | "else" 
  | "interface" 
  | "return" 
  | "private" 
  | "volatile" 
  | "default" 
  | "throws" 
  | "static" 
  | "long" 
  | "throw" 
  | "this" 
  | "catch" 
  | "super" 
  | "const" 
  | "switch" 
  | "int" 
  | "implements" 
  | "native" 
  | "abstract" 
  | "break" 
  | "goto" 
  | "final" 
  | "class" 
  | "byte" 
  | "instanceof" 
  | "void" 
  | "finally" 
  | "try" 
  | "new" 
  | "float" 
  | "public" 
  | "transient" 
  | "char" 
  | "assert" 
  | "case" 
  | "while" 
  | "double" 
  | "protected" 
  | "import" 
  ;
```

## syntax FooStringChars {#lang-java-\syntax-Java18-FooStringChars}

```rascal
lexical FooStringChars =
  ([\a00] | ![\n \a0D \" \\])+ 
  ;
```

## syntax StringPart {#lang-java-\syntax-Java18-StringPart}

```rascal
lexical StringPart =
  UnicodeEscape 
  | EscapeSeq 
  |  chars: StringChars !>> ![\n \a0D \" \\]  !>> [\a00]
  ;
```

## syntax EOLCommentChars {#lang-java-\syntax-Java18-EOLCommentChars}

```rascal
lexical EOLCommentChars =
  ![\n \a0D]* 
  ;
```

## syntax SingleChar {#lang-java-\syntax-Java18-SingleChar}

```rascal
lexical SingleChar =
  ![\n \a0D \' \\] 
  ;
```

## syntax CommentPart {#lang-java-\syntax-Java18-CommentPart}

```rascal
lexical CommentPart 
  = UnicodeEscape 
  | BlockCommentChars !>> ![* \\] 
  | EscChar !>> [\\ u] 
  | Asterisk !>> [/] 
  | EscEscChar 
  ;
```

## syntax Identifier {#lang-java-\syntax-Java18-Identifier}

```rascal
syntax Identifier = id: [$ A-Z _ a-z] !<< ID \ IDKeywords !>> [$ 0-9 A-Z _ a-z];
```

## syntax BooleanLiteral {#lang-java-\syntax-Java18-BooleanLiteral}

```rascal
syntax BooleanLiteral
  = \false: "false" 
  | \true: "true" 
  ;
```

## syntax DeciFloatExponentPart {#lang-java-\syntax-Java18-DeciFloatExponentPart}

```rascal
lexical DeciFloatExponentPart =
  [E e] SignedInteger !>> [0-9] 
  ;
```

## syntax DeciFloatDigitsKeywords {#lang-java-\syntax-Java18-DeciFloatDigitsKeywords}

```rascal
keyword DeciFloatDigitsKeywords =
  "." 
  ;
```

## syntax IDKeywords {#lang-java-\syntax-Java18-IDKeywords}

```rascal
keyword IDKeywords =
  "null" 
  | Keyword 
  | "true" 
  | "false" 
  ;
```

## syntax DeciFloatNumeral {#lang-java-\syntax-Java18-DeciFloatNumeral}

```rascal
lexical DeciFloatNumeral
	= [0-9] !<< [0-9]+ DeciFloatExponentPart
	| [0-9] !<< [0-9]+ >> [D F d f]
	| [0-9] !<< [0-9]+ "." [0-9]* !>> [0-9] DeciFloatExponentPart?
	| [0-9] !<< "." [0-9]+ !>> [0-9] DeciFloatExponentPart?
  ;
```

## syntax CarriageReturn {#lang-java-\syntax-Java18-CarriageReturn}

```rascal
lexical CarriageReturn =
  [\a0D] 
  ;
```

## syntax UnicodeEscape {#lang-java-\syntax-Java18-UnicodeEscape}

```rascal
lexical UnicodeEscape =
   unicodeEscape: "\\" [u]+ [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] [0-9 A-F a-f] 
  ;
```

## syntax LineTerminator {#lang-java-\syntax-Java18-LineTerminator}

```rascal
lexical LineTerminator =
  [\n] 
  | () !>> ![] 
  | [\a0D] [\n] 
  | CarriageReturn !>> [\n] 
  ;
```

## syntax HexaFloatLiteral {#lang-java-\syntax-Java18-HexaFloatLiteral}

```rascal
lexical HexaFloatLiteral =
  HexaFloatNumeral [D F d f]? 
  ;
```

## syntax Asterisk {#lang-java-\syntax-Java18-Asterisk}

```rascal
lexical Asterisk =
  "*" 
  ;
```

## syntax CharacterLiteral {#lang-java-\syntax-Java18-CharacterLiteral}

```rascal
syntax CharacterLiteral =
  LEX_CharLiteral 
  ;
```

## syntax StringLiteral {#lang-java-\syntax-Java18-StringLiteral}

```rascal
syntax StringLiteral =
  LEX_StringLiteral 
  ;
```

## syntax Null {#lang-java-\syntax-Java18-Null}

```rascal
syntax Null = "null" ;
```

## syntax NullLiteral {#lang-java-\syntax-Java18-NullLiteral}

```rascal
syntax NullLiteral = Null ;
```

