/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lang.java.m3.internal.LimitedTypeStore;
import lang.java.m3.internal.M3LocationUtil;
import lang.java.m3.internal.NodeResolver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.ParameterNode;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;
import org.rascalmpl.values.ValueFactoryFactory;

public class ASMNodeResolver
implements NodeResolver {
    private static final IValueFactory valueFactory = ValueFactoryFactory.getValueFactory();
    private static final TypeFactory typeFactory = TypeFactory.getInstance();
    private Map<String, String> primitiveTypes;
    private Map<String, String> typeSchemes;
    private LimitedTypeStore typeStore;
    private URIResolverRegistry registry;
    private ISourceLocation uri;
    private final SourceLocationClassLoader loader;

    public ASMNodeResolver(ISourceLocation uri, IList classPath, LimitedTypeStore typeStore) {
        this.typeStore = typeStore;
        this.uri = uri;
        this.registry = URIResolverRegistry.getInstance();
        this.loader = new SourceLocationClassLoader(this.initializeClassPath(classPath), Object.class.getClassLoader());
        this.typeSchemes = new HashMap<String, String>();
        this.initializePrimitiveTypes();
    }

    private void initializePrimitiveTypes() {
        this.primitiveTypes = new HashMap<String, String>();
        this.primitiveTypes.put(org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor(), org.objectweb.asm.Type.BOOLEAN_TYPE.getClassName());
        this.primitiveTypes.put(org.objectweb.asm.Type.CHAR_TYPE.getDescriptor(), org.objectweb.asm.Type.CHAR_TYPE.getClassName());
        this.primitiveTypes.put(org.objectweb.asm.Type.DOUBLE_TYPE.getDescriptor(), org.objectweb.asm.Type.DOUBLE_TYPE.getClassName());
        this.primitiveTypes.put(org.objectweb.asm.Type.INT_TYPE.getDescriptor(), org.objectweb.asm.Type.INT_TYPE.getClassName());
        this.primitiveTypes.put(org.objectweb.asm.Type.LONG_TYPE.getDescriptor(), org.objectweb.asm.Type.LONG_TYPE.getClassName());
        this.primitiveTypes.put(org.objectweb.asm.Type.SHORT_TYPE.getDescriptor(), org.objectweb.asm.Type.SHORT_TYPE.getClassName());
    }

    private List<ISourceLocation> initializeClassPath(IList classPath) {
        ArrayList<ISourceLocation> cp = new ArrayList<ISourceLocation>();
        try {
            ISourceLocation mainJar = this.toJarSrcLocation(this.uri);
            cp.add(mainJar);
            cp.addAll(this.getNestedJars(mainJar));
            classPath.forEach(loc -> {
                try {
                    ISourceLocation jarLoc = this.toJarSrcLocation((ISourceLocation)loc);
                    cp.add(jarLoc);
                    cp.addAll(this.getNestedJars(jarLoc));
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException("Cannot gather nested JARs.", e);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Cannot gather nested JARs.", e);
        }
        return cp;
    }

    private ISourceLocation toJarSrcLocation(ISourceLocation uri) {
        try {
            if (uri.getPath().endsWith(".jar")) {
                uri = uri.getScheme().startsWith("jar") ? uri : URIUtil.changeScheme((ISourceLocation)uri, (String)("jar+" + uri.getScheme()));
                return uri.getScheme().endsWith("!") ? uri : URIUtil.changePath((ISourceLocation)uri, (String)(uri.getPath() + "!"));
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("The location " + String.valueOf(uri) + " does not reference a JAR file.", e);
        }
        throw new RuntimeException("The location " + String.valueOf(uri) + " does not reference a JAR file.");
    }

    private List<ISourceLocation> getNestedJars(ISourceLocation uri) throws IOException, URISyntaxException {
        ISourceLocation[] entries;
        ArrayList<ISourceLocation> cp = new ArrayList<ISourceLocation>();
        for (ISourceLocation entry : entries = this.registry.list(uri)) {
            if (this.registry.isDirectory(entry)) {
                cp.addAll(this.getNestedJars(entry));
            }
            if (!entry.getPath().endsWith(".jar")) continue;
            entry = URIUtil.changeScheme((ISourceLocation)entry, (String)("jar+" + uri.getScheme()));
            entry = URIUtil.changePath((ISourceLocation)entry, (String)(entry.getPath() + "!"));
            cp.add(entry);
        }
        return cp;
    }

    @Override
    public ISourceLocation resolveBinding(Object node, ISourceLocation parent) {
        if (this.resolveInputValidation(node, parent)) {
            if (node instanceof FieldNode) {
                return this.resolveBinding((FieldNode)node, parent);
            }
            if (node instanceof MethodNode) {
                return this.resolveBinding((MethodNode)node, parent);
            }
            if (node instanceof ParameterNode) {
                return this.resolveBinding((ParameterNode)node, parent);
            }
        }
        if (node != null) {
            if (node instanceof AnnotationNode) {
                return this.resolveBinding((AnnotationNode)node);
            }
            if (node instanceof ClassNode) {
                return this.resolveBinding((ClassNode)node);
            }
            if (node instanceof ModuleNode) {
                return this.resolveBinding((ModuleNode)node);
            }
            if (node instanceof FieldInsnNode) {
                return this.resolveBinding((FieldInsnNode)node);
            }
            if (node instanceof MethodInsnNode) {
                return this.resolveBinding((MethodInsnNode)node);
            }
            if (node instanceof org.objectweb.asm.Type) {
                return this.resolveBinding((org.objectweb.asm.Type)node);
            }
        }
        return M3LocationUtil.makeLocation("unresolved", null, null);
    }

    private boolean resolveInputValidation(Object node, ISourceLocation parent) {
        return node != null && parent != null && !parent.getPath().isEmpty();
    }

    private ISourceLocation resolveBinding(AnnotationNode node) {
        String path = org.objectweb.asm.Type.getType((String)node.desc).getInternalName();
        return M3LocationUtil.makeLocation("java+interface", "", path);
    }

    private ISourceLocation resolveBinding(ClassNode node) {
        return M3LocationUtil.makeLocation(this.resolveClassScheme(node), "", node.name);
    }

    private ISourceLocation resolveBinding(ModuleNode node) {
        return M3LocationUtil.makeLocation("java+module", "", node.name);
    }

    private ISourceLocation resolveBinding(FieldInsnNode node) {
        String path = node.owner + "/" + node.name;
        return M3LocationUtil.makeLocation("java+field", "", path);
    }

    private ISourceLocation resolveBinding(FieldNode node, ISourceLocation parent) {
        if (!parent.getScheme().equals("java+class") && !parent.getScheme().equals("java+interface")) {
            return M3LocationUtil.makeLocation("unresolved", null, null);
        }
        String scheme = this.getFieldScheme(node.access);
        String path = parent.getPath() + "/" + node.name;
        return M3LocationUtil.makeLocation(scheme, "", path);
    }

    private String getFieldScheme(int access) {
        return (access & 0x4000) != 0 ? "java+enumConstant" : "java+field";
    }

    private ISourceLocation resolveBinding(MethodInsnNode node) {
        return this.resolveMethodBinding(node.name, node.desc, node.owner);
    }

    private ISourceLocation resolveBinding(MethodNode node, ISourceLocation parent) {
        if (!parent.getScheme().equals("java+class") && !parent.getScheme().equals("java+interface")) {
            return M3LocationUtil.makeLocation("unresolved", null, null);
        }
        return this.resolveMethodBinding(node.name, node.desc, parent);
    }

    @Override
    public ISourceLocation resolveMethodBinding(String name, String desc, ISourceLocation classLoc) {
        return this.resolveMethodBinding(name, desc, classLoc.getPath());
    }

    private ISourceLocation resolveMethodBinding(String name, String desc, String typePath) {
        String typeName = M3LocationUtil.getLocationName(typePath).getValue();
        String signature = this.getMethodSignature(name, desc, typeName);
        String path = typePath + "/" + signature;
        String methodScheme = this.getMethodScheme(name, typeName);
        if (methodScheme.equals("java+arrayMethod")) {
            return M3LocationUtil.makeLocation(methodScheme, "", this.getMethodScheme(name, "java.lang.Object"));
        }
        return M3LocationUtil.makeLocation(methodScheme, "", path);
    }

    private String getMethodSignature(String name, String desc, String typeName) {
        org.objectweb.asm.Type[] arguments;
        if (name.equals("<clinit>")) {
            return this.createStaticInitializerName(typeName);
        }
        String signature = name.equals("<init>") ? typeName + "(" : name + "(";
        for (org.objectweb.asm.Type argument : arguments = org.objectweb.asm.Type.getType((String)desc).getArgumentTypes()) {
            String argumentName = argument.getClassName();
            signature = signature + (String)(signature.endsWith("(") ? argumentName : "," + argumentName);
        }
        return signature + ")";
    }

    private String createStaticInitializerName(String typeName) {
        return typeName + "$initializer";
    }

    private String getMethodScheme(String name, String typeName) {
        switch (name) {
            case "<init>": {
                return "java+constructor";
            }
            case "<clinit>": {
                return "java+initializer";
            }
        }
        if (typeName.endsWith("[]")) {
            return "java+arrayMethod";
        }
        return "java+method";
    }

    private ISourceLocation resolveBinding(ParameterNode node, ISourceLocation parent) {
        if (!(parent.getScheme().equals("java+method") || parent.getScheme().equals("java+constructor") || parent.getScheme().equals("java+initializer"))) {
            return M3LocationUtil.makeLocation("unresolved", null, null);
        }
        String defaultName = "param";
        String path = parent.getPath() + "/" + defaultName;
        return M3LocationUtil.makeLocation("java+parameter", "", path);
    }

    private ISourceLocation resolveBinding(org.objectweb.asm.Type type) {
        String descriptor = type.getDescriptor().replace("[", "").replace("%5B", "");
        String scheme = this.getTypeScheme(descriptor);
        if (type.getClassName() == null) {
            return M3LocationUtil.makeLocation(scheme, "", descriptor);
        }
        String path = type.getClassName().replace(".", "/").replace("[", "").replace("]", "");
        return M3LocationUtil.makeLocation(scheme, "", path);
    }

    private String getTypeScheme(String descriptor) {
        if (this.primitiveTypes.containsKey(descriptor)) {
            return "java+primitiveType";
        }
        String className = descriptor.replace("[", "").replace("%5B", "");
        if (className.startsWith("L") && className.endsWith(";")) {
            className = className.substring(1, descriptor.length() - 1);
        }
        this.typeSchemes.computeIfAbsent(className, k -> this.resolveClassScheme((String)k));
        return this.typeSchemes.get(className);
    }

    private String resolveClassScheme(String className) {
        ClassReader cr = this.buildClassReader(className);
        return cr != null ? this.resolveClassScheme(cr.getAccess()) : "java+class";
    }

    private String resolveClassScheme(int access) {
        return (access & 0x200) != 0 ? "java+interface" : ((access & 0x4000) != 0 ? "java+enum" : "java+class");
    }

    @Override
    public String resolveClassScheme(ClassNode node) {
        this.typeSchemes.computeIfAbsent(node.name, k -> this.resolveClassScheme(node.access));
        return this.resolveClassScheme(node.access);
    }

    @Override
    public IConstructor resolveLanguageVersion(ClassNode node) {
        Map classToVersions = Map.ofEntries(Map.entry(196653, "1.1"), Map.entry(46, "1.2"), Map.entry(47, "1.3"), Map.entry(48, "1.4"), Map.entry(49, "1.5"), Map.entry(50, "1.6"), Map.entry(51, "1.7"), Map.entry(52, "1.8"), Map.entry(53, "9"), Map.entry(54, "10"), Map.entry(55, "11"), Map.entry(56, "12"), Map.entry(57, "13"), Map.entry(58, "14"), Map.entry(59, "15"), Map.entry(60, "16"), Map.entry(61, "17"), Map.entry(62, "18"), Map.entry(63, "19"), Map.entry(64, "20"), Map.entry(65, "21"), Map.entry(66, "22"));
        Map classToLevels = Map.ofEntries(Map.entry(196653, 1), Map.entry(46, 2), Map.entry(47, 3), Map.entry(48, 4), Map.entry(49, 5), Map.entry(50, 6), Map.entry(51, 7), Map.entry(52, 8), Map.entry(53, 9), Map.entry(54, 10), Map.entry(55, 11), Map.entry(56, 12), Map.entry(57, 13), Map.entry(58, 14), Map.entry(59, 15), Map.entry(60, 16), Map.entry(61, 17), Map.entry(62, 18), Map.entry(63, 19), Map.entry(64, 20), Map.entry(65, 21), Map.entry(66, 22));
        IInteger classFileLevel = valueFactory.integer(((Integer)classToLevels.get(node.version)).intValue());
        IString classFileVersion = valueFactory.string((String)classToVersions.get(node.version));
        Type Lang = this.typeStore.lookupAbstractDataType("Language");
        Type javaCons = this.typeStore.lookupConstructor(Lang, "java", typeFactory.tupleEmpty());
        IConstructor langCons = valueFactory.constructor(javaCons);
        langCons = (IConstructor)langCons.asWithKeywordParameters().setParameter("version", (IValue)classFileVersion);
        langCons = (IConstructor)langCons.asWithKeywordParameters().setParameter("level", (IValue)classFileLevel);
        return langCons;
    }

    @Override
    public IConstructor resolveType(Object node, ISourceLocation parent) {
        ISourceLocation uri = this.resolveBinding(node, parent);
        if (this.resolveInputValidation(node, parent)) {
            if (node instanceof FieldNode) {
                return this.resolveType((FieldNode)node, uri);
            }
            if (node instanceof MethodNode) {
                return this.resolveType((MethodNode)node, uri);
            }
        }
        if (node != null) {
            if (node instanceof ClassNode) {
                return this.resolveType((ClassNode)node, uri);
            }
            if (node instanceof org.objectweb.asm.Type) {
                return this.resolveType((org.objectweb.asm.Type)node);
            }
        }
        return this.unresolvedSym();
    }

    private IConstructor resolveType(ClassNode node, ISourceLocation uri) {
        IList typeParameterSymbols = valueFactory.list(new IValue[0]);
        if (uri.getScheme().equals("java+interface")) {
            return this.interfaceSymbol(uri, typeParameterSymbols);
        }
        return this.classSymbol(uri, typeParameterSymbols);
    }

    private IConstructor resolveType(FieldNode node, ISourceLocation uri) {
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)node.desc);
        return this.resolveType(type);
    }

    private IConstructor resolveType(MethodNode node, ISourceLocation uri) {
        org.objectweb.asm.Type descriptorType = org.objectweb.asm.Type.getType((String)node.desc);
        IList parametersSymbols = this.computeTypes(descriptorType.getArgumentTypes());
        if (uri.getScheme().equals("java+constructor")) {
            return this.constructorSymbol(uri, parametersSymbols);
        }
        IList typeParametersSymbols = valueFactory.list(new IValue[0]);
        IConstructor returnSymbol = this.resolveType(descriptorType.getReturnType());
        return this.methodSymbol(uri, typeParametersSymbols, returnSymbol, parametersSymbols);
    }

    private IList computeTypes(org.objectweb.asm.Type[] types) {
        IListWriter writer = valueFactory.listWriter();
        for (org.objectweb.asm.Type type : types) {
            IConstructor cons = this.resolveType(type);
            writer.append(new IValue[]{cons});
        }
        return (IList)writer.done();
    }

    private IConstructor resolveType(org.objectweb.asm.Type type) {
        String descriptor = type.getDescriptor();
        if (descriptor.equals(org.objectweb.asm.Type.VOID_TYPE.getDescriptor())) {
            return this.voidSymbol();
        }
        if (this.primitiveTypes.containsKey(descriptor)) {
            return this.primitiveSymbol(this.primitiveTypes.get(descriptor));
        }
        if (descriptor.startsWith("[")) {
            return this.arraySymbol(this.resolveType(type.getElementType()), type.getDimensions());
        }
        if (descriptor.startsWith("%5B")) {
            return this.arraySymbol(this.resolveType(type.getElementType()), type.getDimensions());
        }
        if (descriptor.startsWith("L")) {
            ISourceLocation uri = this.resolveBinding(type);
            IList typeParameters = valueFactory.list(new IValue[0]);
            return this.classSymbol(uri, typeParameters);
        }
        return this.unresolvedSym();
    }

    private IConstructor arraySymbol(IConstructor elem, int dimensions) {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "array", typeFactory.tupleType(new Type[]{elem.getType(), typeFactory.integerType()}));
        return valueFactory.constructor(cons, new IValue[]{elem, valueFactory.integer(dimensions)});
    }

    private IConstructor classSymbol(ISourceLocation uri, IList typeParameters) {
        if (uri.getPath().equals("/java/lang/Object")) {
            Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "object", typeFactory.voidType());
            return valueFactory.constructor(cons);
        }
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "class", typeFactory.tupleType(new Type[]{uri.getType(), typeParameters.getType()}));
        return valueFactory.constructor(cons, new IValue[]{uri, typeParameters});
    }

    private IConstructor constructorSymbol(ISourceLocation uri, IList parametersSymbols) {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "constructor", typeFactory.tupleType(new Type[]{uri.getType(), parametersSymbols.getType()}));
        return valueFactory.constructor(cons, new IValue[]{uri, parametersSymbols});
    }

    private IConstructor interfaceSymbol(ISourceLocation uri, IList typeParameterSymbols) {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "interface", typeFactory.tupleType(new Type[]{uri.getType(), typeParameterSymbols.getType()}));
        return valueFactory.constructor(cons, new IValue[]{uri, typeParameterSymbols});
    }

    private IConstructor methodSymbol(ISourceLocation uri, IList typeParametersSymbols, IConstructor returnSymbol, IList parametersSymbols) {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "method", typeFactory.tupleType(new Type[]{uri.getType(), typeParametersSymbols.getType(), returnSymbol.getType(), parametersSymbols.getType()}));
        return valueFactory.constructor(cons, new IValue[]{uri, typeParametersSymbols, returnSymbol, parametersSymbols});
    }

    private IConstructor primitiveSymbol(String name) {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), name, typeFactory.voidType());
        return valueFactory.constructor(cons);
    }

    private IConstructor unresolvedSym() {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "unresolved", typeFactory.voidType());
        return valueFactory.constructor(cons);
    }

    private IConstructor voidSymbol() {
        Type cons = this.typeStore.lookupConstructor(this.getTypeSymbol(), "void", typeFactory.voidType());
        return valueFactory.constructor(cons);
    }

    private Type getTypeSymbol() {
        return this.typeStore.lookupAbstractDataType("TypeSymbol");
    }

    @Override
    public ClassReader buildClassReader(String className) {
        try {
            return new ClassReader(className);
        }
        catch (IOException | IllegalArgumentException e) {
            return this.buildClassReaderFromStream(className);
        }
    }

    private ClassReader buildClassReaderFromStream(String className) {
        try {
            InputStream stream = this.loader.getResourceAsStream(className + ".class");
            return stream != null ? this.buildClassReader(stream) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ClassReader buildClassReader(InputStream classStream) throws IOException {
        return new ClassReader(classStream);
    }
}

