/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import lang.java.m3.internal.BindingsResolver;
import lang.java.m3.internal.LimitedTypeStore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.objectweb.asm.tree.ModuleNode;
import org.rascalmpl.values.ValueFactoryFactory;

public abstract class JavaToRascalConverter
extends ASTVisitor {
    protected static final IValueFactory values = ValueFactoryFactory.getValueFactory();
    protected static final TypeFactory TF = TypeFactory.getInstance();
    protected final LimitedTypeStore typeStore;
    protected IValue ownValue;
    private static final String DATATYPE_RASCAL_AST_TYPE_NODE = "Type";
    private static final String DATATYPE_RASCAL_AST_MODIFIER_NODE = "Modifier";
    private static final String DATATYPE_RASCAL_AST_DECLARATION_NODE = "Declaration";
    private static final String DATATYPE_RASCAL_AST_EXPRESSION_NODE = "Expression";
    private static final String DATATYPE_RASCAL_AST_STATEMENT_NODE = "Statement";
    private static final String DATATYPE_RASCAL_MESSAGE = "Message";
    private static final String DATATYPE_RASCAL_MESSAGE_ERROR = "error";
    protected final Type DATATYPE_RASCAL_AST_DECLARATION_NODE_TYPE;
    protected final Type DATATYPE_RASCAL_AST_EXPRESSION_NODE_TYPE;
    protected final Type DATATYPE_RASCAL_AST_STATEMENT_NODE_TYPE;
    protected final Type DATATYPE_RASCAL_AST_TYPE_NODE_TYPE;
    protected final Type DATATYPE_RASCAL_AST_MODIFIER_NODE_TYPE;
    protected final Type DATATYPE_RASCAL_MESSAGE_DATA_TYPE;
    protected final Type DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE1;
    protected final Type DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2;
    protected CompilationUnit compilUnit;
    protected ISourceLocation loc;
    protected final BindingsResolver bindingsResolver;
    protected final boolean collectBindings;
    protected IListWriter messages;
    protected final Map<String, ISourceLocation> locationCache;

    JavaToRascalConverter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache, boolean collectBindings) {
        super(true);
        this.typeStore = typeStore;
        this.bindingsResolver = new BindingsResolver(typeStore, cache, collectBindings);
        this.collectBindings = collectBindings;
        this.DATATYPE_RASCAL_AST_TYPE_NODE_TYPE = this.typeStore.lookupAbstractDataType(DATATYPE_RASCAL_AST_TYPE_NODE);
        this.DATATYPE_RASCAL_AST_MODIFIER_NODE_TYPE = this.typeStore.lookupAbstractDataType(DATATYPE_RASCAL_AST_MODIFIER_NODE);
        this.DATATYPE_RASCAL_AST_DECLARATION_NODE_TYPE = typeStore.lookupAbstractDataType(DATATYPE_RASCAL_AST_DECLARATION_NODE);
        this.DATATYPE_RASCAL_AST_EXPRESSION_NODE_TYPE = typeStore.lookupAbstractDataType(DATATYPE_RASCAL_AST_EXPRESSION_NODE);
        this.DATATYPE_RASCAL_AST_STATEMENT_NODE_TYPE = typeStore.lookupAbstractDataType(DATATYPE_RASCAL_AST_STATEMENT_NODE);
        this.DATATYPE_RASCAL_MESSAGE_DATA_TYPE = typeStore.lookupAbstractDataType(DATATYPE_RASCAL_MESSAGE);
        TypeFactory tf = TypeFactory.getInstance();
        this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE1 = typeStore.lookupConstructor(this.DATATYPE_RASCAL_MESSAGE_DATA_TYPE, DATATYPE_RASCAL_MESSAGE_ERROR, tf.tupleType(new Type[]{tf.stringType()}));
        this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2 = typeStore.lookupConstructor(this.DATATYPE_RASCAL_MESSAGE_DATA_TYPE, DATATYPE_RASCAL_MESSAGE_ERROR, tf.tupleType(new Type[]{tf.stringType(), tf.sourceLocationType()}));
        this.locationCache = cache;
        this.messages = values.listWriter();
    }

    protected ISourceLocation resolveBinding(String packageComponent) {
        ISourceLocation packageBinding = new BindingsResolver(this.typeStore, this.locationCache, this.collectBindings){

            public ISourceLocation resolveBinding(String packageC) {
                try {
                    if (JavaToRascalConverter.this.collectBindings) {
                        if (JavaToRascalConverter.this.locationCache.containsKey(packageC)) {
                            return JavaToRascalConverter.this.locationCache.get(packageC);
                        }
                        return values.sourceLocation("java+package", null, packageC);
                    }
                    return values.sourceLocation("unknown", null, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Should not happen", e);
                }
            }
        }.resolveBinding(packageComponent);
        this.locationCache.put(packageComponent, packageBinding);
        return packageBinding;
    }

    protected final ISourceLocation resolveBinding(CompilationUnit node) {
        ISourceLocation compilationUnit = new BindingsResolver(this.typeStore, this.locationCache, true){

            public ISourceLocation resolveBinding(CompilationUnit node) {
                return this.makeBinding("java+compilationUnit", null, JavaToRascalConverter.this.loc.getPath());
            }
        }.resolveBinding(node);
        return compilationUnit;
    }

    protected ISourceLocation resolveBinding(IBinding binding) {
        ISourceLocation resolvedBinding = this.bindingsResolver.resolveBinding(binding);
        if (binding != null) {
            this.locationCache.put(binding.getKey(), resolvedBinding);
        }
        return resolvedBinding;
    }

    protected ISourceLocation resolveDeclaringClass(IBinding binding) {
        ISourceLocation resolvedBinding;
        if (binding instanceof ITypeBinding) {
            resolvedBinding = this.bindingsResolver.resolveBinding((IBinding)((ITypeBinding)binding).getDeclaringClass());
        } else if (binding instanceof IMethodBinding) {
            resolvedBinding = this.bindingsResolver.resolveBinding((IBinding)((IMethodBinding)binding).getDeclaringClass());
        } else if (binding instanceof IVariableBinding) {
            resolvedBinding = this.bindingsResolver.resolveBinding((IBinding)((IVariableBinding)binding).getDeclaringClass());
        } else {
            binding = null;
            resolvedBinding = this.bindingsResolver.resolveBinding(binding);
        }
        return resolvedBinding;
    }

    protected ISourceLocation resolveBinding(ASTNode node) {
        if (node instanceof CompilationUnit) {
            return this.resolveBinding((CompilationUnit)node);
        }
        return this.bindingsResolver.resolveBinding(node, true);
    }

    protected ISourceLocation resolveBinding(ModuleNode module) {
        return this.bindingsResolver.makeBinding("java+module", "", module.name);
    }

    protected ISourceLocation getSourceLocation(ASTNode node) {
        try {
            int nodeLength = this.compilUnit.getExtendedLength(node);
            if (nodeLength > 0) {
                int start = this.compilUnit.getExtendedStartPosition(node);
                int end = start + nodeLength - 1;
                if (end < start && (node.getFlags() & 9) > 0) {
                    this.insert(this.messages, (IValue)values.constructor(this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2, new IValue[]{values.string("Recovered/Malformed node, guessing the length"), values.sourceLocation(this.loc, 0, 0)}));
                    nodeLength = node.toString().length();
                    end = start + nodeLength - 1;
                }
                return values.sourceLocation(this.loc, start, nodeLength, this.compilUnit.getLineNumber(start), this.compilUnit.getLineNumber(end), this.compilUnit.getColumnNumber(start), this.compilUnit.getColumnNumber(end) + 1);
            }
        }
        catch (IllegalArgumentException e) {
            this.insert(this.messages, (IValue)values.constructor(this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2, new IValue[]{values.string("Most probably missing dependency"), values.sourceLocation(this.loc, 0, 0)}));
        }
        return values.sourceLocation(this.loc, 0, 0, 0, 0, 0, 0);
    }

    protected IValue visitChild(ASTNode node) {
        node.accept((ASTVisitor)this);
        return this.getValue();
    }

    protected IList visitChildren(List<?> childrenList) {
        if (childrenList == null) {
            return values.list(new IValue[0]);
        }
        return (IList)childrenList.stream().map(o -> (ASTNode)o).map(a -> this.visitChild((ASTNode)a)).collect(values.listWriter());
    }

    public IValue getValue() {
        return this.ownValue;
    }

    protected IConstructor constructModifierNode(ISourceLocation src, String constructor, IValue ... children) {
        return (IConstructor)this.constructModifierNode(constructor, children).asWithKeywordParameters().setParameter("src", (IValue)src);
    }

    protected IConstructor constructModifierNode(String constructor, IValue ... children) {
        Type args = TF.tupleType(children);
        Type constr = this.typeStore.lookupConstructor(this.DATATYPE_RASCAL_AST_MODIFIER_NODE_TYPE, constructor, args);
        assert (constr != null) : "No constructor " + constructor + " for " + String.valueOf(args);
        return values.constructor(constr, children);
    }

    protected void setKeywordParameter(String label, IValue value) {
        if (this.ownValue == null) {
            return;
        }
        if (value != null) {
            this.ownValue = ((IConstructor)this.ownValue).asWithKeywordParameters().setParameter(label, value);
        }
    }

    protected void setKeywordParameters(String label, IList values) {
        if (this.ownValue == null) {
            return;
        }
        if (values != null && !values.isEmpty()) {
            this.ownValue = ((IConstructor)this.ownValue).asWithKeywordParameters().setParameter(label, (IValue)values);
        }
    }

    protected IValue constructDeclarationNode(String constructor, IValue ... children) {
        Type args = TF.tupleType(children);
        Type constr = this.typeStore.lookupConstructor(this.DATATYPE_RASCAL_AST_DECLARATION_NODE_TYPE, constructor, args);
        assert (constr != null) : "No constructor " + constructor + " for " + String.valueOf(args);
        return values.constructor(constr, children);
    }

    protected IValue constructExpressionNode(String constructor, IValue ... children) {
        Type args = TF.tupleType(children);
        Type constr = this.typeStore.lookupConstructor(this.DATATYPE_RASCAL_AST_EXPRESSION_NODE_TYPE, constructor, args);
        assert (constr != null) : "No constructor " + constructor + " for " + String.valueOf(args);
        return values.constructor(constr, children);
    }

    protected IValue constructStatementNode(String constructor, IValue ... children) {
        Type args = TF.tupleType(children);
        Type constr = this.typeStore.lookupConstructor(this.DATATYPE_RASCAL_AST_STATEMENT_NODE_TYPE, constructor, args);
        assert (constr != null) : "No constructor " + constructor + " for " + String.valueOf(args);
        return values.constructor(constr, children);
    }

    protected IValue constructTypeNode(String constructor, IValue ... children) {
        Type args = TF.tupleType(children);
        Type constr = this.typeStore.lookupConstructor(this.DATATYPE_RASCAL_AST_TYPE_NODE_TYPE, constructor, args);
        assert (constr != null) : "No constructor " + constructor + " for " + String.valueOf(args);
        return values.constructor(constr, children);
    }

    protected Type getAdtType() {
        if (this.ownValue == null) {
            return TF.voidType();
        }
        return this.ownValue.getType().getAbstractDataType();
    }

    protected void insertCompilationUnitMessages(boolean insertErrors, IList otherMessages) {
        Type args = TF.tupleType(new Type[]{TF.stringType(), TF.sourceLocationType()});
        IListWriter result = values.listWriter();
        if (otherMessages != null) {
            for (IValue message : otherMessages) {
                result.append(new IValue[]{message});
            }
        }
        if (insertErrors) {
            IProblem[] problems = this.compilUnit.getProblems();
            for (int i = 0; i < problems.length; ++i) {
                int offset = problems[i].getSourceStart();
                int length = problems[i].getSourceEnd() - offset + 1;
                int sl = problems[i].getSourceLineNumber();
                ISourceLocation pos = values.sourceLocation(this.loc, offset, length, sl, sl, 0, 0);
                Type constr = problems[i].isError() ? this.typeStore.lookupConstructor(this.typeStore.lookupAbstractDataType(DATATYPE_RASCAL_MESSAGE), DATATYPE_RASCAL_MESSAGE_ERROR, args) : this.typeStore.lookupConstructor(this.typeStore.lookupAbstractDataType(DATATYPE_RASCAL_MESSAGE), "warning", args);
                result.append(new IValue[]{values.constructor(constr, new IValue[]{values.string(problems[i].getMessage()), pos})});
            }
        }
        this.setKeywordParameter("messages", (IValue)result.done());
    }

    public void insert(IListWriter listW, IValue message) {
        if (message.getType().isConstructor() && message.getType().getAbstractDataType().getName().equals(DATATYPE_RASCAL_MESSAGE)) {
            listW.insert(new IValue[]{message});
        }
    }

    public void convert(CompilationUnit root, ASTNode node, ISourceLocation loc) {
        this.compilUnit = root;
        this.loc = loc;
        node.accept((ASTVisitor)this);
    }
}

