/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValueFactory;
import java.net.URISyntaxException;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.ValueFactoryFactory;

public class M3LocationUtil {
    private static final IValueFactory valueFactory = ValueFactoryFactory.getValueFactory();

    public static ISourceLocation makeLocation(String scheme, String authority, String path) {
        try {
            return valueFactory.sourceLocation(scheme, authority, path);
        }
        catch (UnsupportedOperationException | URISyntaxException e) {
            throw new RuntimeException("Error while creating an ISourceLocation", e);
        }
    }

    public static ISourceLocation makeLocation(ISourceLocation uri, int offset, int length) {
        return valueFactory.sourceLocation(uri, offset, length);
    }

    public static ISourceLocation extendPath(ISourceLocation uri, String path) {
        return URIUtil.getChildLocation((ISourceLocation)uri, (String)path);
    }

    public static ISourceLocation changePath(ISourceLocation uri, String path) {
        try {
            return URIUtil.changePath((ISourceLocation)uri, (String)path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Changing path error with URIUtil", e);
        }
    }

    public static IString getLocationName(String path) {
        return valueFactory.string(path.substring(path.lastIndexOf("/") + 1));
    }

    public static IString getLocationName(ISourceLocation loc) {
        String path = loc.getPath();
        return M3LocationUtil.getLocationName(path);
    }
}

