---
title: "module lang::java::tests::BasicM3Tests"
id: BasicM3Tests
slug: /Packages/org.rascalmpl.java-air/API/lang/java/tests/BasicM3Tests
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.java-air-1.0.0</div>

Regression tests and backward compatibility tests for AST construction and M3 extraction for Java
#### Usage

```rascal
import lang::java::tests::BasicM3Tests;
```

#### Dependencies
```rascal
import util::Reflective;
import List;
import Message;
import IO;
import util::FileSystem;
import util::Math;
import ValueIO;
import Node;
import String;
import lang::java::m3::Core;
import lang::java::m3::AST;
```


## function unpackExampleProject {#lang-java-tests-BasicM3Tests-unpackExampleProject}

Unpack a test source zip in a temporary folder for downstream analysis.

```rascal
loc unpackExampleProject(str name, loc projectZip)
```

## function compareM3s {#lang-java-tests-BasicM3Tests-compareM3s}

Comparison and simplistic differential diagnosis between two M3 models

```rascal
bool compareM3s(M3 a, M3 b)
```

# Tests
## test junitM3RemainedTheSame {#lang-java-tests-BasicM3Tests-junitM3RemainedTheSame}

```rascal

test bool junitM3RemainedTheSame() {
	reference = readBinaryValueFile(#M3, junitBinaryM3);
	root = junitProject;
	models = createM3sFromFiles(find(root + "src", "java"),
		sourcePath = junitSourcePath, 
		classPath = junitClassPath, 
		javaVersion = JLS13());
	result = composeJavaM3(|project://junit4|, models);

	if (OVERWRITE) {
		writeBinaryValueFile(junitBinaryM3, result);
	}

	return compareM3s(reference, result);
}
```

## test snakesM3RemainedTheSame {#lang-java-tests-BasicM3Tests-snakesM3RemainedTheSame}

```rascal

test bool snakesM3RemainedTheSame() {
	reference = readBinaryValueFile(#M3, snakesAndLaddersBinaryM3);
	root = snakesAndLaddersProject;

	models = createM3sFromFiles(find(root + "src", "java"),
		sourcePath = snakesSourcePath, 
		classPath = snakesClassPath, 
		javaVersion = JLS13());
	result = composeJavaM3(|project://snakes-and-ladders/|, models);

	if (OVERWRITE) {
		writeBinaryValueFile(snakesAndLaddersBinaryM3, result);
	}

	return compareM3s(reference, result);
}
```

## test junitASTsRemainedTheSame {#lang-java-tests-BasicM3Tests-junitASTsRemainedTheSame}

```rascal
  
test bool junitASTsRemainedTheSame()  {
	reference = readBinaryValueFile(#set[Declaration], junitBinaryASTs);
	root = junitProject;

	asts = createAstsFromFiles(find(root + "src", "java"), true, 
		sourcePath = junitSourcePath, 
		classPath = junitClassPath, 
		javaVersion = JLS13());

	// Because java.lang.SecurityManager no longer exists in JLS13 and we are compiling
	// an older version of Junit4, we get unresolved decl's for all things related to SecurityManager.
	astNodeSpecification(asts, checkNameResolution=true, checkSourceLocation=true);

	if (OVERWRITE) {
		writeBinaryValueFile(junitBinaryASTs, asts);
	}

	return reference == asts;
}
```

## test snakesASTsRemainedTheSame {#lang-java-tests-BasicM3Tests-snakesASTsRemainedTheSame}

```rascal
  	    
test bool snakesASTsRemainedTheSame() {
	reference = readBinaryValueFile(#set[Declaration], snakesAndLaddersBinaryAST);
	
	root = snakesAndLaddersProject;

	asts = createAstsFromFiles(find(root + "src", "java"), true, 
		sourcePath = junitSourcePath, 
		classPath = junitClassPath, 
		javaVersion = JLS13());

	astNodeSpecification(asts, checkNameResolution=true, checkSourceLocation=true);

	if (OVERWRITE) {
		writeBinaryValueFile(snakesAndLaddersBinaryAST, asts);
	}

	return reference == asts;
}
```

## test hamcrestJarM3RemainedTheSame {#lang-java-tests-BasicM3Tests-hamcrestJarM3RemainedTheSame}

```rascal

test bool hamcrestJarM3RemainedTheSame() {
	reference = readBinaryValueFile(#M3, hamcrestBinaryM3);

	// move to a location that is the same on all build machines
	targetJar = |tmp:///| + hamcrestJar.file;
	copy(hamcrestJar, targetJar, overwrite=true);

	result = createM3FromJar(targetJar);
	if (OVERWRITE) {
		writeBinaryValueFile(hamcrestBinaryM3, result);
	}
	return compareM3s(reference, result);
}
```

