/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.TypeFactory;
import java.util.List;
import java.util.Map;
import lang.java.m3.internal.JavaToRascalConverter;
import lang.java.m3.internal.LimitedTypeStore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;

public class ASTConverter
extends JavaToRascalConverter {
    private final boolean debug = false;

    public ASTConverter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache, boolean collectBindings) {
        super(typeStore, cache, collectBindings);
    }

    public void postVisit(ASTNode node) {
        this.setKeywordParameter("src", (IValue)this.getSourceLocation(node));
        if (this.collectBindings) {
            ISourceLocation decl = this.resolveBinding(node);
            if (!decl.getScheme().equals("unknown")) {
                this.setKeywordParameter("decl", (IValue)decl);
            }
            if (!(this.getAdtType() == this.DATATYPE_RASCAL_AST_STATEMENT_NODE_TYPE || decl.getScheme().equals("java+package") || decl.getScheme().equals("java+module") || node instanceof ModuleDeclaration)) {
                IValue type = this.resolveType(node);
                this.setKeywordParameter("typ", type);
            }
        }
    }

    private IValue resolveType(ASTNode node) {
        block11: {
            try {
                if (node instanceof Expression) {
                    if (node instanceof Name) {
                        IBinding b = ((Name)node).resolveBinding();
                        return this.bindingsResolver.resolveType(b, false);
                    }
                    ITypeBinding binding = ((Expression)node).resolveTypeBinding();
                    return this.bindingsResolver.resolveType((IBinding)binding, false);
                }
                if (node instanceof TypeDeclaration) {
                    ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
                    return this.bindingsResolver.resolveType((IBinding)binding, true);
                }
                if (node instanceof MethodDeclaration) {
                    IMethodBinding binding = ((MethodDeclaration)node).resolveBinding();
                    return this.bindingsResolver.resolveType((IBinding)binding, true);
                }
                if (node instanceof VariableDeclaration) {
                    IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
                    if (binding != null && binding.getType() != null) {
                        return this.bindingsResolver.resolveType((IBinding)binding.getType(), false);
                    }
                } else {
                    if (node instanceof ModuleDeclaration) {
                        IModuleBinding binding = ((ModuleDeclaration)node).resolveBinding();
                        return this.bindingsResolver.resolveType((IBinding)binding, true);
                    }
                    if (node instanceof Type) {
                        ITypeBinding binding = ((Type)node).resolveBinding();
                        return this.bindingsResolver.resolveType((IBinding)binding, false);
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)("Resolving type for " + node.getClass().getCanonicalName() + " @ " + String.valueOf(this.getSourceLocation(node))));
            }
        }
        return null;
    }

    public void preVisit(ASTNode node) {
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter bodyDeclarations = values.listWriter();
        for (BodyDeclaration d : node.bodyDeclarations()) {
            bodyDeclarations.append(new IValue[]{this.visitChild((ASTNode)d)});
        }
        this.ownValue = this.constructDeclarationNode("annotationType", new IValue[]{modifiers, name, bodyDeclarations.done()});
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue typeArgument = this.visitChild((ASTNode)node.getType());
        IValue name = this.visitChild((ASTNode)node.getName());
        if (node.getDefault() != null) {
            IValue defaultBlock = this.visitChild((ASTNode)node.getDefault());
            this.ownValue = this.constructDeclarationNode("annotationTypeMember", new IValue[]{modifiers, typeArgument, name, defaultBlock});
        } else {
            this.ownValue = this.constructDeclarationNode("annotationTypeMember", new IValue[]{modifiers, typeArgument, name});
        }
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        IListWriter bodyDeclarations = values.listWriter();
        for (BodyDeclaration b : node.bodyDeclarations()) {
            bodyDeclarations.append(new IValue[]{this.visitChild((ASTNode)b)});
        }
        this.ownValue = this.constructDeclarationNode("class", new IValue[]{bodyDeclarations.done()});
        return false;
    }

    public boolean visit(ArrayAccess node) {
        IValue array = this.visitChild((ASTNode)node.getArray());
        IValue index = this.visitChild((ASTNode)node.getIndex());
        this.ownValue = this.constructExpressionNode("arrayAccess", array, index);
        return false;
    }

    public boolean visit(CreationReference node) {
        IValue type = this.visitChild((ASTNode)node.getType());
        IList typeArguments = this.visitChildren(node.typeArguments());
        this.ownValue = this.constructExpressionNode("creationReference", new IValue[]{type, typeArguments});
        return false;
    }

    public boolean visit(ArrayCreation node) {
        IValue type = this.visitChild((ASTNode)node.getType().getElementType());
        IListWriter dimensions = values.listWriter();
        for (Expression e : node.dimensions()) {
            dimensions.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        if (node.getInitializer() != null) {
            IValue initializer = this.visitChild((ASTNode)node.getInitializer());
            this.ownValue = this.constructExpressionNode("newArray", new IValue[]{type, dimensions.done(), initializer});
        } else {
            this.ownValue = this.constructExpressionNode("newArray", new IValue[]{type, dimensions.done()});
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        IListWriter expressions = values.listWriter();
        for (Expression e : node.expressions()) {
            expressions.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        this.ownValue = this.constructExpressionNode("arrayInitializer", new IValue[]{expressions.done()});
        return false;
    }

    public boolean visit(ArrayType node) {
        int apiLevel = node.getAST().apiLevel();
        if (2 <= apiLevel && apiLevel <= 4) {
            IValue type = this.visitChild((ASTNode)node.getComponentType());
            this.ownValue = this.constructTypeNode("arrayType", type);
        } else {
            IValue type = this.visitChild((ASTNode)node.getElementType());
            this.ownValue = this.constructTypeNode("arrayType", type);
        }
        return false;
    }

    public boolean visit(AssertStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        if (node.getMessage() != null) {
            IValue message = this.visitChild((ASTNode)node.getMessage());
            this.ownValue = this.constructStatementNode("assert", expression, message);
        } else {
            this.ownValue = this.constructStatementNode("assert", expression);
        }
        return false;
    }

    public boolean visit(Assignment node) {
        IValue leftSide = this.visitChild((ASTNode)node.getLeftHandSide());
        IValue rightSide = this.visitChild((ASTNode)node.getRightHandSide());
        this.ownValue = this.constructExpressionNode("assignment", new IValue[]{leftSide, values.string(node.getOperator().toString()), rightSide});
        return false;
    }

    public boolean visit(Block node) {
        IListWriter statements = values.listWriter();
        for (Statement s : node.statements()) {
            statements.append(new IValue[]{this.visitChild((ASTNode)s)});
        }
        this.ownValue = this.constructStatementNode("block", new IValue[]{statements.done()});
        return false;
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        IString booleanValue = values.string(Boolean.toString(node.booleanValue()));
        this.ownValue = this.constructExpressionNode("booleanLiteral", new IValue[]{booleanValue});
        return false;
    }

    public boolean visit(BreakStatement node) {
        if (node.getLabel() != null) {
            IValue label = this.visitChild((ASTNode)node.getLabel());
            this.ownValue = this.constructStatementNode("break", label);
        } else if (node.getAST().apiLevel() == 12 && node.getExpression() != null) {
            IValue label = this.visitChild((ASTNode)node.getExpression());
            this.ownValue = this.constructStatementNode("break", label);
        } else {
            this.ownValue = this.constructStatementNode("break", new IValue[0]);
        }
        return false;
    }

    public boolean visit(CastExpression node) {
        IValue type = this.visitChild((ASTNode)node.getType());
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructExpressionNode("cast", type, expression);
        return false;
    }

    public boolean visit(CatchClause node) {
        IValue exception = this.visitChild((ASTNode)node.getException());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructStatementNode("catch", exception, body);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        IString value = values.string(node.getEscapedValue());
        this.ownValue = this.constructExpressionNode("characterLiteral", new IValue[]{value});
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        IValue anonymousClassDeclaration;
        IValue expression = node.getExpression() == null ? null : this.visitChild((ASTNode)node.getExpression());
        IValue type = null;
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() == 2) {
            type = this.visitChild((ASTNode)node.getName());
        } else {
            type = this.visitChild((ASTNode)node.getType());
            if (!node.typeArguments().isEmpty()) {
                for (Type t : node.typeArguments()) {
                    genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
                }
            }
        }
        IListWriter arguments = values.listWriter();
        for (Expression e : node.arguments()) {
            arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        IValue iValue = anonymousClassDeclaration = node.getAnonymousClassDeclaration() == null ? null : this.visitChild((ASTNode)node.getAnonymousClassDeclaration());
        this.ownValue = expression != null ? (anonymousClassDeclaration != null ? this.constructExpressionNode("newObject", new IValue[]{expression, type, genericTypes.done(), arguments.done(), anonymousClassDeclaration}) : this.constructExpressionNode("newObject", new IValue[]{expression, type, genericTypes.done(), arguments.done()})) : (anonymousClassDeclaration != null ? this.constructExpressionNode("newObject", new IValue[]{type, genericTypes.done(), arguments.done(), anonymousClassDeclaration}) : this.constructExpressionNode("newObject", new IValue[]{type, genericTypes.done(), arguments.done()}));
        return false;
    }

    public boolean visit(CompilationUnit node) {
        if (node.getModule() != null) {
            this.ownValue = this.constructDeclarationNode("compilationUnit", this.visitChild((ASTNode)node.getModule()));
            return false;
        }
        IValue packageOfUnit = node.getPackage() == null ? null : this.visitChild((ASTNode)node.getPackage());
        IListWriter imports = values.listWriter();
        for (ImportDeclaration d : node.imports()) {
            imports.append(new IValue[]{this.visitChild((ASTNode)d)});
        }
        IListWriter typeDeclarations = values.listWriter();
        for (AbstractTypeDeclaration d : node.types()) {
            typeDeclarations.append(new IValue[]{this.visitChild((ASTNode)d)});
        }
        this.ownValue = packageOfUnit != null ? this.constructDeclarationNode("compilationUnit", new IValue[]{packageOfUnit, imports.done(), typeDeclarations.done()}) : this.constructDeclarationNode("compilationUnit", new IValue[]{imports.done(), typeDeclarations.done()});
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IValue thenBranch = this.visitChild((ASTNode)node.getThenExpression());
        IValue elseBranch = this.visitChild((ASTNode)node.getElseExpression());
        this.ownValue = this.constructExpressionNode("conditional", expression, thenBranch, elseBranch);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        IListWriter types = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            for (Type t : node.typeArguments()) {
                types.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IListWriter arguments = values.listWriter();
        for (Expression e : node.arguments()) {
            arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        this.ownValue = this.constructStatementNode("constructorCall", new IValue[]{types.done(), arguments.done()});
        return false;
    }

    public boolean visit(ContinueStatement node) {
        if (node.getLabel() != null) {
            IValue label = this.visitChild((ASTNode)node.getLabel());
            this.ownValue = this.constructStatementNode("continue", label);
        } else {
            this.ownValue = this.constructStatementNode("continue", new IValue[0]);
        }
        return false;
    }

    public boolean visit(DoStatement node) {
        IValue body = this.visitChild((ASTNode)node.getBody());
        IValue whileExpression = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructStatementNode("do", body, whileExpression);
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.ownValue = this.constructStatementNode("empty", new IValue[0]);
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        IValue parameter = this.visitChild((ASTNode)node.getParameter());
        IValue collectionExpression = this.visitChild((ASTNode)node.getExpression());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructStatementNode("foreach", parameter, collectionExpression, body);
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter arguments = values.listWriter();
        if (!node.arguments().isEmpty()) {
            for (Expression e : node.arguments()) {
                arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
            }
        }
        if (node.getAnonymousClassDeclaration() != null) {
            IValue anonymousClassDeclaration = this.visitChild((ASTNode)node.getAnonymousClassDeclaration());
            this.ownValue = this.constructDeclarationNode("enumConstant", new IValue[]{modifiers, name, arguments.done(), anonymousClassDeclaration});
        } else {
            this.ownValue = this.constructDeclarationNode("enumConstant", new IValue[]{modifiers, name, arguments.done()});
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter implementedInterfaces = values.listWriter();
        if (!node.superInterfaceTypes().isEmpty()) {
            for (Type t : node.superInterfaceTypes()) {
                implementedInterfaces.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IListWriter enumConstants = values.listWriter();
        for (EnumConstantDeclaration d : node.enumConstants()) {
            enumConstants.append(new IValue[]{this.visitChild((ASTNode)d)});
        }
        IListWriter bodyDeclarations = values.listWriter();
        if (!node.bodyDeclarations().isEmpty()) {
            for (BodyDeclaration d : node.bodyDeclarations()) {
                bodyDeclarations.append(new IValue[]{this.visitChild((ASTNode)d)});
            }
        }
        this.ownValue = this.constructDeclarationNode("enum", new IValue[]{modifiers, name, implementedInterfaces.done(), enumConstants.done(), bodyDeclarations.done()});
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructStatementNode("expressionStatement", expression);
        return false;
    }

    public boolean visit(FieldAccess node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructExpressionNode("fieldAccess", expression, name);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue type = this.visitChild((ASTNode)node.getType());
        IListWriter fragments = values.listWriter();
        for (VariableDeclarationFragment f : node.fragments()) {
            fragments.append(new IValue[]{this.visitChild((ASTNode)f)});
        }
        this.ownValue = this.constructDeclarationNode("field", new IValue[]{modifiers, type, fragments.done()});
        return false;
    }

    public boolean visit(ForStatement node) {
        IListWriter initializers = values.listWriter();
        for (Expression e : node.initializers()) {
            initializers.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        IValue booleanExpression = node.getExpression() == null ? null : this.visitChild((ASTNode)node.getExpression());
        IListWriter updaters = values.listWriter();
        for (Expression e : node.updaters()) {
            updaters.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = booleanExpression != null ? this.constructStatementNode("for", new IValue[]{initializers.done(), booleanExpression, updaters.done(), body}) : this.constructStatementNode("for", new IValue[]{initializers.done(), updaters.done(), body});
        return false;
    }

    public boolean visit(IfStatement node) {
        IValue booleanExpression = this.visitChild((ASTNode)node.getExpression());
        IValue thenStatement = this.visitChild((ASTNode)node.getThenStatement());
        if (node.getElseStatement() != null) {
            IValue elseStatement = this.visitChild((ASTNode)node.getElseStatement());
            this.ownValue = this.constructStatementNode("if", booleanExpression, thenStatement, elseStatement);
        } else {
            this.ownValue = this.constructStatementNode("if", booleanExpression, thenStatement);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter importModifiers = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
            ISourceLocation entireNode = this.getSourceLocation((ASTNode)node);
            ISourceLocation namePosition = this.getSourceLocation((ASTNode)node.getName());
            int staticStart = entireNode.getOffset() + "import".length();
            ISourceLocation staticPos = values.sourceLocation(entireNode.top(), staticStart, namePosition.getOffset() - staticStart);
            importModifiers.append(new IValue[]{this.constructModifierNode(staticPos, "static", new IValue[0])});
        }
        this.ownValue = node.isOnDemand() ? this.constructDeclarationNode("import", new IValue[]{importModifiers.done(), name}) : this.constructDeclarationNode("importOnDemand", new IValue[]{importModifiers.done(), name});
        return false;
    }

    public boolean visit(InfixExpression node) {
        InfixExpression.Operator op = node.getOperator();
        IValue leftSide = this.visitChild((ASTNode)node.getLeftOperand());
        IValue rightSide = this.visitChild((ASTNode)node.getRightOperand());
        switch (op.toString()) {
            case "*": {
                this.ownValue = this.constructExpressionNode("times", leftSide, rightSide);
                break;
            }
            case "/": {
                this.ownValue = this.constructExpressionNode("divide", leftSide, rightSide);
                break;
            }
            case "%": {
                this.ownValue = this.constructExpressionNode("remainder", leftSide, rightSide);
                break;
            }
            case "+": {
                this.ownValue = this.constructExpressionNode("plus", leftSide, rightSide);
                break;
            }
            case "-": {
                this.ownValue = this.constructExpressionNode("minus", leftSide, rightSide);
                break;
            }
            case "<<": {
                this.ownValue = this.constructExpressionNode("leftShift", leftSide, rightSide);
                break;
            }
            case ">>": {
                this.ownValue = this.constructExpressionNode("rightShift", leftSide, rightSide);
                break;
            }
            case ">>>": {
                this.ownValue = this.constructExpressionNode("rightShiftSigned", leftSide, rightSide);
                break;
            }
            case "<": {
                this.ownValue = this.constructExpressionNode("less", leftSide, rightSide);
                break;
            }
            case ">": {
                this.ownValue = this.constructExpressionNode("greater", leftSide, rightSide);
                break;
            }
            case "<=": {
                this.ownValue = this.constructExpressionNode("lessEquals", leftSide, rightSide);
                break;
            }
            case ">=": {
                this.ownValue = this.constructExpressionNode("greaterEquals", leftSide, rightSide);
                break;
            }
            case "==": {
                this.ownValue = this.constructExpressionNode("equals", leftSide, rightSide);
                break;
            }
            case "!=": {
                this.ownValue = this.constructExpressionNode("notEquals", leftSide, rightSide);
                break;
            }
            case "^": {
                this.ownValue = this.constructExpressionNode("xor", leftSide, rightSide);
                break;
            }
            case "|": {
                this.ownValue = this.constructExpressionNode("or", leftSide, rightSide);
                break;
            }
            case "&": {
                this.ownValue = this.constructExpressionNode("and", leftSide, rightSide);
                break;
            }
            case "||": {
                this.ownValue = this.constructExpressionNode("conditionalOr", leftSide, rightSide);
                break;
            }
            case "&&": {
                this.ownValue = this.constructExpressionNode("conditionalAnd", leftSide, rightSide);
                break;
            }
            default: {
                throw new IllegalArgumentException(node.getOperator().getClass().getCanonicalName());
            }
        }
        return false;
    }

    public boolean visit(NameQualifiedType node) {
        IValue qualifier = this.visitChild((ASTNode)node.getQualifier());
        IList annos = this.visitChildren(node.annotations());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructTypeNode("qualifiedType", new IValue[]{annos, qualifier, name});
        return false;
    }

    public boolean visit(Initializer node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructDeclarationNode("initializer", new IValue[]{modifiers, body});
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        IValue leftSide = this.visitChild((ASTNode)node.getLeftOperand());
        IValue rightSide = this.visitChild((ASTNode)node.getRightOperand());
        this.ownValue = this.constructExpressionNode("instanceof", leftSide, rightSide);
        return false;
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        IString label = values.string(node.getLabel().getFullyQualifiedName());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructStatementNode("label", new IValue[]{label, body});
        return false;
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        IValue typeName = this.visitChild((ASTNode)node.getTypeName());
        this.ownValue = this.constructModifierNode("markerAnnotation", typeName);
        return false;
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public boolean visit(MemberValuePair node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IValue value = this.visitChild((ASTNode)node.getValue());
        this.ownValue = this.constructExpressionNode("memberValuePair", name, value);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        IValue body;
        String constructorName = "method";
        IList modifiers = this.visitChildren(node.modifiers());
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
            for (TypeParameter t : node.typeParameters()) {
                genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IValue returnType = null;
        if (!node.isConstructor()) {
            returnType = node.getAST().apiLevel() == 2 ? this.visitChild((ASTNode)node.getReturnType()) : (node.getReturnType2() != null ? this.visitChild((ASTNode)node.getReturnType2()) : this.constructTypeNode("void", new IValue[0]));
        } else {
            constructorName = "constructor";
        }
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter parameters = values.listWriter();
        for (SingleVariableDeclaration v : node.parameters()) {
            parameters.append(new IValue[]{this.visitChild((ASTNode)v)});
        }
        IListWriter possibleExceptions = values.listWriter();
        int apiLevel = node.getAST().apiLevel();
        if (apiLevel == 2 || apiLevel == 3 || apiLevel == 4) {
            if (!node.thrownExceptions().isEmpty()) {
                for (Name n2 : node.thrownExceptions()) {
                    possibleExceptions.append(new IValue[]{this.visitChild((ASTNode)n2)});
                }
            }
        } else if (!node.thrownExceptionTypes().isEmpty()) {
            node.thrownExceptionTypes().stream().map(o -> (ASTNode)o).map(n -> this.visitChild((ASTNode)n)).collect(possibleExceptions);
        }
        IValue iValue = body = node.getBody() == null ? null : this.visitChild((ASTNode)node.getBody());
        if (body == null && constructorName.equals("constructor")) {
            body = this.constructStatementNode("empty", new IValue[0]);
        }
        if (body != null) {
            if ("constructor".equals(constructorName)) {
                this.ownValue = this.constructDeclarationNode(constructorName, new IValue[]{modifiers, name, parameters.done(), possibleExceptions.done(), body});
            } else {
                if (modifiers.getElementType() == TypeFactory.getInstance().nodeType()) {
                    System.err.println(modifiers);
                }
                this.ownValue = this.constructDeclarationNode(constructorName, new IValue[]{modifiers, genericTypes.done(), returnType, name, parameters.done(), possibleExceptions.done(), body});
            }
        } else {
            assert (!constructorName.equals("constructor"));
            this.ownValue = this.constructDeclarationNode(constructorName, new IValue[]{modifiers, genericTypes.done(), returnType, name, parameters.done(), possibleExceptions.done()});
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            for (Type t : node.typeArguments()) {
                genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter arguments = values.listWriter();
        for (Expression e : node.arguments()) {
            arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
            if (arguments.get(0).getType().getName().equals("Expression")) continue;
            System.err.println(arguments.done());
        }
        if (node.getExpression() != null) {
            IValue expression = this.visitChild((ASTNode)node.getExpression());
            this.ownValue = this.constructExpressionNode("methodCall", new IValue[]{expression, genericTypes.done(), name, arguments.done()});
        } else {
            this.ownValue = this.constructExpressionNode("methodCall", new IValue[]{genericTypes.done(), name, arguments.done()});
        }
        return false;
    }

    public boolean visit(MethodRef node) {
        return false;
    }

    public boolean visit(MethodRefParameter node) {
        return false;
    }

    public boolean visit(Modifier node) {
        String modifier = node.getKeyword().toString();
        this.ownValue = this.constructModifierNode(modifier, new IValue[0]);
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        IValue typeName = this.visitChild((ASTNode)node.getTypeName());
        IListWriter memberValuePairs = values.listWriter();
        for (MemberValuePair p : node.values()) {
            memberValuePairs.append(new IValue[]{this.visitChild((ASTNode)p)});
        }
        this.ownValue = this.constructModifierNode("normalAnnotation", new IValue[]{typeName, memberValuePairs.done()});
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.ownValue = this.constructExpressionNode("null", new IValue[0]);
        return false;
    }

    public boolean visit(NumberLiteral node) {
        IString number = values.string(node.getToken());
        this.ownValue = this.constructExpressionNode("number", new IValue[]{number});
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IList annotations = this.visitChildren(node.annotations());
        this.ownValue = this.constructDeclarationNode("package", new IValue[]{annotations, name});
        return false;
    }

    public boolean visit(ParameterizedType node) {
        IValue type = this.visitChild((ASTNode)node.getType());
        IListWriter genericTypes = values.listWriter();
        for (Type t : node.typeArguments()) {
            genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
        }
        this.ownValue = this.constructTypeNode("parameterizedType", new IValue[]{type, genericTypes.done()});
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructExpressionNode("bracket", expression);
        return false;
    }

    public boolean visit(PostfixExpression node) {
        PostfixExpression.Operator op = node.getOperator();
        IValue operand = this.visitChild((ASTNode)node.getOperand());
        switch (op.toString()) {
            case "++": {
                this.ownValue = this.constructExpressionNode("postIncrement", operand);
                break;
            }
            case "--": {
                this.ownValue = this.constructExpressionNode("postDecrement", operand);
                break;
            }
            default: {
                throw new IllegalArgumentException(op.toString());
            }
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        IValue operand = this.visitChild((ASTNode)node.getOperand());
        PrefixExpression.Operator operator = node.getOperator();
        switch (operator.toString()) {
            case "++": {
                this.ownValue = this.constructExpressionNode("preIncrement", operand);
                break;
            }
            case "--": {
                this.ownValue = this.constructExpressionNode("preDecrement", operand);
                break;
            }
            case "+": {
                this.ownValue = this.constructExpressionNode("prePlus", operand);
                break;
            }
            case "-": {
                this.ownValue = this.constructExpressionNode("preMinus", operand);
                break;
            }
            case "~": {
                this.ownValue = this.constructExpressionNode("preComplement", operand);
                break;
            }
            case "!": {
                this.ownValue = this.constructExpressionNode("preNot", operand);
                break;
            }
            default: {
                throw new IllegalArgumentException(operator.toString());
            }
        }
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.ownValue = this.constructTypeNode(node.toString(), new IValue[0]);
        return false;
    }

    public boolean visit(QualifiedName node) {
        IConstructor qualifier = (IConstructor)this.visitChild((ASTNode)node.getQualifier());
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter names = values.listWriter();
        if (qualifier.getConstructorType().getName().equals("qualifiedName")) {
            names.appendAll((Iterable)((IList)qualifier.get("identifiers")));
        } else {
            names.append(new IValue[]{qualifier});
        }
        names.append(new IValue[]{name});
        this.ownValue = this.constructExpressionNode("qualifiedName", new IValue[]{names.done()});
        return false;
    }

    public boolean visit(QualifiedType node) {
        IValue qualifier = this.visitChild((ASTNode)node.getQualifier());
        IList annos = this.visitChildren(node.annotations());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructTypeNode("qualifiedType", new IValue[]{annos, qualifier, name});
        return false;
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() != null) {
            IValue expression = this.visitChild((ASTNode)node.getExpression());
            this.ownValue = this.constructStatementNode("return", expression);
        } else {
            this.ownValue = this.constructStatementNode("return", new IValue[0]);
        }
        return false;
    }

    public boolean visit(SimpleName node) {
        IString value = values.string(node.getFullyQualifiedName());
        this.ownValue = this.constructExpressionNode("id", new IValue[]{value});
        return false;
    }

    public boolean visit(SimpleType node) {
        IValue value = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructTypeNode("simpleType", value);
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        IValue name = this.visitChild((ASTNode)node.getTypeName());
        IValue value = this.visitChild((ASTNode)node.getValue());
        this.ownValue = this.constructModifierNode("singleMemberAnnotation", name, value);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IList modifiers = this.visitChildren(node.modifiers());
        IValue type = this.visitChild((ASTNode)node.getType());
        IValue initializer = node.getInitializer() == null ? null : this.visitChild((ASTNode)node.getInitializer());
        IList dimensions = (IList)node.extraDimensions().stream().map(o -> (ASTNode)o).map(d -> this.visitChild((ASTNode)d)).collect(values.listWriter());
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            assert (initializer == null);
            this.ownValue = this.constructDeclarationNode("vararg", new IValue[]{modifiers, type, name});
        } else {
            this.ownValue = initializer != null ? this.constructDeclarationNode("parameter", new IValue[]{modifiers, type, name, dimensions, initializer}) : this.constructDeclarationNode("parameter", new IValue[]{modifiers, type, name, dimensions});
        }
        return false;
    }

    public boolean visit(Dimension node) {
        IList annos = this.visitChildren(node.annotations());
        this.ownValue = this.constructDeclarationNode("dimension", new IValue[]{annos});
        return false;
    }

    public boolean visit(StringLiteral node) {
        IString escaped = values.string(node.getEscapedValue());
        IString literal = values.string(node.getLiteralValue());
        this.ownValue = this.constructExpressionNode("stringLiteral", new IValue[]{escaped}).asWithKeywordParameters().setParameter("literal", (IValue)literal);
        return false;
    }

    public boolean visit(TextBlock node) {
        IString escaped = values.string(node.getEscapedValue());
        IString literal = values.string(node.getLiteralValue());
        this.ownValue = this.constructExpressionNode("textBlock", new IValue[]{escaped}).asWithKeywordParameters().setParameter("literal", (IValue)literal);
        return false;
    }

    public boolean visit(YieldStatement node) {
        IValue exp = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructStatementNode("yield", exp);
        return false;
    }

    public boolean visit(LambdaExpression node) {
        IList parameters = this.visitChildren(node.parameters());
        this.ownValue = this.constructExpressionNode("lambda", new IValue[]{parameters, this.visitChild(node.getBody())});
        return false;
    }

    public boolean visit(SwitchExpression node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IListWriter statements = values.listWriter();
        for (Statement s : node.statements()) {
            statements.append(new IValue[]{this.visitChild((ASTNode)s)});
        }
        this.ownValue = this.constructExpressionNode("switch", new IValue[]{expression, statements.done()});
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        IValue expression = node.getExpression() == null ? null : this.visitChild((ASTNode)node.getExpression());
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            for (Type t : node.typeArguments()) {
                genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IListWriter arguments = values.listWriter();
        for (Expression e : node.arguments()) {
            arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        this.ownValue = expression != null ? this.constructStatementNode("superConstructorCall", new IValue[]{expression, genericTypes.done(), arguments.done()}) : this.constructStatementNode("superConstructorCall", new IValue[]{genericTypes.done(), arguments.done()});
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        IValue qualifier = node.getQualifier() == null ? null : this.visitChild((ASTNode)node.getQualifier());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = qualifier != null ? this.constructExpressionNode("fieldAccess", qualifier, name) : this.constructExpressionNode("fieldAccess", name);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        IValue qualifier = node.getQualifier() == null ? null : this.visitChild((ASTNode)node.getQualifier());
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            for (Type t : node.typeArguments()) {
                genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter arguments = values.listWriter();
        for (Expression e : node.arguments()) {
            arguments.append(new IValue[]{this.visitChild((ASTNode)e)});
        }
        this.ownValue = qualifier != null ? this.constructExpressionNode("superMethodCall", new IValue[]{qualifier, genericTypes.done(), name, arguments.done()}) : this.constructExpressionNode("superMethodCall", new IValue[]{genericTypes.done(), name, arguments.done()});
        return false;
    }

    public boolean visit(SwitchCase node) {
        IList exprs;
        IValue expression = node.getExpression() == null ? null : this.visitChild((ASTNode)node.getExpression());
        List expressions = node.expressions();
        String constructorName = "case";
        IList iList = exprs = expression == null ? values.list(new IValue[]{expression}) : (IList)expressions.stream().map(o -> (Expression)o).map(e -> this.visitChild((ASTNode)e)).collect(values.listWriter());
        if (node.isSwitchLabeledRule()) {
            constructorName = "caseRule";
            this.ownValue = this.constructStatementNode(constructorName, new IValue[]{exprs});
        } else if (node.isDefault()) {
            constructorName = "defaultCase";
            this.ownValue = this.constructStatementNode(constructorName, new IValue[0]);
        } else {
            this.ownValue = this.constructStatementNode(constructorName, new IValue[]{exprs});
        }
        return false;
    }

    public boolean visit(TypeMethodReference node) {
        IValue type = this.visitChild((ASTNode)node.getType());
        IList args = (IList)node.typeArguments().stream().map(o -> (Type)o).map(t -> this.visitChild((ASTNode)t)).collect(values.listWriter());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructExpressionNode("methodReference", new IValue[]{type, args, name});
        return false;
    }

    public boolean visit(ExpressionMethodReference node) {
        IValue type = this.visitChild((ASTNode)node.getExpression());
        IList args = (IList)node.typeArguments().stream().map(o -> (Type)o).map(t -> this.visitChild((ASTNode)t)).collect(values.listWriter());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructExpressionNode("methodReference", new IValue[]{type, args, name});
        return false;
    }

    public boolean visit(ModuleDeclaration node) {
        IList mod = node.isOpen() ? values.list(new IValue[]{this.constructModifierNode("open", new IValue[0])}) : values.list(new IValue[0]);
        IValue name = this.visitChild((ASTNode)node.getName());
        IList stats = (IList)node.moduleStatements().stream().map(o -> (ASTNode)o).map(s -> this.visitChild((ASTNode)s)).collect(values.listWriter());
        this.ownValue = this.constructDeclarationNode("module", new IValue[]{mod, name, stats});
        return false;
    }

    public boolean visit(ModuleModifier node) {
        if (node.isStatic()) {
            this.ownValue = this.constructModifierNode("static", new IValue[0]);
        } else if (node.isTransitive()) {
            this.ownValue = this.constructModifierNode("static", new IValue[0]);
        } else assert (false);
        return false;
    }

    public boolean visit(OpensDirective node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IList modules = (IList)node.modules().stream().map(e -> (ASTNode)e).map(n -> this.visitChild((ASTNode)n)).collect(values.listWriter());
        this.ownValue = this.constructDeclarationNode("opensPackage", new IValue[]{name, modules});
        return false;
    }

    public boolean visit(ProvidesDirective node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IList implementations = (IList)node.implementations().stream().map(e -> (ASTNode)e).map(n -> this.visitChild((ASTNode)n)).collect(values.listWriter());
        this.ownValue = this.constructDeclarationNode("providesImplementations", new IValue[]{name, implementations});
        return false;
    }

    public boolean visit(RequiresDirective node) {
        IList modifiers = (IList)node.modifiers().stream().map(e -> (ASTNode)e).map(n -> this.visitChild((ASTNode)n)).collect(values.listWriter());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructDeclarationNode("requires", new IValue[]{modifiers, name});
        return false;
    }

    public boolean visit(UsesDirective node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructDeclarationNode("uses", name);
        return false;
    }

    public boolean visit(ExportsDirective node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructDeclarationNode("exports", new IValue[]{name, this.visitChildren(node.modules())});
        return false;
    }

    public boolean visit(SuperMethodReference node) {
        IList args = (IList)node.typeArguments().stream().map(o -> (Type)o).map(t -> this.visitChild((ASTNode)t)).collect(values.listWriter());
        IValue name = this.visitChild((ASTNode)node.getName());
        this.ownValue = this.constructExpressionNode("superMethodReference", new IValue[]{args, name});
        return false;
    }

    public boolean visit(SwitchStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IListWriter statements = values.listWriter();
        for (Statement s : node.statements()) {
            statements.append(new IValue[]{this.visitChild((ASTNode)s)});
        }
        this.ownValue = this.constructStatementNode("switch", new IValue[]{expression, statements.done()});
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructStatementNode("synchronizedStatement", expression, body);
        return false;
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public boolean visit(TextElement node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            IValue qualifier = this.visitChild((ASTNode)node.getQualifier());
            this.ownValue = this.constructExpressionNode("this", qualifier);
        } else {
            this.ownValue = this.constructExpressionNode("this", new IValue[0]);
        }
        return false;
    }

    public boolean visit(ThrowStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        this.ownValue = this.constructStatementNode("throw", expression);
        return false;
    }

    public boolean visit(TryStatement node) {
        IValue body = this.visitChild((ASTNode)node.getBody());
        IListWriter catchClauses = values.listWriter();
        for (CatchClause cc : node.catchClauses()) {
            catchClauses.append(new IValue[]{this.visitChild((ASTNode)cc)});
        }
        if (node.getFinally() != null) {
            IValue finallyBlock = this.visitChild((ASTNode)node.getFinally());
            this.ownValue = this.constructStatementNode("try", new IValue[]{body, catchClauses.done(), finallyBlock});
        } else {
            this.ownValue = this.constructStatementNode("try", new IValue[]{body, catchClauses.done()});
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        IList modifiers = this.visitChildren(node.modifiers());
        String objectType = node.isInterface() ? "interface" : "class";
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter genericTypes = values.listWriter();
        if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
            for (TypeParameter t : node.typeParameters()) {
                genericTypes.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        IListWriter extendsClass = values.listWriter();
        IListWriter implementsInterfaces = values.listWriter();
        if (node.getAST().apiLevel() == 2) {
            if (node.getSuperclass() != null) {
                extendsClass.append(new IValue[]{this.visitChild((ASTNode)node.getSuperclass())});
            }
            if (!node.superInterfaces().isEmpty()) {
                for (Name n : node.superInterfaces()) {
                    implementsInterfaces.append(new IValue[]{this.visitChild((ASTNode)n)});
                }
            }
        } else if (node.getAST().apiLevel() >= 3) {
            if (node.getSuperclassType() != null) {
                extendsClass.append(new IValue[]{this.visitChild((ASTNode)node.getSuperclassType())});
            }
            if (!node.superInterfaceTypes().isEmpty()) {
                for (Type t : node.superInterfaceTypes()) {
                    implementsInterfaces.append(new IValue[]{this.visitChild((ASTNode)t)});
                }
            }
        }
        IListWriter bodyDeclarations = values.listWriter();
        for (BodyDeclaration d : node.bodyDeclarations()) {
            bodyDeclarations.append(new IValue[]{this.visitChild((ASTNode)d)});
        }
        this.ownValue = this.constructDeclarationNode(objectType, new IValue[]{modifiers, name, genericTypes.done(), extendsClass.done(), implementsInterfaces.done(), bodyDeclarations.done()});
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        IValue typeDeclaration = node.getAST().apiLevel() == 2 ? this.visitChild((ASTNode)node.getTypeDeclaration()) : this.visitChild((ASTNode)node.getDeclaration());
        this.ownValue = this.constructStatementNode("declarationStatement", typeDeclaration);
        return false;
    }

    public boolean visit(TypeLiteral node) {
        IValue type = this.visitChild((ASTNode)node.getType());
        this.ownValue = this.constructExpressionNode("type", type);
        return false;
    }

    public boolean visit(TypeParameter node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IListWriter extendsList = values.listWriter();
        if (!node.typeBounds().isEmpty()) {
            for (Type t : node.typeBounds()) {
                extendsList.append(new IValue[]{this.visitChild((ASTNode)t)});
            }
        }
        this.ownValue = this.constructDeclarationNode("typeParameter", new IValue[]{name, extendsList.done()});
        return false;
    }

    public boolean visit(UnionType node) {
        IListWriter typesValues = values.listWriter();
        for (Type type : node.types()) {
            typesValues.append(new IValue[]{this.visitChild((ASTNode)type)});
        }
        this.ownValue = this.constructTypeNode("unionType", new IValue[]{typesValues.done()});
        return false;
    }

    public boolean visit(IntersectionType node) {
        IListWriter typesValues = values.listWriter();
        for (Type type : node.types()) {
            typesValues.append(new IValue[]{this.visitChild((ASTNode)type)});
        }
        this.ownValue = this.constructTypeNode("intersectionType", new IValue[]{typesValues.done()});
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue type = this.visitChild((ASTNode)node.getType());
        IListWriter fragments = values.listWriter();
        for (VariableDeclarationFragment f : node.fragments()) {
            fragments.append(new IValue[]{this.visitChild((ASTNode)f)});
        }
        this.ownValue = this.constructDeclarationNode("variables", new IValue[]{modifiers, type, fragments.done()});
        this.postVisit((ASTNode)node);
        this.ownValue = this.constructExpressionNode("declarationExpression", this.ownValue);
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        IValue name = this.visitChild((ASTNode)node.getName());
        IList dimensions = (IList)node.extraDimensions().stream().map(o -> (ASTNode)o).map(d -> this.visitChild((ASTNode)d)).collect(values.listWriter());
        if (node.getInitializer() != null) {
            IValue initializer = this.visitChild((ASTNode)node.getInitializer());
            this.ownValue = this.constructDeclarationNode("variable", new IValue[]{name, dimensions, initializer});
        } else {
            this.ownValue = this.constructDeclarationNode("variable", new IValue[]{name, dimensions});
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        IList modifiers = this.visitChildren(node.modifiers());
        IValue type = this.visitChild((ASTNode)node.getType());
        IListWriter fragments = values.listWriter();
        for (VariableDeclarationFragment f : node.fragments()) {
            fragments.append(new IValue[]{this.visitChild((ASTNode)f)});
        }
        this.ownValue = this.constructDeclarationNode("variables", new IValue[]{modifiers, type, fragments.done()});
        this.postVisit((ASTNode)node);
        this.ownValue = this.constructStatementNode("declarationStatement", this.ownValue);
        return false;
    }

    public boolean visit(WhileStatement node) {
        IValue expression = this.visitChild((ASTNode)node.getExpression());
        IValue body = this.visitChild((ASTNode)node.getBody());
        this.ownValue = this.constructStatementNode("while", expression, body);
        return false;
    }

    public boolean visit(WildcardType node) {
        String name = "wildcard";
        IList annos = this.visitChildren(node.annotations());
        if (node.getBound() != null) {
            IValue bound = this.visitChild((ASTNode)node.getBound());
            name = node.isUpperBound() ? "extends" : "super";
            this.ownValue = this.constructTypeNode(name, new IValue[]{annos, bound});
        } else {
            this.ownValue = this.constructTypeNode(name, new IValue[]{annos});
        }
        return false;
    }
}

