/*
 * Decompiled with CFR 0.152.
 */
package lang.java.m3.internal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lang.java.m3.internal.LimitedTypeStore;
import lang.java.m3.internal.M3Converter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.rascalmpl.uri.URIUtil;

public class SourceConverter
extends M3Converter {
    SourceConverter(LimitedTypeStore typeStore, Map<String, ISourceLocation> cache) {
        super(typeStore, cache);
    }

    private void visitListOfModifiers(List modif) {
        Iterator it = modif.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).accept((ASTVisitor)this);
        }
    }

    private void visitFragments(List fragments) {
        Iterator it = fragments.iterator();
        while (it.hasNext()) {
            ((VariableDeclarationFragment)it.next()).accept((ASTVisitor)this);
        }
    }

    private boolean simpleNameIsConstructorDecl(SimpleName node) {
        ASTNode parent = node.getParent();
        return parent instanceof MethodDeclaration && ((MethodDeclaration)parent).isConstructor() && ((MethodDeclaration)parent).getName() == node;
    }

    private void addTypeDependency(ISourceLocation dependency) {
        ISourceLocation parent;
        if (!this.scopeManager.isEmpty() && !(parent = this.getParent()).equals(dependency)) {
            this.insert(this.typeDependency, (IValue)parent, (IValue)dependency);
        }
    }

    public void preVisit(ASTNode node) {
        if (node instanceof Annotation) {
            this.insert(this.annotations, (IValue)this.getParent(), (IValue)this.resolveBinding((ASTNode)((Annotation)node).getTypeName()));
            return;
        }
        this.ownValue = this.resolveBinding(node);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        this.computeTypeSymbol((AbstractTypeDeclaration)node);
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(AnnotationTypeMemberDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        IConstructor type = this.bindingsResolver.resolveType((IBinding)node.getType().resolveBinding(), true);
        this.insert(this.types, this.ownValue, type);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        ASTNode parent = node.getParent();
        if (parent instanceof ClassInstanceCreation) {
            ISourceLocation superclass = this.resolveBinding((ASTNode)((ClassInstanceCreation)parent).getType());
            this.insert(this.typeDependency, this.ownValue, (IValue)superclass);
            IConstructor type = this.bindingsResolver.resolveType((IBinding)((ClassInstanceCreation)parent).getType().resolveBinding(), false);
            this.insert(this.types, this.ownValue, type);
            if (!superclass.getScheme().contains("+interface")) {
                this.insert(this.extendsRelations, this.ownValue, (IValue)superclass);
            } else {
                this.insert(this.implementsRelations, this.ownValue, (IValue)superclass);
            }
        } else if (parent instanceof EnumConstantDeclaration) {
            IVariableBinding var = ((EnumConstantDeclaration)parent).resolveVariable();
            this.insert(this.typeDependency, this.ownValue, (IValue)this.resolveBinding((IBinding)var));
            if (var != null) {
                IConstructor type = this.bindingsResolver.resolveType((IBinding)var.getType(), false);
                this.insert(this.types, this.ownValue, type);
            }
        }
        this.insert(this.declarations, this.ownValue, (IValue)this.getSourceLocation((ASTNode)node));
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(AnonymousClassDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
    }

    public boolean visit(BlockComment node) {
        this.insert(this.documentation, (IValue)this.resolveBinding(node.getAlternateRoot()), (IValue)this.getSourceLocation((ASTNode)node));
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        this.insert(this.methodInvocation, (IValue)this.getParent(), this.ownValue);
        this.insert(this.uses, (IValue)this.getSourceLocation((ASTNode)node), this.ownValue);
        return true;
    }

    public boolean visit(CompilationUnit node) {
        this.insert(this.declarations, this.ownValue, (IValue)this.getSourceLocation((ASTNode)node));
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public boolean visit(ModuleDeclaration node) {
        this.insert(this.declarations, this.ownValue, (IValue)this.getSourceLocation((ASTNode)node));
        this.insert(this.names, values.string(node.getName().getFullyQualifiedName()), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(ModuleDeclaration node) {
        this.scopeManager.pop();
    }

    public boolean visit(RequiresDirective node) {
        ISourceLocation parent = (ISourceLocation)this.scopeManager.peek();
        ISourceLocation name = this.resolveBinding((ASTNode)node.getName());
        this.insert(this.moduleRequiresModule, (IValue)parent, (IValue)name);
        return true;
    }

    public boolean visit(ExportsDirective node) {
        ISourceLocation parent = (ISourceLocation)this.scopeManager.peek();
        IList targets = (IList)node.modules().stream().map(o -> (ASTNode)o).map(n -> this.resolveBinding((ASTNode)n)).collect(values.listWriter());
        ISourceLocation name = this.resolveBinding((ASTNode)node.getName());
        if (targets.isEmpty()) {
            this.insert(this.moduleExportsPackage, (IValue)parent, (IValue)name, (IValue)URIUtil.rootLocation((String)"java+module"));
        } else {
            for (IValue target : targets) {
                this.insert(this.moduleExportsPackage, (IValue)parent, (IValue)name, target);
            }
        }
        return true;
    }

    public boolean visit(ProvidesDirective node) {
        ISourceLocation parent = (ISourceLocation)this.scopeManager.peek();
        IList implementations = (IList)node.implementations().stream().map(o -> (ASTNode)o).map(n -> this.resolveBinding((ASTNode)n)).collect(values.listWriter());
        ISourceLocation name = this.resolveBinding((ASTNode)node.getName());
        for (IValue impl : implementations) {
            this.insert(this.moduleProvidesService, (IValue)parent, (IValue)name, impl);
        }
        return true;
    }

    public boolean visit(UsesDirective node) {
        ISourceLocation parent = (ISourceLocation)this.scopeManager.peek();
        this.insert(this.moduleUsesService, (IValue)parent, (IValue)this.resolveBinding((ASTNode)node.getName()));
        return true;
    }

    public boolean visit(OpensDirective node) {
        ISourceLocation parent = (ISourceLocation)this.scopeManager.peek();
        ISourceLocation name = this.resolveBinding((ASTNode)node.getName());
        IList modules = (IList)node.modules().stream().map(o -> (ASTNode)o).map(n -> this.resolveBinding((ASTNode)n)).collect(values.listWriter());
        if (modules.isEmpty()) {
            this.insert(this.moduleOpensPackage, (IValue)parent, (IValue)name, (IValue)URIUtil.rootLocation((String)"java+module"));
        } else {
            for (IValue module : modules) {
                this.insert(this.moduleOpensPackage, (IValue)parent, (IValue)name, module);
            }
        }
        return true;
    }

    public void endVisit(CompilationUnit node) {
        this.ownValue = (IValue)this.scopeManager.pop();
    }

    public boolean visit(ConstructorInvocation node) {
        this.insert(this.methodInvocation, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(EnumConstantDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
    }

    public boolean visit(EnumDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        IListWriter implementedInterfaces = values.listWriter();
        if (!node.superInterfaceTypes().isEmpty()) {
            for (Type t : node.superInterfaceTypes()) {
                implementedInterfaces.append(new IValue[]{this.resolveBinding((ASTNode)t)});
            }
        }
        this.insert(this.implementsRelations, this.ownValue, (IList)implementedInterfaces.done());
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        this.computeTypeSymbol((AbstractTypeDeclaration)node);
    }

    private void computeTypeSymbol(AbstractTypeDeclaration node) {
        IConstructor type = this.bindingsResolver.resolveType((IBinding)node.resolveBinding(), true);
        this.insert(this.types, this.ownValue, type);
    }

    public boolean visit(FieldAccess node) {
        this.insert(this.fieldAccess, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        this.visitFragments(node.fragments());
        return false;
    }

    public boolean visit(Initializer node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.insert(this.declarations, this.ownValue, (IValue)this.getSourceLocation((ASTNode)node));
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(Initializer node) {
        this.ownValue = (IValue)this.scopeManager.pop();
    }

    public boolean visit(Javadoc node) {
        ASTNode parent = node.getParent();
        if (parent == null) {
            parent = node.getAlternateRoot();
        }
        if (parent instanceof FieldDeclaration) {
            FieldDeclaration decl = (FieldDeclaration)parent;
            for (Object var : decl.fragments()) {
                this.insert(this.documentation, (IValue)this.resolveBinding((ASTNode)((VariableDeclaration)var)), (IValue)this.getSourceLocation((ASTNode)node));
            }
        } else {
            this.insert(this.documentation, (IValue)this.resolveBinding(parent), (IValue)this.getSourceLocation((ASTNode)node));
        }
        return false;
    }

    public boolean visit(LineComment node) {
        this.insert(this.documentation, (IValue)this.resolveBinding(node.getAlternateRoot()), (IValue)this.getSourceLocation((ASTNode)node));
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        ASTNode parent = node.getParent();
        if (parent instanceof TypeDeclaration) {
            this.fillOverrides(node.resolveBinding(), ((TypeDeclaration)parent).resolveBinding());
        } else if (parent instanceof AnonymousClassDeclaration) {
            this.fillOverrides(node.resolveBinding(), ((AnonymousClassDeclaration)parent).resolveBinding());
        }
        IConstructor type = this.bindingsResolver.resolveType((IBinding)node.resolveBinding(), true);
        this.insert(this.types, this.ownValue, type);
    }

    private void fillOverrides(IMethodBinding node, ITypeBinding parent) {
        if (node == null || parent == null) {
            this.insert(this.messages, (IValue)values.constructor(this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2, new IValue[]{values.string("parent or method binding is null, not proceeding with fillOverrides"), this.getSourceLocation(this.compilUnit.findDeclaringNode((IBinding)node))}));
            return;
        }
        ArrayList<ITypeBinding> parentClass = new ArrayList<ITypeBinding>();
        parentClass.addAll(Arrays.asList(parent.getInterfaces()));
        parentClass.add(parent.getSuperclass());
        for (ITypeBinding parentBinding : parentClass) {
            if (parentBinding == null) {
                return;
            }
            for (IMethodBinding parentMethod : parentBinding.getDeclaredMethods()) {
                if (!node.overrides(parentMethod) || !node.isSubsignature(parentMethod)) continue;
                this.insert(this.methodOverrides, (IValue)this.resolveBinding((IBinding)node), (IValue)this.resolveBinding((IBinding)parentMethod));
            }
            this.fillOverrides(node, parentBinding);
        }
    }

    public boolean visit(MethodInvocation node) {
        this.insert(this.methodInvocation, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(Modifier node) {
        String modifier = node.getKeyword().toString();
        this.insert(this.modifiers, (IValue)this.getParent(), this.constructModifierNode(modifier, new IValue[0]));
        return true;
    }

    private void generatePackageDecls(ISourceLocation parent, ISourceLocation pkg, ISourceLocation folder) {
        this.insert(this.declarations, (IValue)pkg, (IValue)folder);
        if (parent != null) {
            this.insert(this.containment, (IValue)parent, (IValue)pkg);
            pkg = parent;
            this.generatePackageDecls(this.getParent(pkg), pkg, this.getParent(folder));
        }
    }

    private ISourceLocation getParent(ISourceLocation sourceLoc) {
        ISourceLocation result = URIUtil.getParentLocation((ISourceLocation)sourceLoc);
        if (result.getPath().equals("/")) {
            return null;
        }
        return result;
    }

    public boolean visit(PackageDeclaration node) {
        IPackageBinding binding = node.resolveBinding();
        if (binding != null) {
            this.generatePackageDecls(this.getParent((ISourceLocation)this.ownValue), (ISourceLocation)this.ownValue, this.getParent(this.loc));
            this.insert(this.containment, this.ownValue, (IValue)this.getParent());
        } else {
            this.insert(this.messages, (IValue)values.constructor(this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2, new IValue[]{values.string("Unresolved binding for: " + String.valueOf(node)), values.sourceLocation(this.loc, 0, 0)}));
        }
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(PackageDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
    }

    public boolean visit(QualifiedName node) {
        if (!((ISourceLocation)this.ownValue).getScheme().equals("java+package")) {
            this.insert(this.uses, (IValue)this.getSourceLocation((ASTNode)node), this.ownValue);
        }
        if (((ISourceLocation)this.ownValue).getScheme().equals("java+field")) {
            this.insert(this.fieldAccess, (IValue)this.getParent(), this.ownValue);
        }
        if (((ISourceLocation)this.ownValue).getScheme().equals("java+arrayLength")) {
            this.insert(this.fieldAccess, (IValue)this.getParent(), this.ownValue);
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        this.insert(this.names, values.string(node.getIdentifier()), this.ownValue);
        this.insert(this.names, values.string(node.getFullyQualifiedName()), this.ownValue);
        if (!this.simpleNameIsConstructorDecl(node)) {
            this.addTypeDependency(this.resolveBinding((IBinding)node.resolveTypeBinding()));
            if (!node.isDeclaration()) {
                this.addTypeDependency(this.resolveDeclaringClass(node.resolveBinding()));
            }
        }
        return true;
    }

    public void endVisit(SimpleName node) {
        if (node.isDeclaration() || this.simpleNameIsConstructorDecl(node)) {
            this.insert(this.declarations, this.ownValue, (IValue)this.getSourceLocation(this.compilUnit.findDeclaringNode(node.resolveBinding())));
        } else {
            this.insert(this.uses, (IValue)this.getSourceLocation((ASTNode)node), this.ownValue);
            if (((ISourceLocation)this.ownValue).getScheme().equals("java+field")) {
                this.insert(this.fieldAccess, (IValue)this.getParent(), this.ownValue);
            }
        }
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        return true;
    }

    public void endVisit(SingleVariableDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        IConstructor type = this.bindingsResolver.resolveType((IBinding)node.getType().resolveBinding(), false);
        this.insert(this.types, this.ownValue, type);
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.insert(this.methodInvocation, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        this.insert(this.fieldAccess, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.insert(this.methodInvocation, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        IListWriter extendsClass = values.listWriter();
        IListWriter implementsInterfaces = values.listWriter();
        if (node.getAST().apiLevel() == 2) {
            if (node.getSuperclass() != null) {
                extendsClass.append(new IValue[]{this.resolveBinding((ASTNode)node.getSuperclass())});
            }
            if (!node.superInterfaces().isEmpty()) {
                for (Name n : node.superInterfaces()) {
                    implementsInterfaces.append(new IValue[]{this.resolveBinding((ASTNode)n)});
                }
            }
        } else if (node.getAST().apiLevel() >= 3) {
            if (node.getSuperclassType() != null) {
                extendsClass.append(new IValue[]{this.resolveBinding((ASTNode)node.getSuperclassType())});
            }
            if (!node.superInterfaceTypes().isEmpty()) {
                for (Type t : node.superInterfaceTypes()) {
                    implementsInterfaces.append(new IValue[]{this.resolveBinding((ASTNode)t)});
                }
            }
        }
        if (node.isInterface()) {
            this.insert(this.extendsRelations, this.ownValue, (IList)implementsInterfaces.done());
        } else {
            this.insert(this.extendsRelations, this.ownValue, (IList)extendsClass.done());
            this.insert(this.implementsRelations, this.ownValue, (IList)implementsInterfaces.done());
        }
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.ownValue = (IValue)this.scopeManager.pop();
        this.computeTypeSymbol((AbstractTypeDeclaration)node);
    }

    public boolean visit(TypeParameter node) {
        IListWriter extendsList = values.listWriter();
        if (!node.typeBounds().isEmpty()) {
            for (Type t : node.typeBounds()) {
                extendsList.append(new IValue[]{this.resolveBinding((ASTNode)t)});
            }
        }
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.visitFragments(node.fragments());
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.insert(this.containment, (IValue)this.getParent(), this.ownValue);
        this.scopeManager.push((ISourceLocation)this.ownValue);
        IVariableBinding binding = node.resolveBinding();
        if (binding != null) {
            IConstructor type = this.bindingsResolver.resolveType((IBinding)binding.getType(), false);
            this.insert(this.types, this.ownValue, type);
        } else {
            this.insert(this.messages, (IValue)values.constructor(this.DATATYPE_RASCAL_MESSAGE_ERROR_NODE_TYPE2, new IValue[]{values.string("No binding for: " + String.valueOf(node)), values.sourceLocation(this.loc, 0, 0)}));
        }
        ASTNode parentASTNode = node.getParent();
        if (parentASTNode instanceof FieldDeclaration) {
            FieldDeclaration parent = (FieldDeclaration)parentASTNode;
            parent.getType().accept((ASTVisitor)this);
            this.visitListOfModifiers(parent.modifiers());
            if (parent.getJavadoc() != null) {
                parent.getJavadoc().accept((ASTVisitor)this);
            }
        } else if (parentASTNode instanceof VariableDeclarationExpression) {
            VariableDeclarationExpression parent = (VariableDeclarationExpression)parentASTNode;
            parent.getType().accept((ASTVisitor)this);
            this.visitListOfModifiers(parent.modifiers());
        } else if (!(parentASTNode instanceof LambdaExpression)) {
            VariableDeclarationStatement parent = (VariableDeclarationStatement)parentASTNode;
            parent.getType().accept((ASTVisitor)this);
            this.visitListOfModifiers(parent.modifiers());
        }
        this.scopeManager.pop();
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.visitFragments(node.fragments());
        return false;
    }
}

