---
title: "module lang::java::flow::JavaToObjectFlow"
id: JavaToObjectFlow
slug: /Packages/org.rascalmpl.java-air/API/lang/java/flow/JavaToObjectFlow
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.java-air-1.0.1</div>

mapping all of Java to the object flow language
#### Usage

```rascal
import lang::java::flow::JavaToObjectFlow;
```

#### Dependencies
```rascal
import IO;
import List;
import String;
import analysis::flow::ObjectFlow;
import lang::java::m3::TypeSymbol;
import lang::java::m3::AST;
```

#### Description


More information can be found in [ObjectFlow](../../../../../..//Library/analysis/flow/ObjectFlow.md).


## function createOFG {#lang-java-flow-JavaToObjectFlow-createOFG}

```rascal
FlowProgram createOFG(set[Declaration] asts)
```

## function correctInsertArg {#lang-java-flow-JavaToObjectFlow-correctInsertArg}

```rascal
Expression correctInsertArg(Expression _/*receiver*/, str name, list[Expression] args)
```

## function isContainerInsert {#lang-java-flow-JavaToObjectFlow-isContainerInsert}

```rascal
bool isContainerInsert(Expression recv, str name)
```

## function isContainerExtract {#lang-java-flow-JavaToObjectFlow-isContainerExtract}

```rascal
bool isContainerExtract(Expression recv, str name)
```

## function fixCollections {#lang-java-flow-JavaToObjectFlow-fixCollections}

```rascal
list[Declaration] fixCollections(list[Declaration] ast)
```

## function ignoreType {#lang-java-flow-JavaToObjectFlow-ignoreType}

```rascal
bool ignoreType(arrayType(Type t))

bool ignoreType(super(_, Type t))

bool ignoreType(extends(_, Type t))

bool ignoreType(parameterizedType(_, _))

bool ignoreType(qualifiedType(_, Type t, _))

bool ignoreType(qualifiedType(_, Expression e,_))

bool ignoreType(simpleType(t))

bool ignoreType(unionType(tt))

default bool ignoreType(Type t)

bool ignoreType(id(str n))

bool ignoreType(Expression::qualifiedName([*_, Expression last]))

bool ignoreType(TypeSymbol::interface(_,_))

bool ignoreType(TypeSymbol::\enum(_))

bool ignoreType(TypeSymbol::\typeParameter(_,_))

bool ignoreType(TypeSymbol::\wildcard(_))

bool ignoreType(TypeSymbol::\capture(_,_))

bool ignoreType(TypeSymbol::intersection(tt))

bool ignoreType(TypeSymbol::union(tt))

bool ignoreType(TypeSymbol::\class(t,_))

bool ignoreType(TypeSymbol::\object())

bool ignoreType(TypeSymbol::\array(_,_))

default bool ignoreType(TypeSymbol t)
```

## function getDeclarations {#lang-java-flow-JavaToObjectFlow-getDeclarations}

```rascal
set[FlowDecl] getDeclarations(set[Declaration] asts)
```

## function lhsDecl {#lang-java-flow-JavaToObjectFlow-lhsDecl}

```rascal
loc lhsDecl(arrayAccess(e,_))

loc lhsDecl(f:fieldAccess(_,_))

loc lhsDecl(f:fieldAccess(_))

loc lhsDecl(v:variable(_,_))

loc lhsDecl(s:id(_))

loc lhsDecl(q:qualifiedName(_))
```

## function getStatements {#lang-java-flow-JavaToObjectFlow-getStatements}

```rascal
set[FlowStm] getStatements(set[Declaration] asts)
```

## function translate {#lang-java-flow-JavaToObjectFlow-translate}

```rascal
set[FlowStm] translate(loc base, loc target, c:cast(_, e))

set[FlowStm] translate(loc base, loc target, conditional(con, t, e))

set[FlowStm] translate(loc base, loc target, f:fieldAccess(_,_))

set[FlowStm] translate(loc base, loc target, f:fieldAccess(_))

set[FlowStm] translate(loc base, loc target, s:id(_))

set[FlowStm] translate(loc base, loc target, a:assignment(l,_,r))

set[FlowStm] translate(loc base, loc target, m:methodCall(targs, n, args))

set[FlowStm] translate(loc base, loc target, m:superMethodCall(targs, n, args))

set[FlowStm] translate(loc base, loc target, m:superMethodCall(qual, targs, n, args))

set[FlowStm] translate(loc base, loc target, m:constructorCall(targs, args))

set[FlowStm] translate(loc base, loc target, m:superConstructorCall(qual, targs, args))

set[FlowStm] translate(loc base, loc target, m:superConstructorCall(targs, args))

set[FlowStm] translate(loc base, loc target, m:methodCall(r, _, n, a))
```

## function newObject {#lang-java-flow-JavaToObjectFlow-newObject}

```rascal
Expression newObject(Type t, list[Declaration] targs, list[Expression] args, Expression original)
```

## function translate {#lang-java-flow-JavaToObjectFlow-translate}

```rascal
set[FlowStm] translate(loc base, loc target, Expression ob:newObject(Expression _, Type t, list[Declaration] targs, list[Expression] a))

set[FlowStm] translate(loc base, loc target, Expression ob:newObject(_, Type t,  list[Declaration] targs, list[Expression] a, Declaration _))

set[FlowStm] translate(loc base, loc target, Expression ob:newObject(Type t,  list[Declaration] targs, list[Expression] a, Declaration _))

set[FlowStm] translate(loc base, loc target, Expression ob:newObject(_, Type t, _, a))
```

## function simpleExpression {#lang-java-flow-JavaToObjectFlow-simpleExpression}

```rascal
bool simpleExpression(fieldAccess(_,_))

bool simpleExpression(fieldAccess(_))

bool simpleExpression(qualifiedName([*_, e]))

bool simpleExpression(this())

bool simpleExpression(this(_))

bool simpleExpression(id(_))

default bool simpleExpression(Expression e)
```

## function removeNesting {#lang-java-flow-JavaToObjectFlow-removeNesting}

```rascal
Expression removeNesting(cast(_, e))

Expression removeNesting(arrayAccess(e, _))

Expression removeNesting(\bracket(e))

default Expression removeNesting(Expression e)
```

## function unnestExpressions {#lang-java-flow-JavaToObjectFlow-unnestExpressions}

```rascal
tuple[list[loc], set[FlowStm]] unnestExpressions(loc prefix, int uniqNum, list[Expression] exprs)
```

## function translate {#lang-java-flow-JavaToObjectFlow-translate}

```rascal
default set[FlowStm] translate(loc base, loc target, Expression e)
```

