/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.InvalidDateTimeException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.io.binary.stream.IValueInputStream;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.FailReturnFromVoidException;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.GuardedIValue;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.InternalCompilerError;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.RascalExecutionContext;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.RascalRuntimeValueFactory;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.SliceDescriptor;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.SliceOperator;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.Traverse;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.JavaMethodLink;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.utils.IResourceLocationProvider;
import org.rascalmpl.library.util.ToplevelType;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.SourceLocationURICompare;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class $RascalModule {
    protected final IRascalValueFactory $RVF;
    final PrintStream $OUT;
    final PrintWriter $OUTWRITER;
    final PrintStream $ERR;
    final PrintWriter $ERRWRITER;
    final InputStream $IN;
    final IRascalMonitor $MONITOR;
    protected final RascalExecutionContext rex;
    protected final IValueFactory $VF;
    public final TypeFactory $TF;
    protected final RascalTypeFactory $RTF;
    public final TypeStore $TS;
    protected final Traverse $TRAVERSE;
    public final IBool Rascal_TRUE;
    public final IBool Rascal_FALSE;
    protected final FailReturnFromVoidException $failReturnFromVoidException;
    private final GuardedIValue UNDEFINED = new GuardedIValue();

    public $RascalModule(RascalExecutionContext rex) {
        this.rex = rex;
        this.$IN = rex.getInStream();
        this.$OUT = rex.getOutStream();
        this.$OUTWRITER = rex.getOutWriter();
        this.$ERR = rex.getErrStream();
        this.$ERRWRITER = rex.getErrWriter();
        this.$MONITOR = rex;
        this.$VF = rex.getIValueFactory();
        this.$RVF = rex.getRascalRuntimeValueFactory();
        this.$TF = rex.getTypeFactory();
        this.$TS = rex.getTypeStore();
        this.$RTF = rex.getRascalTypeFactory();
        rex.setModule(this);
        this.$TRAVERSE = rex.getTraverse();
        this.Rascal_TRUE = this.$VF.bool(true);
        this.Rascal_FALSE = this.$VF.bool(false);
        this.$failReturnFromVoidException = new FailReturnFromVoidException();
    }

    public final IConstructor $reifiedAType(IConstructor t, IMap definitions) {
        return this.$RVF.reifiedType(t, definitions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T $initLibrary(String className) {
        PrintWriter[] outputs = new PrintWriter[]{this.$OUTWRITER, this.$ERRWRITER};
        int writers = 0;
        OutputStream[] rawOutputs = new OutputStream[]{this.$OUT, this.$ERR};
        int rawWriters = 0;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            if (clazz.getConstructors().length > 1) {
                throw new IllegalArgumentException("Rascal JavaBridge can only deal with one constructor. This class has multiple: " + clazz);
            }
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length < 1) {
                throw new JavaMethodLink(className, "no public constructors found", (Throwable)new IllegalArgumentException(className));
            }
            if (constructors.length != 1) {
                throw new JavaMethodLink(className, "more than one public constructor found", (Throwable)new IllegalArgumentException(className));
            }
            Constructor<?> constructor = constructors[0];
            Object[] args = new Object[constructor.getParameterCount()];
            Class<?>[] formals = constructor.getParameterTypes();
            int i = 0;
            while (i < constructor.getParameterCount()) {
                if (formals[i].isAssignableFrom(IValueFactory.class)) {
                    args[i] = this.$VF;
                } else if (formals[i].isAssignableFrom(TypeStore.class)) {
                    args[i] = this.$TS;
                } else if (formals[i].isAssignableFrom(TypeFactory.class)) {
                    args[i] = TypeFactory.getInstance();
                } else if (formals[i].isAssignableFrom(PrintWriter.class)) {
                    args[i] = outputs[writers++ % 2];
                } else if (formals[i].isAssignableFrom(OutputStream.class)) {
                    args[i] = rawOutputs[rawWriters++ % 2];
                } else if (formals[i].isAssignableFrom(InputStream.class)) {
                    args[i] = this.$IN;
                } else if (formals[i].isAssignableFrom(IRascalMonitor.class)) {
                    args[i] = this.$MONITOR;
                } else if (formals[i].isAssignableFrom(ClassLoader.class)) {
                    args[i] = this.getClass().getClassLoader();
                } else if (formals[i].isAssignableFrom(IRascalValueFactory.class)) {
                    args[i] = new RascalRuntimeValueFactory(this.rex);
                } else if (formals[i].isAssignableFrom($RascalModule.class)) {
                    args[i] = this;
                } else if (formals[i].isAssignableFrom(IDEServices.class)) {
                    if (!(this.$MONITOR instanceof IDEServices)) throw new IllegalArgumentException("No IDE services are available in this environment");
                    args[i] = (IDEServices)this.$MONITOR;
                } else {
                    if (!formals[i].isAssignableFrom(IResourceLocationProvider.class)) throw new IllegalArgumentException(constructor + " has unknown arguments. Only IValueFactory, TypeStore, ClassLoader, PrintWriter, OutputStream, InputStream, &T extends $RascalModule, IRascalValueFactory, TypeFactory and IResourceLocationProvider are supported");
                    args[i] = new IResourceLocationProvider(){

                        public Set<ISourceLocation> findResources(String fileName) {
                            HashSet<ISourceLocation> result = new HashSet<ISourceLocation>();
                            try {
                                for (URL found : Collections.list(this.getClass().getClassLoader().getResources(fileName))) {
                                    try {
                                        result.add($RascalModule.this.$VF.sourceLocation(found.toURI()));
                                    }
                                    catch (URISyntaxException e) {
                                        $RascalModule.this.$MONITOR.warning("WARNING: skipping " + found + " due to URI syntax exception", URIUtil.rootLocation((String)"module-init"));
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return result;
                        }
                    };
                }
                ++i;
            }
            return (T)constructor.newInstance(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | SecurityException | InvocationTargetException e) {
            throw new JavaMethodLink(className, e.getMessage(), e);
        }
    }

    private static void $usage(String module, String error, Type kwargs) {
        PrintWriter $ERR = new PrintWriter(System.err);
        if (!error.isEmpty() && !error.equals("help")) {
            $ERR.println(error);
        }
        $ERR.println("Usage: ");
        $ERR.println("java -cp ... " + module + " <options>");
        if (kwargs.getArity() > 0) {
            $ERR.println(" [options]\n\nOptions:\n");
            String[] stringArray = kwargs.getFieldNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                $ERR.print("\t-");
                $ERR.print(param);
                if (kwargs.getFieldType(param).isSubtypeOf(TypeFactory.getInstance().boolType())) {
                    $ERR.println("\t[arg]: one of nothing (true), '1', '0', 'true' or 'false';");
                } else {
                    $ERR.println("\t[arg]: " + kwargs.getFieldType(param) + " argument;");
                }
                ++n2;
            }
        } else {
            $ERR.println('\n');
        }
        $ERR.flush();
        if (!error.equals("help")) {
            throw new IllegalArgumentException();
        }
    }

    protected static Map<String, IValue> $parseCommandlineParameters(String module, String[] commandline, Type kwTypes) {
        IValueFactory $VF = ValueFactoryFactory.getValueFactory();
        TypeFactory $TF = TypeFactory.getInstance();
        HashMap<String, Type> expectedTypes = new HashMap<String, Type>();
        String[] stringArray = kwTypes.getFieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kwp = stringArray[n2];
            expectedTypes.put(kwp, kwTypes.getFieldType(kwp));
            ++n2;
        }
        HashMap<String, IValue> params = new HashMap<String, IValue>();
        int i = 0;
        while (i < commandline.length) {
            if (commandline[i].equals("-help")) {
                $RascalModule.$usage(module, "help", kwTypes);
            } else if (commandline[i].startsWith("-")) {
                IListWriter writer;
                String label = commandline[i].replaceFirst("^-+", "");
                Type expected = (Type)expectedTypes.get(label);
                if (expected == null) {
                    $RascalModule.$usage(module, "unknown argument: " + label, kwTypes);
                }
                if (expected.isSubtypeOf(TypeFactory.getInstance().boolType())) {
                    if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                        params.put(label, (IValue)$VF.bool(true));
                    } else if (i < commandline.length - 1) {
                        String arg;
                        if ((arg = commandline[++i].trim()).equals("1") || arg.equals("true")) {
                            params.put(label, (IValue)$VF.bool(true));
                        } else {
                            params.put(label, (IValue)$VF.bool(false));
                        }
                    }
                } else if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                    $RascalModule.$usage(module, "expected option for " + label, kwTypes);
                } else if (expected.isSubtypeOf($TF.listType($TF.valueType()))) {
                    writer = $VF.listWriter();
                    while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                        writer.append(new IValue[]{$RascalModule.$parseCommandlineOption(module, kwTypes, expected.getElementType(), commandline[++i])});
                    }
                    params.put(label, (IValue)writer.done());
                } else if (expected.isSubtypeOf($TF.setType($TF.valueType()))) {
                    writer = $VF.setWriter();
                    while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                        writer.insert(new IValue[]{$RascalModule.$parseCommandlineOption(module, kwTypes, expected.getElementType(), commandline[++i])});
                    }
                    params.put(label, (IValue)writer.done());
                } else {
                    params.put(label, $RascalModule.$parseCommandlineOption(module, kwTypes, expected, commandline[++i]));
                }
            }
            ++i;
        }
        return params;
    }

    private static IValue $parseCommandlineOption(String module, Type kwTypes, Type expected, String option) {
        TypeFactory $TF = TypeFactory.getInstance();
        IValueFactory $VF = ValueFactoryFactory.getValueFactory();
        if (expected.isSubtypeOf($TF.stringType())) {
            return $VF.string(option);
        }
        StringReader reader = new StringReader(option);
        try {
            return new StandardTextReader().read($VF, expected, (Reader)reader);
        }
        catch (FactTypeUseException e) {
            $RascalModule.$usage(module, "expected " + expected + " but got " + option + " (" + e.getMessage() + ")", kwTypes);
        }
        catch (IOException e) {
            $RascalModule.$usage(module, "unexpected problem while parsing commandline:" + e.getMessage(), kwTypes);
        }
        throw new IllegalArgumentException();
    }

    public final IMap $buildMap(IValue ... values) {
        IMapWriter w = this.$VF.mapWriter();
        if (values.length % 2 != 0) {
            throw new InternalCompilerError("$RascalModule: buildMap should have even number of arguments");
        }
        int i = 0;
        while (i < values.length) {
            w.put(values[i], values[i + 1]);
            i += 2;
        }
        return (IMap)w.done();
    }

    public final boolean $intersectsType(Type t1, Type t2) {
        return t1.intersects(t2);
    }

    public final boolean $isComparable(Type t1, Type t2) {
        return this.$isSubtypeOf(t1, t2) || this.$isSubtypeOf(t2, t1);
    }

    public final boolean $isSubtypeOf(Type left, Type right) {
        return left.isSubtypeOf(right);
    }

    public boolean $isTreeProductionEqual(IValue tree, IConstructor production) {
        return tree instanceof ITree && ((ITree)tree).isAppl() && production.equals((Object)((ITree)tree).getProduction());
    }

    public boolean $isNonTerminal(Type treeType, IConstructor expected) {
        return treeType instanceof NonTerminalType && ((NonTerminalType)treeType).getSymbol().equals((Object)expected);
    }

    public boolean $isNonTerminal(Type treeType, Type expected) {
        if (treeType == expected) {
            return true;
        }
        if (treeType instanceof NonTerminalType) {
            NonTerminalType givenNT = (NonTerminalType)treeType;
            NonTerminalType expectedNT = (NonTerminalType)expected;
            return givenNT.getSymbol().equals((Object)expectedNT.getSymbol());
        }
        return false;
    }

    public Type $adt(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        return adtType;
    }

    public Type $sort(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Sort, new IValue[]{this.$VF.string(adtName)}));
    }

    public Type $lex(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Lex, new IValue[]{this.$VF.string(adtName)}));
    }

    public Type $layouts(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Layouts, new IValue[]{this.$VF.string(adtName)}));
    }

    public Type $keywords(String adtName) {
        Type adtType = this.$TF.abstractDataType(this.$TS, adtName, new Type[0]);
        this.$TS.declareAbstractDataType(adtType);
        return new NonTerminalType(this.$RVF.constructor(RascalValueFactory.Symbol_Keywords, new IValue[]{this.$VF.string(adtName)}));
    }

    public IList readBinaryConstantsFile(Class<?> c, String path, int expected_length, String expected_md5Hash) {
        Type constantsFileType = this.$TF.tupleType(new Type[]{this.$TF.integerType(), this.$TF.stringType(), this.$TF.listType(this.$TF.valueType())});
        ISourceLocation loc = null;
        try {
            URL url = c.getClassLoader().getResource(path);
            if (url == null) {
                throw RuntimeExceptionFactory.io((IString)this.$VF.string("Cannot find resource " + path));
            }
            loc = this.$VF.sourceLocation(url.toURI());
        }
        catch (URISyntaxException e) {
            System.err.println("readBinaryConstantsFile: " + path + " throws " + e.getMessage());
        }
        try {
            Throwable e = null;
            Object var8_12 = null;
            try (IValueInputStream in = this.constructValueReader(loc);){
                IValue constantsFile = in.read();
                if (constantsFile.getType().isSubtypeOf(constantsFileType)) {
                    ITuple tup = (ITuple)constantsFile;
                    int found_length = ((IInteger)tup.get(0)).intValue();
                    if (found_length != expected_length) {
                        throw RuntimeExceptionFactory.io((IString)this.$VF.string("Expected " + expected_length + " constants, but only " + found_length + " found in " + path));
                    }
                    String found_hash = ((IString)tup.get(1)).getValue();
                    if (!found_hash.equals(expected_md5Hash)) {
                        throw RuntimeExceptionFactory.io((IString)this.$VF.string("Expected md5Hash " + expected_md5Hash + ", but got " + found_hash + " for " + path));
                    }
                    return (IList)tup.get(2);
                }
                throw RuntimeExceptionFactory.io((IString)this.$VF.string("Requested type " + constantsFileType + ", but found " + constantsFile.getType()));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            System.err.println("readBinaryConstantsFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io((IString)this.$VF.string(e.getMessage()));
        }
        catch (Exception e) {
            System.err.println("readBinaryConstantsFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io((IString)this.$VF.string(e.getMessage()));
        }
    }

    private IValueInputStream constructValueReader(ISourceLocation loc) throws IOException {
        FileChannel channel;
        URIResolverRegistry registry = URIResolverRegistry.getInstance();
        if (registry.supportsReadableFileChannel(loc) && (channel = registry.getReadableFileChannel(loc)) != null) {
            return new IValueInputStream(channel, this.$VF, RascalValueFactory.TYPE_STORE_SUPPLIER);
        }
        return new IValueInputStream(registry.getInputStream(loc), this.$VF, RascalValueFactory.TYPE_STORE_SUPPLIER);
    }

    public final IInteger $aint_add_aint(IInteger lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final IReal $aint_add_areal(IInteger lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $aint_add_arat(IInteger lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $aint_add_anum(IInteger lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_aint(IReal lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final IReal $areal_add_areal(IReal lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_arat(IReal lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $areal_add_anum(IReal lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_aint(IRational lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_areal(IRational lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final IRational $arat_add_arat(IRational lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $arat_add_anum(IRational lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_aint(INumber lhs, IInteger rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_areal(INumber lhs, IReal rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_arat(INumber lhs, IRational rhs) {
        return lhs.add(rhs);
    }

    public final INumber $anum_add_anum(INumber lhs, INumber rhs) {
        return lhs.add(rhs);
    }

    public final IString $astr_add_astr(IString lhs, IString rhs) {
        return lhs.concat(rhs);
    }

    public final ISourceLocation $aloc_add_astr(ISourceLocation sloc, IString s) {
        String path;
        String string = path = sloc.hasPath() ? sloc.getPath() : "";
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = path.concat(s.getValue());
        return this.$aloc_field_update("path", (IValue)this.$VF.string(path), sloc);
    }

    public final ITuple $atuple_add_atuple(ITuple t1, ITuple t2) {
        int len1 = t1.arity();
        int len2 = t2.arity();
        IValue[] elems = new IValue[len1 + len2];
        int i = 0;
        while (i < len1) {
            elems[i] = t1.get(i);
            ++i;
        }
        i = 0;
        while (i < len2) {
            elems[len1 + i] = t2.get(i);
            ++i;
        }
        return this.$VF.tuple(elems);
    }

    public final IList $alist_add_alist(IList lhs, IList rhs) {
        return lhs.concat(rhs);
    }

    public final IList $alist_add_elm(IList lhs, IValue rhs) {
        return lhs.append(rhs);
    }

    public final IList $elm_add_alist(IValue lhs, IList rhs) {
        return rhs.insert(lhs);
    }

    public final ISet $aset_add_aset(ISet lhs, ISet rhs) {
        return lhs.union(rhs);
    }

    public final ISet $aset_add_elm(ISet lhs, IValue rhs) {
        return lhs.insert(rhs);
    }

    public final ISet $elm_add_aset(IValue lhs, ISet rhs) {
        return rhs.insert(lhs);
    }

    public final IMap $amap_add_amap(IMap lhs, IMap rhs) {
        return lhs.join(rhs);
    }

    public final IValue $annotation_get(IConstructor cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return cons.asWithKeywordParameters().getParameter(fieldName);
        }
        throw RuntimeExceptionFactory.noSuchAnnotation((String)fieldName);
    }

    public final IValue $annotation_get(INode cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return cons.asWithKeywordParameters().getParameter(fieldName);
        }
        throw RuntimeExceptionFactory.noSuchAnnotation((String)fieldName);
    }

    public final GuardedIValue $guarded_annotation_get(IConstructor cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return new GuardedIValue(cons.asWithKeywordParameters().getParameter(fieldName));
        }
        if (TreeAdapter.isTree((IConstructor)cons) && TreeAdapter.isAppl((ITree)((ITree)cons))) {
            IConstructor prod = ((ITree)cons).getProduction();
            for (IValue elem : ProductionAdapter.getSymbols((IConstructor)prod)) {
                IConstructor arg = (IConstructor)elem;
                if (!SymbolAdapter.isLabel((IConstructor)arg) || !SymbolAdapter.getLabel((IConstructor)arg).equals(fieldName)) continue;
                return new GuardedIValue((IValue)arg);
            }
        }
        return this.UNDEFINED;
    }

    public final GuardedIValue $guarded_annotation_get(INode cons, String fieldName) {
        if (cons.asWithKeywordParameters().hasParameter(fieldName)) {
            return new GuardedIValue(cons.asWithKeywordParameters().getParameter(fieldName));
        }
        return this.UNDEFINED;
    }

    public final IBool $assert_fails(IString message) {
        throw RuntimeExceptionFactory.assertionFailed((IString)message);
    }

    public final ISourceLocation $create_aloc(IString uri) {
        try {
            return URIUtil.createFromURI((String)uri.getValue());
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionFactory.malformedURI((String)uri.getValue());
        }
        catch (UnsupportedOperationException e) {
            throw RuntimeExceptionFactory.malformedURI((String)(String.valueOf(uri.getValue()) + ":" + e.getMessage()));
        }
    }

    public final ISourceLocation $create_aloc_with_offset(ISourceLocation loc, IInteger offset, IInteger length) {
        return this.$VF.sourceLocation(loc, offset.intValue(), length.intValue());
    }

    public final ISourceLocation $create_aloc_with_offset_and_begin_end(ISourceLocation loc, IInteger offset, IInteger length, ITuple begin, ITuple end) {
        int beginLine = ((IInteger)begin.get(0)).intValue();
        int beginCol = ((IInteger)begin.get(1)).intValue();
        int endLine = ((IInteger)end.get(0)).intValue();
        int endCol = ((IInteger)end.get(1)).intValue();
        return this.$VF.sourceLocation(loc, offset.intValue(), length.intValue(), beginLine, endLine, beginCol, endCol);
    }

    public final IInteger $aint_divide_aint(IInteger a, IInteger b) {
        try {
            return a.divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $aint_divide_areal(IInteger a, IReal b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IRational $aint_divide_arat(IInteger a, IRational b) {
        try {
            return a.toRational().divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $aint_divide_anum(IInteger a, INumber b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IReal $areal_divide_aint(IReal a, IInteger b) {
        try {
            return (IReal)a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IReal $areal_divide_areal(IReal a, IReal b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IReal $areal_divide_arat(IReal a, IRational b) {
        try {
            return (IReal)a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $areal_divide_anum(IReal a, INumber b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IRational $arat_divide_aint(IRational a, IInteger b) {
        try {
            return a.divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IReal $arat_divide_areal(IRational a, IReal b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IRational $arat_divide_arat(IRational a, IRational b) {
        try {
            return a.toRational().divide(b);
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $arat_divide_anum(IRational a, INumber b) {
        try {
            return a.multiply(this.$VF.real(1.0)).divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $anum_divide_aint(INumber a, IInteger b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $anum_divide_areal(INumber a, IReal b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $anum_divide_arat(INumber a, IRational b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final INumber $anum_divide_anum(INumber a, INumber b) {
        try {
            return a.divide(b, this.$VF.getPrecision());
        }
        catch (ArithmeticException e) {
            throw RuntimeExceptionFactory.arithmeticException((String)"divide by zero");
        }
    }

    public final IBool $equal(IValue left, IValue right) {
        Type leftType = left.getType();
        Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).equal((INumber)right);
        }
        if (leftType.isNode() && rightType.isNode()) {
            return ((INode)left).equals((Object)((INode)right)) ? this.Rascal_TRUE : this.Rascal_FALSE;
        }
        if (left instanceof ITree && right instanceof ITree) {
            return this.$VF.bool(left.equals((Object)right));
        }
        return this.$VF.bool(left.equals((Object)right));
    }

    public final IString $anode_get_name(INode nd) {
        return this.$VF.string(nd.getName());
    }

    public final IValue $anode_get_field(INode nd, String fieldName) {
        IValue res = nd.asWithKeywordParameters().getParameter(fieldName);
        if (res != null) {
            return res;
        }
        if (nd instanceof IConstructor) {
            IConstructor c = (IConstructor)nd;
            if (c.has(fieldName)) {
                return c.get(fieldName);
            }
            IValue res1 = c.asWithKeywordParameters().getParameter(fieldName);
            if (res1 != null) {
                return res1;
            }
        }
        throw RuntimeExceptionFactory.noSuchField((String)fieldName);
    }

    public final GuardedIValue $guarded_anode_get_field(INode nd, String fieldName) {
        try {
            IValue result = this.$anode_get_field(nd, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $aadt_get_field(IConstructor cons, String fieldName) {
        ITree res;
        TreeAdapter.FieldResult fldres;
        Type consType = cons.getConstructorType();
        if (TreeAdapter.isTree((IConstructor)cons) && TreeAdapter.isAppl((ITree)((ITree)cons)) && (fldres = TreeAdapter.getLabeledField((ITree)((ITree)cons), (String)fieldName)) != null && (res = TreeAdapter.getLabeledField((ITree)((ITree)cons), (String)fieldName).tree) != null) {
            return res;
        }
        if (consType.hasField(fieldName)) {
            IValue res2 = cons.get(fieldName);
            return res2;
        }
        IValue result = cons.asWithKeywordParameters().getParameter(fieldName);
        if (result != null) {
            return result;
        }
        throw RuntimeExceptionFactory.noSuchField((String)fieldName);
    }

    public final GuardedIValue $guarded_aadt_get_field(IConstructor cons, String fieldName) {
        try {
            IValue result = this.$aadt_get_field(cons, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IValue $aloc_get_field(ISourceLocation sloc, String field) {
        switch (field) {
            case "scheme": {
                String s = sloc.getScheme();
                return this.$VF.string(s == null ? "" : s);
            }
            case "authority": {
                return this.$VF.string(sloc.hasAuthority() ? sloc.getAuthority() : "");
            }
            case "host": {
                if (URIResolverRegistry.getInstance().supportsHost(sloc)) String s;
                return this.$VF.string((s = sloc.getURI().getHost()) == null ? "" : s);
                throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the host field, use authority instead."));
            }
            case "path": {
                return this.$VF.string(sloc.hasPath() ? sloc.getPath() : "/");
            }
            case "parent": {
                String path = sloc.getPath();
                if (path.equals("")) throw RuntimeExceptionFactory.noParent((ISourceLocation)sloc);
                if (path.equals("/")) {
                    throw RuntimeExceptionFactory.noParent((ISourceLocation)sloc);
                }
                while (true) {
                    if (!path.endsWith("/")) {
                        int i = path.lastIndexOf("/");
                        if (i == -1) throw RuntimeExceptionFactory.noParent((ISourceLocation)sloc);
                        path = path.substring(0, i);
                        if (!sloc.getScheme().equalsIgnoreCase("file")) return this.$aloc_field_update("path", (IValue)this.$VF.string(path), sloc);
                        if (path.lastIndexOf("/") != 0) return this.$aloc_field_update("path", (IValue)this.$VF.string(path), sloc);
                        if (!path.endsWith(":")) return this.$aloc_field_update("path", (IValue)this.$VF.string(path), sloc);
                        path = String.valueOf(path) + "/";
                        return this.$aloc_field_update("path", (IValue)this.$VF.string(path), sloc);
                    }
                    path = path.substring(0, path.length() - "/".length());
                }
            }
            case "file": {
                String path;
                String string = path = sloc.hasPath() ? sloc.getPath() : "";
                while (true) {
                    if (!path.endsWith("/")) {
                        int i = path.lastIndexOf("/");
                        if (i == -1) return this.$VF.string(path);
                        path = path.substring(i + "/".length());
                        return this.$VF.string(path);
                    }
                    path = path.substring(0, path.length() - "/".length());
                }
            }
            case "ls": {
                ISourceLocation resolved = sloc;
                if (!URIResolverRegistry.getInstance().exists(resolved)) throw RuntimeExceptionFactory.io((IString)this.$VF.string("You can only access ls on a directory, or a container."));
                if (!URIResolverRegistry.getInstance().isDirectory(resolved)) throw RuntimeExceptionFactory.io((IString)this.$VF.string("You can only access ls on a directory, or a container."));
                IListWriter w = this.$VF.listWriter();
                try {
                    ISourceLocation[] iSourceLocationArray = URIResolverRegistry.getInstance().list(resolved);
                    int n = iSourceLocationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISourceLocation elem = iSourceLocationArray[n2];
                        w.append(new IValue[]{elem});
                        ++n2;
                    }
                    return w.done();
                }
                catch (FactTypeUseException | IOException e) {
                    throw RuntimeExceptionFactory.io((IString)this.$VF.string(e.getMessage()));
                }
            }
            case "extension": {
                int slashIndex;
                String path;
                String string = path = sloc.hasPath() ? sloc.getPath() : "";
                while (true) {
                    if (!path.endsWith("/")) {
                        slashIndex = path.lastIndexOf("/");
                        if (slashIndex != -1) break;
                        return this.$VF.string("");
                    }
                    path = path.substring(0, path.length() - 1);
                }
                int j = path.substring(slashIndex).lastIndexOf(46);
                if (j == -1) return this.$VF.string("");
                return this.$VF.string(path.substring(slashIndex + j + 1));
            }
            case "fragment": {
                return this.$VF.string(sloc.hasFragment() ? sloc.getFragment() : "");
            }
            case "query": {
                return this.$VF.string(sloc.hasQuery() ? sloc.getQuery() : "");
            }
            case "params": {
                String[] params;
                String query = sloc.hasQuery() ? sloc.getQuery() : "";
                IMapWriter res = this.$VF.mapWriter();
                if (query.length() <= 0) return res.done();
                String[] stringArray = params = query.split("&");
                int n = params.length;
                int n3 = 0;
                while (n3 < n) {
                    String param = stringArray[n3];
                    String[] keyValue = param.split("=");
                    res.put((IValue)this.$VF.string(keyValue[0]), (IValue)this.$VF.string(keyValue[1]));
                    ++n3;
                }
                return res.done();
            }
            case "user": {
                if (URIResolverRegistry.getInstance().supportsHost(sloc)) String s;
                return this.$VF.string((s = sloc.getURI().getUserInfo()) == null ? "" : s);
                throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the user field, use authority instead."));
            }
            case "port": {
                if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                    throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the port field, use authority instead."));
                }
                int n = sloc.getURI().getPort();
                return this.$VF.integer(n);
            }
            case "length": {
                if (!sloc.hasOffsetLength()) throw RuntimeExceptionFactory.unavailableInformation(null, null);
                return this.$VF.integer(sloc.getLength());
            }
            case "offset": {
                if (!sloc.hasOffsetLength()) throw RuntimeExceptionFactory.unavailableInformation(null, null);
                return this.$VF.integer(sloc.getOffset());
            }
            case "begin": {
                if (!sloc.hasLineColumn()) throw RuntimeExceptionFactory.unavailableInformation(null, null);
                return this.$VF.tuple(new IValue[]{this.$VF.integer(sloc.getBeginLine()), this.$VF.integer(sloc.getBeginColumn())});
            }
            case "end": {
                if (!sloc.hasLineColumn()) throw RuntimeExceptionFactory.unavailableInformation(null, null);
                return this.$VF.tuple(new IValue[]{this.$VF.integer(sloc.getEndLine()), this.$VF.integer(sloc.getEndColumn())});
            }
            case "uri": {
                return this.$VF.string(sloc.getURI().toString());
            }
            case "top": {
                return sloc.top();
            }
        }
        throw RuntimeExceptionFactory.noSuchField((String)field);
    }

    public final GuardedIValue $guarded_aloc_get_field(ISourceLocation sloc, String field) {
        try {
            IValue result = this.$aloc_get_field(sloc, field);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $adatetime_get_field(IDateTime dt, String field) {
        try {
            IBool v;
            switch (field) {
                case "isDate": {
                    v = this.$VF.bool(dt.isDate());
                    break;
                }
                case "isTime": {
                    v = this.$VF.bool(dt.isTime());
                    break;
                }
                case "isDateTime": {
                    v = this.$VF.bool(dt.isDateTime());
                    break;
                }
                case "century": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getCentury());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "year": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getYear());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "month": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getMonthOfYear());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "day": {
                    if (!dt.isTime()) {
                        v = this.$VF.integer(dt.getDayOfMonth());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "hour": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getHourOfDay());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "minute": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getMinuteOfHour());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "second": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getSecondOfMinute());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "millisecond": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getMillisecondsOfSecond());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "timezoneOffsetHours": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getTimezoneOffsetHours());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "timezoneOffsetMinutes": {
                    if (!dt.isDate()) {
                        v = this.$VF.integer(dt.getTimezoneOffsetMinutes());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "justDate": {
                    if (!dt.isTime()) {
                        v = this.$VF.date(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                case "justTime": {
                    if (!dt.isDate()) {
                        v = this.$VF.time(dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisecondsOfSecond(), dt.getTimezoneOffsetHours(), dt.getTimezoneOffsetMinutes());
                        break;
                    }
                    throw RuntimeExceptionFactory.unavailableInformation(null, null);
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField((String)field);
                }
            }
            return v;
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dt);
        }
    }

    public final GuardedIValue $guarded_datetime_get_field(IDateTime dt, String field) {
        try {
            IValue result = this.$adatetime_get_field(dt, field);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $atuple_get_field(ITuple tup, String fieldName) {
        IValue result = tup.get(fieldName);
        if (result == null) {
            throw RuntimeExceptionFactory.noSuchField((String)fieldName);
        }
        return result;
    }

    public final IValue $atuple_get_field_by_index(ITuple tup, int index) {
        IValue result = tup.get(index);
        return result;
    }

    public final GuardedIValue $guarded_atuple_get_field(ITuple tup, String fieldName) {
        try {
            IValue result = this.$atuple_get_field(tup, fieldName);
            return new GuardedIValue(result);
        }
        catch (RuntimeException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $areified_get_field(IConstructor rt, String field) {
        return rt.get(field);
    }

    public final IValue $atuple_field_project(ITuple tup, IValue ... fields) {
        int n = fields.length;
        IValue[] newFields = new IValue[n];
        int i = 0;
        while (i < n) {
            IValue field = fields[i];
            newFields[i] = field.getType().isInteger() ? tup.get(((IInteger)field).intValue()) : tup.get(((IString)field).getValue());
            ++i;
        }
        return n - 1 > 1 ? this.$VF.tuple(newFields) : newFields[0];
    }

    public final GuardedIValue $guarded_atuple_field_project(ITuple tup, IValue ... fields) {
        try {
            return new GuardedIValue(this.$atuple_field_project(tup, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $amap_field_project(IMap map, IValue ... fields) {
        ISetWriter w = this.$VF.setWriter();
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        int i = 0;
        while (i < indexArity) {
            intFields[i] = ((IInteger)fields[i]).intValue();
            ++i;
        }
        IValue[] elems = new IValue[indexArity];
        Iterator iter = map.entryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            int j = 0;
            while (j < fields.length) {
                elems[j] = intFields[j] == 0 ? (IValue)entry.getKey() : (IValue)entry.getValue();
                ++j;
            }
            w.insert(new IValue[]{indexArity > 1 ? this.$VF.tuple(elems) : elems[0]});
        }
        return (ISet)w.done();
    }

    public final GuardedIValue $guarded_amap_field_project(IMap map, IValue ... fields) {
        try {
            return new GuardedIValue((IValue)this.$amap_field_project(map, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_field_project(ISet set, IValue ... fields) {
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        int i = 0;
        while (i < indexArity) {
            intFields[i] = ((IInteger)fields[i]).intValue();
            ++i;
        }
        return (ISet)set.asRelation().project(intFields);
    }

    public final GuardedIValue $guarded_arel_field_project(ISet set, IValue ... fields) {
        try {
            return new GuardedIValue((IValue)this.$arel_field_project(set, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel_field_project(IList lrel, IValue ... fields) {
        int indexArity = fields.length;
        int[] intFields = new int[indexArity];
        int i = 0;
        while (i < indexArity) {
            intFields[i] = ((IInteger)fields[i]).intValue();
            ++i;
        }
        IListWriter w = this.$VF.listWriter();
        IValue[] elems = new IValue[indexArity];
        for (IValue vtup : lrel) {
            ITuple tup = (ITuple)vtup;
            int j = 0;
            while (j < fields.length) {
                elems[j] = tup.get(intFields[j]);
                ++j;
            }
            w.append(new IValue[]{indexArity > 1 ? this.$VF.tuple(elems) : elems[0]});
        }
        return (IList)w.done();
    }

    public final GuardedIValue $guarded_alrel_field_project(IList lrel, IValue ... fields) {
        try {
            return new GuardedIValue((IValue)this.$alrel_field_project(lrel, fields));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISourceLocation $aloc_field_update(String field, IValue repl, ISourceLocation sloc) {
        Type replType = repl.getType();
        int iLength = sloc.hasOffsetLength() ? sloc.getLength() : -1;
        int iOffset = sloc.hasOffsetLength() ? sloc.getOffset() : -1;
        int iBeginLine = sloc.hasLineColumn() ? sloc.getBeginLine() : -1;
        int iBeginColumn = sloc.hasLineColumn() ? sloc.getBeginColumn() : -1;
        int iEndLine = sloc.hasLineColumn() ? sloc.getEndLine() : -1;
        int iEndColumn = sloc.hasLineColumn() ? sloc.getEndColumn() : -1;
        boolean uriPartChanged = false;
        String scheme = sloc.getScheme();
        String authority = sloc.hasAuthority() ? sloc.getAuthority() : "";
        String path = sloc.hasPath() ? sloc.getPath() : null;
        String query = sloc.hasQuery() ? sloc.getQuery() : null;
        String fragment = sloc.hasFragment() ? sloc.getFragment() : null;
        try {
            String newStringValue = null;
            if (replType.isString()) {
                newStringValue = ((IString)repl).getValue();
            }
            switch (field) {
                case "uri": {
                    URI uri = URIUtil.createFromEncoded((String)newStringValue);
                    scheme = uri.getScheme();
                    authority = uri.getAuthority();
                    path = uri.getPath();
                    query = uri.getQuery();
                    fragment = uri.getFragment();
                    uriPartChanged = true;
                    break;
                }
                case "scheme": {
                    scheme = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "authority": {
                    authority = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "host": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the host field, use authority instead."));
                    }
                    URI uri = URIUtil.changeHost((URI)sloc.getURI(), (String)newStringValue);
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "path": {
                    path = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "file": {
                    boolean endsWithSlash = path.endsWith("/");
                    path = endsWithSlash ? path.substring(0, path.length() - "/".length()) : path;
                    int i = path.lastIndexOf("/");
                    path = i != -1 ? String.valueOf(path.substring(0, i)) + "/" + newStringValue : String.valueOf(path) + "/" + newStringValue;
                    if (endsWithSlash) {
                        path = String.valueOf(path) + "/";
                    }
                    uriPartChanged = true;
                    break;
                }
                case "parent": {
                    int i = path.lastIndexOf("/");
                    String parent = newStringValue;
                    if (!parent.startsWith("/")) {
                        parent = "/" + parent;
                    }
                    path = i != -1 ? String.valueOf(parent) + path.substring(i) : parent;
                    uriPartChanged = true;
                    break;
                }
                case "ls": {
                    throw RuntimeExceptionFactory.noSuchField((String)"Cannot update the children of a location");
                }
                case "extension": {
                    String ext = newStringValue;
                    boolean endsWithSlash = path.endsWith("/");
                    if (endsWithSlash) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (path.length() > 1) {
                        int slashIndex = path.lastIndexOf("/");
                        int index = path.substring(slashIndex).lastIndexOf(46);
                        if (index == -1 && !ext.isEmpty()) {
                            path = String.valueOf(path) + (!ext.startsWith(".") ? "." : "") + ext;
                        } else if (!ext.isEmpty()) {
                            path = String.valueOf(path.substring(0, slashIndex + index)) + (!ext.startsWith(".") ? "." : "") + ext;
                        } else if (index != -1) {
                            path = path.substring(0, slashIndex + index);
                        }
                        if (endsWithSlash) {
                            path = String.valueOf(path) + "/";
                        }
                    }
                    uriPartChanged = true;
                    break;
                }
                case "top": {
                    if (replType.isString()) {
                        URI uri = URIUtil.assumeCorrect((String)newStringValue);
                        scheme = uri.getScheme();
                        authority = uri.getAuthority();
                        path = uri.getPath();
                        query = uri.getQuery();
                        fragment = uri.getFragment();
                    } else if (replType.isSourceLocation()) {
                        ISourceLocation rep = (ISourceLocation)repl;
                        scheme = rep.getScheme();
                        authority = rep.hasAuthority() ? rep.getAuthority() : null;
                        path = rep.hasPath() ? rep.getPath() : null;
                        query = rep.hasQuery() ? rep.getQuery() : null;
                        fragment = rep.hasFragment() ? rep.getFragment() : null;
                    }
                    uriPartChanged = true;
                    break;
                }
                case "fragment": {
                    fragment = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "query": {
                    query = newStringValue;
                    uriPartChanged = true;
                    break;
                }
                case "user": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the user field, use authority instead."));
                    }
                    URI uri = sloc.getURI();
                    if (uri.getHost() != null) {
                        uri = URIUtil.changeUserInformation((URI)uri, (String)newStringValue);
                    }
                    authority = uri.getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "port": {
                    if (!URIResolverRegistry.getInstance().supportsHost(sloc)) {
                        throw RuntimeExceptionFactory.noSuchField((String)("The scheme " + sloc.getScheme() + " does not support the port field, use authority instead."));
                    }
                    if (sloc.getURI().getHost() != null) {
                        int port = Integer.parseInt(((IInteger)repl).getStringRepresentation());
                        URI uRI = URIUtil.changePort((URI)sloc.getURI(), (int)port);
                    }
                    authority = sloc.getURI().getAuthority();
                    uriPartChanged = true;
                    break;
                }
                case "length": {
                    iLength = ((IInteger)repl).intValue();
                    if (iLength >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument((IValue)repl);
                }
                case "offset": {
                    iOffset = ((IInteger)repl).intValue();
                    if (iOffset >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument((IValue)repl);
                }
                case "begin": {
                    iBeginLine = ((IInteger)((ITuple)repl).get(0)).intValue();
                    iBeginColumn = ((IInteger)((ITuple)repl).get(1)).intValue();
                    if (iBeginColumn >= 0 && iBeginLine >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument((IValue)repl);
                }
                case "end": {
                    iEndLine = ((IInteger)((ITuple)repl).get(0)).intValue();
                    iEndColumn = ((IInteger)((ITuple)repl).get(1)).intValue();
                    if (iEndColumn >= 0 && iEndLine >= 0) break;
                    throw RuntimeExceptionFactory.illegalArgument((IValue)repl);
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField((String)("Modification of field " + field + " in location not allowed"));
                }
            }
            ISourceLocation newLoc = sloc;
            if (uriPartChanged) {
                newLoc = this.$VF.sourceLocation(scheme, authority, path, query, fragment);
            }
            if (sloc.hasLineColumn()) {
                return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
            }
            if (sloc.hasOffsetLength()) {
                if (iBeginLine != -1 || iBeginColumn != -1) {
                    iEndLine = iBeginLine;
                    iEndColumn = iBeginColumn;
                    return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
                }
                if (iEndLine != -1 || iEndColumn != -1) {
                    iBeginLine = iEndLine;
                    iBeginColumn = iEndColumn;
                    return this.$VF.sourceLocation(newLoc, iOffset, iLength, iBeginLine, iEndLine, iBeginColumn, iEndColumn);
                }
                return this.$VF.sourceLocation(newLoc, iOffset, iLength);
            }
            if (iBeginColumn != -1 || iEndColumn != -1 || iBeginLine != -1 || iBeginColumn != -1) {
                throw RuntimeExceptionFactory.invalidUseOfLocation((String)"Can not add line/column information without offset/length");
            }
            if (iOffset != -1 && iLength == -1) {
                iLength = 0;
            }
            if (iLength != -1 && iOffset == -1) {
                iOffset = 0;
            }
            if (iOffset != -1 || iLength != -1) {
                return this.$VF.sourceLocation(newLoc, iOffset, iLength);
            }
            return newLoc;
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sloc);
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionFactory.malformedURI((String)e.getMessage());
        }
    }

    public final IDateTime $adatetime_field_update(String field, IValue repl, IDateTime dt) {
        int year = dt.getYear();
        int month = dt.getMonthOfYear();
        int day = dt.getDayOfMonth();
        int hour = dt.getHourOfDay();
        int minute = dt.getMinuteOfHour();
        int second = dt.getSecondOfMinute();
        int milli = dt.getMillisecondsOfSecond();
        int tzOffsetHour = dt.getTimezoneOffsetHours();
        int tzOffsetMin = dt.getTimezoneOffsetMinutes();
        try {
            switch (field) {
                case "year": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException((String)"Can not update the year on a time value");
                    }
                    year = ((IInteger)repl).intValue();
                    break;
                }
                case "month": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException((String)"Can not update the month on a time value");
                    }
                    month = ((IInteger)repl).intValue();
                    break;
                }
                case "day": {
                    if (dt.isTime()) {
                        throw RuntimeExceptionFactory.invalidUseOfTimeException((String)"Can not update the day on a time value");
                    }
                    day = ((IInteger)repl).intValue();
                    break;
                }
                case "hour": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the hour on a date value");
                    }
                    hour = ((IInteger)repl).intValue();
                    break;
                }
                case "minute": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the minute on a date value");
                    }
                    minute = ((IInteger)repl).intValue();
                    break;
                }
                case "second": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the second on a date value");
                    }
                    second = ((IInteger)repl).intValue();
                    break;
                }
                case "millisecond": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the millisecond on a date value");
                    }
                    milli = ((IInteger)repl).intValue();
                    break;
                }
                case "timezoneOffsetHours": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the timezone offset hours on a date value");
                    }
                    tzOffsetHour = ((IInteger)repl).intValue();
                    break;
                }
                case "timezoneOffsetMinutes": {
                    if (dt.isDate()) {
                        throw RuntimeExceptionFactory.invalidUseOfDateException((String)"Can not update the timezone offset minutes on a date value");
                    }
                    tzOffsetMin = ((IInteger)repl).intValue();
                    break;
                }
                default: {
                    throw RuntimeExceptionFactory.noSuchField((String)field);
                }
            }
            IDateTime newdt = null;
            newdt = dt.isDate() ? this.$VF.date(year, month, day) : (dt.isTime() ? this.$VF.time(hour, minute, second, milli, tzOffsetHour, tzOffsetMin) : this.$VF.datetime(year, month, day, hour, minute, second, milli, tzOffsetHour, tzOffsetMin));
            return newdt;
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)repl, null, null);
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dt, null, null);
        }
    }

    public final INode $anode_field_update(String fieldName, IValue repl, INode nd) {
        if (nd.getType().isAbstractData()) {
            return this.$aadt_field_update(fieldName, repl, (IConstructor)nd);
        }
        if (nd.mayHaveKeywordParameters() && nd.asWithKeywordParameters().getParameter(fieldName) != null) {
            return (INode)nd.asWithKeywordParameters().setParameter(fieldName, repl);
        }
        throw RuntimeExceptionFactory.illegalArgument((IValue)nd, null, null);
    }

    public final IConstructor $aadt_field_update(String fieldName, IValue repl, IConstructor cons) {
        Type consType = cons.getConstructorType();
        if (TreeAdapter.isTree((IConstructor)cons)) {
            if (TreeAdapter.isAppl((ITree)((ITree)cons)) && TreeAdapter.getLabeledField((ITree)((ITree)cons), (String)fieldName) != null) {
                return TreeAdapter.setArg((ITree)((ITree)cons), (String)fieldName, (IConstructor)((IConstructor)repl));
            }
            return (IConstructor)cons.asWithKeywordParameters().setParameter(fieldName, repl);
        }
        if (consType.hasField(fieldName)) {
            return cons.set(fieldName, repl);
        }
        return (IConstructor)cons.asWithKeywordParameters().setParameter(fieldName, repl);
    }

    public final boolean $anode_has_field(INode nd, String fieldName) {
        if (nd.getType().isAbstractData() && this.$aadt_has_field((IConstructor)nd, fieldName, new Type[0])) {
            return true;
        }
        return nd.mayHaveKeywordParameters() && nd.asWithKeywordParameters().getParameter(fieldName) != null;
    }

    public final boolean $aadt_has_field(IConstructor cons, String fieldName, Type ... consesWithField) {
        if (TreeAdapter.isTree((IConstructor)cons) && TreeAdapter.isAppl((ITree)((ITree)cons))) {
            TreeAdapter.FieldResult fldres = TreeAdapter.getLabeledField((ITree)((ITree)cons), (String)fieldName);
            if (fldres != null) {
                return true;
            }
            if (cons.asWithKeywordParameters().getParameter(fieldName) != null) {
                return true;
            }
        }
        Type consType = cons.getConstructorType();
        Type[] typeArray = consesWithField;
        int n = consesWithField.length;
        int n2 = 0;
        while (n2 < n) {
            Type ct = typeArray[n2];
            if (consType.equals(ct)) {
                return true;
            }
            ++n2;
        }
        if (consType.hasField(fieldName)) {
            return true;
        }
        return cons.asWithKeywordParameters().getParameter(fieldName) != null;
    }

    public final boolean $nonterminal_has_name_and_arity(IValue v, String name, int arity) {
        if (v instanceof IConstructor && TreeAdapter.isTree((IConstructor)((IConstructor)v))) {
            ITree tree = (ITree)v;
            IList args = TreeAdapter.getArgs((ITree)tree);
            int prod_arity = 0;
            for (IValue varg : args) {
                if (!TreeAdapter.isLexical((ITree)((ITree)varg)) && !TreeAdapter.isSort((ITree)((ITree)varg)) && !TreeAdapter.isList((ITree)((ITree)varg))) continue;
                ++prod_arity;
            }
            if (prod_arity != arity) {
                return false;
            }
            IConstructor prod = TreeAdapter.getProduction((ITree)tree);
            IValue def = prod.get("def");
            if (def == null) {
                return false;
            }
            if (((IConstructor)def).has("name")) {
                return ((IString)((IConstructor)def).get("name")).getValue().equals(name);
            }
        }
        return false;
    }

    public final boolean $has_type_and_arity(IValue v, Type type, int arity) {
        HashMap m;
        Type consType;
        if (v instanceof IConstructor && (consType = ((IConstructor)v).getConstructorType()).match(type, m = new HashMap())) {
            if (TreeAdapter.isTree((IConstructor)((IConstructor)v))) {
                ITree tree = (ITree)v;
                if (TreeAdapter.isChar((ITree)tree)) {
                    return arity == 1;
                }
                if (TreeAdapter.isAmb((ITree)tree)) {
                    return arity == 1;
                }
                IList args = TreeAdapter.getArgs((ITree)tree);
                if (args == null && arity != 0) {
                    return false;
                }
                if (TreeAdapter.isLiteral((ITree)tree)) {
                    IConstructor p = TreeAdapter.getProduction((ITree)tree);
                    IList symbols = ProductionAdapter.getSymbols((IConstructor)p);
                    return args.size() == symbols.size();
                }
                if (!TreeAdapter.isAppl((ITree)tree)) {
                    return false;
                }
                return arity == 2;
            }
            return true;
        }
        return false;
    }

    public final IValue $nonterminal_get_arg(ITree tree, int idx) {
        IList args = TreeAdapter.getArgs((ITree)tree);
        int i = 0;
        for (IValue varg : args) {
            if (TreeAdapter.isLayout((ITree)((ITree)varg)) || !TreeAdapter.isLexical((ITree)((ITree)varg)) && !TreeAdapter.isSort((ITree)((ITree)varg)) && !TreeAdapter.isList((ITree)((ITree)varg))) continue;
            if (i == idx) {
                return varg;
            }
            ++i;
        }
        throw new InternalCompilerError("nonterminal does not have argument #" + idx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean $is(IValue val, IString sname) {
        Type tp = val.getType();
        String name = sname.getValue();
        if (tp.isAbstractData()) {
            if (tp.getName().equals("Tree")) {
                IConstructor prod;
                IConstructor def;
                IConstructor cons = (IConstructor)val;
                if (!cons.getName().equals("appl") || !(def = (IConstructor)(prod = (IConstructor)cons.get(0)).get(0)).getName().equals("label")) return false;
                return ((IString)def.get(0)).getValue().equals(name);
            }
            String consName = ((IConstructor)val).getConstructorType().getName();
            if (!consName.startsWith("\\")) return consName.equals(name);
            consName = consName.substring(1);
            return consName.equals(name);
        }
        if (!tp.isNode()) return false;
        String nodeName = ((INode)val).getName();
        if (!nodeName.startsWith("\\")) return nodeName.equals(name);
        nodeName = nodeName.substring(1);
        return nodeName.equals(name);
    }

    public final boolean $is_defined_value(GuardedIValue val) {
        return val.defined;
    }

    public final IValue $get_defined_value(GuardedIValue val) {
        return val.value;
    }

    public final IList $alist_join_alrel(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type rightType = right.get(0).getType();
        assert (rightType.isTuple());
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[1 + rarity];
        IListWriter w = this.$VF.listWriter();
        Iterator iterator = left.iterator();
        while (iterator.hasNext()) {
            IValue lval;
            fieldValues[0] = lval = (IValue)iterator.next();
            for (IValue rtuple : right) {
                int i = 0;
                while (i < rarity) {
                    fieldValues[i + 1] = ((ITuple)rtuple).get(i);
                    ++i;
                }
                w.append(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (IList)w.done();
    }

    public final IList $alrel_join_alrel(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type leftType = left.get(0).getType();
        Type rightType = right.get(0).getType();
        assert (leftType.isTuple());
        assert (rightType.isTuple());
        int larity = leftType.getArity();
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[larity + rarity];
        IListWriter w = this.$VF.listWriter();
        for (IValue ltuple : left) {
            for (IValue rtuple : right) {
                int i = 0;
                while (i < larity) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                    ++i;
                }
                i = larity;
                while (i < larity + rarity) {
                    fieldValues[i] = ((ITuple)rtuple).get(i - larity);
                    ++i;
                }
                w.append(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (IList)w.done();
    }

    public final IList $alrel_join_alist(IList left, IList right) {
        if (left.length() == 0) {
            return left;
        }
        if (right.length() == 0) {
            return right;
        }
        Type leftType = left.get(0).getType();
        assert (leftType.isTuple());
        int larity = leftType.getArity();
        IValue[] fieldValues = new IValue[larity + 1];
        IListWriter w = this.$VF.listWriter();
        for (IValue ltuple : left) {
            for (IValue rval : right) {
                int i = 0;
                while (i < larity) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                    ++i;
                }
                fieldValues[larity] = rval;
                w.append(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (IList)w.done();
    }

    public final ISet $aset_join_arel(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type rightType = right.getElementType();
        assert (rightType.isTuple());
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[1 + rarity];
        ISetWriter w = this.$VF.setWriter();
        for (IValue lval : left) {
            for (IValue rtuple : right) {
                fieldValues[0] = lval;
                int i = 0;
                while (i < rarity) {
                    fieldValues[i + 1] = ((ITuple)rtuple).get(i);
                    ++i;
                }
                w.insert(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (ISet)w.done();
    }

    public final ISet $arel_join_arel(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type leftType = left.getElementType();
        Type rightType = right.getElementType();
        assert (leftType.isTuple());
        assert (rightType.isTuple());
        int larity = leftType.getArity();
        int rarity = rightType.getArity();
        IValue[] fieldValues = new IValue[larity + rarity];
        ISetWriter w = this.$VF.setWriter();
        for (IValue ltuple : left) {
            for (IValue rtuple : right) {
                int i = 0;
                while (i < larity) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                    ++i;
                }
                i = larity;
                while (i < larity + rarity) {
                    fieldValues[i] = ((ITuple)rtuple).get(i - larity);
                    ++i;
                }
                w.insert(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (ISet)w.done();
    }

    public final ISet $arel_join_aset(ISet left, ISet right) {
        if (left.size() == 0) {
            return left;
        }
        if (right.size() == 0) {
            return right;
        }
        Type leftType = left.getElementType();
        assert (leftType.isTuple());
        int larity = leftType.getArity();
        IValue[] fieldValues = new IValue[larity + 1];
        ISetWriter w = this.$VF.setWriter();
        for (IValue ltuple : left) {
            for (IValue rval : right) {
                int i = 0;
                while (i < larity) {
                    fieldValues[i] = ((ITuple)ltuple).get(i);
                    ++i;
                }
                fieldValues[larity] = rval;
                w.insert(new IValue[]{this.$VF.tuple(fieldValues)});
            }
        }
        return (ISet)w.done();
    }

    public final IBool $less(final IValue left, final IValue right) {
        final Type leftType = left.getType();
        final Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).less((INumber)right);
        }
        if (!leftType.comparable(rightType)) {
            return this.Rascal_FALSE;
        }
        return (IBool)leftType.accept((ITypeVisitor)new DefaultRascalTypeVisitor<IBool, RuntimeException>(this.Rascal_FALSE){

            public IBool visitList(Type type) throws RuntimeException {
                if (rightType.isList()) {
                    return $RascalModule.this.$alist_less_alist((IList)left, (IList)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitMap(Type type) throws RuntimeException {
                if (rightType.isMap()) {
                    return $RascalModule.this.$amap_less_amap((IMap)left, (IMap)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitSet(Type type) throws RuntimeException {
                if (rightType.isSet()) {
                    return $RascalModule.this.$aset_less_aset((ISet)left, (ISet)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitSourceLocation(Type type) throws RuntimeException {
                if (rightType.isSourceLocation()) {
                    return $RascalModule.this.$aloc_less_aloc((ISourceLocation)left, (ISourceLocation)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitString(Type type) throws RuntimeException {
                if (rightType.isString()) {
                    return $RascalModule.this.$astr_less_astr((IString)left, (IString)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitNode(Type type) throws RuntimeException {
                if (rightType.isNode()) {
                    return $RascalModule.this.$anode_less_anode((INode)left, (INode)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitConstructor(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            public IBool visitAbstractData(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            public IBool visitTuple(Type type) throws RuntimeException {
                if (rightType.isTuple()) {
                    return $RascalModule.this.$atuple_less_atuple((ITuple)left, (ITuple)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitBool(Type type) throws RuntimeException {
                if (rightType.isBool()) {
                    return $RascalModule.this.$abool_less_abool((IBool)left, (IBool)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitDateTime(Type type) throws RuntimeException {
                if (rightType.isDateTime()) {
                    return $RascalModule.this.$adatetime_less_adatetime((IDateTime)left, (IDateTime)right);
                }
                throw new InternalCompilerError("less: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }
        });
    }

    public final IBool $aint_less_aint(IInteger a, IInteger b) {
        return a.less(b);
    }

    public final IBool $aint_less_areal(IInteger a, IReal b) {
        return a.less(b);
    }

    public final IBool $aint_less_arat(IInteger a, IRational b) {
        return a.toRational().less(b);
    }

    public final IBool $aint_less_anum(IInteger a, INumber b) {
        return a.less(b);
    }

    public final IBool $areal_less_aint(IReal a, IInteger b) {
        return a.less(b);
    }

    public final IBool $areal_less_areal(IReal a, IReal b) {
        return a.less(b);
    }

    public final IBool $areal_less_arat(IReal a, IRational b) {
        return a.less(b);
    }

    public final IBool $areal_less_anum(IReal a, INumber b) {
        return a.less(b);
    }

    public final IBool $arat_less_aint(IRational a, IInteger b) {
        return a.less(b);
    }

    public final IBool $arat_less_areal(IRational a, IReal b) {
        return a.less(b);
    }

    public final IBool $arat_less_arat(IRational a, IRational b) {
        return a.toRational().less(b);
    }

    public final IBool $arat_less_anum(IRational a, INumber b) {
        return a.less(b);
    }

    public final IBool $anum_less_aint(INumber a, IInteger b) {
        return a.less(b);
    }

    public final IBool $anum_less_areal(INumber a, IReal b) {
        return a.less(b);
    }

    public final IBool $anum_less_arat(INumber a, IRational b) {
        return a.less(b);
    }

    public final IBool $anum_less_anum(INumber a, INumber b) {
        return a.less(b);
    }

    public final IBool $abool_less_abool(IBool left, IBool right) {
        return this.$VF.bool(!left.getValue() && right.getValue());
    }

    public final IBool $astr_less_astr(IString left, IString right) {
        return this.$VF.bool(left.compare(right) == -1);
    }

    public final IBool $adatetime_less_adatetime(IDateTime left, IDateTime right) {
        return this.$VF.bool(left.compareTo((Object)right) == -1);
    }

    public final IBool $aloc_less_aloc(ISourceLocation left, ISourceLocation right) {
        int compare = SourceLocationURICompare.compare((ISourceLocation)left, (ISourceLocation)right);
        if (compare < 0) {
            return this.Rascal_TRUE;
        }
        if (compare > 0) {
            return this.Rascal_FALSE;
        }
        if (left.hasOffsetLength()) {
            if (!right.hasOffsetLength()) {
                return this.Rascal_FALSE;
            }
            int roffset = right.getOffset();
            int rlen = right.getLength();
            int loffset = left.getOffset();
            int llen = left.getLength();
            if (loffset == roffset) {
                return this.$VF.bool(llen < rlen);
            }
            return this.$VF.bool(roffset < loffset && roffset + rlen >= loffset + llen);
        }
        if (compare == 0) {
            return this.Rascal_FALSE;
        }
        if (!right.hasOffsetLength()) {
            throw new InternalCompilerError("offset length missing");
        }
        return this.Rascal_FALSE;
    }

    public final IBool $atuple_less_atuple(ITuple left, ITuple right) {
        int leftArity = left.arity();
        int rightArity = right.arity();
        int i = 0;
        while (i < Math.min(leftArity, rightArity)) {
            IBool result = leftArity < rightArity || i < leftArity - 1 ? this.$equal(left.get(i), right.get(i)) : this.$less(left.get(i), right.get(i));
            if (!result.getValue()) {
                return this.Rascal_FALSE;
            }
            ++i;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $anode_less_anode(INode left, INode right) {
        int compare = left.getName().compareTo(right.getName());
        if (compare <= -1) {
            return this.Rascal_TRUE;
        }
        if (compare >= 1) {
            return this.Rascal_FALSE;
        }
        int leftArity = left.arity();
        int rightArity = right.arity();
        IBool result = this.Rascal_FALSE;
        int i = 0;
        while (i < Math.min(leftArity, rightArity)) {
            result = leftArity < rightArity || i < leftArity - 1 ? this.$lessequal(left.get(i), right.get(i)) : this.$less(left.get(i), right.get(i));
            if (!result.getValue()) {
                return this.Rascal_FALSE;
            }
            ++i;
        }
        if (!left.mayHaveKeywordParameters()) {
            right.mayHaveKeywordParameters();
        }
        if (!left.asWithKeywordParameters().hasParameters() && right.asWithKeywordParameters().hasParameters()) {
            return this.Rascal_TRUE;
        }
        if (left.asWithKeywordParameters().hasParameters() && !right.asWithKeywordParameters().hasParameters()) {
            return this.Rascal_FALSE;
        }
        if (left.asWithKeywordParameters().hasParameters() && right.asWithKeywordParameters().hasParameters()) {
            Map paramsLeft = left.asWithKeywordParameters().getParameters();
            Map paramsRight = right.asWithKeywordParameters().getParameters();
            if (paramsLeft.size() < paramsRight.size()) {
                return this.Rascal_TRUE;
            }
            if (paramsLeft.size() > paramsRight.size()) {
                return this.Rascal_FALSE;
            }
            if (paramsRight.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return this.Rascal_TRUE;
            }
            if (paramsLeft.keySet().containsAll(paramsLeft.keySet()) && !paramsRight.keySet().equals(paramsLeft.keySet())) {
                return this.Rascal_FALSE;
            }
            for (String k : paramsLeft.keySet()) {
                result = this.$less((IValue)paramsLeft.get(k), (IValue)paramsRight.get(k));
                if (result.getValue()) continue;
                return this.Rascal_FALSE;
            }
        }
        return this.$VF.bool(leftArity < rightArity || result.getValue());
    }

    public final IBool $alist_less_alist(IList left, IList right) {
        if (left.length() > right.length()) {
            return this.Rascal_FALSE;
        }
        int l = 0;
        int r = 0;
        while (l < left.length()) {
            block4: {
                r = Math.max(l, r);
                while (r < right.length()) {
                    if (left.get(l).equals((Object)right.get(r))) {
                        ++r;
                        break block4;
                    }
                    ++r;
                }
                return this.Rascal_FALSE;
            }
            ++l;
        }
        return this.$VF.bool(left.length() != right.length());
    }

    public final IBool $aset_less_aset(ISet left, ISet right) {
        return this.$VF.bool(!left.equals((Object)right) && left.isSubsetOf(right));
    }

    public final IBool $amap_less_amap(IMap left, IMap right) {
        return this.$VF.bool(left.isSubMap(right) && !right.isSubMap(left));
    }

    public final IBool $lessequal(final IValue left, final IValue right) {
        final Type leftType = left.getType();
        final Type rightType = right.getType();
        if (leftType.isSubtypeOf(this.$TF.numberType()) && rightType.isSubtypeOf(this.$TF.numberType())) {
            return ((INumber)left).lessEqual((INumber)right);
        }
        if (!leftType.comparable(rightType)) {
            return this.Rascal_FALSE;
        }
        return (IBool)leftType.accept((ITypeVisitor)new DefaultRascalTypeVisitor<IBool, RuntimeException>(this.Rascal_FALSE){

            public IBool visitList(Type type) throws RuntimeException {
                if (rightType.isList()) {
                    return $RascalModule.this.$alist_lessequal_alist((IList)left, (IList)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitMap(Type type) throws RuntimeException {
                if (rightType.isMap()) {
                    return $RascalModule.this.$amap_lessequal_amap((IMap)left, (IMap)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitSet(Type type) throws RuntimeException {
                if (rightType.isSet()) {
                    return $RascalModule.this.$aset_lessequal_aset((ISet)left, (ISet)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitSourceLocation(Type type) throws RuntimeException {
                if (rightType.isSourceLocation()) {
                    return $RascalModule.this.$aloc_lessequal_aloc((ISourceLocation)left, (ISourceLocation)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitString(Type type) throws RuntimeException {
                if (rightType.isString()) {
                    return $RascalModule.this.$astr_lessequal_astr((IString)left, (IString)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitNode(Type type) throws RuntimeException {
                if (rightType.isNode()) {
                    return $RascalModule.this.$anode_lessequal_anode((INode)left, (INode)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitConstructor(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            public IBool visitAbstractData(Type type) throws RuntimeException {
                return this.visitNode(type);
            }

            public IBool visitTuple(Type type) throws RuntimeException {
                if (rightType.isTuple()) {
                    return $RascalModule.this.$atuple_lessequal_atuple((ITuple)left, (ITuple)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitBool(Type type) throws RuntimeException {
                if (rightType.isBool()) {
                    return $RascalModule.this.$abool_lessequal_abool((IBool)left, (IBool)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }

            public IBool visitDateTime(Type type) throws RuntimeException {
                if (rightType.isDateTime()) {
                    return $RascalModule.this.$adatetime_lessequal_adatetime((IDateTime)left, (IDateTime)right);
                }
                throw new InternalCompilerError("lessequal: unexpected arguments `" + leftType + "` and `" + rightType + "`");
            }
        });
    }

    public final IBool $aint_lessequal_aint(IInteger a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_areal(IInteger a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_arat(IInteger a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $aint_lessequal_anum(IInteger a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_aint(IReal a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_areal(IReal a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_arat(IReal a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $areal_lessequal_anum(IReal a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_aint(IRational a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_areal(IRational a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_arat(IRational a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $arat_lessequal_anum(IRational a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_aint(INumber a, IInteger b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_areal(INumber a, IReal b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_arat(INumber a, IRational b) {
        return a.lessEqual(b);
    }

    public final IBool $anum_lessequal_anum(INumber a, INumber b) {
        return a.lessEqual(b);
    }

    public final IBool $abool_lessequal_abool(IBool left, IBool right) {
        boolean l = left.getValue();
        boolean r = right.getValue();
        return this.$VF.bool(!l && r || l == r);
    }

    public final IBool $astr_lessequal_astr(IString left, IString right) {
        int c = left.compare(right);
        return this.$VF.bool(c == -1 || c == 0);
    }

    public final IBool $adatetime_lessequal_adatetime(IDateTime left, IDateTime right) {
        int c = left.compareTo((Object)right);
        return this.$VF.bool(c == -1 || c == 0);
    }

    public final IBool $aloc_lessequal_aloc(ISourceLocation left, ISourceLocation right) {
        int compare = SourceLocationURICompare.compare((ISourceLocation)left, (ISourceLocation)right);
        if (compare < 0) {
            return this.Rascal_TRUE;
        }
        if (compare > 0) {
            return this.Rascal_FALSE;
        }
        if (left.hasOffsetLength()) {
            if (!right.hasOffsetLength()) {
                return this.Rascal_FALSE;
            }
            int roffset = right.getOffset();
            int rlen = right.getLength();
            int loffset = left.getOffset();
            int llen = left.getLength();
            if (loffset == roffset) {
                return this.$VF.bool(llen <= rlen);
            }
            return this.$VF.bool(roffset < loffset && roffset + rlen >= loffset + llen);
        }
        if (compare == 0) {
            return this.Rascal_TRUE;
        }
        if (!right.hasOffsetLength()) {
            throw new InternalCompilerError("missing offset length");
        }
        return this.Rascal_FALSE;
    }

    public final IBool $anode_lessequal_anode(INode left, INode right) {
        int compare = left.getName().compareTo(right.getName());
        if (compare <= -1) {
            return this.Rascal_TRUE;
        }
        if (compare >= 1) {
            return this.Rascal_FALSE;
        }
        int leftArity = left.arity();
        int rightArity = right.arity();
        int i = 0;
        while (i < Math.min(leftArity, rightArity)) {
            if (!this.$lessequal(left.get(i), right.get(i)).getValue()) {
                return this.Rascal_FALSE;
            }
            ++i;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $atuple_lessequal_atuple(ITuple left, ITuple right) {
        int leftArity = left.arity();
        int rightArity = right.arity();
        int i = 0;
        while (i < Math.min(leftArity, rightArity)) {
            if (!this.$lessequal(left.get(i), right.get(i)).getValue()) {
                return this.Rascal_FALSE;
            }
            ++i;
        }
        return this.$VF.bool(leftArity <= rightArity);
    }

    public final IBool $alist_lessequal_alist(IList left, IList right) {
        if (left.length() == 0) {
            return this.Rascal_TRUE;
        }
        if (left.length() > right.length()) {
            return this.Rascal_FALSE;
        }
        int l = 0;
        int r = 0;
        while (l < left.length()) {
            block5: {
                r = Math.max(l, r);
                while (r < right.length()) {
                    if (!left.get(l).equals((Object)right.get(r))) {
                        ++r;
                        continue;
                    }
                    break block5;
                }
                return this.Rascal_FALSE;
            }
            ++l;
        }
        return this.$VF.bool(left.length() <= right.length());
    }

    public final IBool $aset_lessequal_aset(ISet left, ISet right) {
        return this.$VF.bool(left.size() == 0 || left.equals((Object)right) || left.isSubsetOf(right));
    }

    public final IBool $amap_lessequal_amap(IMap left, IMap right) {
        return this.$VF.bool(left.isSubMap(right));
    }

    public final IValue $parse(IValue reified, IString inputText, ISourceLocation inputLocation) {
        IFunction parser = this.$RVF.parser(reified, this.$VF.bool(true), this.$VF.bool(false), this.$VF.bool(false), this.$VF.set(new IValue[0]));
        return parser.call(new IValue[]{inputText, inputLocation});
    }

    public final IInteger $aint_product_aint(IInteger a, IInteger b) {
        return a.multiply(b);
    }

    public final IReal $aint_product_areal(IInteger a, IReal b) {
        return a.multiply(b);
    }

    public final IRational $aint_product_arat(IInteger a, IRational b) {
        return a.toRational().multiply(b);
    }

    public final INumber $aint_product_anum(IInteger a, INumber b) {
        return a.multiply(b);
    }

    public final IReal $areal_product_aint(IReal a, IInteger b) {
        return (IReal)a.multiply(b);
    }

    public final IReal $areal_product_areal(IReal a, IReal b) {
        return a.multiply(b);
    }

    public final IReal $areal_product_arat(IReal a, IRational b) {
        return (IReal)a.multiply(b);
    }

    public final INumber $areal_product_anum(IReal a, INumber b) {
        return a.multiply(b);
    }

    public final INumber $arat_product_aint(IRational a, IInteger b) {
        return a.multiply(b);
    }

    public final IReal $arat_product_areal(IRational a, IReal b) {
        return a.multiply(b);
    }

    public final IRational $arat_product_arat(IRational a, IRational b) {
        return a.toRational().multiply(b);
    }

    public final INumber $arat_product_anum(IRational a, INumber b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_aint(INumber a, IInteger b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_areal(INumber a, IReal b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_arat(INumber a, IRational b) {
        return a.multiply(b);
    }

    public final INumber $anum_product_anum(INumber a, INumber b) {
        return a.multiply(b);
    }

    public final IList $alist_product_alist(IList left, IList right) {
        IListWriter w = this.$VF.listWriter();
        for (IValue l : left) {
            for (IValue r : right) {
                w.append(new IValue[]{this.$VF.tuple(new IValue[]{l, r})});
            }
        }
        return (IList)w.done();
    }

    public final ISet $aset_product_aset(ISet left, ISet right) {
        ISetWriter w = this.$VF.setWriter();
        for (IValue l : left) {
            for (IValue r : right) {
                w.insert(new IValue[]{this.$VF.tuple(new IValue[]{l, r})});
            }
        }
        return (ISet)w.done();
    }

    public final Matcher $regExpCompile(String pat, String subject) {
        try {
            Pattern p = Pattern.compile(pat, 256);
            return p.matcher(subject);
        }
        catch (PatternSyntaxException e) {
            throw RuntimeExceptionFactory.regExpSyntaxError((String)e.getMessage());
        }
    }

    public final IString $str_escape_for_regexp(IString insert) {
        StringBuilder sw = new StringBuilder();
        Iterator iterator = insert.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            char c = (char)i;
            switch (c) {
                case '.': {
                    sw.append("\\.");
                    break;
                }
                case '(': {
                    sw.append("\\(");
                    break;
                }
                case ')': {
                    sw.append("\\)");
                    break;
                }
                case '*': {
                    sw.append("\\*");
                    break;
                }
                default: {
                    sw.append(c);
                }
            }
        }
        return this.$VF.string(sw.toString());
    }

    public final IString $str_escape_for_regexp(String insert) {
        return this.$str_escape_for_regexp(this.$VF.string(insert));
    }

    public final IString $astr_slice(IString str, Integer first, Integer second, Integer end) {
        StringBuilder buffer;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, str.length());
            buffer = new StringBuilder();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                int i = sd.first;
                while (i >= 0 && i < sd.end) {
                    buffer.appendCodePoint(str.charAt(i));
                    i += increment;
                }
            } else {
                int j = sd.first;
                while (j >= 0 && j > sd.end && j < str.length()) {
                    buffer.appendCodePoint(str.charAt(j));
                    j += increment;
                }
            }
        }
        return this.$VF.string(buffer.toString());
    }

    public final IList $anode_slice(INode node, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                int i = sd.first;
                while (i >= 0 && i < sd.end) {
                    w.append(new IValue[]{node.get(i)});
                    i += increment;
                }
            } else {
                int j = sd.first;
                while (j >= 0 && j > sd.end && j < node.arity()) {
                    w.append(new IValue[]{node.get(j)});
                    j += increment;
                }
            }
        }
        return (IList)w.done();
    }

    public final IList $alist_slice(IList lst, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                int i = sd.first;
                while (i >= 0 && i < sd.end) {
                    w.append(new IValue[]{lst.get(i)});
                    i += increment;
                }
            } else {
                int j = sd.first;
                while (j >= 0 && j > sd.end && j < lst.length()) {
                    w.append(new IValue[]{lst.get(j)});
                    j += increment;
                }
            }
        }
        return (IList)w.done();
    }

    public final ITree $lexical_slice(ITree tree, Integer first, Integer second, Integer end) {
        return this.$syntactic_slice(tree, first, second, end, 1);
    }

    public final ITree $concrete_slice(ITree tree, Integer first, Integer second, Integer end) {
        return this.$syntactic_slice(tree, first, second, end, 2);
    }

    public final ITree $lexical_slice_seps(ITree tree, Integer first, Integer second, Integer end) {
        IConstructor nt = ProductionAdapter.getType((IConstructor)TreeAdapter.getProduction((ITree)tree));
        int delta = SymbolAdapter.getSeparators((IConstructor)nt).size() + 1;
        return this.$syntactic_slice(tree, first, second, end, delta);
    }

    public final ITree $concrete_slice_seps(ITree tree, Integer first, Integer second, Integer end) {
        IConstructor nt = ProductionAdapter.getType((IConstructor)TreeAdapter.getProduction((ITree)tree));
        int delta = SymbolAdapter.getSeparators((IConstructor)nt).size() + 1;
        return this.$syntactic_slice(tree, first, second, end, delta);
    }

    private final ITree $syntactic_slice(ITree tree, Integer first, Integer second, Integer end, int delta) {
        boolean isPlusIter;
        IList args = tree.getArgs();
        int nargs = args.size();
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, nargs);
        int sd_first = sd.first * delta;
        int sd_second = sd.second * delta;
        int sd_end = Math.min(sd.end * delta, nargs);
        IListWriter w = this.$VF.listWriter();
        int increment = sd_second - sd_first;
        if (sd_first != sd_end && increment != 0) {
            int j;
            int i;
            if (sd_first <= sd_end) {
                i = sd_first;
                while (i >= 0 && i < sd_end) {
                    w.append(new IValue[]{args.get(i)});
                    if (i < sd_end - increment) {
                        j = i + 1;
                        while (j < i + delta) {
                            w.append(new IValue[]{args.get(j)});
                            ++j;
                        }
                    }
                    i += increment;
                }
            } else {
                i = sd_first;
                while (i >= 0 && i > sd_end && i < nargs) {
                    w.append(new IValue[]{args.get(i)});
                    if (i > 0) {
                        j = i - 1;
                        while (j > i - delta) {
                            w.append(new IValue[]{args.get(j)});
                            --j;
                        }
                    }
                    i += increment;
                }
            }
        }
        IList newArgs = (IList)w.done();
        String opname = ((IConstructor)TreeAdapter.getProduction((ITree)tree).get(0)).getName();
        boolean bl = isPlusIter = opname == "iter" || opname == "iter-seps";
        if (isPlusIter && newArgs.size() == 0) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)newArgs, (String)"Slice should not create empty list of elements for lexical or nonterminal with one or more repetitions");
        }
        return TreeAdapter.setArgs((ITree)tree, (IList)newArgs);
    }

    public final IList $makeSlice(INode node, Integer first, Integer second, Integer end) {
        IListWriter w;
        block4: {
            SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            if (sd.first == sd.end || increment == 0) break block4;
            if (sd.first <= sd.end) {
                int i = sd.first;
                while (i >= 0 && i < sd.end) {
                    w.append(new IValue[]{node.get(i)});
                    i += increment;
                }
            } else {
                int j = sd.first;
                while (j >= 0 && j > sd.end && j < node.arity()) {
                    w.append(new IValue[]{node.get(j)});
                    j += increment;
                }
            }
        }
        return (IList)w.done();
    }

    private SliceDescriptor makeSliceDescriptor(Integer first, Integer second, Integer end, int len) {
        int firstIndex = 0;
        int secondIndex = 1;
        int endIndex = len;
        if (first != null && (firstIndex = first.intValue()) < 0) {
            firstIndex += len;
        }
        if (end != null && (endIndex = end.intValue()) < 0) {
            endIndex += len;
        }
        if (second == null) {
            secondIndex = firstIndex + (firstIndex <= endIndex ? 1 : -1);
        } else {
            secondIndex = second;
            if (secondIndex < 0) {
                secondIndex += len;
            }
            if (first != null || end != null) {
                if (first == null && secondIndex > endIndex) {
                    firstIndex = len - 1;
                }
                if (end == null && secondIndex < firstIndex) {
                    endIndex = -1;
                }
            }
        }
        if (len == 0 || firstIndex >= len) {
            endIndex = 0;
            secondIndex = 0;
            firstIndex = 0;
        } else if (endIndex > len) {
            endIndex = len;
        }
        return new SliceDescriptor(firstIndex, secondIndex, endIndex);
    }

    public final IString $astr_slice_replace(IString str, Integer first, Integer second, Integer end, IString repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, str.length());
        return str.replace(sd.first, sd.second, sd.end, repl);
    }

    public final INode $anode_slice_replace(INode node, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, node.arity());
        return node.replace(sd.first, sd.second, sd.end, repl);
    }

    public final IList $alist_slice_replace(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.replace, repl);
    }

    public final IList $alist_slice_add(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.add, repl);
    }

    public final IList $alist_slice_subtract(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.subtract, repl);
    }

    public final IList $alist_slice_product(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.product, repl);
    }

    public final IList $alist_slice_divide(IList lst, Integer first, Integer second, Integer end, IList repl) {
        SliceDescriptor sd = this.makeSliceDescriptor(first, second, end, lst.length());
        return this.$updateListSlice(lst, sd, SliceOperator.divide, repl);
    }

    public final IList $updateListSlice(IList lst, SliceDescriptor sd, SliceOperator op, IList repl) {
        IListWriter w;
        block18: {
            w = this.$VF.listWriter();
            int increment = sd.second - sd.first;
            int replIndex = 0;
            int rlen = repl.length();
            boolean wrapped = false;
            if (sd.first == sd.end || increment == 0) break block18;
            if (sd.first <= sd.end) {
                assert (increment > 0);
                int listIndex = 0;
                while (listIndex < sd.first) {
                    w.append(new IValue[]{lst.get(listIndex++)});
                }
                while (listIndex >= 0 && listIndex < sd.end) {
                    w.append(new IValue[]{op.execute(lst.get(listIndex), repl.get(replIndex++), this)});
                    if (replIndex == rlen) {
                        replIndex = 0;
                        wrapped = true;
                    }
                    int q = 1;
                    while (q < increment && listIndex + q < sd.end) {
                        w.append(new IValue[]{lst.get(listIndex + q)});
                        ++q;
                    }
                    listIndex += increment;
                }
                listIndex = sd.end;
                if (!wrapped) {
                    while (replIndex < rlen) {
                        w.append(new IValue[]{repl.get(replIndex++)});
                    }
                }
                while (listIndex < lst.length()) {
                    w.append(new IValue[]{lst.get(listIndex++)});
                }
            } else {
                assert (increment < 0);
                int j = lst.length() - 1;
                while (j > sd.first) {
                    w.insert(new IValue[]{lst.get(j--)});
                }
                while (j >= 0 && j > sd.end && j < lst.length()) {
                    w.insert(new IValue[]{op.execute(lst.get(j), repl.get(replIndex++), this)});
                    if (replIndex == rlen) {
                        replIndex = 0;
                        wrapped = true;
                    }
                    int q = -1;
                    while (q > increment && j + q > sd.end) {
                        w.insert(new IValue[]{lst.get(j + q)});
                        --q;
                    }
                    j += increment;
                }
                j = sd.end;
                if (!wrapped) {
                    while (replIndex < rlen) {
                        w.insert(new IValue[]{repl.get(replIndex++)});
                    }
                }
                while (j >= 0) {
                    w.insert(new IValue[]{lst.get(j--)});
                }
            }
        }
        return (IList)w.done();
    }

    public final IListWriter $listwriter_splice(IListWriter writer, IValue val) {
        if (val instanceof IList) {
            IList lst = (IList)val;
            for (IValue v : lst) {
                writer.append(new IValue[]{v});
            }
        } else if (val instanceof ISet) {
            ISet set = (ISet)val;
            for (IValue v : set) {
                writer.append(new IValue[]{v});
            }
        } else {
            writer.append(new IValue[]{val});
        }
        return writer;
    }

    public final ISetWriter $setwriter_splice(ISetWriter writer, IValue val) {
        if (val instanceof IList) {
            IList lst = (IList)val;
            for (IValue v : lst) {
                writer.insert(new IValue[]{v});
            }
        } else if (val instanceof ISet) {
            ISet set = (ISet)val;
            for (IValue v : set) {
                writer.insert(new IValue[]{v});
            }
        } else {
            writer.insert(new IValue[]{val});
        }
        return writer;
    }

    public final IString $astr_subscript_int(IString str, int idx) {
        try {
            return idx >= 0 ? str.substring(idx, idx + 1) : str.substring(str.length() + idx, str.length() + idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_astr_subscript_int(IString str, int idx) {
        try {
            IString res = idx >= 0 ? str.substring(idx, idx + 1) : str.substring(str.length() + idx, str.length() + idx + 1);
            return new GuardedIValue((IValue)res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $alist_subscript_int(IList lst, int idx) {
        try {
            return lst.get(idx >= 0 ? idx : lst.length() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_list_subscript(IList lst, int idx) {
        try {
            return new GuardedIValue(lst.get(idx >= 0 ? idx : lst.length() + idx));
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $amap_subscript(String name, IMap map, IValue idx) {
        IValue v = map.get(idx);
        if (v == null) {
            throw RuntimeExceptionFactory.noSuchKey((IValue)idx);
        }
        return v;
    }

    public final IValue $amap_subscript(IMap map, IValue idx) {
        IValue v = map.get(idx);
        if (v == null) {
            throw RuntimeExceptionFactory.noSuchKey((IValue)idx);
        }
        return v;
    }

    public final GuardedIValue $guarded_map_subscript(IMap map, IValue idx) {
        IValue v = map.get(idx);
        return v == null ? this.UNDEFINED : new GuardedIValue(v);
    }

    public final IValue $atuple_subscript_int(ITuple tup, int idx) {
        try {
            return tup.get(idx >= 0 ? idx : tup.arity() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_atuple_subscript_int(ITuple tup, int idx) {
        try {
            IValue res = tup.get(idx >= 0 ? idx : tup.arity() + idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $anode_subscript_int(INode node, int idx) {
        try {
            if (idx < 0) {
                idx = node.arity() + idx;
            }
            return node.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_anode_subscript_int(INode node, int idx) {
        try {
            if (idx < 0) {
                idx = node.arity() + idx;
            }
            IValue res = node.get(idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $aadt_subscript_int(IConstructor cons, int idx) {
        try {
            return cons.get(idx >= 0 ? idx : cons.arity() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final GuardedIValue $guarded_aadt_subscript_int(IConstructor cons, int idx) {
        try {
            IValue res = cons.get(idx >= 0 ? idx : cons.arity() + idx);
            return new GuardedIValue(res);
        }
        catch (IndexOutOfBoundsException e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_subscript1_noset(ISet rel, IValue idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        return (ISet)rel.asRelation().index(idx);
    }

    public final GuardedIValue $guarded_arel_subscript1_noset(ISet rel, IValue idx) {
        try {
            return new GuardedIValue((IValue)this.$arel_subscript1_noset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel2_subscript1_aset(ISet rel, ISet idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        ISetWriter wset = this.$VF.setWriter();
        for (IValue v : rel) {
            ITuple tup = (ITuple)v;
            IValue tup0 = tup.get(0);
            if ((!tup0.getType().isSet() || !idx.equals((Object)tup0)) && !idx.contains(tup0)) continue;
            wset.insert(new IValue[]{tup.get(1)});
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel2_subscript1_aset(ISet rel, ISet idx) {
        try {
            return new GuardedIValue((IValue)this.$arel2_subscript1_aset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final ISet $arel_subscript1_aset(ISet rel, ISet idx) {
        if (rel.isEmpty()) {
            return rel;
        }
        int relArity = rel.getElementType().getArity();
        ISetWriter wset = this.$VF.setWriter();
        IValue[] args = new IValue[relArity - 1];
        for (IValue v : rel) {
            ITuple tup = (ITuple)v;
            IValue tup0 = tup.get(0);
            if ((!tup0.getType().isSet() || !idx.equals((Object)tup0)) && !idx.contains(tup0)) continue;
            int i = 1;
            while (i < relArity) {
                args[i - 1] = tup.get(i);
                ++i;
            }
            wset.insert(new IValue[]{this.$VF.tuple(args)});
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel_subscript1_aset(ISet rel, ISet idx) {
        try {
            return new GuardedIValue((IValue)this.$arel_subscript1_aset(rel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final ISet $arel_subscript(ISet rel, IValue[] idx, int[] subsDesc) {
        block17: {
            block16: {
                if (rel.isEmpty()) {
                    return rel;
                }
                indexArity = idx.length;
                relArity = rel.getElementType().getArity();
                wset = this.$VF.setWriter();
                if (relArity - indexArity != 1) break block16;
                block8: for (IValue v : rel) {
                    tup = (ITuple)v;
                    k = 0;
                    while (k < indexArity) {
                        switch (subsDesc[k]) {
                            case 0: {
                                if (!tup.get(k).equals((Object)idx[k])) {
                                    continue block8;
                                }
                                ** GOTO lbl19
                            }
                            case 1: {
                                tup_k = tup.get(k);
                                if ((!tup_k.getType().isSet() || !idx[k].equals((Object)tup_k)) && !((ISet)idx[k]).contains(tup_k)) continue block8;
                            }
lbl19:
                            // 3 sources

                            default: {
                                ++k;
                            }
                        }
                    }
                    wset.insert(new IValue[]{tup.get(indexArity)});
                }
                break block17;
            }
            args = new IValue[relArity - indexArity];
            block10: for (IValue v : rel) {
                tup = (ITuple)v;
                k = 0;
                while (k < indexArity) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (!tup.get(k).equals((Object)idx[k])) {
                                continue block10;
                            }
                            ** GOTO lbl39
                        }
                        case 1: {
                            tup_k = tup.get(k);
                            if ((!tup_k.getType().isSet() || !idx[k].equals((Object)tup_k)) && !((ISet)idx[k]).contains(tup_k)) continue block10;
                        }
lbl39:
                        // 3 sources

                        default: {
                            ++k;
                        }
                    }
                }
                i = indexArity;
                while (i < relArity) {
                    args[i - indexArity] = tup.get(i);
                    ++i;
                }
                wset.insert(new IValue[]{this.$VF.tuple(args)});
            }
        }
        return (ISet)wset.done();
    }

    public final GuardedIValue $guarded_arel_subscript(ISet rel, IValue[] idx, int[] subsDesc) {
        try {
            return new GuardedIValue((IValue)this.$arel_subscript(rel, idx, subsDesc));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $alrel_subscript1_noset(IList lrel, IValue idx) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        if (idx instanceof IInteger) {
            return lrel.get(((IInteger)idx).intValue());
        }
        return lrel.asRelation().index(idx);
    }

    public final GuardedIValue $guarded_alrel_subscript1_noset(IList lrel, IValue idx) {
        try {
            return new GuardedIValue(this.$alrel_subscript1_noset(lrel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel2_subscript1_aset(IList lrel, ISet idx) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        IListWriter wlist = this.$VF.listWriter();
        for (IValue v : lrel) {
            ITuple tup = (ITuple)v;
            if (!idx.contains(tup.get(0))) continue;
            wlist.append(new IValue[]{tup.get(1)});
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel2_subscript1_aset(IList lrel, ISet idx) {
        try {
            return new GuardedIValue((IValue)this.$alrel2_subscript1_aset(lrel, idx));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IList $alrel_subscript1_aset(IList lrel, ISet index) {
        if (lrel.isEmpty()) {
            return lrel;
        }
        int lrelArity = lrel.getElementType().getArity();
        IListWriter wlist = this.$VF.listWriter();
        IValue[] args = new IValue[lrelArity - 1];
        for (IValue v : lrel) {
            ITuple tup = (ITuple)v;
            if (!index.contains(tup.get(0))) continue;
            int i = 1;
            while (i < lrelArity) {
                args[i - 1] = tup.get(i);
                ++i;
            }
            wlist.append(new IValue[]{this.$VF.tuple(args)});
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel_subscript1_aset(IList lrel, ISet index) {
        try {
            return new GuardedIValue((IValue)this.$alrel_subscript1_aset(lrel, index));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final IList $alrel_subscript(IList lrel, IValue[] idx, int[] subsDesc) {
        block17: {
            block16: {
                if (lrel.isEmpty()) {
                    return lrel;
                }
                indexArity = idx.length;
                lrelArity = lrel.getElementType().getArity();
                wlist = this.$VF.listWriter();
                if (lrelArity - indexArity != 1) break block16;
                block8: for (IValue v : lrel) {
                    tup = (ITuple)v;
                    k = 0;
                    while (k < indexArity) {
                        switch (subsDesc[k]) {
                            case 0: {
                                if (!tup.get(k).equals((Object)idx[k])) {
                                    continue block8;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                if (!((ISet)idx[k]).contains(tup.get(k))) continue block8;
                            }
lbl18:
                            // 3 sources

                            default: {
                                ++k;
                            }
                        }
                    }
                    wlist.append(new IValue[]{tup.get(indexArity)});
                }
                break block17;
            }
            args = new IValue[lrelArity - indexArity];
            block10: for (IValue v : lrel) {
                tup = (ITuple)v;
                k = 0;
                while (k < indexArity) {
                    switch (subsDesc[k]) {
                        case 0: {
                            if (!tup.get(k).equals((Object)idx[k])) {
                                continue block10;
                            }
                            ** GOTO lbl37
                        }
                        case 1: {
                            if (!((ISet)idx[k]).contains(tup.get(k))) continue block10;
                        }
lbl37:
                        // 3 sources

                        default: {
                            ++k;
                        }
                    }
                }
                i = indexArity;
                while (i < lrelArity) {
                    args[i - indexArity] = tup.get(i);
                    ++i;
                }
                wlist.append(new IValue[]{this.$VF.tuple(args)});
            }
        }
        return (IList)wlist.done();
    }

    public final GuardedIValue $guarded_alrel_subscript(IList lrel, IValue[] idx, int[] subsDesc) {
        try {
            return new GuardedIValue((IValue)this.$alrel_subscript(lrel, idx, subsDesc));
        }
        catch (Exception e) {
            return this.UNDEFINED;
        }
    }

    public final IValue $iter_subscript(ITree subject, int idx) {
        IList lst = TreeAdapter.getArgs((ITree)subject);
        return lst.get(idx);
    }

    public final IValue $subscript_int(ITuple tup, int idx) {
        return tup.get(idx);
    }

    public final IValue $subscript_int(INode nd, int idx) {
        return nd.get(idx);
    }

    public final IString $subscript_int(IString str, int idx) {
        return str.substring(idx, 1);
    }

    public final IValue $subscript_int(IValue subject, int idx) {
        Type subjectType = subject.getType();
        if (subjectType.isList()) {
            return ((IList)subject).get(idx);
        }
        if (subjectType.isTuple()) {
            return ((ITuple)subject).get(idx);
        }
        if (subjectType.isString()) {
            return ((IString)subject).substring(idx, 1);
        }
        if (subjectType.isAbstractData()) {
            return ((IConstructor)subject).get(idx);
        }
        if (subjectType.isNode()) {
            return ((INode)subject).get(idx);
        }
        throw new RuntimeException("Unsupported subscript of type " + subject.getType());
    }

    public final IValue $lexical_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs((ITree)subject);
        try {
            return args.get(idx >= 0 ? idx : args.length() + idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final IValue $lexical_subscript_seps(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs((ITree)subject);
        try {
            return args.get(idx >= 0 ? 2 * idx : args.length() + 1 + 2 * idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs((ITree)subject);
        try {
            return args.get(idx >= 0 ? 2 * idx : args.length() + 1 + 2 * idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_physical_subscript(ITree subject, int idx) {
        IList args = TreeAdapter.getArgs((ITree)subject);
        try {
            return args.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
        }
    }

    public final IValue $concrete_subscript_seps(ITree subject, int idx) {
        int n;
        IList args = TreeAdapter.getArgs((ITree)subject);
        IConstructor nt = ProductionAdapter.getType((IConstructor)TreeAdapter.getProduction((ITree)subject));
        int delta = SymbolAdapter.getSeparators((IConstructor)nt).size() + 1;
        int n2 = n = idx >= 0 ? delta * idx : args.length() - 1 + delta * (idx + 1);
        if (n >= 0 && n < args.length()) {
            return args.get(n);
        }
        throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(idx));
    }

    public final ITree $concreteSubList(ITree tree, int from, int len, int delta) {
        if (TreeAdapter.isList((ITree)tree)) {
            int actual_len;
            int adjusted_len = len;
            if (len > 0) {
                adjusted_len = len - delta + 1;
            }
            if (from >= (actual_len = tree.getArgs().length())) {
                return TreeAdapter.setArgs((ITree)tree, (IList)this.$VF.list(new IValue[0]));
            }
            return TreeAdapter.setArgs((ITree)tree, (IList)TreeAdapter.getArgs((ITree)tree).sublist(from, adjusted_len));
        }
        throw RuntimeExceptionFactory.illegalArgument((IValue)tree);
    }

    public final IList $alist_update(int n, IValue v, IList lst) {
        if (n < 0) {
            n = lst.length() + n;
        }
        try {
            return lst.put(n, v);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(n));
        }
    }

    public final IMap $amap_update(IValue key, IValue v, IMap map) {
        IMap res = map.put(key, v);
        return res;
    }

    public final ITuple $atuple_update(int n, IValue v, ITuple tup) {
        try {
            return tup.set(n, v);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds((IInteger)this.$VF.integer(n));
        }
    }

    public final IConstructor $aadt_update(IConstructor cons, IString field, IValue v) {
        return cons.set(field.getValue(), v);
    }

    public String $displayTestArgs(IValue[] args) {
        StringBuilder res = new StringBuilder("\n");
        int i = 0;
        while (i < args.length) {
            res.append("arg #").append(i).append(": ").append(args[i]).append("\n");
            ++i;
        }
        return res.toString();
    }

    final IValue $add(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType((Type)lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType((Type)rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).add((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).add((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).add((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).add((IRational)rhs);
                    }
                    case LIST: {
                        return ((IList)rhs).insert(lhs);
                    }
                    case SET: {
                        return ((ISet)rhs).insert(lhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case SET: {
                return ((ISet)lhs).insert(rhs);
            }
            case LIST: {
                return ((IList)lhs).append(rhs);
            }
            case LOC: {
                switch (rhsType) {
                    case STR: {
                        return this.$aloc_add_astr((ISourceLocation)lhs, (IString)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case LREL: {
                switch (rhsType) {
                    case LIST: 
                    case LREL: {
                        return ((IList)lhs).concat((IList)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case MAP: {
                switch (rhsType) {
                    case MAP: {
                        return ((IMap)lhs).compose((IMap)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REL: {
                switch (rhsType) {
                    case SET: 
                    case REL: {
                        return ((ISet)lhs).union((ISet)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case STR: {
                switch (rhsType) {
                    case STR: {
                        return ((IString)lhs).concat((IString)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case TUPLE: {
                switch (rhsType) {
                    case TUPLE: {
                        return this.$atuple_add_atuple((ITuple)lhs, (ITuple)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        switch (rhsType) {
            case LIST: {
                return ((IList)rhs).insert(lhs);
            }
            case SET: {
                return ((ISet)rhs).insert(lhs);
            }
        }
        throw new InternalCompilerError("$RascalModule add: Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $subtract(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType((Type)lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType((Type)rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).subtract((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).subtract((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).subtract((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).subtract((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
    }

    public final IValue $product(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType((Type)lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType((Type)rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return ((IInteger)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IInteger)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IInteger)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IInteger)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return ((INumber)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((INumber)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((INumber)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((INumber)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return ((IReal)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IReal)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IReal)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IReal)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return ((IRational)lhs).multiply((IInteger)rhs);
                    }
                    case NUM: {
                        return ((IRational)lhs).multiply((INumber)rhs);
                    }
                    case REAL: {
                        return ((IRational)lhs).multiply((IReal)rhs);
                    }
                    case RAT: {
                        return ((IRational)lhs).multiply((IRational)rhs);
                    }
                }
                throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $divide(IValue lhs, IValue rhs) {
        ToplevelType lhsType = ToplevelType.getToplevelType((Type)lhs.getType());
        ToplevelType rhsType = ToplevelType.getToplevelType((Type)rhs.getType());
        switch (lhsType) {
            case INT: {
                switch (rhsType) {
                    case INT: {
                        return this.$aint_divide_aint((IInteger)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$aint_divide_anum((IInteger)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$aint_divide_areal((IInteger)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$aint_divide_arat((IInteger)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case NUM: {
                switch (rhsType) {
                    case INT: {
                        return this.$anum_divide_aint((INumber)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$anum_divide_anum((INumber)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$anum_divide_areal((INumber)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$anum_divide_arat((INumber)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case REAL: {
                switch (rhsType) {
                    case INT: {
                        return this.$areal_divide_aint((IReal)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$areal_divide_anum((IReal)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$areal_divide_areal((IReal)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$areal_divide_arat((IReal)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
            case RAT: {
                switch (rhsType) {
                    case INT: {
                        return this.$arat_divide_aint((IRational)lhs, (IInteger)rhs);
                    }
                    case NUM: {
                        return this.$arat_divide_anum((IRational)lhs, (INumber)rhs);
                    }
                    case REAL: {
                        return this.$arat_divide_areal((IRational)lhs, (IReal)rhs);
                    }
                    case RAT: {
                        return this.$arat_divide_arat((IRational)lhs, (IRational)rhs);
                    }
                }
                throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
            }
        }
        throw new InternalCompilerError("$RascalModule divide: Illegal type combination: " + lhsType + " and " + rhsType);
    }

    final IValue $intersect(IValue left, IValue right) {
        Type leftType = left.getType();
        Type rightType = right.getType();
        switch (ToplevelType.getToplevelType((Type)leftType)) {
            case LIST: {
                switch (ToplevelType.getToplevelType((Type)rightType)) {
                    case LIST: 
                    case LREL: {
                        return ((IList)left).intersect((IList)right);
                    }
                }
                throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
            }
            case SET: {
                switch (ToplevelType.getToplevelType((Type)rightType)) {
                    case SET: 
                    case REL: {
                        return ((ISet)left).intersect((ISet)right);
                    }
                }
                throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
            }
            case MAP: {
                return ((IMap)left).common((IMap)right);
            }
        }
        throw new InternalCompilerError("intersect: illegal combination " + leftType + " and " + rightType);
    }

    protected IString $toIString(IValue v) {
        if (v instanceof IString) {
            return (IString)v;
        }
        if (v instanceof ITree) {
            return this.$VF.string(TreeAdapter.yield((IConstructor)((ITree)v)));
        }
        return this.$VF.string(v.toString());
    }
}

