/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.RascalExecutionContext;

public final class ModuleStore {
    private final ConcurrentMap<Class<?>, Object> importedModules = new ConcurrentHashMap();
    private final ConcurrentMap<Map.Entry<Class<?>, Class<?>>, Object> extendedModules = new ConcurrentHashMap();
    private final HashSet<Class<?>> importInProgress = new HashSet();

    public <T> void importModule(Class<T> module, RascalExecutionContext rex, Function<RascalExecutionContext, T> builder) {
        Object result = this.importedModules.get(module);
        if (result == null) {
            if (this.importInProgress.contains(module)) {
                return;
            }
            this.importInProgress.add(module);
            Object newResult = builder.apply(rex);
            this.importedModules.merge(module, newResult, (a, b) -> a == newResult ? b : a);
            this.importInProgress.remove(module);
        }
    }

    public <T> T getModule(Class<T> module) {
        Object newResult = this.importedModules.get(module);
        assert (newResult != null);
        return (T)newResult;
    }

    public <Base, Extension> Base extendModule(Class<Base> baseModule, RascalExecutionContext rex, BiFunction<RascalExecutionContext, Object, Base> builder, Object extension) {
        AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(baseModule, extension.getClass());
        Object ext = this.extendedModules.get(entry);
        if (ext == null) {
            Base newResult = builder.apply(rex, extension);
            entry = new AbstractMap.SimpleEntry(baseModule, extension.getClass());
            this.extendedModules.put(entry, newResult);
            return newResult;
        }
        return (Base)ext;
    }

    public boolean notPresent(Class<?> module) {
        return this.importedModules.get(module) == null && !this.importInProgress.contains(module);
    }

    public <T> void put(Class<T> module, T c) {
        this.importedModules.put(module, c);
    }
}

