/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.ModuleStore;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.RascalRuntimeValueFactory;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.Traverse;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.load.IRascalSearchPathContributor;
import org.rascalmpl.interpreter.load.RascalSearchPath;
import org.rascalmpl.interpreter.load.SourceLocationListContributor;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.project.ProjectURIResolver;
import org.rascalmpl.uri.project.TargetURIResolver;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class RascalExecutionContext
implements IRascalMonitor {
    private String currentModuleName = "UNDEFINED";
    private .RascalModule module;
    private final IRascalValueFactory $RVF;
    private final InputStream instream;
    private final PrintStream outstream;
    private final PrintWriter outwriter;
    private final PrintStream errstream;
    private final PrintWriter errwriter;
    private final PathConfig pcfg;
    private final IDEServices ideServices;
    private final Traverse $TRAVERSE;
    private final ModuleStore mstore;
    private final TypeStore $TS;
    private final TypeFactory $TF;
    private final RascalTypeFactory $RTF;
    private IValueFactory $VF;
    private RascalSearchPath rascalSearchPath;

    public RascalExecutionContext(InputStream instream, PrintStream outstream, PrintStream errstream, PathConfig pcfg, IDEServices ideServices, Class<?> clazz) {
        this.instream = instream;
        this.outstream = outstream;
        this.outwriter = new PrintWriter(outstream);
        this.errstream = errstream;
        this.errwriter = new PrintWriter(errstream);
        this.pcfg = pcfg == null ? new PathConfig() : pcfg;
        this.ideServices = ideServices == null ? new BasicIDEServices(this.errwriter, (IRascalMonitor)this) : ideServices;
        this.$RVF = new RascalRuntimeValueFactory(this);
        this.$VF = ValueFactoryFactory.getValueFactory();
        this.$TF = TypeFactory.getInstance();
        this.$RTF = RascalTypeFactory.getInstance();
        this.$TRAVERSE = new Traverse((IValueFactory)this.$RVF);
        this.mstore = new ModuleStore();
        this.$TS = new TypeStore(new TypeStore[0]);
        this.rascalSearchPath = new RascalSearchPath();
        ISourceLocation projectRoot = RascalExecutionContext.inferProjectRoot(clazz);
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        String projectName = new RascalManifest().getProjectName(projectRoot);
        if (!projectName.isEmpty()) {
            reg.registerLogical((ILogicalSourceLocationResolver)new ProjectURIResolver(projectRoot, projectName));
            reg.registerLogical((ILogicalSourceLocationResolver)new TargetURIResolver(projectRoot, projectName));
        }
        String projectPath = projectRoot.getPath();
        String projectsDirPath = projectPath.substring(0, projectPath.length() - projectName.length() - 1);
        try {
            ISourceLocation projectsDir = this.$RVF.sourceLocation(projectRoot.getScheme(), projectRoot.getAuthority(), projectsDirPath);
            String[] entries = URIResolverRegistry.getInstance().listEntries(projectsDir);
            if (entries != null) {
                String[] stringArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String entryName = stringArray[n2];
                    if (!(entryName.charAt(0) == '.' || entryName.equals("pom-parent") || entryName.equals("bin") || entryName.equals("src") || entryName.equals("META-INF"))) {
                        ISourceLocation entryRoot = this.$RVF.sourceLocation(projectsDir.getScheme(), projectsDir.getAuthority(), String.valueOf(projectsDir.getPath()) + "/" + entryName);
                        if (URIResolverRegistry.getInstance().isDirectory(entryRoot)) {
                            reg.registerLogical((ILogicalSourceLocationResolver)new ProjectURIResolver(entryRoot, entryName));
                            reg.registerLogical((ILogicalSourceLocationResolver)new TargetURIResolver(entryRoot, entryName));
                            this.rascalSearchPath.addPathContributor((IRascalSearchPathContributor)new SourceLocationListContributor(entryName, this.$VF.list(new IValue[]{entryRoot})));
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            return;
        }
        catch (URISyntaxException e) {
            return;
        }
    }

    IRascalValueFactory getRascalRuntimeValueFactory() {
        return this.$RVF;
    }

    public Traverse getTraverse() {
        return this.$TRAVERSE;
    }

    public InputStream getInStream() {
        return this.instream;
    }

    public PrintWriter getOutWriter() {
        return this.outwriter;
    }

    public PrintStream getOutStream() {
        return this.outstream;
    }

    public PrintWriter getErrWriter() {
        return this.errwriter;
    }

    public PrintStream getErrStream() {
        return this.errstream;
    }

    public PathConfig getPathConfig() {
        return this.pcfg;
    }

    public void setModule(.RascalModule module) {
        this.module = module;
    }

    public .RascalModule getModule() {
        return this.module;
    }

    public String getFullModuleName() {
        return this.currentModuleName;
    }

    public String getFullModuleNameAsPath() {
        return String.valueOf(this.currentModuleName.replaceAll("::", "/")) + ".rsc";
    }

    public void setFullModuleName(String moduleName) {
        this.currentModuleName = moduleName;
    }

    public ModuleStore getModuleStore() {
        return this.mstore;
    }

    public TypeStore getTypeStore() {
        return this.$TS;
    }

    public TypeFactory getTypeFactory() {
        return this.$TF;
    }

    public RascalTypeFactory getRascalTypeFactory() {
        return this.$RTF;
    }

    public IValueFactory getIValueFactory() {
        return this.$VF;
    }

    public RascalSearchPath getRascalSearchPath() {
        return this.rascalSearchPath;
    }

    public int jobEnd(String name, boolean succeeded) {
        this.errstream.println(String.valueOf(name) + " ends");
        return 0;
    }

    public void jobStep(String name, String message, int worked) {
    }

    public void jobStart(String name, int workShare, int totalWork) {
        this.errstream.println(String.valueOf(name) + " starts");
    }

    public void jobTodo(String name, int work) {
    }

    public boolean jobIsCanceled(String name) {
        this.errstream.println(String.valueOf(name) + " canceled");
        return true;
    }

    public void warning(String message, ISourceLocation src) {
        this.errstream.println(message);
    }

    public static ISourceLocation inferProjectRoot(Class<?> clazz) {
        try {
            String file = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (file.endsWith(".jar")) {
                throw new IllegalArgumentException("can not run Rascal JUnit tests from within a jar file");
            }
            File current = new File(file);
            while (current != null && current.exists() && current.isDirectory()) {
                if (new File(current, "META-INF/RASCAL.MF").exists()) {
                    if (current.getName().equals("classes") && current.getParentFile().getName().equals("target")) {
                        current = current.getParentFile().getParentFile();
                        continue;
                    }
                    return URIUtil.createFileLocation((String)current.getAbsolutePath());
                }
                current = current.getParentFile();
            }
        }
        catch (URISyntaxException e) {
            System.err.println("[ERROR] can not infer project root:" + e);
            return null;
        }
        return null;
    }

    public void endAllJobs() {
        this.ideServices.endAllJobs();
    }
}

