/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.control_exceptions.Filtered;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalFunctionActionExecutor
implements IActionExecutor<ITree> {
    private final boolean isPure;
    private List<IFunction> filters;

    public RascalFunctionActionExecutor(ISet functions, boolean isPure) {
        this.isPure = isPure;
        assert (!functions.isEmpty());
        this.filters = functions.stream().map(v -> (IFunction)v).collect(Collectors.toList());
    }

    public void completed(Object environment, boolean filtered) {
    }

    public Object createRootEnvironment() {
        return new Object();
    }

    public Object enteringListNode(Object production, int index, Object environment) {
        return environment;
    }

    public Object enteringListProduction(Object production, Object env) {
        return env;
    }

    public Object enteringNode(Object production, int index, Object environment) {
        return environment;
    }

    public Object enteringProduction(Object production, Object env) {
        return env;
    }

    public void exitedListProduction(Object production, boolean filtered, Object environment) {
    }

    public void exitedProduction(Object production, boolean filtered, Object environment) {
    }

    public ITree filterAmbiguity(ITree ambCluster, Object environment) {
        if (!TreeAdapter.isAmb((ITree)ambCluster)) {
            return ambCluster;
        }
        if (TreeAdapter.getAlternatives((ITree)ambCluster).size() == 0) {
            return null;
        }
        if (this.filters == null) {
            return ambCluster;
        }
        Iterator<IFunction> iterator = this.filters.iterator();
        if (iterator.hasNext()) {
            IFunction f = iterator.next();
            try {
                ITree result = (ITree)f.call(new IValue[]{ambCluster});
                if (!TreeAdapter.isAmb((ITree)result)) {
                    return result;
                }
                if (TreeAdapter.getAlternatives((ITree)result).size() == 1) {
                    return (ITree)TreeAdapter.getAlternatives((ITree)result).iterator().next();
                }
                return result;
            }
            catch (MatchFailed m) {
                return ambCluster;
            }
            catch (Throw t) {
                IValue exc = t.getException();
                if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                    return ambCluster;
                }
                throw t;
            }
            catch (Filtered x) {
                return null;
            }
        }
        return ambCluster;
    }

    public ITree filterCycle(ITree cycle, Object environment) {
        return cycle;
    }

    public ITree filterListAmbiguity(ITree ambCluster, Object environment) {
        return this.filterAmbiguity(ambCluster, environment);
    }

    public ITree filterListCycle(ITree cycle, Object environment) {
        return cycle;
    }

    public ITree filterListProduction(ITree tree, Object environment) {
        return tree;
    }

    public ITree filterProduction(ITree tree, Object environment) {
        if (this.filters == null) {
            return tree;
        }
        Iterator<IFunction> iterator = this.filters.iterator();
        if (iterator.hasNext()) {
            IFunction f = iterator.next();
            try {
                ITree result = (ITree)f.call(new IValue[]{tree});
                if (!TreeAdapter.isAmb((ITree)result)) {
                    return result;
                }
                if (TreeAdapter.getAlternatives((ITree)result).size() == 1) {
                    return (ITree)TreeAdapter.getAlternatives((ITree)result).iterator().next();
                }
                return result;
            }
            catch (MatchFailed m) {
                return tree;
            }
            catch (Throw t) {
                IValue exc = t.getException();
                if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                    return tree;
                }
                throw t;
            }
            catch (Filtered x) {
                return null;
            }
        }
        return tree;
    }

    public boolean isImpure(Object rhs) {
        return !this.isPure;
    }
}

