/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.ReturnFromTraversalException;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.TraversalState;
import org.rascalmpl.values.parsetrees.ITree;

public abstract class TraverseOnce {
    protected final IValueFactory vf;

    public TraverseOnce(IValueFactory vf) {
        this.vf = vf;
    }

    public IValue traverseTop(IValue subject, TraversalState tr) {
        IValue res = tr.execute(subject);
        if (tr.isLeavingVisit()) {
            throw new ReturnFromTraversalException(res);
        }
        return res;
    }

    abstract IValue traverseStringOnce(IValue var1, TraversalState var2);

    abstract IValue traverseTupleOnce(IValue var1, TraversalState var2);

    abstract IValue traverseADTOnce(IValue var1, TraversalState var2);

    abstract IValue traverseConcreteTreeOnce(IValue var1, TraversalState var2);

    abstract IValue traverseMapOnce(IValue var1, TraversalState var2);

    abstract IValue traverseSetOnce(IValue var1, TraversalState var2);

    abstract IValue traverseListOnce(IValue var1, TraversalState var2);

    abstract IValue traverseNodeOnce(IValue var1, TraversalState var2);

    private IValue traverseOnce(Type subjectType, IValue subject, TraversalState tr) {
        if (subjectType.isAbstractData()) {
            return this.traverseADTOnce(subject, tr);
        }
        if (subjectType.isNode()) {
            return this.traverseNodeOnce(subject, tr);
        }
        if (subjectType.isList()) {
            return this.traverseListOnce(subject, tr);
        }
        if (subjectType.isSet()) {
            return this.traverseSetOnce(subject, tr);
        }
        if (subjectType.isMap()) {
            return this.traverseMapOnce(subject, tr);
        }
        if (subjectType.isTuple()) {
            return this.traverseTupleOnce(subject, tr);
        }
        return subject;
    }

    public IValue traverseOnceBottomUpContinuingFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        if (tr.hasChanged()) {
            do {
                tr.setMatchedAndChanged(false, false);
                result = this.traverseTop(result, tr);
            } while (tr.hasChanged());
            tr.setMatchedAndChanged(true, true);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpContinuingFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        if (tr.hasChanged()) {
            do {
                tr.setMatchedAndChanged(false, false);
                result = this.traverseTop(result, tr);
            } while (tr.hasChanged());
            tr.setMatchedAndChanged(true, true);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpContinuingNoFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpContinuingNoFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpBreakingFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        if (tr.hasMatched()) {
            return result;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        if (tr.hasChanged()) {
            do {
                tr.setMatchedAndChanged(false, false);
                result = this.traverseTop(result, tr);
            } while (tr.hasChanged());
            tr.setMatchedAndChanged(true, true);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpBreakingFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        if (tr.hasMatched()) {
            return result;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        if (tr.hasChanged()) {
            do {
                tr.setMatchedAndChanged(false, false);
                result = this.traverseTop(result, tr);
            } while (tr.hasChanged());
            tr.setMatchedAndChanged(true, true);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpBreakingNoFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        if (tr.hasMatched()) {
            return result;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceBottomUpBreakingNoFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        if (tr.hasMatched()) {
            return result;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        result = this.traverseTop(result, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownContinuingFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasChanged()) {
            do {
                tr.setChanged(false);
                newTop = this.traverseTop(newTop, tr);
            } while (tr.hasChanged());
            tr.setChanged(true);
            subject = newTop;
        } else {
            subject = newTop;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownContinuingFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasChanged()) {
            do {
                tr.setChanged(false);
                newTop = this.traverseTop(newTop, tr);
            } while (tr.hasChanged());
            tr.setChanged(true);
            subject = newTop;
        } else {
            subject = newTop;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownContinuingNoFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        subject = this.traverseTop(subject, tr);
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownContinuingNoFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        subject = this.traverseTop(subject, tr);
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownBreakingFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasMatched()) {
            return newTop;
        }
        if (tr.hasChanged()) {
            do {
                tr.setChanged(false);
                newTop = this.traverseTop(newTop, tr);
            } while (tr.hasChanged());
            tr.setChanged(true);
            subject = newTop;
        } else {
            subject = newTop;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownBreakingFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasMatched()) {
            return newTop;
        }
        if (tr.hasChanged()) {
            do {
                tr.setChanged(false);
                newTop = this.traverseTop(newTop, tr);
            } while (tr.hasChanged());
            tr.setChanged(true);
            subject = newTop;
        } else {
            subject = newTop;
        }
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownBreakingNoFixedPointConcrete(IValue subject, TraversalState tr) {
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasMatched()) {
            return newTop;
        }
        subject = newTop;
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInConcreteValue((ITree)subject)) {
            result = this.traverseConcreteTreeOnce(subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }

    public IValue traverseOnceTopDownBreakingNoFixedPointAbstract(IValue subject, TraversalState tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue newTop = this.traverseTop(subject, tr);
        if (tr.hasMatched()) {
            return newTop;
        }
        subject = newTop;
        hasMatched = tr.hasMatched();
        hasChanged = tr.hasChanged();
        if (tr.shouldDescentInAbstractValue(subject)) {
            result = this.traverseOnce(subjectType, subject, tr);
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return result;
    }
}

