/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.Iterator;
import java.util.Map;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.ITraverseSpecialization;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.TraversalState;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.traverse.TraverseOnce;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class TraverseOnceNoRebuild
extends TraverseOnce
implements ITraverseSpecialization {
    public TraverseOnceNoRebuild(IValueFactory vf) {
        super(vf);
    }

    @Override
    public IValue traverseTupleOnce(IValue subject, TraversalState tr) {
        ITuple tuple = (ITuple)subject;
        int arity = tuple.arity();
        boolean hasMatched = false;
        boolean hasChanged = false;
        int i = 0;
        while (i < arity) {
            tr.setMatchedAndChanged(false, false);
            tr.traverse.once(tuple.get(i), tr);
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
            ++i;
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return subject;
    }

    @Override
    public IValue traverseADTOnce(IValue subject, TraversalState tr) {
        IConstructor cons = (IConstructor)subject;
        boolean hasKwParams = cons.mayHaveKeywordParameters() && cons.asWithKeywordParameters().hasParameters();
        int arity = cons.arity();
        if (arity == 0 && !hasKwParams) {
            return subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        int i = 0;
        while (i < arity) {
            IValue child = cons.get(i);
            tr.setMatchedAndChanged(false, false);
            child = tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
            ++i;
        }
        if (hasKwParams) {
            IWithKeywordParameters consKw = cons.asWithKeywordParameters();
            for (String kwName : consKw.getParameterNames()) {
                IValue val = consKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(val, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return subject;
    }

    @Override
    public IValue traverseConcreteTreeOnce(IValue subject, TraversalState tr) {
        ITree tree = (ITree)subject;
        IList list = TreeAdapter.getArgs((ITree)tree);
        int len = list.length();
        if (len > 0) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            if (TreeAdapter.isTop((ITree)tree)) {
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(0), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(1), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(2), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            } else {
                int i = 0;
                while (i < len) {
                    IValue elem = list.get(i);
                    if (i % 2 == 0) {
                        tr.setMatchedAndChanged(false, false);
                        tr.traverse.once(elem, tr);
                        hasChanged |= tr.hasChanged();
                        hasMatched |= tr.hasMatched();
                    }
                    ++i;
                }
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
        }
        return subject;
    }

    @Override
    public IValue traverseMapOnce(IValue subject, TraversalState tr) {
        IMap map = (IMap)subject;
        if (!map.isEmpty()) {
            Iterator iter = map.entryIterator();
            boolean hasChanged = false;
            boolean hasMatched = false;
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once((IValue)entry.getKey(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once((IValue)entry.getValue(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseSetOnce(IValue subject, TraversalState tr) {
        ISet set = (ISet)subject;
        if (!set.isEmpty()) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (IValue v : set) {
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(v, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseListOnce(IValue subject, TraversalState tr) {
        IList list = (IList)subject;
        int len = list.length();
        if (len > 0) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            int i = 0;
            while (i < len) {
                IValue elem = list.get(i);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(elem, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                ++i;
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseNodeOnce(IValue subject, TraversalState tr) {
        boolean hasKwParams;
        IValue result = subject;
        INode node = (INode)subject;
        int arity = node.arity();
        boolean bl = hasKwParams = node.mayHaveKeywordParameters() && node.asWithKeywordParameters().hasParameters();
        if (arity == 0 && !hasKwParams) {
            result = subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        int i = 0;
        while (i < arity) {
            IValue child = node.get(i);
            tr.setMatchedAndChanged(false, false);
            tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
            ++i;
        }
        if (hasKwParams) {
            IWithKeywordParameters nodeKw = node.asWithKeywordParameters();
            for (String kwName : nodeKw.getParameterNames()) {
                IValue val2 = nodeKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(val2, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return result;
    }

    @Override
    public IValue traverseStringOnce(IValue subject, TraversalState tr) {
        boolean hasMatched = tr.hasMatched();
        boolean hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        IValue res = this.traverseString(subject, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return res;
    }

    private IValue traverseString(IValue subject, TraversalState tr) {
        IString subjectIString = (IString)subject;
        String subjectString = subjectIString.getValue();
        int len = subjectString.length();
        int subjectCursor = 0;
        boolean hasMatched = false;
        boolean hasChanged = false;
        while (subjectCursor < len) {
            tr.setMatchedAndChanged(false, false);
            tr.setBegin(0);
            tr.setEnd(len);
            this.traverseTop((IValue)this.vf.string(subjectString.substring(subjectCursor, len)), tr);
            subjectCursor = tr.hasMatched() ? (subjectCursor += tr.getEnd()) : ++subjectCursor;
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return subject;
    }
}

