/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils;

import io.usethesource.vallang.IValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils.JavaCompiler;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils.JavaCompilerException;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.library.util.PathConfig;

public class ExecutionTools<T> {
    private JavaCompiler<T> javaCompiler;
    private Map<String, Class<T>> classCache;

    ExecutionTools(PathConfig pcfg) {
        ClassLoader loader = null;
        this.javaCompiler = new JavaCompiler(loader, null, null);
        this.classCache = new HashMap<String, Class<T>>();
    }

    String interfaceName(String className) {
        int idx = className.lastIndexOf(".");
        if (idx < 0) {
            return "$" + className;
        }
        return String.valueOf(className.substring(0, idx)) + ".$" + className.substring(idx + 1);
    }

    public Class<T> compile(String className, String interfaceModule, String classModule, DiagnosticCollector<JavaFileObject> diagnostics) {
        try {
            HashMap<String, CharSequence> classes = new HashMap<String, CharSequence>();
            String interfaceName = this.interfaceName(className);
            classes.put(interfaceName, interfaceModule);
            classes.put(className, classModule);
            Map<String, Class<T>> clazzes = this.javaCompiler.compile(classes, diagnostics);
            Class<T> the_class = clazzes.get(className);
            Class<T> the_interface = clazzes.get(interfaceName);
            this.classCache.put(className, the_class);
            this.classCache.put(interfaceName, the_interface);
            return the_class;
        }
        catch (JavaCompilerException e) {
            if (!e.getDiagnostics().getDiagnostics().isEmpty()) {
                Diagnostic<JavaFileObject> msg = e.getDiagnostics().getDiagnostics().iterator().next();
                throw new JavaCompilation(msg.getMessage(null), msg.getLineNumber(), msg.getColumnNumber(), interfaceModule, classModule, (Exception)e);
            }
            throw new JavaCompilation(e.getMessage(), 0L, 0L, interfaceModule, classModule, (Exception)e);
        }
    }

    public IValue executeProgram(String className, Map<String, IValue> keywordArguments) {
        Class<T> clazz = this.classCache.get(className);
        if (clazz == null) {
            throw new RuntimeException("Not available: " + className);
        }
        try {
            Method m = clazz.getMethod("main", String[].class);
            Object[] _args = new Object[]{new String[0]};
            try {
                return (IValue)m.invoke(null, _args);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String iface = "public interface $Test { }";
        String program = "public class Test implements $Test {   public static void main (String [] args){      System.out.println (\"Hello, World\");      System.out.println (args.length);   }}";
        PathConfig pcfg = new PathConfig();
        ExecutionTools exec = new ExecutionTools(pcfg);
        exec.compile("Test", iface, program, null);
        exec.executeProgram("Test", null);
    }
}

