/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils.JavaCompiler;
import org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils.JavaCompilerException;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.library.util.PathConfig;

public class JavaBridge {
    private String javaCompilerPath;

    public JavaBridge(List<ClassLoader> classLoaders, PathConfig config) {
        StringBuilder sw = new StringBuilder();
        for (IValue v : config.getJavaCompilerPath()) {
            if (sw.length() > 0) {
                sw.append(":");
            }
            sw.append(v.toString());
        }
        this.javaCompilerPath = sw.toString();
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new ImplementationError("Could not find an installed System Java Compiler, please provide a Java Runtime that includes the Java Development Tools (JDK 1.6 or higher).");
        }
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, String source) {
        return this.compileJava(loc, className, this.getClass(), source);
    }

    public <T> Class<T> compileJava(ISourceLocation loc, String className, Class<?> parent, String source) {
        try {
            List<String> commandline = Arrays.asList("-proc:none", "-cp", this.javaCompilerPath);
            JavaCompiler javaCompiler = new JavaCompiler(parent.getClassLoader(), null, commandline);
            Class result = javaCompiler.compile(className, source, null, Object.class);
            return result;
        }
        catch (ClassCastException e) {
            throw new JavaCompilation(e.getMessage(), 0L, 0L, className, className, (Exception)e);
        }
        catch (JavaCompilerException e) {
            if (!e.getDiagnostics().getDiagnostics().isEmpty()) {
                Diagnostic<JavaFileObject> msg = e.getDiagnostics().getDiagnostics().iterator().next();
                throw new JavaCompilation(msg.getMessage(null), msg.getLineNumber(), msg.getColumnNumber(), className, this.javaCompilerPath, (Exception)e);
            }
            throw new JavaCompilation(e.getMessage(), 0L, 0L, className, this.javaCompilerPath, (Exception)e);
        }
    }
}

