/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.core.library.lang.rascalcore.compile.runtime.utils;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.Iterator;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.values.ValueFactoryFactory;

class SubSetIterator
implements Iterator<ISet> {
    private static final IValueFactory $VF = ValueFactoryFactory.getValueFactory();
    private long n;
    private final int len;
    private final long max;
    private final IValue[] setElems;

    SubSetIterator(ISet s) {
        this.len = s.size();
        if (this.len >= 64) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)s, (String)"SubSetIterator can only handle sets with less than 64 elements");
        }
        this.n = 0L;
        this.max = 1L << this.len;
        this.setElems = new IValue[this.len];
        int i = 0;
        for (IValue elm : s) {
            this.setElems[i++] = elm;
        }
    }

    @Override
    public boolean hasNext() {
        return this.n < this.max;
    }

    @Override
    public ISet next() {
        ISetWriter w = $VF.setWriter();
        int j = 0;
        while (j < this.len) {
            if ((this.n & 1L << j) > 0L) {
                w.insert(new IValue[]{this.setElems[j]});
            }
            ++j;
        }
        ++this.n;
        return (ISet)w.done();
    }
}

