module lang::rascalcore::grammar::tests::Compare

import IO;
import List;
import String;
import Set;

value main() = compare3();

value compare1() {
 INT = split("\n", readFile(|std:///lang/rascal/grammar/tests/generated_parsers/CParserINT.java|));
 COMP = split("\n", readFile(|std://lang/rascal/grammar/tests/generated_parsers/CParserCOMP.java|));
 
 INTSET = toSet(INT);
 COMPSET = toSet(COMP);
 println("INT: <size(INT)> lines, COMP <size(COMP)> lines");
 println("INT - COMP : <size(INT - COMP)> lines, COMP - INT <size(COMP - INT)> lines");
 
 println("INT - COMP:");
 iprintln(INT-COMP);
 
 println("COMP - INT:");
 iprintln(COMP - INT);
 
 
 println("INTSET: <size(INTSET)> lines, COMPSET <size(COMPSET)> lines");
 println("INTSET - COMPSET : <size(INTSET - COMPSET)> lines, COMPSET - INTSET <size(COMPSET - INTSET)> lines");
 
 println("INTSET - COMPSET:");
 iprintln(INTSET-COMPSET);
 
 println("COMPSET - INTSET:");
 iprintln(COMPSET - INTSET);
 
 return true;
}

void compare2(){
dontNestCOMP = {<284,367>,<344,474>,<284,474>,<257,288>,<284,468>,<344,468>,<354,373>,<273,407>,<294,336>,<319,336>,<219,391>,<348,438>,<302,474>,<348,342>,<240,414>,<361,444>,<306,379>,<344,367>,<440,426>,<452,438>,<440,420>,<281,348>,<261,456>,<189,288>,<240,407>,<277,481>,<385,426>,<385,420>,<407,474>,<302,367>,<288,456>,<253,336>,<350,462>,<325,397>,<297,316>,<273,414>,<166,397>,<407,468>,<288,391>,<261,391>,<189,261>,<312,361>,<422,432>,<323,438>,<332,450>,<323,342>,<166,354>,<281,426>,<219,456>,<277,294>,<281,420>,<247,288>,<177,462>,<281,310>,<325,354>,<302,468>,<281,323>,<434,468>,<434,474>,<323,414>,<363,474>,<416,468>,<464,450>,<294,316>,<336,481>,<348,407>,<257,444>,<363,468>,<297,336>,<452,414>,<253,316>,<338,397>,<393,450>,<416,474>,<354,432>,<348,414>,<240,438>,<240,342>,<265,294>,<195,361>,<381,420>,<189,444>,<381,426>,<219,265>,<189,281>,<323,407>,<247,444>,<391,444>,<379,432>,<273,342>,<273,438>,<265,481>,<316,385>,<166,247>,<203,379>,<195,302>,<350,414>,<247,361>,<344,450>,<332,367>,<375,444>,<306,348>,<257,302>,<277,397>,<189,302>,<281,379>,<332,474>,<316,432>,<325,481>,<407,450>,<273,462>,<166,481>,<177,407>,<470,432>,<354,385>,<284,450>,<438,481>,<240,462>,<189,361>,<203,323>,<387,420>,<387,426>,<357,444>,<277,354>,<166,294>,<342,336>,<195,444>,<235,336>,<399,456>,<257,361>,<290,316>,<379,385>,<332,468>,<247,302>,<350,407>,<195,281>,<306,420>,<177,414>,<306,426>,<302,450>,<312,444>,<323,462>,<219,240>,<306,323>,<203,273>,<336,397>,<290,336>,<336,354>,<316,373>,<393,474>,<416,450>,<338,481>,<393,468>,<363,450>,<452,462>,<316,329>,<361,361>,<434,450>,<348,462>,<203,348>,<195,288>,<474,481>,<464,474>,<310,456>,<329,456>,<203,420>,<203,426>,<203,310>,<235,316>,<195,261>,<464,468>,<310,391>,<329,391>,<265,397>,<350,438>,<177,342>,<265,354>,<177,438>,<219,261>,<428,474>,<257,456>,<235,468>,<410,450>,<195,240>,<177,397>,<273,294>,<391,391>,<306,385>,<247,391>,<277,407>,<367,468>,<240,481>,<354,426>,<354,420>,<261,288>,<458,474>,<381,432>,<203,235>,<189,456>,<281,373>,<277,414>,<319,450>,<342,468>,<294,450>,<288,288>,<336,438>,<336,342>,<166,462>,<257,391>,<325,462>,<342,474>,<273,481>,<240,294>,<177,354>,<281,329>,<235,474>,<367,367>,<265,438>,<350,397>,<265,342>,<369,450>,<458,468>,<428,468>,<189,391>,<379,426>,<379,420>,<219,288>,<397,450>,<367,474>,<235,367>,<354,348>,<247,456>,<391,456>,<342,367>,<253,450>,<452,481>,<385,432>,<373,468>,<261,444>,<373,474>,<336,407>,<323,481>,<1441,1475>,<336,414>,<446,468>,<219,281>,<361,456>,<189,265>,<203,385>,<297,450>,<288,444>,<338,462>,<329,361>,<348,481>,<310,361>,<290,474>,<177,247>,<265,407>,<290,468>,<281,432>,<219,444>,<361,391>,<316,379>,<422,420>,<446,474>,<265,414>,<422,426>,<440,432>,<277,438>,<290,367>,<277,342>,<428,450>,<219,361>,<195,265>,<235,450>,<288,361>,<284,336>,<273,354>,<319,474>,<294,474>,<385,385>,<354,379>,<325,414>,<306,329>,<273,397>,<302,336>,<166,414>,<312,456>,<350,481>,<458,450>,<369,468>,<369,474>,<288,302>,<294,468>,<306,373>,<177,294>,<240,354>,<319,468>,<342,450>,<261,302>,<253,367>,<312,391>,<277,462>,<253,474>,<261,361>,<379,379>,<367,450>,<310,444>,<329,444>,<240,397>,<397,474>,<281,385>,<410,474>,<338,438>,<219,302>,<316,323>,<410,468>,<319,367>,<166,407>,<294,367>,<253,468>,<177,481>,<203,432>,<397,468>,<325,407>,<323,397>,<189,240>,<203,373>,<338,414>,<373,450>,<297,468>,<336,462>,<265,462>,<316,348>,<297,367>,<470,426>,<470,420>,<203,329>,<203,253>,<302,316>,<348,397>,<375,456>,<284,316>,<316,310>,<316,420>,<446,450>,<348,354>,<316,426>,<387,432>,<357,456>,<338,407>,<195,456>,<399,444>,<306,432>,<297,474>,<357,391>,<195,391>,<323,354>,<166,438>,<166,342>,<325,438>,<325,342>,<290,450>,<375,391>,<325,444>,<336,361>,<166,444>,<342,385>,<253,329>,<265,302>,<354,336>,<387,468>,<294,329>,<195,294>,<265,361>,<177,265>,<235,385>,<294,373>,<319,373>,<306,468>,<387,474>,<367,385>,<281,450>,<1495,1534>,<332,426>,<332,420>,<189,247>,<1206,1225>,<440,450>,<357,481>,<302,379>,<195,481>,<361,397>,<310,414>,<329,414>,<306,474>,<297,432>,<375,481>,<344,379>,<306,367>,<253,373>,<399,438>,<284,379>,<385,450>,<166,281>,<310,407>,<329,407>,<363,379>,<166,288>,<177,456>,<219,462>,<397,432>,<203,474>,<189,354>,<277,361>,<177,391>,<166,261>,<277,302>,<297,373>,<369,432>,<247,354>,<350,456>,<312,481>,<373,385>,<391,397>,<410,432>,<247,397>,<203,468>,<253,432>,<464,420>,<464,426>,<399,414>,<257,354>,<288,462>,<399,407>,<290,385>,<338,444>,<381,450>,<257,397>,<350,391>,<1453,1475>,<393,420>,<261,462>,<393,426>,<310,438>,<294,432>,<329,438>,<203,367>,<319,432>,<329,342>,<310,342>,<189,397>,<297,329>,<253,385>,<302,310>,<235,373>,<440,474>,<290,432>,<348,391>,<281,367>,<385,468>,<369,385>,<357,397>,<329,462>,<310,462>,<446,432>,<261,438>,<261,342>,<195,397>,<440,468>,<361,481>,<235,329>,<177,240>,<281,474>,<288,342>,<332,379>,<288,438>,<338,361>,<387,450>,<284,348>,<265,288>,<281,468>,<302,426>,<302,420>,<342,373>,<306,450>,<323,456>,<344,420>,<344,426>,<284,426>,<284,420>,<284,310>,<316,316>,<219,342>,<219,438>,<407,426>,<367,373>,<407,420>,<385,474>,<294,385>,<319,385>,<375,397>,<348,456>,<323,391>,<195,354>,<452,456>,<302,348>,<373,432>,<277,444>,<240,391>,<265,444>,<166,361>,<325,361>,<277,288>,<235,432>,<261,407>,<302,323>,<367,432>,<399,462>,<288,407>,<290,373>,<240,456>,<373,373>,<290,329>,<219,414>,<312,354>,<257,294>,<391,481>,<247,481>,<297,385>,<336,444>,<203,450>,<189,294>,<166,302>,<195,247>,<416,420>,<416,426>,<458,432>,<273,456>,<381,474>,<428,432>,<312,397>,<219,407>,<257,481>,<284,323>,<316,336>,<434,420>,<247,294>,<434,426>,<273,391>,<381,468>,<288,414>,<363,426>,<363,420>,<342,432>,<261,414>,<189,481>,<235,379>,<281,336>,<177,444>,<357,414>,<361,462>,<195,414>,<302,385>,<375,407>,<393,432>,<369,420>,<338,391>,<369,426>,<350,444>,<342,379>,<253,420>,<253,426>,<297,323>,<312,342>,<312,438>,<253,310>,<464,432>,<166,265>,<397,420>,<323,361>,<397,426>,<367,379>,<379,450>,<410,420>,<294,348>,<319,348>,<410,426>,<329,481>,<177,281>,<310,481>,<348,361>,<319,426>,<294,426>,<375,414>,<319,420>,<294,420>,<219,247>,<294,310>,<203,257>,<338,456>,<195,407>,<332,373>,<284,385>,<354,450>,<432,481>,<344,385>,<253,348>,<357,407>,<325,456>,<426,481>,<273,361>,<297,310>,<375,438>,<325,391>,<288,397>,<281,316>,<357,438>,<219,354>,<166,456>,<316,367>,<312,414>,<297,348>,<312,407>,<219,397>,<332,432>,<391,462>,<247,462>,<177,288>,<316,474>,<422,450>,<297,420>,<297,426>,<253,323>,<240,302>,<261,354>,<288,354>,<177,261>,<316,468>,<399,481>,<257,462>,<166,391>,<189,462>,<240,361>,<195,342>,<195,438>,<470,474>,<261,397>,<290,379>,<294,323>,<373,379>,<273,302>,<363,385>,<470,468>,<265,391>,<265,456>,<336,456>,<203,277>,<342,348>,<284,329>,<354,474>,<416,432>,<363,432>,<354,468>,<253,379>,<344,373>,<284,373>,<189,342>,<189,438>,<195,462>,<379,474>,<240,444>,<361,414>,<332,385>,<357,462>,<329,397>,<310,397>,<367,426>,<336,391>,<367,420>,<257,438>,<257,342>,<354,367>,<379,468>,<235,348>,<319,379>,<294,379>,<428,420>,<428,426>,<273,444>,<458,426>,<458,420>,<247,342>,<247,438>,<391,438>,<306,336>,<302,329>,<235,310>,<203,316>,<369,379>,<342,426>,<342,420>,<302,373>,<166,240>,<235,426>,<375,462>,<235,420>,<361,407>,<310,354>,<329,354>,<434,432>,<290,323>,<257,407>,<240,288>,<288,294>,<350,361>,<363,373>,<177,361>,<273,288>,<257,414>,<288,481>,<348,444>,<446,426>,<316,450>,<446,420>,<422,474>,<219,481>,<297,379>,<422,468>,<247,414>,<391,414>,<302,432>,<261,294>,<177,302>,<470,450>,<203,336>,<235,323>,<407,432>,<277,391>,<312,462>,<284,432>,<323,444>,<247,407>,<290,310>,<391,407>,<444,481>,<344,432>,<290,426>,<290,420>,<373,426>,<452,444>,<219,294>,<373,420>,<277,456>,<361,438>,<456,481>,<189,414>,<261,481>,<290,348>,<189,407>,<277,379>,<195,367>,<166,273>,<306,481>,<261,316>,<470,438>,<219,277>,<297,456>,<325,348>,<195,468>,<387,481>,<350,373>,<219,316>,<354,462>,<166,310>,<375,474>,<325,426>,<325,420>,<281,354>,<166,420>,<166,426>,<177,329>,<332,444>,<281,397>,<240,385>,<357,474>,<297,391>,<288,316>,<379,462>,<195,474>,<361,450>,<166,348>,<357,468>,<316,342>,<316,438>,<375,468>,<177,373>,<273,385>,<177,253>,<385,397>,<312,468>,<348,385>,<253,456>,<410,456>,<265,379>,<336,379>,<261,336>,<253,391>,<288,336>,<312,474>,<166,323>,<323,385>,<350,432>,<470,414>,<294,391>,<319,391>,<219,336>,<247,450>,<391,450>,<422,462>,<284,361>,<464,444>,<397,456>,<344,361>,<302,302>,<203,481>,<177,432>,<312,367>,<316,414>,<319,456>,<462,481>,<294,456>,<316,407>,<393,444>,<257,450>,<381,397>,<203,294>,<189,450>,<338,420>,<338,426>,<369,391>,<369,456>,<302,361>,<354,407>,<281,481>,<379,414>,<361,474>,<379,407>,<219,257>,<265,323>,<195,450>,<361,468>,<440,481>,<357,450>,<446,456>,<387,397>,<177,385>,<273,373>,<273,329>,<306,397>,<277,348>,<302,444>,<361,367>,<407,444>,<284,444>,<373,391>,<344,444>,<323,432>,<422,438>,<306,354>,<240,373>,<290,456>,<373,456>,<281,294>,<277,420>,<452,432>,<277,426>,<350,385>,<240,329>,<277,310>,<385,481>,<290,391>,<375,450>,<348,432>,<325,379>,<354,414>,<166,379>,<203,247>,<310,336>,<329,336>,<316,462>,<203,397>,<189,367>,<323,329>,<312,450>,<336,348>,<434,444>,<323,373>,<240,432>,<367,456>,<247,474>,<391,474>,<257,367>,<348,373>,<265,420>,<265,426>,<422,414>,<336,426>,<302,288>,<336,420>,<367,391>,<391,468>,<247,468>,<265,310>,<470,462>,<277,323>,<203,354>,<428,456>,<458,456>,<273,432>,<189,474>,<379,438>,<338,379>,<257,474>,<414,481>,<332,361>,<310,316>,<342,391>,<416,444>,<1191,1225>,<235,391>,<363,444>,<257,468>,<342,456>,<381,481>,<177,235>,<235,456>,<247,367>,<265,348>,<189,468>,<354,438>,<354,342>,<369,444>,<306,407>,<177,273>,<397,444>,<440,462>,<354,354>,<166,373>,<385,462>,<387,407>,<393,456>,<247,316>,<329,367>,<203,438>,<310,367>,<203,342>,<277,385>,<350,426>,<350,420>,<306,414>,<177,420>,<177,426>,<166,329>,<189,316>,<410,444>,<177,310>,<281,462>,<290,361>,<257,316>,<379,397>,<253,444>,<329,474>,<240,379>,<464,456>,<310,474>,<329,468>,<310,468>,<387,414>,<325,373>,<166,253>,<338,432>,<189,277>,<319,444>,<294,444>,<354,397>,<273,379>,<177,348>,<247,336>,<253,288>,<203,414>,<235,361>,<189,336>,<381,462>,<387,438>,<261,450>,<306,342>,<306,438>,<399,474>,<219,450>,<332,456>,<338,373>,<177,323>,<342,361>,<332,391>,<257,336>,<297,444>,<336,385>,<316,481>,<265,385>,<399,468>,<323,379>,<288,450>,<294,288>,<235,302>,<367,361>,<325,432>,<348,379>,<203,407>,<166,432>,<195,257>,<470,481>,<381,438>,<387,462>,<306,462>,<265,432>,<379,481>,<189,257>,<336,432>,<240,348>,<363,391>,<416,456>,<273,310>,<323,323>,<166,385>,<297,361>,<420,481>,<310,450>,<329,450>,<273,348>,<177,379>,<367,444>,<440,414>,<240,310>,<385,407>,<240,426>,<240,420>,<277,329>,<281,414>,<277,373>,<273,426>,<458,444>,<273,420>,<281,407>,<428,444>,<325,385>,<434,456>,<385,414>,<363,456>,<354,481>,<235,444>,<195,336>,<350,379>,<342,444>,<323,348>,<312,336>,<284,456>,<235,288>,<344,391>,<446,444>,<468,481>,<219,474>,<399,450>,<385,438>,<381,407>,<195,277>,<166,235>,<302,391>,<316,397>,<219,468>,<422,481>,<302,456>,<288,367>,<253,302>,<261,367>,<203,462>,<240,323>,<348,348>,<323,426>,<323,420>,<344,456>,<338,385>,<290,444>,<253,361>,<261,474>,<281,342>,<281,438>,<407,456>,<265,329>,<195,316>,<288,474>,<348,420>,<348,426>,<316,354>,<265,373>,<219,367>,<288,468>,<381,414>,<336,373>,<452,426>,<284,391>,<452,420>,<277,432>,<440,438>,<373,444>,<273,323>,<261,468>,<294,302>,<319,361>,<294,361>,<481,481>,<235,407>,<342,407>,<288,432>,<385,444>,<277,474>,<344,481>,<458,414>,<253,462>,<367,414>,<373,438>,<440,444>,<361,420>,<247,323>,<361,426>,<367,407>,<277,468>,<302,294>,<261,432>,<342,414>,<446,438>,<235,414>,<294,462>,<319,462>,<166,450>,<177,336>,<407,481>,<325,450>,<203,361>,<189,323>,<284,481>,<257,323>,<369,462>,<428,414>,<410,462>,<329,385>,<310,385>,<281,444>,<219,432>,<332,397>,<357,379>,<397,462>,<290,438>,<277,367>,<422,456>,<290,342>,<203,302>,<302,481>,<195,379>,<261,329>,<379,391>,<297,462>,<177,316>,<434,481>,<354,391>,<306,361>,<416,481>,<428,438>,<261,373>,<336,474>,<373,407>,<354,456>,<247,348>,<189,310>,<363,481>,<338,450>,<189,273>,<381,444>,<189,420>,<189,426>,<312,379>,<373,414>,<367,438>,<219,373>,<265,367>,<257,420>,<257,426>,<257,310>,<219,253>,<336,367>,<290,414>,<219,329>,<379,456>,<458,438>,<257,348>,<177,277>,<247,310>,<189,348>,<281,288>,<290,407>,<265,468>,<391,420>,<247,426>,<391,426>,<247,420>,<336,468>,<288,373>,<342,342>,<288,329>,<342,438>,<235,342>,<265,474>,<446,414>,<235,438>,<195,348>,<166,474>,<325,367>,<367,462>,<316,456>,<195,273>,<332,481>,<369,407>,<253,414>,<397,414>,<325,468>,<302,354>,<397,407>,<253,407>,<166,468>,<458,462>,<344,397>,<428,462>,<369,414>,<284,397>,<310,373>,<470,456>,<329,373>,<310,329>,<1507,1534>,<329,329>,<297,438>,<297,342>,<450,481>,<312,323>,<319,414>,<375,420>,<294,414>,<375,426>,<235,462>,<325,474>,<342,462>,<240,336>,<277,450>,<219,235>,<319,407>,<294,407>,<166,367>,<357,420>,<203,261>,<387,444>,<357,426>,<195,310>,<195,426>,<195,420>,<399,432>,<203,288>,<306,444>,<410,414>,<284,354>,<302,397>,<316,391>,<273,336>,<361,379>,<261,385>,<240,316>,<281,361>,<363,397>,<297,407>,<177,257>,<373,462>,<348,336>,<219,385>,<247,379>,<273,316>,<281,302>,<397,438>,<338,474>,<410,438>,<257,379>,<338,468>,<393,481>,<446,462>,<294,342>,<319,438>,<294,438>,<329,432>,<310,432>,<319,342>,<203,281>,<297,414>,<312,348>,<323,336>,<338,367>,<464,481>,<369,438>,<203,444>,<336,450>,<195,323>,<265,450>,<290,462>,<288,385>,<253,438>,<253,342>,<312,426>,<189,379>,<312,420>,<434,438>,<273,367>,<219,323>,<363,438>,<257,432>,<316,361>,<235,481>,<350,450>,<302,407>,<344,414>,<325,336>,<240,468>,<294,354>,<367,481>,<319,354>,<354,444>,<294,397>,<319,397>,<189,432>,<273,474>,<342,481>,<381,456>,<381,391>,<240,367>,<253,354>,<407,414>,<273,468>,<375,385>,<261,323>,<369,397>,<284,414>,<428,481>,<361,373>,<458,481>,<288,323>,<416,438>,<195,385>,<284,407>,<332,462>,<357,385>,<391,432>,<247,432>,<344,407>,<253,397>,<379,444>,<177,450>,<302,414>,<166,336>,<235,294>,<329,379>,<397,397>,<240,474>,<310,379>,<363,407>,<297,354>,<247,329>,<385,391>,<290,481>,<416,414>,<344,438>,<219,310>,<281,391>,<446,481>,<257,329>,<361,432>,<297,397>,<189,329>,<203,240>,<323,367>,<440,456>,<166,316>,<323,474>,<452,468>,<261,310>,<363,414>,<261,426>,<219,348>,<261,420>,<393,462>,<312,385>,<373,481>,<288,310>,<348,468>,<247,373>,<434,414>,<385,456>,<288,420>,<288,426>,<348,474>,<302,342>,<302,438>,<195,235>,<323,468>,<166,277>,<452,474>,<189,253>,<464,462>,<288,348>,<422,444>,<284,438>,<284,342>,<189,373>,<261,348>,<281,456>,<219,426>,<407,438>,<219,420>,<257,373>,<348,367>,<219,273>,<350,468>,<357,373>,<344,462>,<265,316>,<195,329>,<342,397>,<203,391>,<310,310>,<393,438>,<410,481>,<302,462>,<397,481>,<310,348>,<329,348>,<407,462>,<273,450>,<369,481>,<464,438>,<195,253>,<195,373>,<332,407>,<312,432>,<284,462>,<319,481>,<253,294>,<294,481>,<177,367>,<350,474>,<235,397>,<342,354>,<277,336>,<240,450>,<235,354>,<177,474>,<367,397>,<350,367>,<329,420>,<310,426>,<329,426>,<310,420>,<189,235>,<203,456>,<332,414>,<361,385>,<294,294>,<253,481>,<177,468>,<203,265>,<393,414>,<375,432>,<373,397>,<434,462>,<348,450>,<354,361>,<277,316>,<464,414>,<312,329>,<265,336>,<416,462>,<189,385>,<323,450>,<288,379>,<332,438>,<452,450>,<363,462>,<387,456>,<357,432>,<306,391>,<247,385>,<399,426>,<399,420>,<195,432>,<312,373>,<166,257>,<219,379>,<297,481>,<393,407>,<316,444>,<306,456>,<290,354>,<310,323>,<329,323>,<257,385>,<470,444>,<336,336>,<290,397>,<261,379>};

dontNestGroupsCOMP = {<{1475},{}>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},{}>,<{474,438,391,426,432,462,414,385,420,407,450,397,444,456,481,468},{}>,<{1534},{}>,<{474,438,391,426,432,462,414,385,407,450,397,444,456,481,468,379,420},{}>,<{1225},{}>,<{474,438,391,426,432,462,414,420,407,450,397,444,456,481,468},{}>,<{474,438,426,432,462,414,420,407,450,397,444,456,481,468},{}>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},{}>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},{}>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},{}>,<{474,438,426,432,462,414,420,450,444,456,481,468},{}>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},{}>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},{}>,<{474,438,426,432,462,414,420,407,450,444,456,481,468},{}>,<{481},{}>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},{}>};


dontNestINT = {<284,367>,<344,474>,<284,474>,<257,288>,<284,468>,<344,468>,<354,373>,<273,407>,<294,336>,<319,336>,<219,391>,<348,438>,<302,474>,<348,342>,<240,414>,<361,444>,<306,379>,<344,367>,<440,426>,<452,438>,<440,420>,<281,348>,<261,456>,<189,288>,<240,407>,<277,481>,<385,426>,<385,420>,<407,474>,<302,367>,<288,456>,<253,336>,<350,462>,<325,397>,<297,316>,<273,414>,<166,397>,<407,468>,<288,391>,<261,391>,<189,261>,<312,361>,<422,432>,<323,438>,<332,450>,<323,342>,<166,354>,<281,426>,<219,456>,<277,294>,<281,420>,<247,288>,<177,462>,<281,310>,<325,354>,<302,468>,<281,323>,<434,468>,<434,474>,<323,414>,<363,474>,<416,468>,<464,450>,<294,316>,<336,481>,<348,407>,<257,444>,<363,468>,<297,336>,<452,414>,<253,316>,<338,397>,<393,450>,<416,474>,<354,432>,<348,414>,<240,438>,<240,342>,<265,294>,<195,361>,<381,420>,<189,444>,<381,426>,<219,265>,<189,281>,<323,407>,<247,444>,<391,444>,<379,432>,<273,342>,<273,438>,<265,481>,<316,385>,<166,247>,<203,379>,<195,302>,<350,414>,<247,361>,<344,450>,<332,367>,<375,444>,<306,348>,<257,302>,<277,397>,<189,302>,<281,379>,<332,474>,<316,432>,<325,481>,<407,450>,<273,462>,<166,481>,<177,407>,<470,432>,<354,385>,<284,450>,<438,481>,<240,462>,<189,361>,<203,323>,<387,420>,<387,426>,<357,444>,<277,354>,<166,294>,<342,336>,<195,444>,<235,336>,<399,456>,<257,361>,<290,316>,<379,385>,<332,468>,<247,302>,<350,407>,<195,281>,<306,420>,<177,414>,<306,426>,<302,450>,<312,444>,<323,462>,<219,240>,<306,323>,<203,273>,<336,397>,<290,336>,<336,354>,<316,373>,<393,474>,<416,450>,<338,481>,<393,468>,<363,450>,<452,462>,<316,329>,<361,361>,<434,450>,<348,462>,<203,348>,<195,288>,<474,481>,<464,474>,<310,456>,<329,456>,<203,420>,<203,426>,<203,310>,<235,316>,<195,261>,<464,468>,<310,391>,<329,391>,<265,397>,<350,438>,<177,342>,<265,354>,<177,438>,<219,261>,<428,474>,<257,456>,<235,468>,<410,450>,<195,240>,<177,397>,<273,294>,<391,391>,<306,385>,<247,391>,<277,407>,<367,468>,<240,481>,<354,426>,<354,420>,<261,288>,<458,474>,<381,432>,<203,235>,<189,456>,<281,373>,<277,414>,<319,450>,<342,468>,<294,450>,<288,288>,<336,438>,<336,342>,<166,462>,<257,391>,<325,462>,<342,474>,<273,481>,<240,294>,<177,354>,<281,329>,<235,474>,<367,367>,<265,438>,<350,397>,<265,342>,<369,450>,<458,468>,<428,468>,<189,391>,<379,426>,<379,420>,<219,288>,<397,450>,<367,474>,<235,367>,<354,348>,<247,456>,<391,456>,<342,367>,<253,450>,<452,481>,<385,432>,<373,468>,<261,444>,<373,474>,<336,407>,<323,481>,<1441,1475>,<336,414>,<446,468>,<219,281>,<361,456>,<189,265>,<203,385>,<297,450>,<288,444>,<338,462>,<329,361>,<348,481>,<310,361>,<290,474>,<177,247>,<265,407>,<290,468>,<281,432>,<219,444>,<361,391>,<316,379>,<422,420>,<446,474>,<265,414>,<422,426>,<440,432>,<277,438>,<290,367>,<277,342>,<428,450>,<219,361>,<195,265>,<235,450>,<288,361>,<284,336>,<273,354>,<319,474>,<294,474>,<385,385>,<354,379>,<325,414>,<306,329>,<273,397>,<302,336>,<166,414>,<312,456>,<350,481>,<458,450>,<369,468>,<369,474>,<288,302>,<294,468>,<306,373>,<177,294>,<240,354>,<319,468>,<342,450>,<261,302>,<253,367>,<312,391>,<277,462>,<253,474>,<261,361>,<379,379>,<367,450>,<310,444>,<329,444>,<240,397>,<397,474>,<281,385>,<410,474>,<338,438>,<219,302>,<316,323>,<410,468>,<319,367>,<166,407>,<294,367>,<253,468>,<177,481>,<203,432>,<397,468>,<325,407>,<323,397>,<189,240>,<203,373>,<338,414>,<373,450>,<297,468>,<336,462>,<265,462>,<316,348>,<297,367>,<470,426>,<470,420>,<203,329>,<203,253>,<302,316>,<348,397>,<375,456>,<284,316>,<316,310>,<316,420>,<446,450>,<348,354>,<316,426>,<387,432>,<357,456>,<338,407>,<195,456>,<399,444>,<306,432>,<297,474>,<357,391>,<195,391>,<323,354>,<166,438>,<166,342>,<325,438>,<325,342>,<290,450>,<375,391>,<325,444>,<336,361>,<166,444>,<342,385>,<253,329>,<265,302>,<354,336>,<387,468>,<294,329>,<195,294>,<265,361>,<177,265>,<235,385>,<294,373>,<319,373>,<306,468>,<387,474>,<367,385>,<281,450>,<1495,1534>,<332,426>,<332,420>,<189,247>,<1206,1225>,<440,450>,<357,481>,<302,379>,<195,481>,<361,397>,<310,414>,<329,414>,<306,474>,<297,432>,<375,481>,<344,379>,<306,367>,<253,373>,<399,438>,<284,379>,<385,450>,<166,281>,<310,407>,<329,407>,<363,379>,<166,288>,<177,456>,<219,462>,<397,432>,<203,474>,<189,354>,<277,361>,<177,391>,<166,261>,<277,302>,<297,373>,<369,432>,<247,354>,<350,456>,<312,481>,<373,385>,<391,397>,<410,432>,<247,397>,<203,468>,<253,432>,<464,420>,<464,426>,<399,414>,<257,354>,<288,462>,<399,407>,<290,385>,<338,444>,<381,450>,<257,397>,<350,391>,<1453,1475>,<393,420>,<261,462>,<393,426>,<310,438>,<294,432>,<329,438>,<203,367>,<319,432>,<329,342>,<310,342>,<189,397>,<297,329>,<253,385>,<302,310>,<235,373>,<440,474>,<290,432>,<348,391>,<281,367>,<385,468>,<369,385>,<357,397>,<329,462>,<310,462>,<446,432>,<261,438>,<261,342>,<195,397>,<440,468>,<361,481>,<235,329>,<177,240>,<281,474>,<288,342>,<332,379>,<288,438>,<338,361>,<387,450>,<284,348>,<265,288>,<281,468>,<302,426>,<302,420>,<342,373>,<306,450>,<323,456>,<344,420>,<344,426>,<284,426>,<284,420>,<284,310>,<316,316>,<219,342>,<219,438>,<407,426>,<367,373>,<407,420>,<385,474>,<294,385>,<319,385>,<375,397>,<348,456>,<323,391>,<195,354>,<452,456>,<302,348>,<373,432>,<277,444>,<240,391>,<265,444>,<166,361>,<325,361>,<277,288>,<235,432>,<261,407>,<302,323>,<367,432>,<399,462>,<288,407>,<290,373>,<240,456>,<373,373>,<290,329>,<219,414>,<312,354>,<257,294>,<391,481>,<247,481>,<297,385>,<336,444>,<203,450>,<189,294>,<166,302>,<195,247>,<416,420>,<416,426>,<458,432>,<273,456>,<381,474>,<428,432>,<312,397>,<219,407>,<257,481>,<284,323>,<316,336>,<434,420>,<247,294>,<434,426>,<273,391>,<381,468>,<288,414>,<363,426>,<363,420>,<342,432>,<261,414>,<189,481>,<235,379>,<281,336>,<177,444>,<357,414>,<361,462>,<195,414>,<302,385>,<375,407>,<393,432>,<369,420>,<338,391>,<369,426>,<350,444>,<342,379>,<253,420>,<253,426>,<297,323>,<312,342>,<312,438>,<253,310>,<464,432>,<166,265>,<397,420>,<323,361>,<397,426>,<367,379>,<379,450>,<410,420>,<294,348>,<319,348>,<410,426>,<329,481>,<177,281>,<310,481>,<348,361>,<319,426>,<294,426>,<375,414>,<319,420>,<294,420>,<219,247>,<294,310>,<203,257>,<338,456>,<195,407>,<332,373>,<284,385>,<354,450>,<432,481>,<344,385>,<253,348>,<357,407>,<325,456>,<426,481>,<273,361>,<297,310>,<375,438>,<325,391>,<288,397>,<281,316>,<357,438>,<219,354>,<166,456>,<316,367>,<312,414>,<297,348>,<312,407>,<219,397>,<332,432>,<391,462>,<247,462>,<177,288>,<316,474>,<422,450>,<297,420>,<297,426>,<253,323>,<240,302>,<261,354>,<288,354>,<177,261>,<316,468>,<399,481>,<257,462>,<166,391>,<189,462>,<240,361>,<195,342>,<195,438>,<470,474>,<261,397>,<290,379>,<294,323>,<373,379>,<273,302>,<363,385>,<470,468>,<265,391>,<265,456>,<336,456>,<203,277>,<342,348>,<284,329>,<354,474>,<416,432>,<363,432>,<354,468>,<253,379>,<344,373>,<284,373>,<189,342>,<189,438>,<195,462>,<379,474>,<240,444>,<361,414>,<332,385>,<357,462>,<329,397>,<310,397>,<367,426>,<336,391>,<367,420>,<257,438>,<257,342>,<354,367>,<379,468>,<235,348>,<319,379>,<294,379>,<428,420>,<428,426>,<273,444>,<458,426>,<458,420>,<247,342>,<247,438>,<391,438>,<306,336>,<302,329>,<235,310>,<203,316>,<369,379>,<342,426>,<342,420>,<302,373>,<166,240>,<235,426>,<375,462>,<235,420>,<361,407>,<310,354>,<329,354>,<434,432>,<290,323>,<257,407>,<240,288>,<288,294>,<350,361>,<363,373>,<177,361>,<273,288>,<257,414>,<288,481>,<348,444>,<446,426>,<316,450>,<446,420>,<422,474>,<219,481>,<297,379>,<422,468>,<247,414>,<391,414>,<302,432>,<261,294>,<177,302>,<470,450>,<203,336>,<235,323>,<407,432>,<277,391>,<312,462>,<284,432>,<323,444>,<247,407>,<290,310>,<391,407>,<444,481>,<344,432>,<290,426>,<290,420>,<373,426>,<452,444>,<219,294>,<373,420>,<277,456>,<361,438>,<456,481>,<189,414>,<261,481>,<290,348>,<189,407>,<277,379>,<195,367>,<166,273>,<306,481>,<261,316>,<470,438>,<219,277>,<297,456>,<325,348>,<195,468>,<387,481>,<350,373>,<219,316>,<354,462>,<166,310>,<375,474>,<325,426>,<325,420>,<281,354>,<166,420>,<166,426>,<177,329>,<332,444>,<281,397>,<240,385>,<357,474>,<297,391>,<288,316>,<379,462>,<195,474>,<361,450>,<166,348>,<357,468>,<316,342>,<316,438>,<375,468>,<177,373>,<273,385>,<177,253>,<385,397>,<312,468>,<348,385>,<253,456>,<410,456>,<265,379>,<336,379>,<261,336>,<253,391>,<288,336>,<312,474>,<166,323>,<323,385>,<350,432>,<470,414>,<294,391>,<319,391>,<219,336>,<247,450>,<391,450>,<422,462>,<284,361>,<464,444>,<397,456>,<344,361>,<302,302>,<203,481>,<177,432>,<312,367>,<316,414>,<319,456>,<462,481>,<294,456>,<316,407>,<393,444>,<257,450>,<381,397>,<203,294>,<189,450>,<338,420>,<338,426>,<369,391>,<369,456>,<302,361>,<354,407>,<281,481>,<379,414>,<361,474>,<379,407>,<219,257>,<265,323>,<195,450>,<361,468>,<440,481>,<357,450>,<446,456>,<387,397>,<177,385>,<273,373>,<273,329>,<306,397>,<277,348>,<302,444>,<361,367>,<407,444>,<284,444>,<373,391>,<344,444>,<323,432>,<422,438>,<306,354>,<240,373>,<290,456>,<373,456>,<281,294>,<277,420>,<452,432>,<277,426>,<350,385>,<240,329>,<277,310>,<385,481>,<290,391>,<375,450>,<348,432>,<325,379>,<354,414>,<166,379>,<203,247>,<310,336>,<329,336>,<316,462>,<203,397>,<189,367>,<323,329>,<312,450>,<336,348>,<434,444>,<323,373>,<240,432>,<367,456>,<247,474>,<391,474>,<257,367>,<348,373>,<265,420>,<265,426>,<422,414>,<336,426>,<302,288>,<336,420>,<367,391>,<391,468>,<247,468>,<265,310>,<470,462>,<277,323>,<203,354>,<428,456>,<458,456>,<273,432>,<189,474>,<379,438>,<338,379>,<257,474>,<414,481>,<332,361>,<310,316>,<342,391>,<416,444>,<1191,1225>,<235,391>,<363,444>,<257,468>,<342,456>,<381,481>,<177,235>,<235,456>,<247,367>,<265,348>,<189,468>,<354,438>,<354,342>,<369,444>,<306,407>,<177,273>,<397,444>,<440,462>,<354,354>,<166,373>,<385,462>,<387,407>,<393,456>,<247,316>,<329,367>,<203,438>,<310,367>,<203,342>,<277,385>,<350,426>,<350,420>,<306,414>,<177,420>,<177,426>,<166,329>,<189,316>,<410,444>,<177,310>,<281,462>,<290,361>,<257,316>,<379,397>,<253,444>,<329,474>,<240,379>,<464,456>,<310,474>,<329,468>,<310,468>,<387,414>,<325,373>,<166,253>,<338,432>,<189,277>,<319,444>,<294,444>,<354,397>,<273,379>,<177,348>,<247,336>,<253,288>,<203,414>,<235,361>,<189,336>,<381,462>,<387,438>,<261,450>,<306,342>,<306,438>,<399,474>,<219,450>,<332,456>,<338,373>,<177,323>,<342,361>,<332,391>,<257,336>,<297,444>,<336,385>,<316,481>,<265,385>,<399,468>,<323,379>,<288,450>,<294,288>,<235,302>,<367,361>,<325,432>,<348,379>,<203,407>,<166,432>,<195,257>,<470,481>,<381,438>,<387,462>,<306,462>,<265,432>,<379,481>,<189,257>,<336,432>,<240,348>,<363,391>,<416,456>,<273,310>,<323,323>,<166,385>,<297,361>,<420,481>,<310,450>,<329,450>,<273,348>,<177,379>,<367,444>,<440,414>,<240,310>,<385,407>,<240,426>,<240,420>,<277,329>,<281,414>,<277,373>,<273,426>,<458,444>,<273,420>,<281,407>,<428,444>,<325,385>,<434,456>,<385,414>,<363,456>,<354,481>,<235,444>,<195,336>,<350,379>,<342,444>,<323,348>,<312,336>,<284,456>,<235,288>,<344,391>,<446,444>,<468,481>,<219,474>,<399,450>,<385,438>,<381,407>,<195,277>,<166,235>,<302,391>,<316,397>,<219,468>,<422,481>,<302,456>,<288,367>,<253,302>,<261,367>,<203,462>,<240,323>,<348,348>,<323,426>,<323,420>,<344,456>,<338,385>,<290,444>,<253,361>,<261,474>,<281,342>,<281,438>,<407,456>,<265,329>,<195,316>,<288,474>,<348,420>,<348,426>,<316,354>,<265,373>,<219,367>,<288,468>,<381,414>,<336,373>,<452,426>,<284,391>,<452,420>,<277,432>,<440,438>,<373,444>,<273,323>,<261,468>,<294,302>,<319,361>,<294,361>,<481,481>,<235,407>,<342,407>,<288,432>,<385,444>,<277,474>,<344,481>,<458,414>,<253,462>,<367,414>,<373,438>,<440,444>,<361,420>,<247,323>,<361,426>,<367,407>,<277,468>,<302,294>,<261,432>,<342,414>,<446,438>,<235,414>,<294,462>,<319,462>,<166,450>,<177,336>,<407,481>,<325,450>,<203,361>,<189,323>,<284,481>,<257,323>,<369,462>,<428,414>,<410,462>,<329,385>,<310,385>,<281,444>,<219,432>,<332,397>,<357,379>,<397,462>,<290,438>,<277,367>,<422,456>,<290,342>,<203,302>,<302,481>,<195,379>,<261,329>,<379,391>,<297,462>,<177,316>,<434,481>,<354,391>,<306,361>,<416,481>,<428,438>,<261,373>,<336,474>,<373,407>,<354,456>,<247,348>,<189,310>,<363,481>,<338,450>,<189,273>,<381,444>,<189,420>,<189,426>,<312,379>,<373,414>,<367,438>,<219,373>,<265,367>,<257,420>,<257,426>,<257,310>,<219,253>,<336,367>,<290,414>,<219,329>,<379,456>,<458,438>,<257,348>,<177,277>,<247,310>,<189,348>,<281,288>,<290,407>,<265,468>,<391,420>,<247,426>,<391,426>,<247,420>,<336,468>,<288,373>,<342,342>,<288,329>,<342,438>,<235,342>,<265,474>,<446,414>,<235,438>,<195,348>,<166,474>,<325,367>,<367,462>,<316,456>,<195,273>,<332,481>,<369,407>,<253,414>,<397,414>,<325,468>,<302,354>,<397,407>,<253,407>,<166,468>,<458,462>,<344,397>,<428,462>,<369,414>,<284,397>,<310,373>,<470,456>,<329,373>,<310,329>,<1507,1534>,<329,329>,<297,438>,<297,342>,<450,481>,<312,323>,<319,414>,<375,420>,<294,414>,<375,426>,<235,462>,<325,474>,<342,462>,<240,336>,<277,450>,<219,235>,<319,407>,<294,407>,<166,367>,<357,420>,<203,261>,<387,444>,<357,426>,<195,310>,<195,426>,<195,420>,<399,432>,<203,288>,<306,444>,<410,414>,<284,354>,<302,397>,<316,391>,<273,336>,<361,379>,<261,385>,<240,316>,<281,361>,<363,397>,<297,407>,<177,257>,<373,462>,<348,336>,<219,385>,<247,379>,<273,316>,<281,302>,<397,438>,<338,474>,<410,438>,<257,379>,<338,468>,<393,481>,<446,462>,<294,342>,<319,438>,<294,438>,<329,432>,<310,432>,<319,342>,<203,281>,<297,414>,<312,348>,<323,336>,<338,367>,<464,481>,<369,438>,<203,444>,<336,450>,<195,323>,<265,450>,<290,462>,<288,385>,<253,438>,<253,342>,<312,426>,<189,379>,<312,420>,<434,438>,<273,367>,<219,323>,<363,438>,<257,432>,<316,361>,<235,481>,<350,450>,<302,407>,<344,414>,<325,336>,<240,468>,<294,354>,<367,481>,<319,354>,<354,444>,<294,397>,<319,397>,<189,432>,<273,474>,<342,481>,<381,456>,<381,391>,<240,367>,<253,354>,<407,414>,<273,468>,<375,385>,<261,323>,<369,397>,<284,414>,<428,481>,<361,373>,<458,481>,<288,323>,<416,438>,<195,385>,<284,407>,<332,462>,<357,385>,<391,432>,<247,432>,<344,407>,<253,397>,<379,444>,<177,450>,<302,414>,<166,336>,<235,294>,<329,379>,<397,397>,<240,474>,<310,379>,<363,407>,<297,354>,<247,329>,<385,391>,<290,481>,<416,414>,<344,438>,<219,310>,<281,391>,<446,481>,<257,329>,<361,432>,<297,397>,<189,329>,<203,240>,<323,367>,<440,456>,<166,316>,<323,474>,<452,468>,<261,310>,<363,414>,<261,426>,<219,348>,<261,420>,<393,462>,<312,385>,<373,481>,<288,310>,<348,468>,<247,373>,<434,414>,<385,456>,<288,420>,<288,426>,<348,474>,<302,342>,<302,438>,<195,235>,<323,468>,<166,277>,<452,474>,<189,253>,<464,462>,<288,348>,<422,444>,<284,438>,<284,342>,<189,373>,<261,348>,<281,456>,<219,426>,<407,438>,<219,420>,<257,373>,<348,367>,<219,273>,<350,468>,<357,373>,<344,462>,<265,316>,<195,329>,<342,397>,<203,391>,<310,310>,<393,438>,<410,481>,<302,462>,<397,481>,<310,348>,<329,348>,<407,462>,<273,450>,<369,481>,<464,438>,<195,253>,<195,373>,<332,407>,<312,432>,<284,462>,<319,481>,<253,294>,<294,481>,<177,367>,<350,474>,<235,397>,<342,354>,<277,336>,<240,450>,<235,354>,<177,474>,<367,397>,<350,367>,<329,420>,<310,426>,<329,426>,<310,420>,<189,235>,<203,456>,<332,414>,<361,385>,<294,294>,<253,481>,<177,468>,<203,265>,<393,414>,<375,432>,<373,397>,<434,462>,<348,450>,<354,361>,<277,316>,<464,414>,<312,329>,<265,336>,<416,462>,<189,385>,<323,450>,<288,379>,<332,438>,<452,450>,<363,462>,<387,456>,<357,432>,<306,391>,<247,385>,<399,426>,<399,420>,<195,432>,<312,373>,<166,257>,<219,379>,<297,481>,<393,407>,<316,444>,<306,456>,<290,354>,<310,323>,<329,323>,<257,385>,<470,444>,<336,336>,<290,397>,<261,379>};

dontNestGroupsINT = {<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},{310,316,284,290,297}>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},{265,277,281,302,235,273,240,257,247,261,288,294,253}>,<{474,438,391,426,432,462,414,385,420,407,450,397,444,456,481,468},{375,385}>,<{481},{474,438,426,432,462,414,420,450,444,456,481,468}>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},{336,325,348,354,342,319}>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},{357,363,373}>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},{323,312,329,306}>,<{474,438,391,426,432,462,414,420,407,450,397,444,456,481,468},{391,381}>,<{1534},{1507,1495}>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},{338,350,361,344,332,367}>,<{1225},{1191,1206}>,<{1475},{1441,1453}>,<{474,438,426,432,462,414,420,407,450,397,444,456,481,468},{387,397}>,<{474,438,426,432,462,414,420,407,450,444,456,481,468},{399,393}>,<{474,438,426,432,462,414,420,450,444,456,481,468},{452,440,470,422,407,464,446,410,434,416,458,428}>,<{474,438,391,426,432,462,414,385,407,450,397,444,456,481,468,379,420},{379,369}>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},{166,177,195,189,219,203}>};

println(" dontNestCOMP == dontNestINT: <dontNestCOMP == dontNestINT>");
println(" dontNestGroupsCOMP == dontNestGroupsINT: <dontNestGroupsCOMP == dontNestGroupsINT>");

println(" size(dontNestGroupsCOMP) : <size(dontNestGroupsCOMP)>");
println(" size(dontNestGroupsINT) : <size(dontNestGroupsINT)>");
}

bool compare3(){

	rel[int parent, int child] dontNestINT = {<284,367>,<344,474>,<284,474>,<257,288>,<284,468>,<344,468>,<354,373>,<273,407>,<294,336>,<319,336>,<219,391>,<348,438>,<302,474>,<348,342>,<240,414>,<361,444>,<306,379>,<344,367>,<440,426>,<452,438>,<440,420>,<281,348>,<261,456>,<189,288>,<240,407>,<277,481>,<385,426>,<385,420>,<407,474>,<302,367>,<288,456>,<253,336>,<350,462>,<325,397>,<297,316>,<273,414>,<166,397>,<407,468>,<288,391>,<261,391>,<189,261>,<312,361>,<422,432>,<323,438>,<332,450>,<323,342>,<166,354>,<281,426>,<219,456>,<277,294>,<281,420>,<247,288>,<177,462>,<281,310>,<325,354>,<302,468>,<281,323>,<434,468>,<434,474>,<323,414>,<363,474>,<416,468>,<464,450>,<294,316>,<336,481>,<348,407>,<257,444>,<363,468>,<297,336>,<452,414>,<253,316>,<338,397>,<393,450>,<416,474>,<354,432>,<348,414>,<240,438>,<240,342>,<265,294>,<195,361>,<381,420>,<189,444>,<381,426>,<219,265>,<189,281>,<323,407>,<247,444>,<391,444>,<379,432>,<273,342>,<273,438>,<265,481>,<316,385>,<166,247>,<203,379>,<195,302>,<350,414>,<247,361>,<344,450>,<332,367>,<375,444>,<306,348>,<257,302>,<277,397>,<189,302>,<281,379>,<332,474>,<316,432>,<325,481>,<407,450>,<273,462>,<166,481>,<177,407>,<470,432>,<354,385>,<284,450>,<438,481>,<240,462>,<189,361>,<203,323>,<387,420>,<387,426>,<357,444>,<277,354>,<166,294>,<342,336>,<195,444>,<235,336>,<399,456>,<257,361>,<290,316>,<379,385>,<332,468>,<247,302>,<350,407>,<195,281>,<306,420>,<177,414>,<306,426>,<302,450>,<312,444>,<323,462>,<219,240>,<306,323>,<203,273>,<336,397>,<290,336>,<336,354>,<316,373>,<393,474>,<416,450>,<338,481>,<393,468>,<363,450>,<452,462>,<316,329>,<361,361>,<434,450>,<348,462>,<203,348>,<195,288>,<474,481>,<464,474>,<310,456>,<329,456>,<203,420>,<203,426>,<203,310>,<235,316>,<195,261>,<464,468>,<310,391>,<329,391>,<265,397>,<350,438>,<177,342>,<265,354>,<177,438>,<219,261>,<428,474>,<257,456>,<235,468>,<410,450>,<195,240>,<177,397>,<273,294>,<391,391>,<306,385>,<247,391>,<277,407>,<367,468>,<240,481>,<354,426>,<354,420>,<261,288>,<458,474>,<381,432>,<203,235>,<189,456>,<281,373>,<277,414>,<319,450>,<342,468>,<294,450>,<288,288>,<336,438>,<336,342>,<166,462>,<257,391>,<325,462>,<342,474>,<273,481>,<240,294>,<177,354>,<281,329>,<235,474>,<367,367>,<265,438>,<350,397>,<265,342>,<369,450>,<458,468>,<428,468>,<189,391>,<379,426>,<379,420>,<219,288>,<397,450>,<367,474>,<235,367>,<354,348>,<247,456>,<391,456>,<342,367>,<253,450>,<452,481>,<385,432>,<373,468>,<261,444>,<373,474>,<336,407>,<323,481>,<1441,1475>,<336,414>,<446,468>,<219,281>,<361,456>,<189,265>,<203,385>,<297,450>,<288,444>,<338,462>,<329,361>,<348,481>,<310,361>,<290,474>,<177,247>,<265,407>,<290,468>,<281,432>,<219,444>,<361,391>,<316,379>,<422,420>,<446,474>,<265,414>,<422,426>,<440,432>,<277,438>,<290,367>,<277,342>,<428,450>,<219,361>,<195,265>,<235,450>,<288,361>,<284,336>,<273,354>,<319,474>,<294,474>,<385,385>,<354,379>,<325,414>,<306,329>,<273,397>,<302,336>,<166,414>,<312,456>,<350,481>,<458,450>,<369,468>,<369,474>,<288,302>,<294,468>,<306,373>,<177,294>,<240,354>,<319,468>,<342,450>,<261,302>,<253,367>,<312,391>,<277,462>,<253,474>,<261,361>,<379,379>,<367,450>,<310,444>,<329,444>,<240,397>,<397,474>,<281,385>,<410,474>,<338,438>,<219,302>,<316,323>,<410,468>,<319,367>,<166,407>,<294,367>,<253,468>,<177,481>,<203,432>,<397,468>,<325,407>,<323,397>,<189,240>,<203,373>,<338,414>,<373,450>,<297,468>,<336,462>,<265,462>,<316,348>,<297,367>,<470,426>,<470,420>,<203,329>,<203,253>,<302,316>,<348,397>,<375,456>,<284,316>,<316,310>,<316,420>,<446,450>,<348,354>,<316,426>,<387,432>,<357,456>,<338,407>,<195,456>,<399,444>,<306,432>,<297,474>,<357,391>,<195,391>,<323,354>,<166,438>,<166,342>,<325,438>,<325,342>,<290,450>,<375,391>,<325,444>,<336,361>,<166,444>,<342,385>,<253,329>,<265,302>,<354,336>,<387,468>,<294,329>,<195,294>,<265,361>,<177,265>,<235,385>,<294,373>,<319,373>,<306,468>,<387,474>,<367,385>,<281,450>,<1495,1534>,<332,426>,<332,420>,<189,247>,<1206,1225>,<440,450>,<357,481>,<302,379>,<195,481>,<361,397>,<310,414>,<329,414>,<306,474>,<297,432>,<375,481>,<344,379>,<306,367>,<253,373>,<399,438>,<284,379>,<385,450>,<166,281>,<310,407>,<329,407>,<363,379>,<166,288>,<177,456>,<219,462>,<397,432>,<203,474>,<189,354>,<277,361>,<177,391>,<166,261>,<277,302>,<297,373>,<369,432>,<247,354>,<350,456>,<312,481>,<373,385>,<391,397>,<410,432>,<247,397>,<203,468>,<253,432>,<464,420>,<464,426>,<399,414>,<257,354>,<288,462>,<399,407>,<290,385>,<338,444>,<381,450>,<257,397>,<350,391>,<1453,1475>,<393,420>,<261,462>,<393,426>,<310,438>,<294,432>,<329,438>,<203,367>,<319,432>,<329,342>,<310,342>,<189,397>,<297,329>,<253,385>,<302,310>,<235,373>,<440,474>,<290,432>,<348,391>,<281,367>,<385,468>,<369,385>,<357,397>,<329,462>,<310,462>,<446,432>,<261,438>,<261,342>,<195,397>,<440,468>,<361,481>,<235,329>,<177,240>,<281,474>,<288,342>,<332,379>,<288,438>,<338,361>,<387,450>,<284,348>,<265,288>,<281,468>,<302,426>,<302,420>,<342,373>,<306,450>,<323,456>,<344,420>,<344,426>,<284,426>,<284,420>,<284,310>,<316,316>,<219,342>,<219,438>,<407,426>,<367,373>,<407,420>,<385,474>,<294,385>,<319,385>,<375,397>,<348,456>,<323,391>,<195,354>,<452,456>,<302,348>,<373,432>,<277,444>,<240,391>,<265,444>,<166,361>,<325,361>,<277,288>,<235,432>,<261,407>,<302,323>,<367,432>,<399,462>,<288,407>,<290,373>,<240,456>,<373,373>,<290,329>,<219,414>,<312,354>,<257,294>,<391,481>,<247,481>,<297,385>,<336,444>,<203,450>,<189,294>,<166,302>,<195,247>,<416,420>,<416,426>,<458,432>,<273,456>,<381,474>,<428,432>,<312,397>,<219,407>,<257,481>,<284,323>,<316,336>,<434,420>,<247,294>,<434,426>,<273,391>,<381,468>,<288,414>,<363,426>,<363,420>,<342,432>,<261,414>,<189,481>,<235,379>,<281,336>,<177,444>,<357,414>,<361,462>,<195,414>,<302,385>,<375,407>,<393,432>,<369,420>,<338,391>,<369,426>,<350,444>,<342,379>,<253,420>,<253,426>,<297,323>,<312,342>,<312,438>,<253,310>,<464,432>,<166,265>,<397,420>,<323,361>,<397,426>,<367,379>,<379,450>,<410,420>,<294,348>,<319,348>,<410,426>,<329,481>,<177,281>,<310,481>,<348,361>,<319,426>,<294,426>,<375,414>,<319,420>,<294,420>,<219,247>,<294,310>,<203,257>,<338,456>,<195,407>,<332,373>,<284,385>,<354,450>,<432,481>,<344,385>,<253,348>,<357,407>,<325,456>,<426,481>,<273,361>,<297,310>,<375,438>,<325,391>,<288,397>,<281,316>,<357,438>,<219,354>,<166,456>,<316,367>,<312,414>,<297,348>,<312,407>,<219,397>,<332,432>,<391,462>,<247,462>,<177,288>,<316,474>,<422,450>,<297,420>,<297,426>,<253,323>,<240,302>,<261,354>,<288,354>,<177,261>,<316,468>,<399,481>,<257,462>,<166,391>,<189,462>,<240,361>,<195,342>,<195,438>,<470,474>,<261,397>,<290,379>,<294,323>,<373,379>,<273,302>,<363,385>,<470,468>,<265,391>,<265,456>,<336,456>,<203,277>,<342,348>,<284,329>,<354,474>,<416,432>,<363,432>,<354,468>,<253,379>,<344,373>,<284,373>,<189,342>,<189,438>,<195,462>,<379,474>,<240,444>,<361,414>,<332,385>,<357,462>,<329,397>,<310,397>,<367,426>,<336,391>,<367,420>,<257,438>,<257,342>,<354,367>,<379,468>,<235,348>,<319,379>,<294,379>,<428,420>,<428,426>,<273,444>,<458,426>,<458,420>,<247,342>,<247,438>,<391,438>,<306,336>,<302,329>,<235,310>,<203,316>,<369,379>,<342,426>,<342,420>,<302,373>,<166,240>,<235,426>,<375,462>,<235,420>,<361,407>,<310,354>,<329,354>,<434,432>,<290,323>,<257,407>,<240,288>,<288,294>,<350,361>,<363,373>,<177,361>,<273,288>,<257,414>,<288,481>,<348,444>,<446,426>,<316,450>,<446,420>,<422,474>,<219,481>,<297,379>,<422,468>,<247,414>,<391,414>,<302,432>,<261,294>,<177,302>,<470,450>,<203,336>,<235,323>,<407,432>,<277,391>,<312,462>,<284,432>,<323,444>,<247,407>,<290,310>,<391,407>,<444,481>,<344,432>,<290,426>,<290,420>,<373,426>,<452,444>,<219,294>,<373,420>,<277,456>,<361,438>,<456,481>,<189,414>,<261,481>,<290,348>,<189,407>,<277,379>,<195,367>,<166,273>,<306,481>,<261,316>,<470,438>,<219,277>,<297,456>,<325,348>,<195,468>,<387,481>,<350,373>,<219,316>,<354,462>,<166,310>,<375,474>,<325,426>,<325,420>,<281,354>,<166,420>,<166,426>,<177,329>,<332,444>,<281,397>,<240,385>,<357,474>,<297,391>,<288,316>,<379,462>,<195,474>,<361,450>,<166,348>,<357,468>,<316,342>,<316,438>,<375,468>,<177,373>,<273,385>,<177,253>,<385,397>,<312,468>,<348,385>,<253,456>,<410,456>,<265,379>,<336,379>,<261,336>,<253,391>,<288,336>,<312,474>,<166,323>,<323,385>,<350,432>,<470,414>,<294,391>,<319,391>,<219,336>,<247,450>,<391,450>,<422,462>,<284,361>,<464,444>,<397,456>,<344,361>,<302,302>,<203,481>,<177,432>,<312,367>,<316,414>,<319,456>,<462,481>,<294,456>,<316,407>,<393,444>,<257,450>,<381,397>,<203,294>,<189,450>,<338,420>,<338,426>,<369,391>,<369,456>,<302,361>,<354,407>,<281,481>,<379,414>,<361,474>,<379,407>,<219,257>,<265,323>,<195,450>,<361,468>,<440,481>,<357,450>,<446,456>,<387,397>,<177,385>,<273,373>,<273,329>,<306,397>,<277,348>,<302,444>,<361,367>,<407,444>,<284,444>,<373,391>,<344,444>,<323,432>,<422,438>,<306,354>,<240,373>,<290,456>,<373,456>,<281,294>,<277,420>,<452,432>,<277,426>,<350,385>,<240,329>,<277,310>,<385,481>,<290,391>,<375,450>,<348,432>,<325,379>,<354,414>,<166,379>,<203,247>,<310,336>,<329,336>,<316,462>,<203,397>,<189,367>,<323,329>,<312,450>,<336,348>,<434,444>,<323,373>,<240,432>,<367,456>,<247,474>,<391,474>,<257,367>,<348,373>,<265,420>,<265,426>,<422,414>,<336,426>,<302,288>,<336,420>,<367,391>,<391,468>,<247,468>,<265,310>,<470,462>,<277,323>,<203,354>,<428,456>,<458,456>,<273,432>,<189,474>,<379,438>,<338,379>,<257,474>,<414,481>,<332,361>,<310,316>,<342,391>,<416,444>,<1191,1225>,<235,391>,<363,444>,<257,468>,<342,456>,<381,481>,<177,235>,<235,456>,<247,367>,<265,348>,<189,468>,<354,438>,<354,342>,<369,444>,<306,407>,<177,273>,<397,444>,<440,462>,<354,354>,<166,373>,<385,462>,<387,407>,<393,456>,<247,316>,<329,367>,<203,438>,<310,367>,<203,342>,<277,385>,<350,426>,<350,420>,<306,414>,<177,420>,<177,426>,<166,329>,<189,316>,<410,444>,<177,310>,<281,462>,<290,361>,<257,316>,<379,397>,<253,444>,<329,474>,<240,379>,<464,456>,<310,474>,<329,468>,<310,468>,<387,414>,<325,373>,<166,253>,<338,432>,<189,277>,<319,444>,<294,444>,<354,397>,<273,379>,<177,348>,<247,336>,<253,288>,<203,414>,<235,361>,<189,336>,<381,462>,<387,438>,<261,450>,<306,342>,<306,438>,<399,474>,<219,450>,<332,456>,<338,373>,<177,323>,<342,361>,<332,391>,<257,336>,<297,444>,<336,385>,<316,481>,<265,385>,<399,468>,<323,379>,<288,450>,<294,288>,<235,302>,<367,361>,<325,432>,<348,379>,<203,407>,<166,432>,<195,257>,<470,481>,<381,438>,<387,462>,<306,462>,<265,432>,<379,481>,<189,257>,<336,432>,<240,348>,<363,391>,<416,456>,<273,310>,<323,323>,<166,385>,<297,361>,<420,481>,<310,450>,<329,450>,<273,348>,<177,379>,<367,444>,<440,414>,<240,310>,<385,407>,<240,426>,<240,420>,<277,329>,<281,414>,<277,373>,<273,426>,<458,444>,<273,420>,<281,407>,<428,444>,<325,385>,<434,456>,<385,414>,<363,456>,<354,481>,<235,444>,<195,336>,<350,379>,<342,444>,<323,348>,<312,336>,<284,456>,<235,288>,<344,391>,<446,444>,<468,481>,<219,474>,<399,450>,<385,438>,<381,407>,<195,277>,<166,235>,<302,391>,<316,397>,<219,468>,<422,481>,<302,456>,<288,367>,<253,302>,<261,367>,<203,462>,<240,323>,<348,348>,<323,426>,<323,420>,<344,456>,<338,385>,<290,444>,<253,361>,<261,474>,<281,342>,<281,438>,<407,456>,<265,329>,<195,316>,<288,474>,<348,420>,<348,426>,<316,354>,<265,373>,<219,367>,<288,468>,<381,414>,<336,373>,<452,426>,<284,391>,<452,420>,<277,432>,<440,438>,<373,444>,<273,323>,<261,468>,<294,302>,<319,361>,<294,361>,<481,481>,<235,407>,<342,407>,<288,432>,<385,444>,<277,474>,<344,481>,<458,414>,<253,462>,<367,414>,<373,438>,<440,444>,<361,420>,<247,323>,<361,426>,<367,407>,<277,468>,<302,294>,<261,432>,<342,414>,<446,438>,<235,414>,<294,462>,<319,462>,<166,450>,<177,336>,<407,481>,<325,450>,<203,361>,<189,323>,<284,481>,<257,323>,<369,462>,<428,414>,<410,462>,<329,385>,<310,385>,<281,444>,<219,432>,<332,397>,<357,379>,<397,462>,<290,438>,<277,367>,<422,456>,<290,342>,<203,302>,<302,481>,<195,379>,<261,329>,<379,391>,<297,462>,<177,316>,<434,481>,<354,391>,<306,361>,<416,481>,<428,438>,<261,373>,<336,474>,<373,407>,<354,456>,<247,348>,<189,310>,<363,481>,<338,450>,<189,273>,<381,444>,<189,420>,<189,426>,<312,379>,<373,414>,<367,438>,<219,373>,<265,367>,<257,420>,<257,426>,<257,310>,<219,253>,<336,367>,<290,414>,<219,329>,<379,456>,<458,438>,<257,348>,<177,277>,<247,310>,<189,348>,<281,288>,<290,407>,<265,468>,<391,420>,<247,426>,<391,426>,<247,420>,<336,468>,<288,373>,<342,342>,<288,329>,<342,438>,<235,342>,<265,474>,<446,414>,<235,438>,<195,348>,<166,474>,<325,367>,<367,462>,<316,456>,<195,273>,<332,481>,<369,407>,<253,414>,<397,414>,<325,468>,<302,354>,<397,407>,<253,407>,<166,468>,<458,462>,<344,397>,<428,462>,<369,414>,<284,397>,<310,373>,<470,456>,<329,373>,<310,329>,<1507,1534>,<329,329>,<297,438>,<297,342>,<450,481>,<312,323>,<319,414>,<375,420>,<294,414>,<375,426>,<235,462>,<325,474>,<342,462>,<240,336>,<277,450>,<219,235>,<319,407>,<294,407>,<166,367>,<357,420>,<203,261>,<387,444>,<357,426>,<195,310>,<195,426>,<195,420>,<399,432>,<203,288>,<306,444>,<410,414>,<284,354>,<302,397>,<316,391>,<273,336>,<361,379>,<261,385>,<240,316>,<281,361>,<363,397>,<297,407>,<177,257>,<373,462>,<348,336>,<219,385>,<247,379>,<273,316>,<281,302>,<397,438>,<338,474>,<410,438>,<257,379>,<338,468>,<393,481>,<446,462>,<294,342>,<319,438>,<294,438>,<329,432>,<310,432>,<319,342>,<203,281>,<297,414>,<312,348>,<323,336>,<338,367>,<464,481>,<369,438>,<203,444>,<336,450>,<195,323>,<265,450>,<290,462>,<288,385>,<253,438>,<253,342>,<312,426>,<189,379>,<312,420>,<434,438>,<273,367>,<219,323>,<363,438>,<257,432>,<316,361>,<235,481>,<350,450>,<302,407>,<344,414>,<325,336>,<240,468>,<294,354>,<367,481>,<319,354>,<354,444>,<294,397>,<319,397>,<189,432>,<273,474>,<342,481>,<381,456>,<381,391>,<240,367>,<253,354>,<407,414>,<273,468>,<375,385>,<261,323>,<369,397>,<284,414>,<428,481>,<361,373>,<458,481>,<288,323>,<416,438>,<195,385>,<284,407>,<332,462>,<357,385>,<391,432>,<247,432>,<344,407>,<253,397>,<379,444>,<177,450>,<302,414>,<166,336>,<235,294>,<329,379>,<397,397>,<240,474>,<310,379>,<363,407>,<297,354>,<247,329>,<385,391>,<290,481>,<416,414>,<344,438>,<219,310>,<281,391>,<446,481>,<257,329>,<361,432>,<297,397>,<189,329>,<203,240>,<323,367>,<440,456>,<166,316>,<323,474>,<452,468>,<261,310>,<363,414>,<261,426>,<219,348>,<261,420>,<393,462>,<312,385>,<373,481>,<288,310>,<348,468>,<247,373>,<434,414>,<385,456>,<288,420>,<288,426>,<348,474>,<302,342>,<302,438>,<195,235>,<323,468>,<166,277>,<452,474>,<189,253>,<464,462>,<288,348>,<422,444>,<284,438>,<284,342>,<189,373>,<261,348>,<281,456>,<219,426>,<407,438>,<219,420>,<257,373>,<348,367>,<219,273>,<350,468>,<357,373>,<344,462>,<265,316>,<195,329>,<342,397>,<203,391>,<310,310>,<393,438>,<410,481>,<302,462>,<397,481>,<310,348>,<329,348>,<407,462>,<273,450>,<369,481>,<464,438>,<195,253>,<195,373>,<332,407>,<312,432>,<284,462>,<319,481>,<253,294>,<294,481>,<177,367>,<350,474>,<235,397>,<342,354>,<277,336>,<240,450>,<235,354>,<177,474>,<367,397>,<350,367>,<329,420>,<310,426>,<329,426>,<310,420>,<189,235>,<203,456>,<332,414>,<361,385>,<294,294>,<253,481>,<177,468>,<203,265>,<393,414>,<375,432>,<373,397>,<434,462>,<348,450>,<354,361>,<277,316>,<464,414>,<312,329>,<265,336>,<416,462>,<189,385>,<323,450>,<288,379>,<332,438>,<452,450>,<363,462>,<387,456>,<357,432>,<306,391>,<247,385>,<399,426>,<399,420>,<195,432>,<312,373>,<166,257>,<219,379>,<297,481>,<393,407>,<316,444>,<306,456>,<290,354>,<310,323>,<329,323>,<257,385>,<470,444>,<336,336>,<290,397>,<261,379>};
	dontNestGroupsINT = {<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},{310,316,284,290,297}>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},{265,277,281,302,235,273,240,257,247,261,288,294,253}>,<{474,438,391,426,432,462,414,385,420,407,450,397,444,456,481,468},{375,385}>,<{481},{474,438,426,432,462,414,420,450,444,456,481,468}>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},{336,325,348,354,342,319}>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},{357,363,373}>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},{323,312,329,306}>,<{474,438,391,426,432,462,414,420,407,450,397,444,456,481,468},{391,381}>,<{1534},{1507,1495}>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},{338,350,361,344,332,367}>,<{1225},{1191,1206}>,<{1475},{1441,1453}>,<{474,438,426,432,462,414,420,407,450,397,444,456,481,468},{387,397}>,<{474,438,426,432,462,414,420,407,450,444,456,481,468},{399,393}>,<{474,438,426,432,462,414,420,450,444,456,481,468},{452,440,470,422,407,464,446,410,434,416,458,428}>,<{474,438,391,426,432,462,414,385,407,450,397,444,456,481,468,379,420},{379,369}>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},{166,177,195,189,219,203}>};


    set[rel[set[int] children, int parent]] allGINT = {{<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},338>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},273>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},316>,<{474,438,391,426,432,462,414,385,407,450,397,444,456,481,468,379,420},369>,<{474,438,426,432,462,414,420,450,444,456,481,468},458>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},294>,<{1225},1206>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},290>,<{481},432>,<{1475},1453>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},323>,<{474,438,426,432,462,414,420,407,450,444,456,481,468},393>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},354>,<{474,438,426,432,462,414,420,450,444,456,481,468},422>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},166>,<{474,438,426,432,462,414,420,450,444,456,481,468},470>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},361>,<{474,438,391,426,432,462,414,420,407,450,397,444,456,481,468},381>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},329>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},277>,<{474,438,426,432,462,414,420,450,444,456,481,468},428>,<{481},426>,<{481},420>,<{1534},1495>,<{474,438,426,432,462,414,420,450,444,456,481,468},446>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},257>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},189>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},342>,<{474,438,391,426,432,462,414,385,420,407,450,397,444,456,481,468},375>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},363>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},310>,<{474,438,426,432,462,414,420,407,450,397,444,456,481,468},387>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},297>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},332>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},177>,<{481},450>,<{474,438,426,432,462,414,420,407,450,444,456,481,468},399>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},253>,<{1475},1441>,<{336,474,438,391,361,426,462,414,385,316,407,450,373,397,323,348,432,329,310,444,456,481,468,379,354,420,342,367},284>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},219>,<{474,438,426,432,462,414,420,450,444,456,481,468},464>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},235>,<{474,438,426,432,462,414,420,450,444,456,481,468},416>,<{481},474>,<{481},468>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},288>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},261>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},350>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},348>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},281>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},312>,<{474,438,426,432,462,414,420,407,450,397,444,456,481,468},397>,<{481},462>,<{474,438,391,426,432,462,414,420,407,450,397,444,456,481,468},391>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},302>,<{481},438>,<{1534},1507>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},203>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},357>,<{277,474,438,361,426,462,414,316,450,373,336,265,323,348,273,240,257,391,247,432,329,310,444,261,456,288,385,281,481,468,379,354,420,302,407,235,342,367,294,397,253},195>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},367>,<{481},414>,<{474,438,426,432,462,414,420,450,444,456,481,468},410>,<{1225},1191>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},265>,<{474,438,391,426,432,462,414,385,407,450,373,397,444,456,481,468,379,420},373>,<{474,438,391,426,432,462,414,385,407,450,397,444,456,481,468,379,420},379>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},319>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},240>,<{481},481>,<{481},456>,<{336,474,438,391,361,426,462,414,385,316,450,373,323,348,432,329,310,444,456,288,481,468,379,354,420,302,407,342,367,294,397},247>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},325>,<{474,438,426,432,462,414,420,450,444,456,481,468},440>,<{474,438,391,426,432,462,414,385,420,407,450,397,444,456,481,468},385>,<{336,474,438,391,361,426,462,414,385,407,450,373,397,323,348,432,329,444,456,481,468,379,354,420,342,367},306>,<{474,438,426,432,462,414,420,450,444,456,481,468},452>,<{336,474,438,348,391,361,426,432,462,414,385,407,450,373,397,444,456,481,468,379,354,420,342,367},336>,<{481},444>,<{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420},344>,<{474,438,426,432,462,414,420,450,444,456,481,468},407>,<{474,438,426,432,462,414,420,450,444,456,481,468},434>}};
	rel[set[int] children, int parent] allG = {<dontNestINT[p],p> | int p <- dontNestINT.parent};
	
	println("{allG }== allGINT: <{allG} == allGINT>");
	
	rel[set[int] children, set[int] parents] dontNestGroups = 
      {<c,g[c]> | rel[set[int] children, int parent] g := {<dontNestINT[p],p> | p <- dontNestINT.parent}, c <- g.children};
      
    rel[set[int] children, set[int] parents] dontNestGroups1 = 
      {<c,g[c]> | rel[set[int] children, int parent] g := allG, c <- g.children};
      
    rel[set[int] children, set[int] parents] dontNestGroups2 = 
      {<c,allG[c]> | c <- allG.children};
    
    println("dontNestGroups: <dontNestGroups>");
    println("dontNestGroups1: <dontNestGroups1>");
    println("dontNestGroups2: <dontNestGroups2>");
    
    println("allG[{...}] = <allG[{474,438,391,361,426,432,462,414,385,407,450,373,367,397,444,456,481,468,379,420}]>");
    
    println("dontNestGroups == dontNestGroupsINT: <dontNestGroups == dontNestGroupsINT>");
    println("dontNestGroups1 == dontNestGroupsINT: <dontNestGroups1 == dontNestGroupsINT>");
    println("dontNestGroups2 == dontNestGroupsINT: <dontNestGroups2 == dontNestGroupsINT>");
	
	return dontNestGroupsINT == dontNestGroups;
}

value compare4(){
    r = {<{1,2}, "a">, <{10,20}, "b">};
	return r[{10,20}];
}




