module lang::rascalcore::grammar::tests::CGrammar

import IO;
import Grammar;
import ParseTree;
import lang::rascal::grammar::ParserGenerator;
import lang::rascal::grammar::Lookahead;
import util::Benchmark;
import util::Reflective;
import lang::rascal::grammar::tests::ParserGeneratorTests;

public Grammar C = grammar({sort("TranslationUnit")},

(
empty(): choice(empty(),{prod(empty(),[],{})}),
sort("MoreParameters"): choice(sort("MoreParameters"),{prod(sort("MoreParameters"),[lit(","),layouts("LAYOUTLIST"),lit("...")],{})}),
sort("Specifier"): choice(sort("Specifier"),{prod(label("typeSpecifier",sort("Specifier")),[sort("TypeSpecifier")],{}),prod(label("typeQualifier",sort("Specifier")),[sort("TypeQualifier")],{}),prod(label("storageClass",sort("Specifier")),[sort("StorageClass")],{})}),
sort("Declarator"): choice(sort("Declarator"),{priority(sort("Declarator"),[choice(sort("Declarator"),{prod(label("bracket",sort("Declarator")),[lit("("),layouts("LAYOUTLIST"),label("decl",sort("Declarator")),layouts("LAYOUTLIST"),lit(")")],{\bracket()}),prod(label("functionDeclarator",sort("Declarator")),[label("decl",sort("Declarator")),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),label("params",opt(sort("Parameters"))),layouts("LAYOUTLIST"),lit(")")],{}),prod(label("identifier",sort("Declarator")),[lex("Identifier")],{}),prod(label("arrayDeclarator",sort("Declarator")),[label("decl",sort("Declarator")),layouts("LAYOUTLIST"),lit("["),layouts("LAYOUTLIST"),label("exp",opt(sort("Expression"))),layouts("LAYOUTLIST"),lit("]")],{})}),prod(label("pointerDeclarator",sort("Declarator")),[lit("*"),layouts("LAYOUTLIST"),label("qualifiers",\iter-star-seps(sort("TypeQualifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("decl",sort("Declarator"))],{})])}),
sort("TypeQualifier"): choice(sort("TypeQualifier"),{prod(sort("TypeQualifier"),[lit("volatile")],{}),prod(sort("TypeQualifier"),[lit("const")],{})}),
sort("TranslationUnit"): choice(sort("TranslationUnit"),{prod(sort("TranslationUnit"),[\iter-seps(sort("ExternalDeclaration"),[layouts("LAYOUTLIST")])],{})}),
sort("AnonymousIdentifier"): choice(sort("AnonymousIdentifier"),{prod(sort("AnonymousIdentifier"),[],{})}),
sort("FunctionDefinition"): choice(sort("FunctionDefinition"),{prod(label("defaultFunctionDefinition",sort("FunctionDefinition")),[label("specs",\iter-star-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),sort("Declarator"),layouts("LAYOUTLIST"),\iter-star-seps(sort("Declaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("Declaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),\iter-star-seps(sort("Statement"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{})}),
lex("MultiLineCommentBodyToken"): choice(lex("MultiLineCommentBodyToken"),{prod(lex("MultiLineCommentBodyToken"),[\char-class([range(1,41),range(43,16777215)])],{}),prod(lex("MultiLineCommentBodyToken"),[lex("Asterisk")],{})}),
sort("NonCommaExpression"): choice(sort("NonCommaExpression"),{prod(label("nonCommaExpression",sort("NonCommaExpression")),[label("expr",sort("Expression"))],{})}),
\start(sort("TranslationUnit")): choice(\start(sort("TranslationUnit")),{prod(\start(sort("TranslationUnit")),[layouts("LAYOUTLIST"),label("top",sort("TranslationUnit")),layouts("LAYOUTLIST")],{})}),
sort("Expression"): choice(sort("Expression"),{priority(sort("Expression"),[choice(sort("Expression"),{prod(sort("Expression"),[lex("FloatingPointConstant")],{\tag("category"("Constant"))}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("-\>"),layouts("LAYOUTLIST"),lex("Identifier")],{}),prod(label("variable",sort("Expression")),[lex("Identifier")],{}),prod(sort("Expression"),[lex("HexadecimalConstant")],{\tag("category"("Constant"))}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),\iter-star-seps(sort("NonCommaExpression"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit(")")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("."),layouts("LAYOUTLIST"),lex("Identifier")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("["),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit("]")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("--")],{}),prod(sort("Expression"),[lex("IntegerConstant")],{\tag("category"("Constant"))}),prod(sort("Expression"),[lex("StringConstant")],{\tag("category"("Constant"))}),prod(sort("Expression"),[lit("sizeof"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("TypeName"),layouts("LAYOUTLIST"),lit(")")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("++")],{}),prod(label("bracket",sort("Expression")),[lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")")],{\bracket()}),prod(sort("Expression"),[lex("CharacterConstant")],{\tag("category"("Constant"))})}),choice(sort("Expression"),{prod(sort("Expression"),[lit("~"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(label("sizeOfExpression",sort("Expression")),[lit("sizeof"),layouts("LAYOUTLIST"),label("exp",sort("Expression"))],{}),prod(sort("Expression"),[conditional(lit("--"),{\not-precede(\char-class([range(45,45)]))}),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[conditional(lit("++"),{\not-precede(\char-class([range(43,43)]))}),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("-"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("+"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("*"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("("),layouts("LAYOUTLIST"),sort("TypeName"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("!"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[lit("&"),layouts("LAYOUTLIST"),sort("Expression")],{})}),associativity(sort("Expression"),left(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("%"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("/"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(label("multiplicationExpression",sort("Expression")),[label("lexp",sort("Expression")),layouts("LAYOUTLIST"),lit("*"),layouts("LAYOUTLIST"),label("rexp",sort("Expression"))],{})}),associativity(sort("Expression"),left(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("+"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("-"),layouts("LAYOUTLIST"),sort("Expression")],{})}),associativity(sort("Expression"),left(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\<\<"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\>\>"),layouts("LAYOUTLIST"),sort("Expression")],{})}),associativity(sort("Expression"),left(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\>="),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\<="),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\>"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\<"),layouts("LAYOUTLIST"),sort("Expression")],{})}),associativity(sort("Expression"),left(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("=="),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("!="),layouts("LAYOUTLIST"),sort("Expression")],{})}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("&"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("^"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("|"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("&&"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("||"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("?"),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(":"),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),associativity(sort("Expression"),right(),{prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\>\>="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("+="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("*="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("-="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("^="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\n\t        | ="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("/="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("&="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("%="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())}),prod(sort("Expression"),[sort("Expression"),layouts("LAYOUTLIST"),lit("\<\<="),layouts("LAYOUTLIST"),sort("Expression")],{\assoc(right())})}),prod(label("commaExpression",sort("Expression")),[sort("Expression"),layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST"),sort("Expression")],{})])}),
layouts("$default$"): choice(layouts("$default$"),{prod(layouts("$default$"),[],{})}),
lex("Asterisk"): choice(lex("Asterisk"),{prod(lex("Asterisk"),[conditional(\char-class([range(42,42)]),{\not-follow(\char-class([range(47,47)]))})],{})}),
sort("Declaration"): choice(sort("Declaration"),{prod(label("declarationWithoutInitDecls",sort("Declaration")),[label("specs",\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),lit(";")],{}),prod(label("declarationWithInitDecls",sort("Declaration")),[label("specs",\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("initDeclarators",\iter-seps(sort("InitDeclarator"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),lit(";")],{})}),
sort("StorageClass"): choice(sort("StorageClass"),{prod(sort("StorageClass"),[lit("auto")],{}),prod(label("typeDef",sort("StorageClass")),[lit("typedef")],{}),prod(sort("StorageClass"),[lit("extern")],{}),prod(sort("StorageClass"),[lit("static")],{}),prod(sort("StorageClass"),[lit("register")],{})}),
lex("StringConstant"): choice(lex("StringConstant"),{prod(lex("StringConstant"),[opt(\char-class([range(76,76)])),\char-class([range(34,34)]),\iter-star(lex("StringConstantContent")),\char-class([range(34,34)])],{})}),
sort("AbstractDeclarator"): choice(sort("AbstractDeclarator"),{priority(sort("AbstractDeclarator"),[choice(sort("AbstractDeclarator"),{prod(label("bracket",sort("AbstractDeclarator")),[lit("("),layouts("LAYOUTLIST"),label("decl",sort("AbstractDeclarator")),layouts("LAYOUTLIST"),lit(")")],{\bracket()}),prod(label("arrayDeclarator",sort("AbstractDeclarator")),[label("decl",sort("AbstractDeclarator")),layouts("LAYOUTLIST"),lit("["),layouts("LAYOUTLIST"),label("exp",opt(sort("Expression"))),layouts("LAYOUTLIST"),lit("]")],{}),prod(label("functionDeclarator",sort("AbstractDeclarator")),[label("decl",sort("AbstractDeclarator")),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),label("params",opt(sort("Parameters"))),layouts("LAYOUTLIST"),lit(")")],{}),prod(label("identifier",sort("AbstractDeclarator")),[sort("AnonymousIdentifier")],{})}),prod(label("pointerDeclarator",sort("AbstractDeclarator")),[lit("*"),layouts("LAYOUTLIST"),label("qualifiers",\iter-star-seps(sort("TypeQualifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("decl",sort("AbstractDeclarator"))],{})])}),
sort("PrototypeDeclarator"): choice(sort("PrototypeDeclarator"),{priority(sort("PrototypeDeclarator"),[choice(sort("PrototypeDeclarator"),{prod(label("identifier",sort("PrototypeDeclarator")),[lex("Identifier")],{}),prod(label("arrayDeclarator",sort("PrototypeDeclarator")),[label("proto_decl",sort("PrototypeDeclarator")),layouts("LAYOUTLIST"),lit("["),layouts("LAYOUTLIST"),label("exp",opt(sort("Expression"))),layouts("LAYOUTLIST"),lit("]")],{}),prod(label("functionDeclarator",sort("PrototypeDeclarator")),[label("proto_decl",sort("PrototypeDeclarator")),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),label("params",opt(sort("PrototypeParameters"))),layouts("LAYOUTLIST"),lit(")")],{}),prod(label("bracket",sort("PrototypeDeclarator")),[lit("("),layouts("LAYOUTLIST"),label("abs_decl",sort("AbstractDeclarator")),layouts("LAYOUTLIST"),lit(")")],{\bracket()})}),prod(label("pointerDeclarator",sort("PrototypeDeclarator")),[lit("*"),layouts("LAYOUTLIST"),label("qualifiers",\iter-star-seps(sort("TypeQualifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("decl",sort("PrototypeDeclarator"))],{})])}),
layouts("LAYOUTLIST"): choice(layouts("LAYOUTLIST"),{prod(layouts("LAYOUTLIST"),[conditional(\iter-star(lex("LAYOUT")),{\not-follow(\char-class([range(9,10),range(13,13),range(32,32)]))})],{})}),
sort("GlobalDeclaration"): choice(sort("GlobalDeclaration"),{prod(label("globalDeclarationWithInitDecls",sort("GlobalDeclaration")),[label("specs0",\iter-star-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("initDeclarators",\iter-seps(sort("InitDeclarator"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),lit(";")],{}),prod(label("globalDeclarationWithoutInitDecls",sort("GlobalDeclaration")),[label("specs1",\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),lit(";")],{})}),
lex("Comment"): choice(lex("Comment"),{prod(lex("Comment"),[lit("//"),\iter-star(\char-class([range(1,9),range(11,16777215)])),\char-class([range(10,10)])],{}),prod(lex("Comment"),[\char-class([range(47,47)]),\char-class([range(42,42)]),\iter-star(lex("MultiLineCommentBodyToken")),\char-class([range(42,42)]),\char-class([range(47,47)])],{})}),
sort("Parameter"): choice(sort("Parameter"),{prod(sort("Parameter"),[\iter-star-seps(sort("Specifier"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),sort("Declarator")],{})}),
keywords("Keyword"): choice(keywords("Keyword"),{prod(keywords("Keyword"),[lit("extern")],{}),prod(keywords("Keyword"),[lit("int")],{}),prod(keywords("Keyword"),[lit("signed")],{}),prod(keywords("Keyword"),[lit("char")],{}),prod(keywords("Keyword"),[lit("const")],{}),prod(keywords("Keyword"),[lit("typedef")],{}),prod(keywords("Keyword"),[lit("register")],{}),prod(keywords("Keyword"),[lit("union")],{}),prod(keywords("Keyword"),[lit("unsigned")],{}),prod(keywords("Keyword"),[lit("auto")],{}),prod(keywords("Keyword"),[lit("goto")],{}),prod(keywords("Keyword"),[lit("do")],{}),prod(keywords("Keyword"),[lit("continue")],{}),prod(keywords("Keyword"),[lit("for")],{}),prod(keywords("Keyword"),[lit("break")],{}),prod(keywords("Keyword"),[lit("short")],{}),prod(keywords("Keyword"),[lit("double")],{}),prod(keywords("Keyword"),[lit("struct")],{}),prod(keywords("Keyword"),[lit("case")],{}),prod(keywords("Keyword"),[lit("while")],{}),prod(keywords("Keyword"),[lit("switch")],{}),prod(keywords("Keyword"),[lit("default")],{}),prod(keywords("Keyword"),[lit("float")],{}),prod(keywords("Keyword"),[lit("long")],{}),prod(keywords("Keyword"),[lit("static")],{}),prod(keywords("Keyword"),[lit("sizeof")],{}),prod(keywords("Keyword"),[lit("volatile")],{}),prod(keywords("Keyword"),[lit("void")],{}),prod(keywords("Keyword"),[lit("enum")],{}),prod(keywords("Keyword"),[lit("if")],{}),prod(keywords("Keyword"),[lit("return")],{}),prod(keywords("Keyword"),[lit("else")],{})}),
sort("Parameters"): choice(sort("Parameters"),{prod(sort("Parameters"),[\iter-seps(sort("Parameter"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),opt(sort("MoreParameters"))],{}),prod(sort("Parameters"),[lit("void")],{})}),
lex("IntegerConstant"): choice(lex("IntegerConstant"),{prod(lex("IntegerConstant"),[iter(\char-class([range(48,57)])),conditional(\iter-star(\char-class([range(76,76),range(85,85),range(108,108),range(117,117)])),{\not-follow(\char-class([range(48,57)]))})],{})}),
sort("FunctionPrototype"): choice(sort("FunctionPrototype"),{prod(label("defaultFunctionPrototype",sort("FunctionPrototype")),[label("specs",\iter-star-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),label("decl",sort("PrototypeDeclarator")),layouts("LAYOUTLIST"),lit(";")],{})}),
lex("StringConstantContent"): choice(lex("StringConstantContent"),{prod(lex("StringConstantContent"),[\char-class([range(92,92)]),\char-class([range(1,16777215)])],{}),prod(lex("StringConstantContent"),[\char-class([range(1,33),range(35,91),range(93,16777215)])],{})}),
sort("PrototypeParameters"): choice(sort("PrototypeParameters"),{prod(sort("PrototypeParameters"),[\iter-seps(sort("PrototypeParameter"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),opt(sort("MoreParameters"))],{}),prod(sort("PrototypeParameters"),[lit("void")],{})}),
sort("Statement"): choice(sort("Statement"),{prod(sort("Statement"),[sort("Expression"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("Declaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),\iter-star-seps(sort("Statement"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(sort("Statement"),[lit("case"),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(":"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("return"),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("if"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Statement"),layouts("LAYOUTLIST"),lit("else"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lex("Identifier"),layouts("LAYOUTLIST"),lit(":"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("break"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit(";")],{}),prod(sort("Statement"),[lit("continue"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("if"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("while"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("goto"),layouts("LAYOUTLIST"),lex("Identifier"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("do"),layouts("LAYOUTLIST"),sort("Statement"),layouts("LAYOUTLIST"),lit("while"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("for"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),opt(sort("Expression")),layouts("LAYOUTLIST"),lit(";"),layouts("LAYOUTLIST"),opt(sort("Expression")),layouts("LAYOUTLIST"),lit(";"),layouts("LAYOUTLIST"),opt(sort("Expression")),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("return"),layouts("LAYOUTLIST"),lit(";")],{}),prod(sort("Statement"),[lit("switch"),layouts("LAYOUTLIST"),lit("("),layouts("LAYOUTLIST"),sort("Expression"),layouts("LAYOUTLIST"),lit(")"),layouts("LAYOUTLIST"),sort("Statement")],{}),prod(sort("Statement"),[lit("default"),layouts("LAYOUTLIST"),lit(":"),layouts("LAYOUTLIST"),sort("Statement")],{})}),
sort("ExternalDeclaration"): choice(sort("ExternalDeclaration"),{prod(sort("ExternalDeclaration"),[sort("FunctionDefinition")],{}),prod(sort("ExternalDeclaration"),[sort("GlobalDeclaration")],{}),prod(sort("ExternalDeclaration"),[sort("FunctionPrototype")],{})}),
sort("InitDeclarator"): choice(sort("InitDeclarator"),{prod(sort("InitDeclarator"),[label("decl",sort("Declarator"))],{}),prod(sort("InitDeclarator"),[label("decl",sort("Declarator")),layouts("LAYOUTLIST"),lit("="),layouts("LAYOUTLIST"),sort("Initializer")],{})}),
lex("Identifier"): choice(lex("Identifier"),{prod(lex("Identifier"),[conditional(seq([\char-class([range(65,90),range(95,95),range(97,122)]),conditional(\iter-star(\char-class([range(48,57),range(65,90),range(95,95),range(97,122)])),{\not-follow(\char-class([range(48,57),range(65,90),range(95,95),range(97,122)]))})]),{delete(keywords("Keyword"))})],{})}),
sort("Initializer"): choice(sort("Initializer"),{prod(sort("Initializer"),[lit("{"),layouts("LAYOUTLIST"),\iter-seps(sort("Initializer"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),opt(lit(",")),layouts("LAYOUTLIST"),lit("}")],{}),prod(sort("Initializer"),[sort("NonCommaExpression")],{})}),
lex("LAYOUT"): choice(lex("LAYOUT"),{prod(label("whitespace",lex("LAYOUT")),[\char-class([range(9,10),range(13,13),range(32,32)])],{}),prod(label("comment",lex("LAYOUT")),[lex("Comment")],{\tag("category"("Comment"))})}),
lex("CharacterConstant"): choice(lex("CharacterConstant"),{prod(lex("CharacterConstant"),[opt(\char-class([range(76,76)])),\char-class([range(39,39)]),iter(lex("CharacterConstantContent")),\char-class([range(39,39)])],{})}),
sort("StructDeclaration"): choice(sort("StructDeclaration"),{prod(label("structDeclWithDecl",sort("StructDeclaration")),[label("specs",\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),\iter-seps(sort("StructDeclarator"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit(";")],{}),prod(label("structDeclWithoutDecl",sort("StructDeclaration")),[label("specs",\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")])),layouts("LAYOUTLIST"),lit(";")],{})}),
sort("TypeName"): choice(sort("TypeName"),{prod(sort("TypeName"),[\iter-seps(sort("Specifier"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),sort("AbstractDeclarator")],{})}),
lex("CharacterConstantContent"): choice(lex("CharacterConstantContent"),{prod(lex("CharacterConstantContent"),[\char-class([range(1,38),range(40,91),range(93,16777215)])],{}),prod(lex("CharacterConstantContent"),[\char-class([range(92,92)]),\char-class([range(1,16777215)])],{})}),
sort("Enumerator"): choice(sort("Enumerator"),{prod(sort("Enumerator"),[lex("Identifier")],{}),prod(sort("Enumerator"),[lex("Identifier"),layouts("LAYOUTLIST"),lit("="),layouts("LAYOUTLIST"),sort("NonCommaExpression")],{})}),
sort("TypeSpecifier"): choice(sort("TypeSpecifier"),{prod(label("char",sort("TypeSpecifier")),[lit("char")],{}),prod(sort("TypeSpecifier"),[lit("unsigned")],{}),prod(label("struct",sort("TypeSpecifier")),[lit("struct"),layouts("LAYOUTLIST"),lex("Identifier")],{}),prod(label("enumDecl",sort("TypeSpecifier")),[lit("enum"),layouts("LAYOUTLIST"),lex("Identifier"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-seps(sort("Enumerator"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(label("identifier",sort("TypeSpecifier")),[lex("Identifier")],{}),prod(label("void",sort("TypeSpecifier")),[lit("void")],{}),prod(label("int",sort("TypeSpecifier")),[lit("int")],{}),prod(label("union",sort("TypeSpecifier")),[lit("union"),layouts("LAYOUTLIST"),lex("Identifier")],{}),prod(label("structDecl",sort("TypeSpecifier")),[lit("struct"),layouts("LAYOUTLIST"),lex("Identifier"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("StructDeclaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(label("float",sort("TypeSpecifier")),[lit("float")],{}),prod(label("enumAnonDecl",sort("TypeSpecifier")),[lit("enum"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-seps(sort("Enumerator"),[layouts("LAYOUTLIST"),lit(","),layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(label("long",sort("TypeSpecifier")),[lit("long")],{}),prod(label("double",sort("TypeSpecifier")),[lit("double")],{}),prod(label("unionAnonDecl",sort("TypeSpecifier")),[lit("union"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("StructDeclaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(label("enum",sort("TypeSpecifier")),[lit("enum"),layouts("LAYOUTLIST"),lex("Identifier")],{}),prod(sort("TypeSpecifier"),[lit("signed")],{}),prod(label("unionDecl",sort("TypeSpecifier")),[lit("union"),layouts("LAYOUTLIST"),lex("Identifier"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("StructDeclaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{}),prod(label("short",sort("TypeSpecifier")),[lit("short")],{}),prod(label("structAnonDecl",sort("TypeSpecifier")),[lit("struct"),layouts("LAYOUTLIST"),lit("{"),layouts("LAYOUTLIST"),\iter-star-seps(sort("StructDeclaration"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),lit("}")],{})}),
lex("HexadecimalConstant"): choice(lex("HexadecimalConstant"),{prod(lex("HexadecimalConstant"),[\char-class([range(48,48)]),\char-class([range(88,88),range(120,120)]),iter(\char-class([range(48,57),range(65,70),range(97,102)])),conditional(\iter-star(\char-class([range(76,76),range(85,85),range(108,108),range(117,117)])),{\not-follow(\char-class([range(48,57),range(65,70),range(97,102)]))})],{})}),
lex("Exponent"): choice(lex("Exponent"),{prod(lex("Exponent"),[\char-class([range(69,69),range(101,101)]),opt(\char-class([range(43,43),range(45,45)])),conditional(iter(\char-class([range(48,57)])),{\not-follow(\char-class([range(48,57)]))})],{})}),
sort("PrototypeParameter"): choice(sort("PrototypeParameter"),{prod(sort("PrototypeParameter"),[\iter-star-seps(sort("Specifier"),[layouts("LAYOUTLIST")]),layouts("LAYOUTLIST"),sort("AbstractDeclarator")],{})}),
lex("FloatingPointConstant"): choice(lex("FloatingPointConstant"),{prod(lex("FloatingPointConstant"),[\iter-star(\char-class([range(48,57)])),\char-class([range(46,46)]),conditional(iter(\char-class([range(48,57)])),{\not-follow(\char-class([range(48,57)]))}),opt(lex("Exponent")),opt(\char-class([range(70,70),range(76,76),range(102,102),range(108,108)]))],{}),prod(lex("FloatingPointConstant"),[iter(\char-class([range(48,57)])),\char-class([range(46,46)]),opt(lex("Exponent")),opt(\char-class([range(70,70),range(76,76),range(102,102),range(108,108)]))],{}),prod(lex("FloatingPointConstant"),[iter(\char-class([range(48,57)])),lex("Exponent"),opt(\char-class([range(70,70),range(76,76),range(102,102),range(108,108)]))],{})}),
sort("StructDeclarator"): choice(sort("StructDeclarator"),{prod(sort("StructDeclarator"),[opt(sort("Declarator")),layouts("LAYOUTLIST"),lit(":"),layouts("LAYOUTLIST"),sort("Expression")],{}),prod(sort("StructDeclarator"),[sort("Declarator")],{})})
)
);

loc CParserLoc = |project://rascal/src/org/rascalmpl/library/lang/rascal/grammar/tests/| + "generated_parsers/CParser.java.gz";

str generateCParser() = newGenerate("org.rascalmpl.library.lang.rascal.grammar.tests.generated_parsers", "CParser", C);

void generateAndWriteCParser(){
	writeFile(CParserLoc, generateCParser());
}

int generateAndTimeCParser() { 
	println("GenerateAndTimeCParser");
	t = cpuTime(); 
	generateCParser();
	return (cpuTime() - t)/1000000;
}	

//value main() { return generateAndTimeCParser(); }
value main() {cnt = 0; visit(C){ case {*value _s}: cnt += 1; }; return cnt; }

test bool tstGenerateCParser() = sameLines(generateCParser(), readFile(CParserLoc));