/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.debug;

import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.debug.DebugRemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.debug.json.DebugMessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;

public final class DebugLauncher {
    private DebugLauncher() {
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).create();
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, boolean validate, PrintWriter trace) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).validateMessages(validate).traceMessages(trace).create();
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return DebugLauncher.createIoLauncher(localService, remoteInterface, in, out, executorService, wrapper);
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper, Consumer<GsonBuilder> configureGson) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).configureGson(configureGson).create();
    }

    public static class Builder<T>
    extends Launcher.Builder<T> {
        @Override
        protected MessageJsonHandler createJsonHandler() {
            Map<String, JsonRpcMethod> supportedMethods = this.getSupportedMethods();
            if (this.configureGson != null) {
                return new DebugMessageJsonHandler(supportedMethods, this.configureGson);
            }
            return new DebugMessageJsonHandler(supportedMethods);
        }

        @Override
        protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
            MessageConsumer outgoingMessageStream = new StreamMessageConsumer(this.output, jsonHandler);
            outgoingMessageStream = this.wrapMessageConsumer(outgoingMessageStream);
            Endpoint localEndpoint = ServiceEndpoints.toEndpoint(this.localServices);
            DebugRemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new DebugRemoteEndpoint(outgoingMessageStream, localEndpoint) : new DebugRemoteEndpoint(outgoingMessageStream, localEndpoint, this.exceptionHandler);
            jsonHandler.setMethodProvider(remoteEndpoint);
            remoteEndpoint.setJsonHandler(jsonHandler);
            return remoteEndpoint;
        }
    }
}

