/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.DocumentChanges;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class LSPIDEServices
implements IDEServices {
    private final IBaseLanguageClient languageClient;
    private final IBaseTextDocumentService docService;
    private final BaseWorkspaceService workspaceService;
    private final IRascalMonitor monitor;

    public LSPIDEServices(IBaseLanguageClient client, IBaseTextDocumentService docService, BaseWorkspaceService workspaceService, IRascalMonitor monitor) {
        this.languageClient = client;
        this.workspaceService = workspaceService;
        this.docService = docService;
        this.monitor = monitor;
    }

    public PrintWriter stderr() {
        assert (false) : "this should not be used here";
        return new PrintWriter(System.out);
    }

    public void browse(URI uri, IString title, IInteger viewColumn) {
        this.languageClient.showContent(uri, title, viewColumn);
    }

    public void edit(ISourceLocation path, int viewColumn) {
        ISourceLocation physical = Locations.toClientLocation(path);
        Range range = null;
        if (physical.hasOffsetLength()) {
            range = Locations.toRange(physical, this.docService.getColumnMap(physical));
        }
        this.languageClient.editDocument(Locations.toUri(path), range, viewColumn);
    }

    public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        for (WorkspaceFolder folder : this.workspaceService.workspaceFolders()) {
            if (!folder.getName().equals(input.getAuthority())) continue;
            return this.buildProjectChildLoc(folder, input);
        }
        return input;
    }

    private ISourceLocation buildProjectChildLoc(WorkspaceFolder folder, ISourceLocation input) {
        ISourceLocation root = Locations.toLoc(folder.getUri());
        return URIUtil.getChildLocation((ISourceLocation)root, (String)input.getPath());
    }

    public void applyDocumentsEdits(IList edits) {
        this.applyFileSystemEdits(edits);
    }

    public void applyFileSystemEdits(IList edits) {
        this.languageClient.applyEdit(new ApplyWorkspaceEditParams(DocumentChanges.translateDocumentChanges(edits, this.docService.getColumnMaps())));
    }

    public void registerLocations(IString scheme, IString auth, IMap map) {
        super.registerLocations(scheme, auth, map);
    }

    public void registerDiagnostics(IList messages) {
        Map<ISourceLocation, List<Diagnostic>> translated = Diagnostics.translateMessages(messages, this.docService.getColumnMaps());
        for (Map.Entry<ISourceLocation, List<Diagnostic>> entry : translated.entrySet()) {
            String uri = Locations.toUri(entry.getKey()).toString();
            this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(uri, entry.getValue()));
        }
    }

    public void unregisterDiagnostics(IList resources) {
        for (IValue elem : resources) {
            String uri = Locations.toUri((ISourceLocation)elem).toString();
            this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(uri, Collections.emptyList()));
        }
    }

    public void jobStart(String name, int workShare, int totalWork) {
        this.monitor.jobStart(name, workShare, totalWork);
    }

    public void jobStep(String name, String message, int workShare) {
        this.monitor.jobStep(name, message, workShare);
    }

    public int jobEnd(String name, boolean succeeded) {
        return this.monitor.jobEnd(name, succeeded);
    }

    public boolean jobIsCanceled(String name) {
        return this.monitor.jobIsCanceled(name);
    }

    public void jobTodo(String name, int work) {
        this.monitor.jobTodo(name, work);
    }

    public void endAllJobs() {
        this.monitor.endAllJobs();
    }

    public void warning(String message, ISourceLocation src) {
        this.monitor.warning(message, src);
    }

    public IRascalMonitor getMonitor() {
        return this.monitor;
    }
}

