/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.log;

import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class LogJsonConfiguration
extends ConfigurationFactory {
    @Override
    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return this.buildConfiguration();
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation, ClassLoader loader) {
        return this.buildConfiguration();
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.buildConfiguration();
    }

    private Configuration buildConfiguration() {
        Level targetLevel = Level.getLevel(System.getProperty("log4j2.level", "INFO"));
        if (targetLevel == null) {
            targetLevel = Level.INFO;
        }
        ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("JsonLogger");
        builder.setStatusLevel(targetLevel);
        builder.add(((AppenderComponentBuilder)builder.newAppender("Console", "Console").addAttribute("target", ConsoleAppender.Target.SYSTEM_ERR)).add((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("JsonTemplateLayout").addAttribute("maxStringLength", 6000)).addAttribute("eventTemplateUri", "classpath:JsonLogTemplate.json")));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(targetLevel).add(builder.newAppenderRef("Console")));
        return (Configuration)builder.build();
    }
}

