/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.RascalLSPMonitor;
import org.rascalmpl.vscode.lsp.parametric.EmptySummary;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.util.EvaluatorUtil;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public class InterpretedLanguageContributions
implements ILanguageContributions {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private static final Logger logger = LogManager.getLogger(InterpretedLanguageContributions.class);
    private final ExecutorService exec;
    private final String name;
    private final String mainModule;
    private final CompletableFuture<Evaluator> eval;
    private final CompletableFuture<TypeStore> store;
    private final CompletableFuture<IFunction> parsing;
    private final CompletableFuture<@Nullable IFunction> analysis;
    private final CompletableFuture<@Nullable IFunction> build;
    private final CompletableFuture<@Nullable IFunction> documentSymbol;
    private final CompletableFuture<@Nullable IFunction> codeLens;
    private final CompletableFuture<@Nullable IFunction> inlayHint;
    private final CompletableFuture<@Nullable IFunction> execution;
    private final CompletableFuture<@Nullable IFunction> hover;
    private final CompletableFuture<@Nullable IFunction> definition;
    private final CompletableFuture<@Nullable IFunction> references;
    private final CompletableFuture<@Nullable IFunction> implementation;
    private final CompletableFuture<@Nullable IFunction> codeAction;
    private final CompletableFuture<@Nullable IFunction> prepareRename;
    private final CompletableFuture<@Nullable IFunction> rename;
    private final CompletableFuture<@Nullable IFunction> didRenameFiles;
    private final CompletableFuture<@Nullable IFunction> selectionRange;
    private final CompletableFuture<@Nullable IFunction> prepareCallHierarchy;
    private final CompletableFuture<@Nullable IFunction> callHierarchyService;
    private final CompletableFuture<Boolean> hasAnalysis;
    private final CompletableFuture<Boolean> hasBuild;
    private final CompletableFuture<Boolean> hasDocumentSymbol;
    private final CompletableFuture<Boolean> hasCodeLens;
    private final CompletableFuture<Boolean> hasInlayHint;
    private final CompletableFuture<Boolean> hasExecution;
    private final CompletableFuture<Boolean> hasHover;
    private final CompletableFuture<Boolean> hasDefinition;
    private final CompletableFuture<Boolean> hasReferences;
    private final CompletableFuture<Boolean> hasImplementation;
    private final CompletableFuture<Boolean> hasCodeAction;
    private final CompletableFuture<Boolean> hasRename;
    private final CompletableFuture<Boolean> hasDidRenameFiles;
    private final CompletableFuture<Boolean> hasSelectionRange;
    private final CompletableFuture<Boolean> hasCallHierarchy;
    private final CompletableFuture<Boolean> specialCaseHighlighting;
    private final CompletableFuture<ILanguageContributions.SummaryConfig> analyzerSummaryConfig;
    private final CompletableFuture<ILanguageContributions.SummaryConfig> builderSummaryConfig;
    private final CompletableFuture<ILanguageContributions.SummaryConfig> ondemandSummaryConfig;
    private final IBaseLanguageClient client;
    private final RascalLSPMonitor monitor;

    public InterpretedLanguageContributions(LanguageRegistry.LanguageParameter lang, IBaseTextDocumentService docService, BaseWorkspaceService workspaceService, IBaseLanguageClient client, ExecutorService exec) {
        this.client = client;
        this.name = lang.getName();
        this.mainModule = lang.getMainModule();
        this.exec = exec;
        try {
            PathConfig pcfg = PathConfig.parse((String)lang.getPathConfig());
            pcfg = EvaluatorUtil.addLSPSources(pcfg, false);
            this.monitor = new RascalLSPMonitor(client, LogManager.getLogger(logger.getName() + "[" + lang.getName() + "]"), lang.getName() + ": ");
            this.eval = EvaluatorUtil.makeFutureEvaluator(new EvaluatorUtil.LSPContext(exec, docService, workspaceService, client), "evaluator for " + lang.getName(), this.monitor, pcfg, lang.getMainModule());
            CompletableFuture<ISet> contributions = EvaluatorUtil.runEvaluator(this.name + ": loading contributions", this.eval, e -> InterpretedLanguageContributions.loadContributions(e, lang), ValueFactoryFactory.getValueFactory().set(new IValue[0]), exec, true, client).get();
            this.store = this.eval.thenApply(e -> ((ModuleEnvironment)e.getModule(this.mainModule)).getStore());
            this.parsing = InterpretedLanguageContributions.requireFunction(contributions, "parsing");
            this.analysis = InterpretedLanguageContributions.getFunctionFor(contributions, "analysis");
            this.build = InterpretedLanguageContributions.getFunctionFor(contributions, "build");
            this.documentSymbol = InterpretedLanguageContributions.getFunctionFor(contributions, "documentSymbol");
            this.codeLens = InterpretedLanguageContributions.getFunctionFor(contributions, "codeLens");
            this.inlayHint = InterpretedLanguageContributions.getFunctionFor(contributions, "inlayHint");
            this.execution = InterpretedLanguageContributions.getFunctionFor(contributions, "execution");
            this.hover = InterpretedLanguageContributions.getFunctionFor(contributions, "hover");
            this.definition = InterpretedLanguageContributions.getFunctionFor(contributions, "definition");
            this.references = InterpretedLanguageContributions.getFunctionFor(contributions, "references");
            this.implementation = InterpretedLanguageContributions.getFunctionFor(contributions, "implementation");
            this.codeAction = InterpretedLanguageContributions.getFunctionFor(contributions, "codeAction");
            this.prepareRename = InterpretedLanguageContributions.getKeywordParamFunctionFor(contributions, "rename", "prepareRenameService");
            this.rename = InterpretedLanguageContributions.getFunctionFor(contributions, "rename");
            this.didRenameFiles = InterpretedLanguageContributions.getFunctionFor(contributions, "didRenameFiles");
            this.selectionRange = InterpretedLanguageContributions.getFunctionFor(contributions, "selectionRange");
            this.prepareCallHierarchy = InterpretedLanguageContributions.getFunctionFor(contributions, "callHierarchy", 0);
            this.callHierarchyService = InterpretedLanguageContributions.getFunctionFor(contributions, "callHierarchy", 1);
            this.hasAnalysis = InterpretedLanguageContributions.nonNull(this.analysis);
            this.hasBuild = InterpretedLanguageContributions.nonNull(this.build);
            this.hasDocumentSymbol = InterpretedLanguageContributions.nonNull(this.documentSymbol);
            this.hasCodeLens = InterpretedLanguageContributions.nonNull(this.codeLens);
            this.hasInlayHint = InterpretedLanguageContributions.nonNull(this.inlayHint);
            this.hasExecution = InterpretedLanguageContributions.nonNull(this.execution);
            this.hasHover = InterpretedLanguageContributions.nonNull(this.hover);
            this.hasDefinition = InterpretedLanguageContributions.nonNull(this.definition);
            this.hasReferences = InterpretedLanguageContributions.nonNull(this.references);
            this.hasImplementation = InterpretedLanguageContributions.nonNull(this.implementation);
            this.hasCodeAction = InterpretedLanguageContributions.nonNull(this.codeAction);
            this.hasRename = InterpretedLanguageContributions.nonNull(this.rename);
            this.hasDidRenameFiles = InterpretedLanguageContributions.nonNull(this.didRenameFiles);
            this.hasSelectionRange = InterpretedLanguageContributions.nonNull(this.selectionRange);
            this.hasCallHierarchy = InterpretedLanguageContributions.nonNull(this.prepareCallHierarchy);
            this.specialCaseHighlighting = InterpretedLanguageContributions.getContributionParameter(contributions, "parsing", "usesSpecialCaseHighlighting");
            this.analyzerSummaryConfig = InterpretedLanguageContributions.scheduledSummaryConfig(contributions, "analysis");
            this.builderSummaryConfig = InterpretedLanguageContributions.scheduledSummaryConfig(contributions, "build");
            this.ondemandSummaryConfig = InterpretedLanguageContributions.ondemandSummaryConfig(contributions);
        }
        catch (IOException e1) {
            logger.catching(e1);
            throw new IllegalArgumentException(e1);
        }
    }

    private static CompletableFuture<Boolean> nonNull(CompletableFuture<?> x) {
        return x.thenApply(Objects::nonNull);
    }

    private static CompletableFuture<ILanguageContributions.SummaryConfig> scheduledSummaryConfig(CompletableFuture<ISet> contributions, String summarizer) {
        return contributions.thenApply(c -> {
            IConstructor constructor = InterpretedLanguageContributions.getContribution(c, summarizer);
            if (constructor != null) {
                return new ILanguageContributions.SummaryConfig(InterpretedLanguageContributions.isTrue(constructor, "providesHovers"), InterpretedLanguageContributions.isTrue(constructor, "providesDefinitions"), InterpretedLanguageContributions.isTrue(constructor, "providesReferences"), InterpretedLanguageContributions.isTrue(constructor, "providesImplementations"));
            }
            return ILanguageContributions.SummaryConfig.FALSY;
        });
    }

    private static CompletableFuture<ILanguageContributions.SummaryConfig> ondemandSummaryConfig(CompletableFuture<ISet> contributions) {
        return contributions.thenApply(c -> new ILanguageContributions.SummaryConfig(InterpretedLanguageContributions.hasContribution(c, "hover"), InterpretedLanguageContributions.hasContribution(c, "definition"), InterpretedLanguageContributions.hasContribution(c, "references"), InterpretedLanguageContributions.hasContribution(c, "implementation")));
    }

    private static @Nullable IConstructor getContribution(ISet contributions, String name) {
        return contributions.stream().map(IConstructor.class::cast).filter(cons -> cons.getConstructorType().getName().equals(name)).findAny().orElse(null);
    }

    private static boolean hasContribution(ISet contributions, String name) {
        return InterpretedLanguageContributions.getContribution(contributions, name) != null;
    }

    private static CompletableFuture<Boolean> getContributionParameter(CompletableFuture<ISet> contributions, String name, String parameter) {
        return contributions.thenApply(c -> InterpretedLanguageContributions.isTrue(InterpretedLanguageContributions.getContribution(c, name), parameter));
    }

    private static boolean isTrue(@Nullable IConstructor constructor, String parameter) {
        if (constructor == null) {
            return false;
        }
        IValue val = constructor.asWithKeywordParameters().getParameter(parameter);
        return !(val instanceof IBool) || ((IBool)val).getValue();
    }

    private static ISet loadContributions(Evaluator eval, LanguageRegistry.LanguageParameter lang) {
        return (ISet)eval.call(eval.getMonitor(), lang.getMainFunction(), new IValue[0]);
    }

    @Override
    public CompletableFuture<IList> parseCodeActions(String command) {
        return this.store.thenApply(commandStore -> {
            try {
                Type codeActionADT = commandStore.lookupAbstractDataType("CodeAction");
                if (codeActionADT == null) {
                    throw new IllegalArgumentException("CodeAction is not defined in environment");
                }
                return (IList)new StandardTextReader().read(VF, commandStore, TypeFactory.getInstance().listType(codeActionADT), (Reader)new StringReader(command));
            }
            catch (FactTypeUseException | IOException e) {
                throw new IllegalArgumentException("The command could not be parsed", e);
            }
        });
    }

    @Override
    public CompletableFuture<IConstructor> parseCallHierarchyData(String data) {
        return this.store.thenApply(completionStore -> {
            try {
                Type callHierarchyDataAdt = completionStore.lookupAbstractDataType("CallHierarchyData");
                if (callHierarchyDataAdt == null) {
                    throw new IllegalArgumentException("CallHierarchyData is not defined in environment");
                }
                if (data.isEmpty()) {
                    Type none = completionStore.lookupConstructor(callHierarchyDataAdt, "none", TypeFactory.getInstance().tupleEmpty());
                    if (none == null) {
                        throw new IllegalArgumentException("CallHierarchyData::none() is not defined in environment");
                    }
                    return VF.constructor(none);
                }
                return (IConstructor)new StandardTextReader().read(VF, completionStore, callHierarchyDataAdt, (Reader)new StringReader(data));
            }
            catch (FactTypeUseException | IOException e) {
                throw new IllegalArgumentException("The call hierarchy item data could not be parsed", e);
            }
        });
    }

    private CompletableFuture<IConstructor> parseCommand(String command) {
        return this.store.thenApply(commandStore -> {
            try {
                Type commandADT = commandStore.lookupAbstractDataType("Command");
                if (commandADT == null) {
                    throw new IllegalArgumentException("Command is not defined in environment");
                }
                return (IConstructor)new StandardTextReader().read(VF, commandStore, commandADT, (Reader)new StringReader(command));
            }
            catch (FactTypeUseException | IOException e) {
                logger.catching(e);
                throw new IllegalArgumentException("The command could not be parsed", e);
            }
        });
    }

    private static CompletableFuture<@Nullable IConstructor> getContribution(CompletableFuture<ISet> contributions, String cons) {
        return contributions.thenApply(conts -> {
            for (IValue elem : conts) {
                IConstructor contrib = (IConstructor)elem;
                if (!cons.equals(contrib.getConstructorType().getName())) continue;
                return contrib;
            }
            logger.debug("No {} defined", (Object)cons);
            return null;
        });
    }

    private static CompletableFuture<IFunction> requireFunction(CompletableFuture<ISet> contributions, String cons) {
        return InterpretedLanguageContributions.getContribution(contributions, cons).thenApply(con -> {
            if (con == null) {
                throw new IllegalStateException("Missing required contribution: " + cons);
            }
            return (IFunction)con.get(0);
        });
    }

    private static CompletableFuture<@Nullable IFunction> getFunctionFor(CompletableFuture<ISet> contributions, String cons) {
        return InterpretedLanguageContributions.getFunctionFor(contributions, cons, 0);
    }

    private static CompletableFuture<@Nullable IFunction> getFunctionFor(CompletableFuture<ISet> contributions, String cons, int argumentPos) {
        return InterpretedLanguageContributions.getContribution(contributions, cons).thenApply(contribution -> contribution != null ? (IFunction)contribution.get(argumentPos) : null);
    }

    private static CompletableFuture<@Nullable IFunction> getKeywordParamFunctionFor(CompletableFuture<ISet> contributions, String cons, String kwParam) {
        return InterpretedLanguageContributions.getContribution(contributions, cons).thenApply(contribution -> contribution != null ? (IFunction)contribution.asWithKeywordParameters().getParameter(kwParam) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<ITree> parsing(ISourceLocation loc, String input) {
        this.debug("parsing", loc, input);
        return this.parsing.thenApplyAsync(p -> (ITree)p.call(new IValue[]{VF.string(input), loc}), (Executor)this.exec);
    }

    @Override
    public InterruptibleFuture<IList> documentSymbol(ITree input) {
        this.debug("documentSymbol", TreeAdapter.getLocation((ITree)input));
        return this.execFunction("documentSymbol", this.documentSymbol, VF.list(new IValue[0]), new IValue[]{input});
    }

    @Override
    public InterruptibleFuture<IConstructor> analysis(ISourceLocation src, ITree input) {
        this.debug("analysis", src);
        return this.execFunction("analysis", this.analysis, EmptySummary.newInstance(src), new IValue[]{src, input});
    }

    @Override
    public InterruptibleFuture<IConstructor> build(ISourceLocation src, ITree input) {
        this.debug("build", src);
        return this.execFunction("build", this.build, EmptySummary.newInstance(src), new IValue[]{src, input});
    }

    @Override
    public InterruptibleFuture<IList> codeLens(ITree input) {
        this.debug("codeLens", TreeAdapter.getLocation((ITree)input));
        return this.execFunction("codeLens", this.codeLens, VF.list(new IValue[0]), new IValue[]{input});
    }

    @Override
    public InterruptibleFuture<IList> inlayHint(ITree input) {
        this.debug("inlayHint", TreeAdapter.getLocation((ITree)input));
        return this.execFunction("inlayHint", this.inlayHint, VF.list(new IValue[0]), new IValue[]{input});
    }

    @Override
    public InterruptibleFuture<ISourceLocation> prepareRename(IList focus) {
        this.debug("prepareRenameService", focus.isEmpty() ? "" : focus.get(0));
        return this.execFunction("prepareRenameService", this.prepareRename, URIUtil.unknownLocation(), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<ITuple> rename(IList focus, String newName) {
        this.debug("renameService", newName, focus.isEmpty() ? "" : focus.get(0));
        return this.execFunction("renameService", this.rename, VF.tuple(new IValue[]{VF.list(new IValue[0]), VF.list(new IValue[0])}), new IValue[]{focus, VF.string(newName)});
    }

    @Override
    public InterruptibleFuture<ITuple> didRenameFiles(IList fileRenames) {
        this.debug("didRenameFiles", fileRenames);
        return this.execFunction("didRenameFiles", this.didRenameFiles, VF.tuple(new IValue[]{VF.list(new IValue[0]), VF.set(new IValue[0])}), new IValue[]{fileRenames});
    }

    @Override
    public InterruptibleFuture<ISet> hover(IList focus) {
        this.debug("hover", focus.length());
        return this.execFunction("hover", this.hover, VF.set(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<ISet> definition(IList focus) {
        this.debug("definition", focus.length());
        return this.execFunction("definition", this.definition, VF.set(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<ISet> implementation(IList focus) {
        this.debug("implementation", focus.length());
        return this.execFunction("implementation", this.implementation, VF.set(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<ISet> references(IList focus) {
        this.debug("references", focus.length());
        return this.execFunction("references", this.references, VF.set(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<IList> codeAction(IList focus) {
        this.debug("codeAction", focus.length());
        return this.execFunction("codeAction", this.codeAction, VF.list(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<IList> selectionRange(IList focus) {
        this.debug("selectionRange", focus.length());
        return this.execFunction("selectionRange", this.selectionRange, VF.list(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<IList> prepareCallHierarchy(IList focus) {
        this.debug("callHierarchy", "prepare", focus.length());
        return this.execFunction("callHierarchy", this.prepareCallHierarchy, VF.list(new IValue[0]), new IValue[]{focus});
    }

    @Override
    public InterruptibleFuture<IList> incomingOutgoingCalls(IConstructor hierarchyItem, IConstructor direction) {
        this.debug("callHierarchy", hierarchyItem.has("name") ? hierarchyItem.get("name") : "?", direction.getName());
        return this.execFunction("callHierarchy", this.callHierarchyService, VF.list(new IValue[0]), new IValue[]{hierarchyItem, direction});
    }

    private void debug(String name, Object param) {
        logger.debug("{}({})", (Object)name, param);
    }

    private void debug(String name, Object param1, Object param2) {
        logger.debug("{}({},{})", (Object)name, param1, param2);
    }

    @Override
    public CompletableFuture<Boolean> hasDefinition() {
        return this.hasDefinition;
    }

    @Override
    public CompletableFuture<Boolean> hasReferences() {
        return this.hasReferences;
    }

    @Override
    public CompletableFuture<Boolean> hasImplementation() {
        return this.hasImplementation;
    }

    @Override
    public CompletableFuture<Boolean> hasHover() {
        return this.hasHover;
    }

    @Override
    public CompletableFuture<Boolean> hasExecution() {
        return this.hasExecution;
    }

    @Override
    public CompletableFuture<Boolean> hasInlayHint() {
        return this.hasInlayHint;
    }

    @Override
    public CompletableFuture<Boolean> hasRename() {
        return this.hasRename;
    }

    @Override
    public CompletableFuture<Boolean> hasDidRenameFiles() {
        return this.hasDidRenameFiles;
    }

    @Override
    public CompletableFuture<Boolean> hasCodeLens() {
        return this.hasCodeLens;
    }

    @Override
    public CompletableFuture<Boolean> hasDocumentSymbol() {
        return this.hasDocumentSymbol;
    }

    @Override
    public CompletableFuture<Boolean> hasCodeAction() {
        return this.hasCodeAction;
    }

    @Override
    public CompletableFuture<Boolean> hasSelectionRange() {
        return this.hasSelectionRange;
    }

    @Override
    public CompletableFuture<Boolean> hasCallHierarchy() {
        return this.hasCallHierarchy;
    }

    @Override
    public CompletableFuture<Boolean> hasAnalysis() {
        return this.hasAnalysis;
    }

    @Override
    public CompletableFuture<Boolean> hasBuild() {
        return this.hasBuild;
    }

    @Override
    public CompletableFuture<Boolean> specialCaseHighlighting() {
        return this.specialCaseHighlighting;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getAnalyzerSummaryConfig() {
        return this.analyzerSummaryConfig;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getBuilderSummaryConfig() {
        return this.builderSummaryConfig;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getOndemandSummaryConfig() {
        return this.ondemandSummaryConfig;
    }

    @Override
    public InterruptibleFuture<IValue> execution(String command) {
        logger.debug("executeCommand({}...) (full command value in TRACE level)", () -> command.substring(0, Math.min(10, command.length())));
        logger.trace("Full command: {}", (Object)command);
        return InterruptibleFuture.flatten(this.parseCommand(command).thenCombine(this.execution, (cons, func) -> {
            if (func == null) {
                logger.warn("Command is being executed without a registered command executor; for language {}", (Object)this.name);
                throw new IllegalStateException("No command executor registered for " + this.name);
            }
            return EvaluatorUtil.runEvaluator("executeCommand", this.eval, ev -> func.call(new IValue[]{cons}), VF.bool(false), this.exec, true, this.client);
        }), this.exec);
    }

    private <T> InterruptibleFuture<T> execFunction(String name, CompletableFuture<@Nullable IFunction> target, T defaultResult, IValue ... args) {
        if (target == null) {
            return InterruptibleFuture.completedFuture(defaultResult, this.exec);
        }
        return InterruptibleFuture.flatten(target.thenApply(s -> {
            if (s == null) {
                return InterruptibleFuture.completedFuture(defaultResult, this.exec);
            }
            return EvaluatorUtil.runEvaluator(name, this.eval, e -> s.call(args), defaultResult, this.exec, true, this.client);
        }), this.exec);
    }

    @Override
    public void cancelProgress(String progressId) {
        this.monitor.cancelProgress(progressId);
    }
}

