/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.IOUtils;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensDelta;
import org.eclipse.lsp4j.SemanticTokensDeltaParams;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensRangeParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.TextDocumentState;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.InterpretedLanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.LanguageContributionsMultiplexer;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.parametric.NoContributions;
import org.rascalmpl.vscode.lsp.parametric.ParserOnlyContribution;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricFileFacts;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummary;
import org.rascalmpl.vscode.lsp.uri.FallbackResolver;
import org.rascalmpl.vscode.lsp.util.CallHierarchy;
import org.rascalmpl.vscode.lsp.util.CodeActions;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.DocumentChanges;
import org.rascalmpl.vscode.lsp.util.DocumentSymbols;
import org.rascalmpl.vscode.lsp.util.FoldingRanges;
import org.rascalmpl.vscode.lsp.util.SelectionRanges;
import org.rascalmpl.vscode.lsp.util.SemanticTokenizer;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.locations.Locations;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeSearch;

public class ParametricTextDocumentService
implements IBaseTextDocumentService,
LanguageClientAware {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private static final Logger logger = LogManager.getLogger(ParametricTextDocumentService.class);
    private final ExecutorService exec;
    private final String dedicatedLanguageName;
    private final SemanticTokenizer tokenizer = new SemanticTokenizer();
    private @MonotonicNonNull LanguageClient client;
    private @MonotonicNonNull BaseWorkspaceService workspaceService;
    private final Map<ISourceLocation, TextDocumentState> files;
    private final ColumnMaps columns;
    private final Map<String, String> registeredExtensions = new ConcurrentHashMap<String, String>();
    private final Map<String, ParametricFileFacts> facts = new ConcurrentHashMap<String, ParametricFileFacts>();
    private final Map<String, LanguageContributionsMultiplexer> contributions = new ConcurrentHashMap<String, LanguageContributionsMultiplexer>();
    private final @Nullable LanguageRegistry.LanguageParameter dedicatedLanguage;
    private final TypeStore typeStore = new TypeStore(new TypeStore[0]);
    private final TypeFactory tf = TypeFactory.getInstance();
    private final Type renamedConstructor = this.tf.constructor(this.typeStore, this.tf.abstractDataType(this.typeStore, "FileSystemChange", new Type[0]), "renamed", new Object[]{this.tf.sourceLocationType(), "from", this.tf.sourceLocationType(), "to"});

    public ParametricTextDocumentService(ExecutorService exec, @Nullable LanguageRegistry.LanguageParameter dedicatedLanguage) {
        URIResolverRegistry.getInstance();
        this.exec = exec;
        this.files = new ConcurrentHashMap<ISourceLocation, TextDocumentState>();
        this.columns = new ColumnMaps(this::getContents);
        if (dedicatedLanguage == null) {
            this.dedicatedLanguageName = "";
            this.dedicatedLanguage = null;
        } else {
            this.dedicatedLanguageName = dedicatedLanguage.getName();
            this.dedicatedLanguage = dedicatedLanguage;
        }
        FallbackResolver.getInstance().registerTextDocumentService(this);
    }

    @Override
    public ColumnMaps getColumnMaps() {
        return this.columns;
    }

    @Override
    public LineColumnOffsetMap getColumnMap(ISourceLocation file) {
        return this.columns.get(file);
    }

    public String getContents(ISourceLocation file) {
        String string;
        block9: {
            TextDocumentState ideState = this.files.get(file = file.top());
            if (ideState != null) {
                return ideState.getCurrentContent().get();
            }
            Reader src = URIResolverRegistry.getInstance().getCharacterReader(file);
            try {
                string = IOUtils.toString(src);
                if (src == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error opening file {} to get contents", (Object)file, (Object)e);
                    return "";
                }
            }
            src.close();
        }
        return string;
    }

    @Override
    public void initializeServerCapabilities(ServerCapabilities result) {
        result.setDefinitionProvider(true);
        result.setTextDocumentSync(TextDocumentSyncKind.Full);
        result.setHoverProvider(true);
        result.setReferencesProvider(true);
        result.setDocumentSymbolProvider(true);
        result.setImplementationProvider(true);
        result.setSemanticTokensProvider(this.tokenizer.options());
        result.setCodeActionProvider(true);
        result.setCodeLensProvider(new CodeLensOptions(false));
        result.setRenameProvider(new RenameOptions(true));
        result.setExecuteCommandProvider(new ExecuteCommandOptions(Collections.singletonList(this.getRascalMetaCommandName())));
        result.setInlayHintProvider(true);
        result.setSelectionRangeProvider(true);
        result.setFoldingRangeProvider(true);
        result.setCallHierarchyProvider(true);
    }

    private String getRascalMetaCommandName() {
        if (!this.dedicatedLanguageName.isEmpty()) {
            return "rascal-meta-command-" + this.dedicatedLanguageName;
        }
        return "rascal-meta-command";
    }

    private BaseWorkspaceService availableWorkspaceService() {
        if (this.workspaceService == null) {
            throw new IllegalStateException("Workspace Service has not been paired");
        }
        return this.workspaceService;
    }

    @Override
    public void pair(BaseWorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    private LanguageClient availableClient() {
        if (this.client == null) {
            throw new IllegalStateException("Language Client has not been connected yet");
        }
        return this.client;
    }

    @Override
    public void connect(LanguageClient client) {
        this.client = client;
        this.facts.values().forEach(v -> v.setClient(client));
        if (this.dedicatedLanguage != null) {
            this.registerLanguage(this.dedicatedLanguage);
        }
    }

    @Override
    public void initialized() {
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        long timestamp = System.currentTimeMillis();
        logger.debug("Did Open file: {}", (Object)params.getTextDocument());
        TextDocumentState file = this.open(params.getTextDocument(), timestamp);
        this.handleParsingErrors(file, file.getCurrentDiagnosticsAsync());
        this.triggerAnalyzer(params.getTextDocument(), NORMAL_DEBOUNCE);
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        long timestamp = System.currentTimeMillis();
        logger.debug("Did Change file: {}", (Object)params.getTextDocument().getUri());
        this.updateContents(params.getTextDocument(), ParametricTextDocumentService.last(params.getContentChanges()).getText(), timestamp);
        this.triggerAnalyzer(params.getTextDocument(), NORMAL_DEBOUNCE);
    }

    @Override
    public void didSave(DidSaveTextDocumentParams params) {
        logger.debug("Did Save file: {}", (Object)params.getTextDocument());
        this.triggerBuilder(params.getTextDocument());
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        logger.debug("Did Close file: {}", (Object)params.getTextDocument());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        if (this.files.remove(loc) == null) {
            throw new ResponseErrorException(this.unknownFileError(loc, params));
        }
        this.facts(loc).close(loc);
        if (!URIResolverRegistry.getInstance().exists(loc)) {
            this.didDeleteFiles(new DeleteFilesParams(List.of(new FileDelete(params.getTextDocument().getUri()))));
        }
    }

    @Override
    public void didDeleteFiles(DeleteFilesParams params) {
        this.exec.submit(() -> {
            for (FileDelete f : params.getFiles()) {
                this.availableClient().publishDiagnostics(new PublishDiagnosticsParams(f.getUri(), List.of()));
            }
        });
    }

    private void triggerAnalyzer(TextDocumentItem doc, Duration delay) {
        this.triggerAnalyzer(new VersionedTextDocumentIdentifier(doc.getUri(), doc.getVersion()), delay);
    }

    private void triggerAnalyzer(VersionedTextDocumentIdentifier doc, Duration delay) {
        ISourceLocation location = Locations.toLoc(doc);
        this.triggerAnalyzer(location, doc.getVersion(), delay);
    }

    private void triggerAnalyzer(ISourceLocation location, int version, Duration delay) {
        if (this.safeLanguage(location).isPresent()) {
            logger.trace("Triggering analyzer for {}", (Object)location);
            ParametricFileFacts fileFacts = this.facts(location);
            fileFacts.invalidateAnalyzer(location);
            fileFacts.calculateAnalyzer(location, this.getFile(location).getCurrentTreeAsync(true), version, delay);
        } else {
            logger.debug("Not triggering analyzer, since no language is registered for {}", (Object)location);
        }
    }

    private void triggerBuilder(TextDocumentIdentifier doc) {
        logger.trace("Triggering builder for {}", (Object)doc.getUri());
        ISourceLocation location = Locations.toLoc(doc);
        ParametricFileFacts fileFacts = this.facts(location);
        fileFacts.invalidateBuilder(location);
        fileFacts.calculateBuilder(location, this.getFile(location).getCurrentTreeAsync(true));
    }

    private void updateContents(VersionedTextDocumentIdentifier doc, String newContents, long timestamp) {
        logger.trace("New contents for {}", (Object)doc);
        TextDocumentState file = this.getFile(Locations.toLoc(doc));
        this.columns.clear(file.getLocation());
        this.handleParsingErrors(file, file.update(doc.getVersion(), newContents, timestamp));
    }

    private void handleParsingErrors(TextDocumentState file, CompletableFuture<Versioned<List<Diagnostics.Template>>> diagnosticsAsync) {
        diagnosticsAsync.thenAccept(diagnostics -> {
            List<Diagnostic> parseErrors = ((List)diagnostics.get()).stream().map(diagnostic -> diagnostic.instantiate(this.columns)).collect(Collectors.toList());
            logger.trace("Finished parsing tree, reporting new parse errors: {} for: {}", (Object)parseErrors, (Object)file.getLocation());
            this.facts(file.getLocation()).reportParseErrors(file.getLocation(), diagnostics.version(), parseErrors);
        });
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        logger.trace("codeLens for: {}", (Object)params.getTextDocument().getUri());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        TextDocumentState file = this.getFile(loc);
        ILanguageContributions contrib = this.contributions(loc);
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(contrib::codeLens)).thenCompose(InterruptibleFuture::get)).thenApply(s -> s.stream().map(e -> this.locCommandTupleToCodeLense(contrib.getName(), (IValue)e)).collect(Collectors.toList())), () -> null);
    }

    @Override
    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        logger.trace("prepareRename for: {}", (Object)params.getTextDocument().getUri());
        ISourceLocation location = Locations.toLoc(params.getTextDocument());
        ILanguageContributions contribs = this.contributions(location);
        Position pos = params.getPosition();
        return ((CompletableFuture)((CompletableFuture)this.getFile(location).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(tree -> this.computeRenameRange(contribs, pos.getLine(), pos.getCharacter(), (ITree)tree))).thenApply(loc -> {
            if (loc.equals(URIUtil.unknownLocation())) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "Rename not possible", (Object)pos));
            }
            return Either3.forFirst(Locations.toRange(loc, this.columns));
        });
    }

    private CompletableFuture<ISourceLocation> computeRenameRange(ILanguageContributions contribs, int startLine, int startColumn, ITree tree) {
        IList focus = TreeSearch.computeFocusList(tree, startLine + 1, startColumn);
        if (focus.isEmpty()) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "No focus found at " + startLine + ":" + startColumn, (Object)TreeAdapter.getLocation((ITree)tree)));
        }
        return contribs.prepareRename(focus).get();
    }

    @Override
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        logger.trace("rename for: {}, new name: {}", (Object)params.getTextDocument().getUri(), (Object)params.getNewName());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        ILanguageContributions contribs = this.contributions(loc);
        Position rascalPos = Locations.toRascalPosition(loc, params.getPosition(), this.columns);
        return ((CompletableFuture)this.getFile(loc).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(tree -> this.computeRename(contribs, rascalPos.getLine(), rascalPos.getCharacter(), params.getNewName(), (ITree)tree));
    }

    private CompletableFuture<WorkspaceEdit> computeRename(ILanguageContributions contribs, int startLine, int startColumn, String newName, ITree tree) {
        IList focus = TreeSearch.computeFocusList(tree, startLine, startColumn);
        if (focus.isEmpty()) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "No focus found at " + startLine + ":" + startColumn, (Object)TreeAdapter.getLocation((ITree)tree)));
        }
        return contribs.rename(focus, newName).thenApply(tuple -> {
            IList documentEdits = (IList)tuple.get(0);
            ParametricTextDocumentService.showMessages(this.availableClient(), (ISet)tuple.get(1));
            return DocumentChanges.translateDocumentChanges(documentEdits, this.columns);
        }).get();
    }

    private static void showMessages(LanguageClient client, ISet messages) {
        for (IValue msg : messages) {
            IConstructor message = (IConstructor)msg;
            if (!message.getName().equals("error")) continue;
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "Rename failed: " + ((IString)message.get("msg")).getValue(), null));
        }
        for (IValue msg : messages) {
            client.showMessage(ParametricTextDocumentService.setMessageParams((IConstructor)msg));
        }
    }

    private static MessageParams setMessageParams(IConstructor message) {
        MessageParams params = new MessageParams();
        switch (message.getName()) {
            case "warning": {
                params.setType(MessageType.Warning);
                break;
            }
            case "info": {
                params.setType(MessageType.Info);
                break;
            }
            default: {
                params.setType(MessageType.Log);
            }
        }
        String msgText = ((IString)message.get("msg")).getValue();
        if (message.has("at")) {
            URI at = Locations.toUri((ISourceLocation)message.get("at"));
            params.setMessage(String.format("%s (at %s)", msgText, at));
        } else {
            params.setMessage(msgText);
        }
        return params;
    }

    @Override
    public void didCreateFiles(CreateFilesParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'didCreateFiles'");
    }

    @Override
    public void didRenameFiles(RenameFilesParams params, List<WorkspaceFolder> workspaceFolders) {
        Map<ILanguageContributions, List<FileRename>> byContrib = this.bundleRenamesByContribution(params.getFiles());
        for (Map.Entry<ILanguageContributions, List<FileRename>> entry : byContrib.entrySet()) {
            ILanguageContributions contrib = entry.getKey();
            List<FileRename> renames = entry.getValue();
            IList renameDocumentEdits = (IList)renames.stream().map(rename -> this.fileRenameToDocumentEdit((FileRename)rename)).collect(VF.listWriter());
            contrib.didRenameFiles(renameDocumentEdits).thenAccept(res -> {
                IList edits = (IList)res.get(0);
                ISet messages = (ISet)res.get(1);
                LanguageClient client = this.availableClient();
                ParametricTextDocumentService.showMessages(client, messages);
                if (edits.isEmpty()) {
                    return;
                }
                WorkspaceEdit changes = DocumentChanges.translateDocumentChanges(edits, this.columns);
                client.applyEdit(new ApplyWorkspaceEditParams(changes, "Rename files")).thenAccept(editResponse -> {
                    if (!editResponse.isApplied()) {
                        throw new RuntimeException("didRenameFiles resulted in a list of edits but applying them failed" + (String)(editResponse.getFailureReason() != null ? ": " + editResponse.getFailureReason() : ""));
                    }
                });
            }).get().exceptionally(e -> {
                Throwable cause = e.getCause();
                logger.catching(Level.ERROR, cause);
                String message = "unknown error";
                if (cause != null && cause.getMessage() != null) {
                    message = cause.getMessage();
                }
                this.availableClient().showMessage(new MessageParams(MessageType.Error, message));
                return null;
            });
        }
    }

    private Map<ILanguageContributions, List<FileRename>> bundleRenamesByContribution(List<FileRename> allRenames) {
        HashMap<ILanguageContributions, List<FileRename>> bundled = new HashMap<ILanguageContributions, List<FileRename>>();
        for (FileRename rename : allRenames) {
            ILanguageContributions contrib;
            ISourceLocation l = Locations.toLoc(rename.getNewUri());
            Optional<String> language = this.safeLanguage(l);
            if (!language.isPresent() || (contrib = (ILanguageContributions)this.contributions.get(language.get())) == null) continue;
            bundled.computeIfAbsent(contrib, k -> new ArrayList()).add(rename);
        }
        return bundled;
    }

    private IConstructor fileRenameToDocumentEdit(FileRename rename) {
        ISourceLocation from = Locations.toLoc(rename.getOldUri());
        ISourceLocation to = Locations.toLoc(rename.getNewUri());
        return VF.constructor(this.renamedConstructor, new IValue[]{from, to});
    }

    @Override
    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        logger.trace("inlayHint for: {}", (Object)params.getTextDocument().getUri());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        TextDocumentState file = this.getFile(loc);
        ILanguageContributions contrib = this.contributions(loc);
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)((CompletableFuture)file.getLastTreeAsync(false).thenApply(Versioned::get)).thenApply(contrib::inlayHint)).thenCompose(InterruptibleFuture::get)).thenApply(s -> s.stream().map(this::rowToInlayHint).collect(Collectors.toList())), () -> null);
    }

    private static <T> CompletableFuture<T> recoverExceptions(CompletableFuture<T> future, Supplier<T> defaultValue) {
        return future.exceptionally(e -> {
            logger.error("Operation failed with", (Throwable)e);
            return defaultValue.get();
        });
    }

    private InlayHint rowToInlayHint(IValue v) {
        IConstructor t = (IConstructor)v;
        ISourceLocation loc = (ISourceLocation)t.get("position");
        String label = ((IString)t.get("label")).getValue();
        IConstructor kind = (IConstructor)t.get("kind");
        IWithKeywordParameters tKW = t.asWithKeywordParameters();
        IString toolTip = (IString)tKW.getParameter("toolTip");
        boolean atEnd = tKW.hasParameter("atEnd") && ((IBool)tKW.getParameter("atEnd")).getValue();
        InlayHint result = new InlayHint(Locations.toPosition(loc, this.columns, atEnd), Either.forLeft(label.trim()));
        result.setKind(kind.getName().equals("type") ? InlayHintKind.Type : InlayHintKind.Parameter);
        result.setPaddingLeft(label.startsWith(" "));
        result.setPaddingRight(label.endsWith(" "));
        if (toolTip != null && toolTip.length() > 0) {
            result.setTooltip(toolTip.getValue());
        }
        return result;
    }

    private CodeLens locCommandTupleToCodeLense(String languageName, IValue v) {
        ITuple t = (ITuple)v;
        ISourceLocation loc = (ISourceLocation)t.get(0);
        IConstructor command = (IConstructor)t.get(1);
        return new CodeLens(Locations.toRange(loc, this.columns), CodeActions.constructorToCommand(this.dedicatedLanguageName, languageName, command), null);
    }

    private static <T> T last(List<T> l) {
        return l.get(l.size() - 1);
    }

    private Optional<String> safeLanguage(ISourceLocation loc) {
        String ext = ParametricTextDocumentService.extension(loc);
        if ("".equals(ext)) {
            if (this.contributions.size() == 1) {
                logger.trace("file was opened without an extension; falling back to the single registered language for: {}", (Object)loc);
                return this.contributions.keySet().stream().findFirst();
            }
            logger.error("file was opened without an extension and there are multiple languages registered, so we cannot pick a fallback for: {}", (Object)loc);
            return Optional.empty();
        }
        return Optional.ofNullable(this.registeredExtensions.get(ext));
    }

    private String language(ISourceLocation loc) {
        return this.safeLanguage(loc).orElseThrow(() -> new UnsupportedOperationException(String.format("Rascal Parametric LSP has no support for this file, since no language is registered for extension '%s': %s", ParametricTextDocumentService.extension(loc), loc)));
    }

    private ILanguageContributions contributions(ISourceLocation doc) {
        return this.safeLanguage(doc).map(this.contributions::get).map(ILanguageContributions.class::cast).flatMap(Optional::ofNullable).orElseGet(() -> new NoContributions(ParametricTextDocumentService.extension(doc), this.exec));
    }

    private static String extension(ISourceLocation doc) {
        return URIUtil.getExtension((ISourceLocation)doc);
    }

    private ParametricFileFacts facts(ISourceLocation doc) {
        ParametricFileFacts fact = this.facts.get(this.language(doc));
        if (fact == null) {
            throw new ResponseErrorException(this.unknownFileError(doc, doc));
        }
        return fact;
    }

    private TextDocumentState open(TextDocumentItem doc, long timestamp) {
        return this.files.computeIfAbsent(Locations.toLoc(doc), l -> new TextDocumentState(this.contributions((ISourceLocation)l)::parsing, (ISourceLocation)l, doc.getVersion(), doc.getText(), timestamp));
    }

    private TextDocumentState getFile(ISourceLocation loc) {
        TextDocumentState file = this.files.get(loc);
        if (file == null) {
            throw new ResponseErrorException(this.unknownFileError(loc, loc));
        }
        return file;
    }

    @Override
    public void shutdown() {
        this.exec.shutdown();
    }

    private CompletableFuture<SemanticTokens> getSemanticTokens(TextDocumentIdentifier doc) {
        ISourceLocation loc = Locations.toLoc(doc);
        CompletableFuture<Boolean> specialCaseHighlighting = this.contributions(loc).specialCaseHighlighting();
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)this.getFile(loc).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCombineAsync(specialCaseHighlighting, this.tokenizer::semanticTokensFull, (Executor)this.exec)).whenComplete((r, e) -> logger.trace("Semantic tokens success, reporting {} tokens back", (Object)(r == null ? 0 : r.getData().size() / 5))), () -> new SemanticTokens(Collections.emptyList()));
    }

    @Override
    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        logger.debug("semanticTokensFull: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument());
    }

    @Override
    public CompletableFuture<Either<SemanticTokens, SemanticTokensDelta>> semanticTokensFullDelta(SemanticTokensDeltaParams params) {
        logger.debug("semanticTokensFullDelta: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument()).thenApply(Either::forLeft);
    }

    @Override
    public CompletableFuture<SemanticTokens> semanticTokensRange(SemanticTokensRangeParams params) {
        logger.debug("semanticTokensRange: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument());
    }

    @Override
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        logger.debug("Outline/documentSymbol: {}", (Object)params.getTextDocument());
        ISourceLocation location = Locations.toLoc(params.getTextDocument());
        TextDocumentState file = this.getFile(location);
        ILanguageContributions contrib = this.contributions(location);
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(contrib::documentSymbol)).thenCompose(InterruptibleFuture::get)).thenApply(documentSymbols -> DocumentSymbols.toLSP(documentSymbols, this.columns.get(file.getLocation()))), Collections::emptyList);
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        logger.debug("codeAction: {}", (Object)params);
        ISourceLocation location = Locations.toLoc(params.getTextDocument());
        ILanguageContributions contribs = this.contributions(location);
        CompletableFuture<Stream<IValue>> quickfixes = CodeActions.extractActionsFromDiagnostics(params, contribs::parseCodeActions, this.exec);
        CompletableFuture<Stream<IValue>> codeActions = ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)this.getFile(location).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(tree -> {
            Range range = Locations.toRascalRange(location, params.getRange(), this.columns);
            return this.computeCodeActions(contribs, range.getStart().getLine(), range.getStart().getCharacter(), (ITree)tree);
        })).thenApply(ICollection::stream), Stream::empty);
        return CodeActions.mergeAndConvertCodeActions(this, this.dedicatedLanguageName, contribs.getName(), quickfixes, codeActions);
    }

    private CompletableFuture<IList> computeCodeActions(ILanguageContributions contribs, int startLine, int startColumn, ITree tree) {
        IList focus = TreeSearch.computeFocusList(tree, startLine, startColumn);
        if (!focus.isEmpty()) {
            return contribs.codeAction(focus).get();
        }
        logger.log(Level.DEBUG, "no tree focus found at {}:{}", (Object)startLine, (Object)startColumn);
        return CompletableFutureUtils.completedFuture(VF.list(new IValue[0]), this.exec);
    }

    private <T> CompletableFuture<List<T>> lookup(ParametricSummary.SummaryLookup<T> lookup, TextDocumentIdentifier doc, Position cursor) {
        ISourceLocation loc = Locations.toLoc(doc);
        return ((CompletableFuture)this.getFile(loc).getCurrentTreeAsync(true).thenApply(tree -> this.facts(loc).lookupInSummaries(lookup, loc, (Versioned<ITree>)tree, cursor))).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        logger.debug("Definition: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)this.lookup(ParametricSummary::definitions, params.getTextDocument(), params.getPosition()).thenApply(d -> {
            logger.debug("Definitions: {}", d);
            return d;
        })).thenApply(Either::forLeft), () -> Either.forLeft(Collections.emptyList()));
    }

    @Override
    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams params) {
        logger.debug("Implementation: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        return ParametricTextDocumentService.recoverExceptions(this.lookup(ParametricSummary::implementations, params.getTextDocument(), params.getPosition()).thenApply(Either::forLeft), () -> Either.forLeft(Collections.emptyList()));
    }

    @Override
    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        logger.debug("References: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        return ParametricTextDocumentService.recoverExceptions(this.lookup(ParametricSummary::references, params.getTextDocument(), params.getPosition()).thenApply(l -> l), Collections::emptyList);
    }

    @Override
    public CompletableFuture<@Nullable Hover> hover(HoverParams params) {
        logger.debug("Hover: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        return ParametricTextDocumentService.recoverExceptions(this.lookup(ParametricSummary::hovers, params.getTextDocument(), params.getPosition()).thenApply(Hover::new), () -> null);
    }

    @Override
    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        logger.debug("Folding range: {}", (Object)params.getTextDocument());
        TextDocumentState file = this.getFile(Locations.toLoc(params.getTextDocument()));
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(FoldingRanges::getFoldingRanges)).whenComplete((r, e) -> logger.trace("Folding regions success, reporting {} regions back", (Object)(r == null ? 0 : r.size()))), Collections::emptyList);
    }

    @Override
    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        logger.debug("Selection range: {} at {}", (Object)params.getTextDocument(), (Object)params.getPositions());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        ILanguageContributions contrib = this.contributions(loc);
        TextDocumentState file = this.getFile(loc);
        CompletionStage computeSelection = contrib.hasSelectionRange().thenApply(hasDef -> {
            if (!hasDef.booleanValue()) {
                logger.debug("Selection range not implemented; falling back to default implementation ({})", (Object)params.getTextDocument());
                return focus -> CompletableFutureUtils.completedFuture(SelectionRanges.uniqueTreeLocations(focus), this.exec);
            }
            return focus -> contrib.selectionRange((IList)focus).get();
        });
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(arg_0 -> this.lambda$selectionRange$40(params, loc, (CompletableFuture)computeSelection, arg_0)), Collections::emptyList);
    }

    @Override
    public CompletableFuture<List<CallHierarchyItem>> prepareCallHierarchy(CallHierarchyPrepareParams params) {
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        ILanguageContributions contrib = this.contributions(loc);
        TextDocumentState file = this.getFile(loc);
        return ParametricTextDocumentService.recoverExceptions(((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(t -> {
            Position pos = Locations.toRascalPosition(loc, params.getPosition(), this.columns);
            return contrib.prepareCallHierarchy(TreeSearch.computeFocusList(t, pos.getLine(), pos.getCharacter())).get().thenApply(items -> {
                CallHierarchy ch = new CallHierarchy(this.exec);
                return items.stream().map(IConstructor.class::cast).map(ci -> ch.toLSP((IConstructor)ci, this.columns)).collect(Collectors.toList());
            });
        }), Collections::emptyList);
    }

    private <T> CompletableFuture<List<T>> incomingOutgoingCalls(BiFunction<CallHierarchyItem, List<Range>, T> constructor, CallHierarchyItem source, CallHierarchy.Direction direction) {
        ILanguageContributions contrib = this.contributions(Locations.toLoc(source.getUri()));
        CallHierarchy ch = new CallHierarchy(this.exec);
        return ((CompletableFuture)ch.toRascal(source, contrib::parseCallHierarchyData, this.columns).thenCompose(sourceItem -> contrib.incomingOutgoingCalls((IConstructor)sourceItem, ch.direction(direction)).get())).thenApply(callRel -> {
            LinkedHashMap<IConstructor, List> orderedEdges = new LinkedHashMap<IConstructor, List>();
            for (IValue entry2 : callRel) {
                IConstructor ciItem = (IConstructor)((ITuple)entry2).get(0);
                List sites = orderedEdges.computeIfAbsent(ciItem, _k -> new ArrayList());
                ISourceLocation callSite = (ISourceLocation)((ITuple)entry2).get(1);
                sites.add(Locations.toRange(callSite, this.columns));
            }
            return orderedEdges.entrySet().stream().map(entry -> constructor.apply(ch.toLSP((IConstructor)entry.getKey(), this.columns), (List)entry.getValue())).collect(Collectors.toList());
        });
    }

    @Override
    public CompletableFuture<List<CallHierarchyIncomingCall>> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params) {
        return ParametricTextDocumentService.recoverExceptions(this.incomingOutgoingCalls(CallHierarchyIncomingCall::new, params.getItem(), CallHierarchy.Direction.INCOMING), Collections::emptyList);
    }

    @Override
    public CompletableFuture<List<CallHierarchyOutgoingCall>> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params) {
        return ParametricTextDocumentService.recoverExceptions(this.incomingOutgoingCalls(CallHierarchyOutgoingCall::new, params.getItem(), CallHierarchy.Direction.OUTGOING), Collections::emptyList);
    }

    @Override
    public synchronized void registerLanguage(LanguageRegistry.LanguageParameter lang) {
        logger.info("registerLanguage({})", (Object)lang.getName());
        LanguageContributionsMultiplexer multiplexer = this.contributions.computeIfAbsent(lang.getName(), t -> new LanguageContributionsMultiplexer(lang.getName(), this.exec));
        ParametricFileFacts fact = this.facts.computeIfAbsent(lang.getName(), t -> new ParametricFileFacts(this.exec, this.columns, multiplexer));
        LanguageRegistry.ParserSpecification parserConfig = lang.getPrecompiledParser();
        if (parserConfig != null) {
            try {
                ISourceLocation location = parserConfig.getParserLocation();
                if (URIResolverRegistry.getInstance().exists(location)) {
                    logger.debug("Got precompiled definition: {}", (Object)parserConfig);
                    multiplexer.addContributor(ParametricTextDocumentService.buildContributionKey(lang) + "$parser", new ParserOnlyContribution(lang.getName(), parserConfig, this.exec));
                } else {
                    logger.error("Defined precompiled parser ({}) does not exist", (Object)parserConfig);
                }
            }
            catch (FactParseError e) {
                logger.error("Error parsing location in precompiled parser specification (we expect a rascal loc)", (Throwable)e);
            }
        }
        LanguageClient clientCopy = this.availableClient();
        multiplexer.addContributor(ParametricTextDocumentService.buildContributionKey(lang), new InterpretedLanguageContributions(lang, this, this.availableWorkspaceService(), (IBaseLanguageClient)clientCopy, this.exec));
        fact.reloadContributions();
        fact.setClient(clientCopy);
        for (String extension : lang.getExtensions()) {
            this.registeredExtensions.put(extension, lang.getName());
        }
        List<String> extensions = Arrays.asList(lang.getExtensions());
        for (ISourceLocation f : this.files.keySet()) {
            if (!extensions.contains(ParametricTextDocumentService.extension(f))) continue;
            this.updateFileState(lang, f);
        }
    }

    private void updateFileState(LanguageRegistry.LanguageParameter lang, ISourceLocation f) {
        logger.trace("File of language {} - updating state: {}", (Object)lang.getName(), (Object)f);
        TextDocumentState state = this.files.computeIfPresent(f, (loc, currentState) -> currentState.changeParser(this.contributions((ISourceLocation)loc)::parsing));
        if (state == null) {
            logger.debug("Updating the parser of {} failed, since it was closed.", (Object)f);
            return;
        }
        this.handleParsingErrors(state, state.getCurrentDiagnosticsAsync());
        this.triggerAnalyzer(f, state.getCurrentContent().version(), NORMAL_DEBOUNCE);
    }

    private static String buildContributionKey(LanguageRegistry.LanguageParameter lang) {
        return lang.getMainFunction() + "::" + lang.getMainFunction();
    }

    @Override
    public synchronized void unregisterLanguage(LanguageRegistry.LanguageParameter lang) {
        boolean removeAll;
        boolean bl = removeAll = lang.getMainModule() == null || lang.getMainModule().isEmpty();
        if (!removeAll) {
            LanguageContributionsMultiplexer contrib = this.contributions.get(lang.getName());
            if (contrib != null && !contrib.removeContributor(ParametricTextDocumentService.buildContributionKey(lang))) {
                logger.error("unregisterLanguage cleared everything, so removing all");
                removeAll = true;
            } else {
                ParametricFileFacts fact = this.facts.get(lang.getName());
                if (fact != null) {
                    fact.reloadContributions();
                }
            }
        }
        if (removeAll) {
            logger.trace("unregisterLanguage({}) completely", (Object)lang.getName());
            for (String extension : lang.getExtensions()) {
                this.registeredExtensions.remove(extension);
            }
            this.facts.remove(lang.getName());
            this.contributions.remove(lang.getName());
        }
    }

    @Override
    public void projectAdded(String name, ISourceLocation projectRoot) {
    }

    @Override
    public void projectRemoved(String name, ISourceLocation projectRoot) {
    }

    @Override
    public CompletableFuture<IValue> executeCommand(String languageName, String command) {
        ILanguageContributions contribs = this.contributions.get(languageName);
        if (contribs != null) {
            return contribs.execution(command).get();
        }
        logger.warn("ignoring command execution (no contributor configured for this language): {}, {} ", (Object)languageName, (Object)command);
        return CompletableFutureUtils.completedFuture(IRascalValueFactory.getInstance().string("No contributions configured for the language: " + languageName), this.exec);
    }

    @Override
    public boolean isManagingFile(ISourceLocation file) {
        return this.files.containsKey(file.top());
    }

    @Override
    public @Nullable TextDocumentState getDocumentState(ISourceLocation file) {
        return this.files.get(file.top());
    }

    @Override
    public void cancelProgress(String progressId) {
        this.contributions.values().forEach(plex -> plex.cancelProgress(progressId));
    }

    private ResponseError unknownFileError(ISourceLocation loc, Object data) {
        return new ResponseError(ResponseErrorCode.RequestFailed, "Unknown file: " + String.valueOf(loc), data);
    }

    private /* synthetic */ CompletionStage lambda$selectionRange$40(SelectionRangeParams params, ISourceLocation loc, CompletableFuture computeSelection, ITree t) {
        return CompletableFutureUtils.reduce(params.getPositions().stream().map(p -> Locations.toRascalPosition(loc, p, this.columns)).map(p -> ((CompletableFuture)computeSelection.thenCompose(compute -> (CompletionStage)compute.apply(TreeSearch.computeFocusList(t, p.getLine(), p.getCharacter())))).thenApply(selection -> SelectionRanges.toSelectionRange(p, selection, this.columns))).collect(Collectors.toUnmodifiableList()), (Executor)this.exec);
    }
}

