/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.util.NamedThreadPool;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeSearch;

public class RascalInterface {
    private final @Nullable LanguageRegistry languageRegistry;
    private final IRascalMonitor monitor;

    public RascalInterface(IRascalMonitor monitor) {
        this.monitor = monitor;
        LanguageRegistry registry = null;
        try {
            String property = System.getProperty("rascal.languageRegistryPort");
            if (property != null) {
                int port = Integer.parseInt(property);
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
                Launcher<LanguageRegistry> clientLauncher = new Launcher.Builder().setLocalService(new Object()).setRemoteInterface(LanguageRegistry.class).setInput(socket.getInputStream()).setOutput(socket.getOutputStream()).setExecutorService(NamedThreadPool.cachedDaemon("rascal-interface")).create();
                clientLauncher.startListening();
                registry = clientLauncher.getRemoteProxy();
            }
        }
        catch (Throwable e) {
            monitor.warning("Could not establish connection with Rascal language registry: " + e.getMessage(), URIUtil.unknownLocation());
        }
        this.languageRegistry = registry;
    }

    public void registerLanguage(IConstructor lang) {
        if (this.languageRegistry == null) {
            this.monitor.warning("Could not register language: no connection", URIUtil.unknownLocation());
        } else {
            try {
                this.languageRegistry.registerLanguage(LanguageRegistry.LanguageParameter.fromRascalValue(lang)).get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                this.monitor.warning("registerLanuage was interrupted: " + e.getMessage(), URIUtil.unknownLocation());
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException | TimeoutException e) {
                throw RuntimeExceptionFactory.io((String)("Could not register language " + String.valueOf(lang) + "\n" + String.valueOf(e)));
            }
        }
    }

    public void unregisterLanguage(IConstructor lang) {
        if (this.languageRegistry == null) {
            this.monitor.warning("Could not unregister language: no connection", URIUtil.unknownLocation());
        } else {
            try {
                this.languageRegistry.unregisterLanguage(LanguageRegistry.LanguageParameter.fromRascalValue(lang)).get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                this.monitor.warning("unregisterLanuage was interrupted: " + e.getMessage(), URIUtil.unknownLocation());
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException | TimeoutException e) {
                throw RuntimeExceptionFactory.io((String)("Could not unregister language " + String.valueOf(lang) + "\n" + String.valueOf(e)));
            }
        }
    }

    public IList computeFocusList(IConstructor input, IInteger line, IInteger column) {
        return TreeSearch.computeFocusList((ITree)input, line.intValue(), column.intValue());
    }
}

