/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric.model;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummary;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummaryFactory;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.locations.Locations;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeSearch;

class OndemandSummaryFactory
extends ParametricSummaryFactory {
    private static final Logger logger = LogManager.getLogger(OndemandSummaryFactory.class);
    private final ILanguageContributions contrib;

    public OndemandSummaryFactory(ILanguageContributions.SummaryConfig config, Executor exec, ColumnMaps columns, ILanguageContributions contrib) {
        super(config, exec, columns);
        this.contrib = contrib;
    }

    public ParametricSummary createSummary(ISourceLocation file, Versioned<ITree> tree, Position cursor) {
        return new OndemandSummary(file, tree, cursor);
    }

    public <T> @Nullable InterruptibleFuture<List<T>> createSummaryThenLookup(ISourceLocation file, Versioned<ITree> tree, Position cursor, ParametricSummary.SummaryLookup<T> lookup) {
        return (InterruptibleFuture)lookup.apply(new OndemandSummary(file, tree, cursor), cursor);
    }

    public class OndemandSummary
    implements ParametricSummary {
        private final ISourceLocation file;
        private final Versioned<ITree> tree;
        private final Position cursor;

        public OndemandSummary(ISourceLocation file, Versioned<ITree> tree, Position cursor) {
            this.file = file;
            this.tree = tree;
            this.cursor = cursor;
        }

        @Override
        public @Nullable InterruptibleFuture<List<Either<String, MarkedString>>> getHovers(Position cursor) {
            return this.get(OndemandSummaryFactory.this.config.providesHovers, cursor, OndemandSummaryFactory.this.contrib::hover, ParametricSummaryFactory::mapValueToString, "hovers");
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getDefinitions(Position cursor) {
            return this.get(OndemandSummaryFactory.this.config.providesDefinitions, cursor, OndemandSummaryFactory.this.contrib::definition, ParametricSummaryFactory.locationMapper(OndemandSummaryFactory.this.columns), "definitions");
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getReferences(Position cursor) {
            return this.get(OndemandSummaryFactory.this.config.providesReferences, cursor, OndemandSummaryFactory.this.contrib::references, ParametricSummaryFactory.locationMapper(OndemandSummaryFactory.this.columns), "references");
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getImplementations(Position cursor) {
            return this.get(OndemandSummaryFactory.this.config.providesImplementations, cursor, OndemandSummaryFactory.this.contrib::implementation, ParametricSummaryFactory.locationMapper(OndemandSummaryFactory.this.columns), "implementations");
        }

        @Override
        public InterruptibleFuture<List<Diagnostic>> getMessages() {
            return InterruptibleFuture.completedFuture(Collections.emptyList(), OndemandSummaryFactory.this.exec);
        }

        @Override
        public void invalidate() {
        }

        private <T> @Nullable InterruptibleFuture<List<T>> get(boolean provides, Position cursor, ILanguageContributions.OnDemandFocusToSetCalculator calculator, Function<IValue, T> valueMapper, String logName) {
            if (!provides) {
                return null;
            }
            if (this.cursor != cursor) {
                logger.trace("{}: unexpected use of an on-demand summary (cursor at creation time != cursor at usage time)", (Object)logName);
                return null;
            }
            Position pos = Locations.toRascalPosition(this.file, cursor, OndemandSummaryFactory.this.columns);
            IList focus = TreeSearch.computeFocusList(this.tree.get(), pos.getLine(), pos.getCharacter());
            InterruptibleFuture<ISet> set = null;
            if (focus.isEmpty()) {
                logger.trace("{}: could not find substree at line {} and offset {}", (Object)logName, (Object)pos.getLine(), (Object)pos.getCharacter());
                set = InterruptibleFuture.completedFuture(IRascalValueFactory.getInstance().set(new IValue[0]), OndemandSummaryFactory.this.exec);
            } else {
                logger.trace("{}: looked up focus with length: {}, now calling dedicated function", (Object)logName, (Object)focus.length());
                set = (InterruptibleFuture<ISet>)calculator.apply(focus);
            }
            logger.trace("{}: dedicated returned: {}", (Object)logName, (Object)set);
            return set.thenApply(s -> this.toList((ISet)s, valueMapper));
        }

        private <T> List<T> toList(ISet s, Function<IValue, T> valueMapper) {
            if (s == null || s.isEmpty()) {
                return Collections.emptyList();
            }
            int size = s.size();
            if (size == 1) {
                IValue v = (IValue)s.iterator().next();
                return Collections.singletonList(valueMapper.apply(v));
            }
            ArrayList<T> list = new ArrayList<T>(size);
            for (IValue v : s) {
                list.add(valueMapper.apply(v));
            }
            return list;
        }
    }
}

