/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric.model;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public interface ParametricSummary {
    public @Nullable InterruptibleFuture<List<Either<String, MarkedString>>> getHovers(Position var1);

    public @Nullable InterruptibleFuture<List<Location>> getDefinitions(Position var1);

    public @Nullable InterruptibleFuture<List<Location>> getReferences(Position var1);

    public @Nullable InterruptibleFuture<List<Location>> getImplementations(Position var1);

    public InterruptibleFuture<List<Diagnostic>> getMessages();

    public void invalidate();

    public static @Nullable InterruptibleFuture<List<Either<String, MarkedString>>> hovers(ParametricSummary summary, Position position) {
        return summary.getHovers(position);
    }

    public static @Nullable InterruptibleFuture<List<Location>> definitions(ParametricSummary summary, Position position) {
        return summary.getDefinitions(position);
    }

    public static @Nullable InterruptibleFuture<List<Location>> references(ParametricSummary summary, Position position) {
        return summary.getReferences(position);
    }

    public static @Nullable InterruptibleFuture<List<Location>> implementations(ParametricSummary summary, Position position) {
        return summary.getImplementations(position);
    }

    public static InterruptibleFuture<List<Diagnostic>> getMessages(CompletableFuture<Versioned<ParametricSummary>> summary, Executor exec) {
        CompletionStage messages = ((CompletableFuture)summary.thenApply(Versioned::get)).thenApply(ParametricSummary::getMessages);
        return InterruptibleFuture.flatten(messages, exec);
    }

    @FunctionalInterface
    public static interface SummaryLookup<T>
    extends BiFunction<ParametricSummary, Position, InterruptibleFuture<List<T>>> {
    }
}

