/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric.model;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.model.NullSummary;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummary;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummaryFactory;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.Lazy;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.locations.IRangeMap;
import org.rascalmpl.vscode.lsp.util.locations.Locations;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeMapLookup;

class ScheduledSummaryFactory
extends ParametricSummaryFactory {
    private static final Logger logger = LogManager.getLogger(ScheduledSummaryFactory.class);
    private final ILanguageContributions.ScheduledCalculator calculator;

    public ScheduledSummaryFactory(ILanguageContributions.SummaryConfig config, Executor exec, ColumnMaps columns, ILanguageContributions.ScheduledCalculator calculator) {
        super(config, exec, columns);
        this.calculator = calculator;
    }

    public CompletableFuture<Versioned<ParametricSummary>> createMessagesOnlySummary(ISourceLocation file, CompletableFuture<Versioned<ITree>> tree) {
        return this.createSummary(file, tree, cons -> new MessagesOnlyScheduledSummary((InterruptibleFuture<IConstructor>)cons, this.exec));
    }

    public CompletableFuture<Versioned<ParametricSummary>> createFullSummary(ISourceLocation file, CompletableFuture<Versioned<ITree>> tree) {
        return this.createSummary(file, tree, x$0 -> new FullScheduledSummary((InterruptibleFuture<IConstructor>)x$0));
    }

    private CompletableFuture<Versioned<ParametricSummary>> createSummary(ISourceLocation file, CompletableFuture<Versioned<ITree>> tree, Function<InterruptibleFuture<IConstructor>, ParametricSummary> constructor) {
        return tree.thenApplyAsync(t -> {
            logger.trace("Requesting summary calculation for: {}", (Object)file);
            InterruptibleFuture calculation = (InterruptibleFuture)this.calculator.apply(file, (ITree)t.get());
            return new Versioned<ParametricSummary>(t.version(), (ParametricSummary)constructor.apply(calculation));
        }, this.exec);
    }

    public class FullScheduledSummary
    extends MessagesOnlyScheduledSummary {
        private final @Nullable InterruptibleFuture<Lazy<IRangeMap<List<Either<String, MarkedString>>>>> hovers;
        private final @Nullable InterruptibleFuture<Lazy<IRangeMap<List<Location>>>> definitions;
        private final @Nullable InterruptibleFuture<Lazy<IRangeMap<List<Location>>>> references;
        private final @Nullable InterruptibleFuture<Lazy<IRangeMap<List<Location>>>> implementations;

        public FullScheduledSummary(InterruptibleFuture<IConstructor> calculation) {
            super(calculation, ScheduledSummaryFactory.this.exec);
            calculation = calculation.thenApply(summary -> {
                IWithKeywordParameters kws = summary.asWithKeywordParameters();
                if (kws.hasParameter("documentation") && !kws.hasParameter("hovers")) {
                    return (IConstructor)kws.setParameter("hovers", kws.getParameter("documentation"));
                }
                return summary;
            });
            this.hovers = ScheduledSummaryFactory.this.config.providesHovers ? this.mapCalculation("hovers", calculation, "hovers", ParametricSummaryFactory::mapValueToString) : null;
            this.definitions = ScheduledSummaryFactory.this.config.providesDefinitions ? this.mapCalculation("definitions", calculation, "definitions", ParametricSummaryFactory.locationMapper(ScheduledSummaryFactory.this.columns)) : null;
            this.references = ScheduledSummaryFactory.this.config.providesReferences ? this.mapCalculation("references", calculation, "references", ParametricSummaryFactory.locationMapper(ScheduledSummaryFactory.this.columns)) : null;
            this.implementations = ScheduledSummaryFactory.this.config.providesImplementations ? this.mapCalculation("implementations", calculation, "implementations", ParametricSummaryFactory.locationMapper(ScheduledSummaryFactory.this.columns)) : null;
        }

        @Override
        public @Nullable InterruptibleFuture<List<Either<String, MarkedString>>> getHovers(Position cursor) {
            return this.get(this.hovers, cursor);
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getDefinitions(Position cursor) {
            return this.get(this.definitions, cursor);
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getReferences(Position cursor) {
            return this.get(this.references, cursor);
        }

        @Override
        public @Nullable InterruptibleFuture<List<Location>> getImplementations(Position cursor) {
            return this.get(this.implementations, cursor);
        }

        private void interruptNullable(@Nullable InterruptibleFuture<?> future) {
            if (future != null) {
                future.interrupt();
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.interruptNullable(this.hovers);
            this.interruptNullable(this.definitions);
            this.interruptNullable(this.references);
            this.interruptNullable(this.implementations);
        }

        private <T> InterruptibleFuture<Lazy<IRangeMap<List<T>>>> mapCalculation(@UnderInitialization FullScheduledSummary this, String logName, InterruptibleFuture<IConstructor> calculation, String kwField, Function<IValue, T> valueMapper) {
            logger.trace("{}: Mapping summary by getting {}", (Object)logName, (Object)kwField);
            return calculation.thenApply(IConstructor::asWithKeywordParameters).thenApply(s -> Lazy.defer(() -> this.translateRelation(logName, this.getKWFieldSet((IWithKeywordParameters<? extends IConstructor>)s, kwField), valueMapper)));
        }

        private IRelation<ISet> getKWFieldSet(@UnderInitialization FullScheduledSummary this, IWithKeywordParameters<? extends IConstructor> data, String name) {
            if (data.hasParameter(name)) {
                return ((ISet)data.getParameter(name)).asRelation();
            }
            return IRascalValueFactory.getInstance().set(new IValue[0]).asRelation();
        }

        private <T> IRangeMap<List<T>> translateRelation(@UnderInitialization FullScheduledSummary this, String logName, IRelation<ISet> binaryRel, Function<IValue, T> mapValue) {
            logger.trace("{}: summary contain rel of size:{}", (Object)logName, (Object)((ISet)binaryRel.asContainer()).size());
            TreeMapLookup<List<List<Object>>> result = new TreeMapLookup<List<List<Object>>>();
            for (IValue v : binaryRel) {
                ITuple row = (ITuple)v;
                Range from = Locations.toRange((ISourceLocation)row.get(0), ScheduledSummaryFactory.this.columns);
                IValue to = mapValue.apply(row.get(1));
                List<T> existing = result.getExact(from);
                if (existing == null) {
                    result.put(from, Collections.singletonList(to));
                    continue;
                }
                if (existing.size() == 1) {
                    existing = new ArrayList<T>(existing);
                    result.put(from, existing);
                    existing.add(to);
                    continue;
                }
                existing.add(to);
            }
            return result;
        }

        private <T> @Nullable InterruptibleFuture<List<T>> get(@Nullable InterruptibleFuture<Lazy<IRangeMap<List<T>>>> result, Position cursor) {
            return result == null ? null : result.thenApplyAsync(Supplier::get, ScheduledSummaryFactory.this.exec).thenApply(l -> {
                List r = (List)l.lookup(new Range(cursor, cursor));
                if (r == null) {
                    return Collections.emptyList();
                }
                return r;
            });
        }
    }

    public class MessagesOnlyScheduledSummary
    extends NullSummary {
        private final InterruptibleFuture<Lazy<List<Diagnostic>>> messages;

        public MessagesOnlyScheduledSummary(InterruptibleFuture<IConstructor> calculation, Executor exec) {
            super(exec);
            this.messages = this.extractMessages(calculation);
        }

        @Override
        public InterruptibleFuture<List<Diagnostic>> getMessages() {
            return this.messages.thenApply(Supplier::get);
        }

        @Override
        public void invalidate() {
            this.messages.interrupt();
        }

        private InterruptibleFuture<Lazy<List<Diagnostic>>> extractMessages(@UnderInitialization MessagesOnlyScheduledSummary this, InterruptibleFuture<IConstructor> summary) {
            return summary.thenApply(s -> Lazy.defer(() -> {
                IWithKeywordParameters sum = s.asWithKeywordParameters();
                if (sum.hasParameter("messages")) {
                    return ((ISet)sum.getParameter("messages")).stream().map(d -> Diagnostics.translateDiagnostic((IConstructor)((ITuple)d).get(1), ScheduledSummaryFactory.this.columns)).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }));
        }
    }
}

