/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal.model;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.vscode.lsp.rascal.RascalLanguageServices;
import org.rascalmpl.vscode.lsp.rascal.model.PathConfigDiagnostics;
import org.rascalmpl.vscode.lsp.rascal.model.PathConfigs;
import org.rascalmpl.vscode.lsp.rascal.model.SummaryBridge;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.Lists;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.concurrent.LazyUpdateableReference;
import org.rascalmpl.vscode.lsp.util.concurrent.ReplaceableFuture;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class FileFacts {
    private static final Logger logger = LogManager.getLogger(FileFacts.class);
    private final Executor exec;
    private final RascalLanguageServices rascal;
    private final LanguageClient client;
    private final Map<ISourceLocation, FileFact> files = new ConcurrentHashMap<ISourceLocation, FileFact>();
    private final ColumnMaps cm;
    private final PathConfigs confs;

    public FileFacts(Executor exec, RascalLanguageServices rascal, LanguageClient client, ColumnMaps cm) {
        this.exec = exec;
        this.rascal = rascal;
        this.client = client;
        this.cm = cm;
        this.confs = new PathConfigs(exec, new PathConfigDiagnostics(client, cm));
    }

    public void projectRemoved(ISourceLocation projectLocation) {
        this.confs.expungePathConfig(projectLocation);
    }

    public void invalidate(ISourceLocation file) {
        this.getFile(file).invalidate();
    }

    public CompletableFuture<@Nullable SummaryBridge> getSummary(ISourceLocation file) {
        return this.getFile(file).getSummary();
    }

    public void reportParseErrors(ISourceLocation file, List<Diagnostic> msgs) {
        this.getFile(file).reportParseErrors(msgs);
    }

    private FileFact getFile(ISourceLocation l) {
        FileFact fact;
        ISourceLocation resolved = Locations.toClientLocation(l = l.top());
        if (resolved == null) {
            resolved = l;
        }
        if ((fact = this.files.get(resolved)) == null) {
            if (URIResolverRegistry.getInstance().exists(resolved)) {
                fact = new ActualFileFact(resolved, this.exec);
                FileFact existing = this.files.putIfAbsent(resolved, fact);
                if (existing != null) {
                    fact = existing;
                }
            } else {
                fact = new NopFileFact();
            }
        }
        return fact;
    }

    public PathConfig getPathConfig(ISourceLocation file) {
        return this.confs.lookupConfig(file);
    }

    public void close(ISourceLocation file) {
        this.getFile(file).close();
    }

    private @Nullable FileFact remove(ISourceLocation file) {
        FileFact removed = this.files.remove(file.top());
        if (removed != null) {
            removed.clearDiagnostics();
        }
        return removed;
    }

    class NopFileFact
    implements FileFact {
        NopFileFact() {
        }

        @Override
        public void reportParseErrors(List<Diagnostic> msgs) {
        }

        @Override
        public void reportTypeCheckerErrors(List<Diagnostic> msgs) {
        }

        @Override
        public CompletableFuture<@Nullable SummaryBridge> getSummary() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void close() {
        }

        @Override
        public void clearDiagnostics() {
        }
    }

    private class ActualFileFact
    implements FileFact {
        private final ISourceLocation file;
        private final LazyUpdateableReference<InterruptibleFuture<@Nullable SummaryBridge>> summary;
        private volatile List<Diagnostic> parseMessages = Collections.emptyList();
        private volatile List<Diagnostic> typeCheckerMessages = Collections.emptyList();
        private final ReplaceableFuture<Map<ISourceLocation, List<Diagnostic>>> typeCheckResults;

        public ActualFileFact(ISourceLocation file, Executor exec) {
            this.file = file;
            this.typeCheckResults = ReplaceableFuture.completedFuture(Collections.emptyMap(), exec);
            this.summary = new LazyUpdateableReference<InterruptibleFuture>(InterruptibleFuture.completedFuture(new SummaryBridge(), exec), r -> {
                r.interrupt();
                InterruptibleFuture<SummaryBridge> summaryCalc = FileFacts.this.rascal.getSummary(file, FileFacts.this.confs.lookupConfig(file)).thenApply(s -> s == null ? null : new SummaryBridge(file, (IConstructor)s, FileFacts.this.cm));
                CompletionStage mergedCalc = this.typeCheckResults.get().thenCompose(o -> summaryCalc.get());
                return new InterruptibleFuture(mergedCalc, summaryCalc::interrupt);
            });
        }

        @Override
        public void reportParseErrors(List<Diagnostic> msgs) {
            this.parseMessages = msgs;
            this.sendDiagnostics();
        }

        @Override
        public void reportTypeCheckerErrors(List<Diagnostic> msgs) {
            this.typeCheckerMessages = msgs;
            this.sendDiagnostics();
        }

        private void sendDiagnostics() {
            if (FileFacts.this.client == null) {
                logger.debug("Cannot send diagnostics since the client hasn't been registered yet");
                return;
            }
            logger.trace("Sending diagnostics for: {}", (Object)this.file);
            FileFacts.this.client.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(this.file).toString(), Lists.union(this.typeCheckerMessages, this.parseMessages)));
        }

        @Override
        public CompletableFuture<@Nullable SummaryBridge> getSummary() {
            return this.summary.get().get();
        }

        @Override
        public void invalidate() {
            this.summary.invalidate();
            this.typeCheckerMessages.clear();
            this.typeCheckResults.replace(FileFacts.this.rascal.compileFile(this.file, FileFacts.this.confs.lookupConfig(this.file), FileFacts.this.exec).thenApply(m -> Diagnostics.translateMessages(m, FileFacts.this.cm))).thenAccept(m -> m.forEach((f, msgs) -> FileFacts.this.getFile((ISourceLocation)f).reportTypeCheckerErrors((List<Diagnostic>)msgs)));
        }

        @Override
        public void close() {
            if (this.parseMessages.isEmpty() && this.typeCheckerMessages.isEmpty() || !URIResolverRegistry.getInstance().exists(this.file)) {
                FileFacts.this.files.remove(this.file);
            }
        }

        @Override
        public void clearDiagnostics() {
            this.summary.invalidate();
            this.typeCheckerMessages.clear();
            this.typeCheckResults.replace(CompletableFuture.completedFuture(Map.of()));
            FileFacts.this.client.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(this.file).toString(), List.of()));
        }
    }

    private static interface FileFact {
        public void reportParseErrors(List<Diagnostic> var1);

        public void reportTypeCheckerErrors(List<Diagnostic> var1);

        public CompletableFuture<@Nullable SummaryBridge> getSummary();

        public void invalidate();

        public void close();

        public void clearDiagnostics();
    }
}

