/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal.model;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

class PathConfigDiagnostics {
    private final LanguageClient client;
    private final ColumnMaps cm;
    private final Map<ISourceLocation, Map<ISourceLocation, List<Diagnostic>>> perFileProjectDiagnostics = new LinkedHashMap<ISourceLocation, Map<ISourceLocation, List<Diagnostic>>>();

    PathConfigDiagnostics(LanguageClient client, ColumnMaps cm) {
        this.client = client;
        this.cm = cm;
    }

    public void publishDiagnostics(ISourceLocation project, IList messages) {
        this.publishDiagnostics(project, Diagnostics.translateMessages(messages, this.cm));
    }

    public void clearDiagnostics(ISourceLocation project) {
        this.publishDiagnostics(project, Collections.emptyMap());
    }

    private void publishDiagnostics(ISourceLocation project, Map<ISourceLocation, List<Diagnostic>> diagnostics) {
        for (PublishDiagnosticsParams params : this.updateDiagnostics(project, diagnostics)) {
            this.client.publishDiagnostics(params);
        }
    }

    private synchronized List<PublishDiagnosticsParams> updateDiagnostics(ISourceLocation project, Map<ISourceLocation, List<Diagnostic>> diagnostics) {
        HashSet<ISourceLocation> filesToRepublish = new HashSet<ISourceLocation>();
        for (Map.Entry<ISourceLocation, List<Diagnostic>> entry : diagnostics.entrySet()) {
            ISourceLocation file = entry.getKey().top();
            List<Diagnostic> newDiagnostics = entry.getValue();
            this.updateFileDiagnostics(project, file, newDiagnostics, filesToRepublish);
        }
        this.cleanFilesWithoutDiagnostics(project, diagnostics, filesToRepublish);
        return this.gatherPublishList(filesToRepublish);
    }

    private void updateFileDiagnostics(ISourceLocation project, ISourceLocation file, List<Diagnostic> diagnostics, Set<ISourceLocation> filesToRepublish) {
        Map publishedDiagsPerProject = this.perFileProjectDiagnostics.computeIfAbsent(file, f -> new LinkedHashMap());
        List publishedForOurProject = (List)publishedDiagsPerProject.get(project);
        if (publishedForOurProject == null || !publishedForOurProject.equals(diagnostics)) {
            publishedDiagsPerProject.put(project, diagnostics);
            filesToRepublish.add(file);
        }
    }

    private void cleanFilesWithoutDiagnostics(ISourceLocation project, Map<ISourceLocation, List<Diagnostic>> diagnostics, Set<ISourceLocation> filesToRepublish) {
        HashSet<ISourceLocation> diagnosticFiles = new HashSet<ISourceLocation>();
        for (ISourceLocation loc : diagnostics.keySet()) {
            diagnosticFiles.add(loc.top());
        }
        this.perFileProjectDiagnostics.entrySet().removeIf(entry -> {
            ISourceLocation file = (ISourceLocation)entry.getKey();
            Map projectDiagnostics = (Map)entry.getValue();
            if (!diagnosticFiles.contains(file) && projectDiagnostics.remove(project) != null) {
                filesToRepublish.add(file);
                if (projectDiagnostics.isEmpty()) {
                    return true;
                }
            }
            return false;
        });
    }

    private List<PublishDiagnosticsParams> gatherPublishList(Set<ISourceLocation> filesToRepublish) {
        ArrayList<PublishDiagnosticsParams> publishList = new ArrayList<PublishDiagnosticsParams>(filesToRepublish.size());
        for (ISourceLocation file : filesToRepublish) {
            ArrayList<Diagnostic> fileDiagnostics = new ArrayList<Diagnostic>();
            for (List diags : this.perFileProjectDiagnostics.getOrDefault(file, Collections.emptyMap()).values()) {
                fileDiagnostics.addAll(diags);
            }
            publishList.add(new PublishDiagnosticsParams(Locations.toUri(file).toString(), fileDiagnostics));
        }
        return publishList;
    }
}

